/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRangeParser;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorState;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.FileNameExtractorCharSequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.PrefixedPath;
import java.io.Closeable;

public class StaticContentProcessor
implements HttpRequestProcessor,
Closeable {
    private static final Log LOG = LogFactory.getLog(StaticContentProcessor.class);
    private static final LocalValue<StaticContentProcessorState> LV = new LocalValue();
    private final MimeTypesCache mimeTypes;
    private final HttpRangeParser rangeParser = new HttpRangeParser();
    private final PrefixedPath prefixedPath;
    private final CharSequence indexFileName;
    private final FilesFacade ff;
    private final String keepAliveHeader;

    public StaticContentProcessor(StaticContentProcessorConfiguration configuration) {
        this.mimeTypes = configuration.getMimeTypesCache();
        this.prefixedPath = new PrefixedPath(configuration.getPublicDirectory());
        this.indexFileName = configuration.getIndexFileName();
        this.ff = configuration.getFilesFacade();
        this.keepAliveHeader = configuration.getKeepAliveHeader();
    }

    @Override
    public void close() {
        Misc.free(this.prefixedPath);
    }

    @Override
    public void onHeadersReady(HttpConnectionContext context) {
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpRequestHeader headers = context.getRequestHeader();
        CharSequence url = headers.getUrl();
        LOG.info().$("incoming [url=").$(url).$(']').$();
        if (Chars.contains(url, "..")) {
            LOG.info().$("URL abuse: ").$(url).$();
            this.sendStatusWithDefaultMessage(context, 404);
        } else {
            PrefixedPath path = this.prefixedPath.rewind();
            if (Chars.equals(url, '/')) {
                path.concat(this.indexFileName);
            } else {
                path.concat(url);
            }
            path.$();
            if (this.ff.exists(path)) {
                this.send(context, path, headers.getUrlParam("attachment") != null);
            } else {
                LOG.info().$("not found [path=").$(path).$(']').$();
                this.sendStatusWithDefaultMessage(context, 404);
            }
        }
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        long l;
        LOG.debug().$("resumeSend").$();
        StaticContentProcessorState state = LV.get(context);
        if (state == null || state.fd == -1L) {
            return;
        }
        HttpRawSocket socket = context.getRawResponseSocket();
        long address = socket.getBufferAddress();
        int size = socket.getBufferSize();
        while (state.bytesSent < state.sendMax && (l = this.ff.read(state.fd, address, size, state.bytesSent)) > 0L) {
            if (l + state.bytesSent > state.sendMax) {
                l = state.sendMax - state.bytesSent;
            }
            state.bytesSent += l;
            socket.send((int)l);
        }
        this.readyForNextRequest(context);
    }

    private void readyForNextRequest(HttpConnectionContext context) {
        context.clear();
        context.getDispatcher().registerChannel(context, 1);
    }

    private void send(HttpConnectionContext context, LPSZ path, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int l;
        int n = Chars.lastIndexOf(path, '.');
        if (n == -1) {
            LOG.info().$("Missing extension: ").$(path).$();
            this.sendStatusWithDefaultMessage(context, 404);
            return;
        }
        HttpRequestHeader headers = context.getRequestHeader();
        CharSequence contentType = (CharSequence)this.mimeTypes.valueAt(this.mimeTypes.keyIndex(path, n + 1, path.length()));
        DirectByteCharSequence val = headers.getHeader("Range");
        if (val != null) {
            this.sendRange(context, val, path, contentType, asAttachment);
            return;
        }
        val = headers.getHeader("If-None-Match");
        if (val != null && (l = val.length()) > 2 && val.charAt(0) == '\"' && val.charAt(l - 1) == '\"') {
            try {
                long that = Numbers.parseLong(val, 1, l - 1);
                if (that == this.ff.getLastModified(path)) {
                    context.simpleResponse().sendStatus(304);
                    this.readyForNextRequest(context);
                    return;
                }
            }
            catch (NumericException e) {
                LOG.info().$("bad 'If-None-Match' [value=").$(val).$(']').$();
                this.sendStatusWithDefaultMessage(context, 400);
                return;
            }
        }
        this.sendVanilla(context, path, contentType, asAttachment);
    }

    private void sendRange(HttpConnectionContext context, CharSequence range, LPSZ path, CharSequence contentType, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.rangeParser.of(range)) {
            StaticContentProcessorState state = LV.get(context);
            if (state == null) {
                state = new StaticContentProcessorState();
                LV.set(context, state);
            }
            state.fd = this.ff.openRO(path);
            if (state.fd == -1L) {
                LOG.info().$("Cannot open file: ").$(path).$();
                this.sendStatusWithDefaultMessage(context, 404);
                return;
            }
            state.bytesSent = 0L;
            long length = this.ff.length(path);
            long lo = this.rangeParser.getLo();
            long hi = this.rangeParser.getHi();
            if (lo > length || hi != Long.MAX_VALUE && hi > length || lo > hi) {
                this.sendStatusWithDefaultMessage(context, 416);
            } else {
                state.bytesSent = lo;
                state.sendMax = hi == Long.MAX_VALUE ? length : hi;
                HttpResponseHeader header = context.getResponseHeader();
                header.status(206, contentType, state.sendMax - lo);
                if (asAttachment) {
                    header.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorCharSequence.get(path)).put('\"').put("\r\n");
                }
                header.put("Accept-Ranges: bytes").put("\r\n");
                header.put("Content-Range: bytes ").put(lo).put('-').put(state.sendMax).put('/').put(length).put("\r\n");
                header.put("ETag: ").put(this.ff.getLastModified(path)).put("\r\n");
                if (this.keepAliveHeader != null) {
                    header.put(this.keepAliveHeader);
                }
                header.send();
                this.resumeSend(context);
            }
        } else {
            this.sendStatusWithDefaultMessage(context, 416);
        }
    }

    private void sendStatusWithDefaultMessage(HttpConnectionContext context, int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
        context.simpleResponse().sendStatusWithDefaultMessage(code);
        this.readyForNextRequest(context);
    }

    private void sendVanilla(HttpConnectionContext context, LPSZ path, CharSequence contentType, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        long fd = this.ff.openRO(path);
        if (fd == -1L) {
            LOG.info().$("Cannot open file: ").$(path).$('(').$(this.ff.errno()).$(')').$();
            this.sendStatusWithDefaultMessage(context, 404);
        } else {
            long length;
            StaticContentProcessorState h = LV.get(context);
            if (h == null) {
                h = new StaticContentProcessorState();
                LV.set(context, h);
            }
            h.fd = fd;
            h.bytesSent = 0L;
            h.sendMax = length = this.ff.length(path);
            HttpResponseHeader header = context.getResponseHeader();
            header.status(200, contentType, length);
            if (asAttachment) {
                header.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorCharSequence.get(path)).put("\"").put("\r\n");
            }
            header.put("ETag: ").put('\"').put(this.ff.getLastModified(path)).put('\"').put("\r\n");
            header.setKeepAlive(this.keepAliveHeader);
            header.send();
            this.resumeSend(context);
        }
    }
}

