/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpMultipartContentListener;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.processors.TextImportProcessorState;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class TextImportProcessor
implements HttpRequestProcessor,
HttpMultipartContentListener,
Closeable {
    static final int RESPONSE_PREFIX = 1;
    static final int MESSAGE_UNKNOWN = 3;
    private static final Log LOG = LogFactory.getLog(TextImportProcessor.class);
    private static final int RESPONSE_COLUMN = 2;
    private static final int RESPONSE_SUFFIX = 3;
    private static final int MESSAGE_SCHEMA = 1;
    private static final int MESSAGE_DATA = 2;
    private static final int TO_STRING_COL1_PAD = 15;
    private static final int TO_STRING_COL2_PAD = 50;
    private static final int TO_STRING_COL3_PAD = 15;
    private static final int TO_STRING_COL4_PAD = 7;
    private static final int TO_STRING_COL5_PAD = 10;
    private static final CharSequence CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    private static final CharSequence CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private static final CharSequenceIntHashMap atomicityParamMap = new CharSequenceIntHashMap();
    private static final LocalValue<TextImportProcessorState> LV = new LocalValue();
    private final CairoEngine engine;
    private HttpConnectionContext transientContext;
    private TextImportProcessorState transientState;

    public TextImportProcessor(CairoEngine cairoEngine) {
        this.engine = cairoEngine;
    }

    private static void resumeJson(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TextLoader textLoader = state.textLoader;
        RecordMetadata metadata = textLoader.getMetadata();
        LongList errors = textLoader.getColumnErrorCounts();
        switch (state.responseState) {
            case 1: {
                long totalRows = state.textLoader.getParsedLineCount();
                long importedRows = state.textLoader.getWrittenLineCount();
                socket.put('{').putQuoted("status").put(':').putQuoted("OK").put(',').putQuoted("location").put(':').encodeUtf8AndQuote(textLoader.getTableName()).put(',').putQuoted("rowsRejected").put(':').put(totalRows - importedRows + textLoader.getErrorLineCount()).put(',').putQuoted("rowsImported").put(':').put(importedRows).put(',').putQuoted("header").put(':').put(textLoader.isForceHeaders()).put(',').putQuoted("columns").put(':').put('[');
                state.responseState = 2;
            }
            case 2: {
                if (metadata != null) {
                    int columnCount = metadata.getColumnCount();
                    while (state.columnIndex < columnCount) {
                        socket.bookmark();
                        if (state.columnIndex > 0) {
                            socket.put(',');
                        }
                        socket.put('{').putQuoted("name").put(':').putQuoted(metadata.getColumnName(state.columnIndex)).put(',').putQuoted("type").put(':').putQuoted(ColumnType.nameOf(metadata.getColumnType(state.columnIndex))).put(',').putQuoted("size").put(':').put(ColumnType.sizeOf(metadata.getColumnType(state.columnIndex))).put(',').putQuoted("errors").put(':').put(errors.getQuick(state.columnIndex));
                        socket.put('}');
                        ++state.columnIndex;
                    }
                }
                state.responseState = 3;
            }
            case 3: {
                socket.bookmark();
                socket.put(']').put('}');
                socket.sendChunk();
                socket.done();
                break;
            }
        }
    }

    private static CharSink pad(CharSink b, int w, CharSequence value) {
        int pad = value == null ? w : w - value.length();
        TextImportProcessor.replicate(b, ' ', pad);
        if (value != null) {
            if (pad < 0) {
                b.put("...").put(value.subSequence(-pad + 3, value.length()));
            } else {
                b.put(value);
            }
        }
        b.put("  |");
        return b;
    }

    private static void pad(CharSink b, int w, long value) {
        int len = (int)Math.log10(value);
        if (len < 0) {
            len = 0;
        }
        TextImportProcessor.replicate(b, ' ', w - len - 1);
        b.put(value);
        b.put("  |");
    }

    private static void replicate(CharSink b, char c, int times) {
        for (int i = 0; i < times; ++i) {
            b.put(c);
        }
    }

    private static void sep(CharSink b) {
        b.put('+');
        TextImportProcessor.replicate(b, '-', 111);
        b.put("+\r\n");
    }

    private static void resumeText(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TextLoader textLoader = state.textLoader;
        RecordMetadata metadata = textLoader.getMetadata();
        LongList errors = textLoader.getColumnErrorCounts();
        switch (state.responseState) {
            case 1: {
                TextImportProcessor.sep(socket);
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Location:");
                TextImportProcessor.pad((CharSink)socket, 50, textLoader.getTableName());
                TextImportProcessor.pad((CharSink)socket, 15, "Pattern");
                TextImportProcessor.pad((CharSink)socket, 7, "Locale");
                TextImportProcessor.pad((CharSink)socket, 10, "Errors").put("\r\n");
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Partition by");
                TextImportProcessor.pad((CharSink)socket, 50, PartitionBy.toString(textLoader.getPartitionBy()));
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                TextImportProcessor.pad((CharSink)socket, 10, "").put("\r\n");
                TextImportProcessor.sep(socket);
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Rows handled");
                TextImportProcessor.pad((CharSink)socket, 50, textLoader.getParsedLineCount() + textLoader.getErrorLineCount());
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                TextImportProcessor.pad((CharSink)socket, 10, "").put("\r\n");
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Rows imported");
                TextImportProcessor.pad((CharSink)socket, 50, textLoader.getWrittenLineCount());
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                TextImportProcessor.pad((CharSink)socket, 10, "").put("\r\n");
                TextImportProcessor.sep(socket);
                state.responseState = 2;
            }
            case 2: {
                if (metadata != null) {
                    int columnCount = metadata.getColumnCount();
                    while (state.columnIndex < columnCount) {
                        socket.bookmark();
                        socket.put('|');
                        TextImportProcessor.pad((CharSink)socket, 15, state.columnIndex);
                        TextImportProcessor.pad((CharSink)socket, 50, metadata.getColumnName(state.columnIndex));
                        TextImportProcessor.pad((CharSink)socket, 25, ColumnType.nameOf(metadata.getColumnType(state.columnIndex)));
                        TextImportProcessor.pad((CharSink)socket, 10, errors.getQuick(state.columnIndex));
                        socket.put("\r\n");
                        ++state.columnIndex;
                    }
                }
                state.responseState = 3;
            }
            case 3: {
                socket.bookmark();
                TextImportProcessor.sep(socket);
                socket.sendChunk();
                socket.done();
                break;
            }
        }
    }

    private static int getAtomicity(CharSequence name) {
        if (name == null) {
            return 2;
        }
        int atomicity = atomicityParamMap.get(name);
        return atomicity == -1 ? 2 : atomicity;
    }

    @Override
    public void close() {
    }

    @Override
    public void onChunk(long lo, long hi) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        if (hi > lo) {
            try {
                this.transientState.textLoader.parse(lo, hi, this.transientContext.getCairoSecurityContext());
                if (this.transientState.messagePart == 2 && !this.transientState.analysed) {
                    this.transientState.analysed = true;
                    this.transientState.textLoader.setState(2);
                }
            }
            catch (TextException e) {
                this.handleTextException(e);
            }
        }
    }

    @Override
    public void onPartBegin(HttpRequestHeader partHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        CharSequence contentDisposition = partHeader.getContentDispositionName();
        LOG.debug().$("part begin [name=").$(contentDisposition).$(']').$();
        if (Chars.equalsNc((CharSequence)"data", contentDisposition)) {
            HttpRequestHeader rh = this.transientContext.getRequestHeader();
            CharSequence name = rh.getUrlParam("name");
            if (name == null) {
                name = partHeader.getContentDispositionFilename();
            }
            if (name == null) {
                this.transientContext.simpleResponse().sendStatus(400, "no file name given");
                throw ServerDisconnectException.INSTANCE;
            }
            this.transientState.analysed = false;
            this.transientState.textLoader.configureDestination(name, Chars.equalsNc((CharSequence)"true", rh.getUrlParam("overwrite")), Chars.equalsNc((CharSequence)"true", rh.getUrlParam("durable")), TextImportProcessor.getAtomicity(rh.getUrlParam("atomicity")));
            this.transientState.textLoader.setForceHeaders(Chars.equalsNc((CharSequence)"true", rh.getUrlParam("forceHeader")));
            this.transientState.textLoader.setSkipRowsWithExtraValues(Chars.equalsNc((CharSequence)"true", rh.getUrlParam("skipLev")));
            this.transientState.textLoader.setState(1);
            this.transientState.forceHeader = Chars.equalsNc((CharSequence)"true", rh.getUrlParam("forceHeader"));
            this.transientState.messagePart = 2;
        } else if (Chars.equalsNc((CharSequence)"schema", contentDisposition)) {
            this.transientState.textLoader.setState(0);
            this.transientState.messagePart = 1;
        } else {
            if (partHeader.getContentDisposition() == null) {
                this.transientContext.simpleResponse().sendStatus(400, "'Content-Disposition' multipart header missing'");
            } else {
                this.transientContext.simpleResponse().sendStatus(400, "invalid value in 'Content-Disposition' multipart header");
            }
            throw ServerDisconnectException.INSTANCE;
        }
    }

    @Override
    public void onPartEnd() throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            LOG.debug().$("part end").$();
            this.transientState.textLoader.wrapUp();
            if (this.transientState.messagePart == 2) {
                this.sendResponse(this.transientContext);
            }
        }
        catch (TextException e) {
            this.handleTextException(e);
        }
    }

    @Override
    public void onHeadersReady(HttpConnectionContext context) {
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) {
        this.transientState.clear();
        context.clear();
        context.getDispatcher().registerChannel(context, 1);
    }

    @Override
    public void resumeRecv(HttpConnectionContext context) {
        this.transientContext = context;
        this.transientState = LV.get(context);
        if (this.transientState == null) {
            LOG.debug().$("new text state").$();
            this.transientState = new TextImportProcessorState(this.engine);
            LV.set(context, this.transientState);
        }
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.doResumeSend(LV.get(context), context.getChunkedResponseSocket());
    }

    private void doResumeSend(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            if (state.json) {
                TextImportProcessor.resumeJson(state, socket);
            } else {
                TextImportProcessor.resumeText(state, socket);
            }
        }
        catch (NoSpaceLeftInResponseBufferException ignored) {
            if (socket.resetToBookmark()) {
                socket.sendChunk();
            }
            throw ServerDisconnectException.INSTANCE;
        }
        state.clear();
    }

    private void handleTextException(TextException e) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.sendError(this.transientContext, e.getFlyweightMessage(), Chars.equalsNc((CharSequence)"json", this.transientContext.getRequestHeader().getUrlParam("fmt")));
        throw ServerDisconnectException.INSTANCE;
    }

    private void sendError(HttpConnectionContext context, CharSequence message, boolean json) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        if (json) {
            socket.status(400, CONTENT_TYPE_JSON);
            socket.sendHeader();
            socket.put('{').putQuoted("status").put(':').encodeUtf8AndQuote(message).put('}');
        } else {
            socket.status(400, CONTENT_TYPE_TEXT);
            socket.sendHeader();
            socket.encodeUtf8(message);
        }
        socket.sendChunk();
        socket.done();
    }

    private void sendResponse(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        TextImportProcessorState state = LV.get(context);
        state.json = Chars.equalsNc((CharSequence)"json", context.getRequestHeader().getUrlParam("fmt"));
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        if (state.state == 0) {
            if (state.json) {
                socket.status(200, CONTENT_TYPE_JSON);
            } else {
                socket.status(200, CONTENT_TYPE_TEXT);
            }
            socket.sendHeader();
            this.doResumeSend(state, socket);
        } else {
            this.sendError(context, state.stateMessage, state.json);
        }
    }

    static {
        atomicityParamMap.put("skipRow", 1);
        atomicityParamMap.put("abort", 0);
    }
}

