/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.json;

import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonParser;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntStack;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class JsonLexer
implements Mutable,
Closeable {
    public static final int EVT_OBJ_START = 1;
    public static final int EVT_OBJ_END = 2;
    public static final int EVT_ARRAY_START = 3;
    public static final int EVT_ARRAY_END = 4;
    public static final int EVT_NAME = 5;
    public static final int EVT_VALUE = 6;
    public static final int EVT_ARRAY_VALUE = 7;
    private static final int S_START = 0;
    private static final int S_EXPECT_NAME = 1;
    private static final int S_EXPECT_FIRST_NAME = 5;
    private static final int S_EXPECT_VALUE = 2;
    private static final int S_EXPECT_COMMA = 3;
    private static final int S_EXPECT_COLON = 4;
    private static final IntHashSet unquotedTerminators = new IntHashSet(256);
    private final IntStack objDepthStack = new IntStack(64);
    private final IntStack arrayDepthStack = new IntStack(64);
    private final StringSink sink = new StringSink();
    private final int cacheSizeLimit;
    private int state = 0;
    private int objDepth = 0;
    private int arrayDepth = 0;
    private boolean ignoreNext = false;
    private boolean quoted = false;
    private long cache;
    private int cacheCapacity;
    private int cacheSize = 0;
    private boolean useCache = false;
    private int position = 0;

    public JsonLexer(int cacheSize, int cacheSizeLimit) {
        this.cacheCapacity = cacheSize;
        this.cache = Unsafe.malloc(cacheSize);
        this.cacheSizeLimit = cacheSizeLimit;
    }

    private static boolean isNotATerminator(char c) {
        return unquotedTerminators.excludes(c);
    }

    private static JsonException unsupportedEncoding(int position) {
        return JsonException.$(position, "Unsupported encoding");
    }

    @Override
    public void clear() {
        this.objDepthStack.clear();
        this.arrayDepthStack.clear();
        this.state = 0;
        this.objDepth = 0;
        this.arrayDepth = 0;
        this.ignoreNext = false;
        this.quoted = false;
        this.cacheSize = 0;
        this.useCache = false;
        this.position = 0;
    }

    @Override
    public void close() {
        if (this.cacheCapacity > 0 && this.cache != 0L) {
            Unsafe.free(this.cache, this.cacheCapacity);
        }
    }

    public void parse(long lo, long hi, JsonParser listener) throws JsonException {
        if (lo >= hi) {
            return;
        }
        long p = lo;
        long valueStart = this.useCache ? lo : 0L;
        int posAtStart = this.position;
        int state = this.state;
        boolean quoted = this.quoted;
        boolean ignoreNext = this.ignoreNext;
        boolean useCache = this.useCache;
        int objDepth = this.objDepth;
        int arrayDepth = this.arrayDepth;
        block14: while (p < hi) {
            char c = (char)Unsafe.getUnsafe().getByte(p++);
            if (ignoreNext) {
                ignoreNext = false;
                continue;
            }
            if (valueStart > 0L) {
                if (quoted) {
                    if (c == '\\') {
                        ignoreNext = true;
                        continue;
                    }
                    if (c != '\"') {
                        continue;
                    }
                } else if (JsonLexer.isNotATerminator(c)) continue;
                int vp = (int)((long)posAtStart + valueStart - lo + 1L - (long)this.cacheSize);
                if (state == 1 || state == 5) {
                    listener.onEvent(5, this.getCharSequence(valueStart, p, vp), vp);
                    state = 4;
                } else {
                    listener.onEvent(arrayDepth > 0 ? 7 : 6, this.getCharSequence(valueStart, p, vp), vp);
                    state = 3;
                }
                valueStart = 0L;
                this.cacheSize = 0;
                useCache = false;
                if (quoted) continue;
            }
            switch (c) {
                case '{': {
                    if (state != 0 && state != 2) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "{ is not expected here");
                    }
                    this.arrayDepthStack.push(arrayDepth);
                    arrayDepth = 0;
                    listener.onEvent(1, null, (int)((long)posAtStart + p - lo));
                    ++objDepth;
                    state = 5;
                    continue block14;
                }
                case '}': {
                    if (arrayDepth > 0) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "} is not expected here. You have non-terminated array");
                    }
                    if (objDepth > 0) {
                        switch (state) {
                            case 2: {
                                throw JsonException.$((int)((long)posAtStart + p - lo - 1L), "Attribute value expected");
                            }
                            case 1: {
                                throw JsonException.$((int)((long)posAtStart + p - lo - 1L), "Attribute name expected");
                            }
                        }
                        listener.onEvent(2, null, (int)((long)posAtStart + p - lo));
                        --objDepth;
                        arrayDepth = this.arrayDepthStack.pop();
                        state = 3;
                        continue block14;
                    }
                    throw JsonException.$((int)((long)posAtStart + p - lo), "Dangling }");
                }
                case '[': {
                    if (state != 0 && state != 2) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "[ is not expected here");
                    }
                    listener.onEvent(3, null, (int)((long)posAtStart + p - lo));
                    this.objDepthStack.push(objDepth);
                    objDepth = 0;
                    ++arrayDepth;
                    state = 2;
                    continue block14;
                }
                case ']': {
                    if (objDepth > 0) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "] is not expected here. You have non-terminated object");
                    }
                    if (arrayDepth == 0) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "Dangling ]");
                    }
                    listener.onEvent(4, null, (int)((long)posAtStart + p - lo));
                    --arrayDepth;
                    objDepth = this.objDepthStack.pop();
                    state = 3;
                    continue block14;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block14;
                }
                case ',': {
                    if (state != 3) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "Unexpected comma");
                    }
                    if (arrayDepth > 0) {
                        state = 2;
                        continue block14;
                    }
                    state = 1;
                    continue block14;
                }
                case ':': {
                    if (state != 4) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "Misplaced ':'");
                    }
                    state = 2;
                    continue block14;
                }
                case '\"': {
                    if (state != 1 && state != 5 && state != 2) {
                        throw JsonException.$((int)((long)posAtStart + p - lo), "Unexpected quote '\"'");
                    }
                    valueStart = p;
                    quoted = true;
                    continue block14;
                }
            }
            if (state != 2) {
                throw JsonException.$((int)((long)posAtStart + p - lo), "Unexpected symbol");
            }
            valueStart = p - 1L;
            quoted = false;
        }
        this.position = (int)((long)posAtStart + p - lo);
        this.state = state;
        this.quoted = quoted;
        this.ignoreNext = ignoreNext;
        this.objDepth = objDepth;
        this.arrayDepth = arrayDepth;
        if (valueStart > 0L) {
            this.addToStash(valueStart, hi);
            useCache = true;
        }
        this.useCache = useCache;
    }

    public void parseLast() throws JsonException {
        if (this.cacheSize > 0) {
            throw JsonException.$(this.position, "Unterminated string");
        }
        if (this.arrayDepth > 0) {
            throw JsonException.$(this.position, "Unterminated array");
        }
        if (this.objDepth > 0 || this.arrayDepthStack.size() > 0 || this.objDepthStack.size() > 0) {
            throw JsonException.$(this.position, "Unterminated object");
        }
    }

    private void addToStash(long lo, long hi) throws JsonException {
        int len = (int)(hi - lo);
        int n = len + this.cacheSize;
        if (n > this.cacheCapacity) {
            this.extendCache(Numbers.ceilPow2(n));
        }
        if (len > 0) {
            Unsafe.getUnsafe().copyMemory(lo, this.cache + (long)this.cacheSize, len);
            this.cacheSize += len;
        }
    }

    private void extendCache(int n) throws JsonException {
        if (n > this.cacheSizeLimit) {
            throw JsonException.$(this.position, "String is too long");
        }
        long ptr = Unsafe.malloc(n);
        if (this.cacheCapacity > 0) {
            Unsafe.getUnsafe().copyMemory(this.cache, ptr, this.cacheSize);
            Unsafe.free(this.cache, this.cacheCapacity);
        }
        this.cacheCapacity = n;
        this.cache = ptr;
    }

    private CharSequence getCharSequence(long lo, long hi, int position) throws JsonException {
        this.sink.clear();
        if (this.cacheSize == 0) {
            if (!Chars.utf8Decode(lo, hi - 1L, this.sink)) {
                throw JsonLexer.unsupportedEncoding(position);
            }
        } else {
            this.utf8DecodeCacheAndBuffer(lo, hi - 1L, position);
        }
        return this.sink;
    }

    private void utf8DecodeCacheAndBuffer(long lo, long hi, int position) throws JsonException {
        int len;
        byte b;
        long p = this.cache;
        long lim = this.cache + (long)this.cacheSize;
        int loOffset = 0;
        while (p < lim) {
            b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                len = Chars.utf8DecodeMultiByte(p, lim, b, this.sink);
                if (len != -1) {
                    p += (long)len;
                    continue;
                }
                int cacheRemaining = (int)(lim - p);
                if (cacheRemaining > 4) {
                    throw JsonLexer.unsupportedEncoding(position);
                }
                int n = (int)Math.max(4L, hi - lo);
                long offset = p - this.cache;
                this.addToStash(lo, lo + (long)n);
                assert (offset < (long)this.cacheSize);
                assert (this.cacheSize <= this.cacheCapacity);
                len = Chars.utf8DecodeMultiByte(this.cache + offset, this.cache + (long)this.cacheSize, b, this.sink);
                if (len == -1) {
                    throw JsonLexer.unsupportedEncoding(position);
                }
                loOffset = len - cacheRemaining;
                p += (long)cacheRemaining;
                continue;
            }
            this.sink.put((char)b);
            ++p;
        }
        p = lo + (long)loOffset;
        while (p < hi) {
            b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                len = Chars.utf8DecodeMultiByte(p, hi, b, this.sink);
                if (len == -1) {
                    throw JsonLexer.unsupportedEncoding(position);
                }
                p += (long)len;
                continue;
            }
            this.sink.put((char)b);
            ++p;
        }
    }

    static {
        unquotedTerminators.add(32);
        unquotedTerminators.add(9);
        unquotedTerminators.add(10);
        unquotedTerminators.add(13);
        unquotedTerminators.add(44);
        unquotedTerminators.add(125);
        unquotedTerminators.add(93);
        unquotedTerminators.add(123);
        unquotedTerminators.add(91);
    }
}

