/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.line.CachedCharSequence;
import io.questdb.cutlass.line.CharSequenceCache;
import io.questdb.cutlass.line.LineProtoParser;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class CairoLineProtoParser
implements LineProtoParser,
Closeable {
    private static final Log LOG = LogFactory.getLog(CairoLineProtoParser.class);
    private static final LineEndParser NOOP_LINE_END = cache -> {};
    private static final FieldValueParser NOOP_FIELD_VALUE = (value, cache) -> {};
    private static final FieldNameParser NOOP_FIELD_NAME = name -> {};
    private static final ObjList<ColumnWriter> writers = new ObjList();
    private final CairoEngine engine;
    private final CharSequenceObjHashMap<CacheEntry> writerCache = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<TableWriter> commitList = new CharSequenceObjHashMap();
    private final Path path = new Path();
    private final CairoConfiguration configuration;
    private final LongList columnNameType = new LongList();
    private final LongList columnIndexAndType = new LongList();
    private final LongList columnValues = new LongList();
    private final AppendMemory appendMemory = new AppendMemory();
    private final MicrosecondClock clock;
    private final FieldNameParser MY_NEW_FIELD_NAME = this::parseFieldNameNewTable;
    private final FieldValueParser MY_NEW_TAG_VALUE = this::parseTagValueNewTable;
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final CairoSecurityContext cairoSecurityContext;
    private final LineProtoTimestampAdapter timestampAdapter;
    private int cacheEntryIndex = 0;
    private TableWriter writer;
    private final LineEndParser MY_LINE_END = this::appendRow;
    private RecordMetadata metadata;
    private int columnCount;
    private int columnIndex;
    private long columnName;
    private int columnType;
    private final FieldNameParser MY_FIELD_NAME = this::parseFieldName;
    private final FieldValueParser MY_TAG_VALUE = this::parseTagValue;
    private long tableName;
    private final LineEndParser MY_NEW_LINE_END = this::createTableAndAppendRow;
    private LineEndParser onLineEnd;
    private FieldNameParser onFieldName;
    private FieldValueParser onFieldValue;
    private FieldValueParser onTagValue;
    private final FieldValueParser MY_FIELD_VALUE = this::parseFieldValue;
    private final FieldValueParser MY_NEW_FIELD_VALUE = this::parseFieldValueNewTable;

    public CairoLineProtoParser(CairoEngine engine, CairoSecurityContext cairoSecurityContext, LineProtoTimestampAdapter timestampAdapter) {
        this.configuration = engine.getConfiguration();
        this.clock = this.configuration.getMicrosecondClock();
        this.engine = engine;
        this.cairoSecurityContext = cairoSecurityContext;
        this.timestampAdapter = timestampAdapter;
    }

    private static boolean isTrue(CharSequence value) {
        char firstChar = value.charAt(0);
        return firstChar == 't' || firstChar == 'T';
    }

    private static void putSymbol(TableWriter.Row row, int index, CharSequence value) {
        row.putSym(index, value);
    }

    private static void putStr(TableWriter.Row row, int index, CharSequence value) {
        row.putStr(index, value, 1, value.length() - 2);
    }

    private static void putBoolean(TableWriter.Row row, int index, CharSequence value) {
        row.putBool(index, CairoLineProtoParser.isTrue(value));
    }

    private static void putDouble(TableWriter.Row row, int index, CharSequence value) throws BadCastException {
        try {
            row.putDouble(index, Numbers.parseDouble(value));
        }
        catch (NumericException e) {
            LOG.error().$("not a DOUBLE: ").$(value).$();
            throw BadCastException.INSTANCE;
        }
    }

    private static void putLong(TableWriter.Row row, int index, CharSequence value) throws BadCastException {
        try {
            row.putLong(index, Numbers.parseLong(value, 0, value.length() - 1));
        }
        catch (NumericException e) {
            LOG.error().$("not an INT: ").$(value).$();
            throw BadCastException.INSTANCE;
        }
    }

    @Override
    public void close() {
        Misc.free(this.path);
        Misc.free(this.appendMemory);
        int n = this.writerCache.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.writerCache.valueQuick(i).writer);
        }
    }

    public void commitAll(int commitMode) {
        if (this.writer != null) {
            this.writer.commit(commitMode);
        }
        int n = this.commitList.size();
        for (int i = 0; i < n; ++i) {
            this.commitList.valueQuick(i).commit(commitMode);
        }
        this.commitList.clear();
    }

    @Override
    public void onError(int position, int state, int code) {
        this.clearState();
    }

    @Override
    public void onEvent(CachedCharSequence token, int eventType, CharSequenceCache cache) {
        switch (eventType) {
            case 1: {
                int wrtIndex = this.writerCache.keyIndex(token);
                if (wrtIndex == this.cacheEntryIndex) {
                    if (this.writer != null) {
                        this.switchModeToAppend();
                        break;
                    }
                    this.initCacheEntry(token, this.writerCache.valueAtQuick(wrtIndex));
                    break;
                }
                this.switchTable(token, wrtIndex);
                break;
            }
            case 4: 
            case 5: {
                this.onFieldName.parse(token);
                break;
            }
            case 2: {
                this.onTagValue.parse(token, cache);
                break;
            }
            case 3: {
                this.onFieldValue.parse(token, cache);
                break;
            }
            case 6: {
                this.columnValues.add(token.getCacheAddress());
                break;
            }
        }
    }

    @Override
    public void onLineEnd(CharSequenceCache cache) {
        try {
            this.onLineEnd.parse(cache);
        }
        catch (CairoException e) {
            LOG.error().$(e).$();
        }
        this.clearState();
    }

    private void appendFirstRowAndCacheWriter(CharSequenceCache cache) {
        TableWriter writer;
        this.writer = writer = this.engine.getWriter(this.cairoSecurityContext, cache.get(this.tableName));
        this.metadata = writer.getMetadata();
        this.columnCount = this.metadata.getColumnCount();
        this.writerCache.valueAtQuick(this.cacheEntryIndex).writer = writer;
        int columnCount = this.columnNameType.size() / 2;
        TableWriter.Row row = this.createNewRow(cache, columnCount);
        if (row == null) {
            return;
        }
        try {
            for (int i = 0; i < columnCount; ++i) {
                this.putValue(row, i, (int)this.columnNameType.getQuick(i * 2 + 1), cache.get(this.columnValues.getQuick(i)));
            }
            row.append();
        }
        catch (BadCastException ignore) {
            row.cancel();
        }
    }

    private void appendRow(CharSequenceCache cache) {
        int columnCount = this.columnIndexAndType.size();
        TableWriter.Row row = this.createNewRow(cache, columnCount);
        if (row == null) {
            return;
        }
        try {
            for (int i = 0; i < columnCount; ++i) {
                long value = this.columnIndexAndType.getQuick(i);
                this.putValue(row, Numbers.decodeLowInt(value), Numbers.decodeHighInt(value), cache.get(this.columnValues.getQuick(i)));
            }
            row.append();
        }
        catch (BadCastException ignore) {
            row.cancel();
        }
    }

    private void clearState() {
        this.columnNameType.clear();
        this.columnIndexAndType.clear();
        this.columnValues.clear();
    }

    private void cacheWriter(CacheEntry entry, CachedCharSequence tableName) {
        try {
            entry.writer = this.engine.getWriter(this.cairoSecurityContext, tableName);
            this.tableName = tableName.getCacheAddress();
            this.createState(entry);
            LOG.info().$("cached writer [name=").$(tableName).$(']').$();
        }
        catch (CairoException ex) {
            LOG.error().$(ex).$();
            this.switchModeToSkipLine();
        }
    }

    private TableWriter.Row createNewRow(CharSequenceCache cache, int columnCount) {
        int valueCount = this.columnValues.size();
        if (columnCount == valueCount) {
            return this.writer.newRow(this.clock.getTicks());
        }
        try {
            return this.writer.newRow(this.timestampAdapter.getMicros(cache.get(this.columnValues.getQuick(valueCount - 1))));
        }
        catch (NumericException e) {
            LOG.error().$("invalid timestamp: ").$(cache.get(this.columnValues.getQuick(valueCount - 1))).$();
            return null;
        }
    }

    private void createState(CacheEntry entry) {
        this.writer = entry.writer;
        this.metadata = this.writer.getMetadata();
        this.columnCount = this.metadata.getColumnCount();
        this.switchModeToAppend();
    }

    private void createTableAndAppendRow(CharSequenceCache cache) {
        this.engine.creatTable(this.cairoSecurityContext, this.appendMemory, this.path, this.tableStructureAdapter.of(cache));
        this.appendFirstRowAndCacheWriter(cache);
    }

    private int getValueType(CharSequence token) {
        int len = token.length();
        switch (token.charAt(len - 1)) {
            case 'i': {
                return 5;
            }
            case 'F': 
            case 'T': 
            case 'e': 
            case 'f': 
            case 't': {
                return 0;
            }
            case '\"': {
                if (len < 2 || token.charAt(0) != '\"') {
                    LOG.error().$("incorrectly quoted string: ").$(token).$();
                    return -1;
                }
                return 10;
            }
        }
        return 9;
    }

    private void initCacheEntry(CachedCharSequence token, CacheEntry entry) {
        block0 : switch (entry.state) {
            case 0: {
                int exists = this.engine.getStatus(this.cairoSecurityContext, this.path, token);
                switch (exists) {
                    case 0: {
                        entry.state = 1;
                        this.cacheWriter(entry, token);
                        break;
                    }
                    case 1: {
                        this.tableName = token.getCacheAddress();
                        if (this.onLineEnd == this.MY_NEW_LINE_END) break block0;
                        this.onLineEnd = this.MY_NEW_LINE_END;
                        this.onFieldName = this.MY_NEW_FIELD_NAME;
                        this.onFieldValue = this.MY_NEW_FIELD_VALUE;
                        this.onTagValue = this.MY_NEW_TAG_VALUE;
                        break;
                    }
                    default: {
                        entry.state = 3;
                        this.switchModeToSkipLine();
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.cacheWriter(entry, token);
                break;
            }
            default: {
                this.switchModeToSkipLine();
            }
        }
    }

    private void parseFieldName(CachedCharSequence token) {
        this.columnIndex = this.metadata.getColumnIndexQuiet(token);
        if (this.columnIndex > -1) {
            this.columnType = this.metadata.getColumnType(this.columnIndex);
        } else {
            this.prepareNewColumn(token);
        }
    }

    private void parseValue(CachedCharSequence value, int valueType, CharSequenceCache cache) {
        if (this.columnType == valueType) {
            this.columnIndexAndType.add(Numbers.encodeLowHighInts(this.columnIndex, valueType));
            this.columnValues.add(value.getCacheAddress());
        } else {
            this.possibleNewColumn(value, valueType, cache);
        }
    }

    private void parseFieldNameNewTable(CachedCharSequence token) {
        this.columnNameType.add(token.getCacheAddress());
    }

    private void parseFieldValue(CachedCharSequence value, CharSequenceCache cache) {
        int valueType = this.getValueType(value);
        if (valueType == -1) {
            this.switchModeToSkipLine();
        } else {
            this.parseValue(value, valueType, cache);
        }
    }

    private void parseFieldValueNewTable(CachedCharSequence value, CharSequenceCache cache) {
        int valueType = this.getValueType(value);
        if (valueType == -1) {
            this.switchModeToSkipLine();
        } else {
            this.parseValueNewTable(value, valueType);
        }
    }

    private void parseTagValue(CachedCharSequence value, CharSequenceCache cache) {
        this.parseValue(value, 11, cache);
    }

    private void parseTagValueNewTable(CachedCharSequence value, CharSequenceCache cache) {
        this.parseValueNewTable(value, 11);
    }

    private void possibleNewColumn(CachedCharSequence value, int valueType, CharSequenceCache cache) {
        if (this.columnIndex > -1) {
            LOG.error().$("mismatched column and value types [table=").$(this.writer.getName()).$(", column=").$(this.metadata.getColumnName(this.columnIndex)).$(", columnType=").$(ColumnType.nameOf(this.columnType)).$(", valueType=").$(ColumnType.nameOf(valueType)).$(']').$();
            this.switchModeToSkipLine();
        } else {
            this.columnIndexAndType.add(Numbers.encodeLowHighInts(this.columnCount++, valueType));
            this.writer.addColumn(cache.get(this.columnName), valueType);
            this.columnValues.add(value.getCacheAddress());
        }
    }

    private void prepareNewColumn(CachedCharSequence token) {
        this.columnName = token.getCacheAddress();
        this.columnType = -1;
    }

    private void parseValueNewTable(CachedCharSequence value, int valueType) {
        this.columnNameType.add(valueType);
        this.columnValues.add(value.getCacheAddress());
    }

    private void putValue(TableWriter.Row row, int index, int columnType, CharSequence value) throws BadCastException {
        writers.getQuick(columnType).write(row, index, value);
    }

    private void switchModeToAppend() {
        if (this.onLineEnd != this.MY_LINE_END) {
            this.onLineEnd = this.MY_LINE_END;
            this.onFieldName = this.MY_FIELD_NAME;
            this.onFieldValue = this.MY_FIELD_VALUE;
            this.onTagValue = this.MY_TAG_VALUE;
        }
    }

    private void switchModeToSkipLine() {
        if (this.onFieldValue != NOOP_FIELD_VALUE) {
            this.onFieldValue = NOOP_FIELD_VALUE;
            this.onFieldName = NOOP_FIELD_NAME;
            this.onTagValue = NOOP_FIELD_VALUE;
            this.onLineEnd = NOOP_LINE_END;
        }
    }

    private void switchTable(CachedCharSequence tableName, int entryIndex) {
        CacheEntry entry;
        CacheEntry e;
        if (this.cacheEntryIndex != 0 && (e = this.writerCache.valueAtQuick(this.cacheEntryIndex)).writer != null) {
            this.commitList.put(e.writer.getName(), e.writer);
        }
        if (entryIndex < 0) {
            entry = this.writerCache.valueAtQuick(entryIndex);
        } else {
            entry = new CacheEntry();
            this.writerCache.putAt(entryIndex, Chars.toString(tableName), entry);
            entryIndex = -entryIndex - 1;
        }
        this.cacheEntryIndex = entryIndex;
        if (entry.writer == null) {
            this.initCacheEntry(tableName, entry);
        } else {
            this.createState(entry);
        }
    }

    static {
        writers.extendAndSet(5, CairoLineProtoParser::putLong);
        writers.extendAndSet(0, CairoLineProtoParser::putBoolean);
        writers.extendAndSet(10, CairoLineProtoParser::putStr);
        writers.extendAndSet(11, CairoLineProtoParser::putSymbol);
        writers.extendAndSet(9, CairoLineProtoParser::putDouble);
    }

    private class TableStructureAdapter
    implements TableStructure {
        private CharSequenceCache cache;
        private int columnCount;
        private int timestampIndex;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            if (columnIndex == this.getTimestampIndex()) {
                return "timestamp";
            }
            return this.cache.get(CairoLineProtoParser.this.columnNameType.getQuick(columnIndex * 2));
        }

        @Override
        public int getColumnType(int columnIndex) {
            if (columnIndex == this.getTimestampIndex()) {
                return 7;
            }
            return (int)CairoLineProtoParser.this.columnNameType.getQuick(columnIndex * 2 + 1);
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return 0;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return false;
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return false;
        }

        @Override
        public int getPartitionBy() {
            return 3;
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            return CairoLineProtoParser.this.configuration.getDefaultSymbolCacheFlag();
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            return CairoLineProtoParser.this.configuration.getDefaultSymbolCapacity();
        }

        @Override
        public CharSequence getTableName() {
            return this.cache.get(CairoLineProtoParser.this.tableName);
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }

        TableStructureAdapter of(CharSequenceCache cache) {
            this.cache = cache;
            this.timestampIndex = CairoLineProtoParser.this.columnNameType.size() / 2;
            this.columnCount = this.timestampIndex + 1;
            return this;
        }
    }

    private static class CacheEntry {
        private TableWriter writer;
        private int state = 0;

        private CacheEntry() {
        }
    }

    private static class BadCastException
    extends Exception {
        private static final BadCastException INSTANCE = new BadCastException();

        private BadCastException() {
        }
    }

    @FunctionalInterface
    private static interface FieldValueParser {
        public void parse(CachedCharSequence var1, CharSequenceCache var2);
    }

    @FunctionalInterface
    private static interface FieldNameParser {
        public void parse(CachedCharSequence var1);
    }

    @FunctionalInterface
    private static interface LineEndParser {
        public void parse(CharSequenceCache var1);
    }

    private static interface ColumnWriter {
        public void write(TableWriter.Row var1, int var2, CharSequence var3) throws BadCastException;
    }
}

