/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cairo.CairoException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class LineProtoSender
extends AbstractCharSink
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineProtoSender.class);
    private final int capacity;
    private final long bufA;
    private final long bufB;
    private final long sockaddr;
    private final long fd;
    private final NetworkFacade nf;
    private long lo;
    private long hi;
    private long ptr;
    private long lineStart;
    private boolean hasMetric = false;
    private boolean noFields = true;

    public LineProtoSender(int interfaceIPv4Address, int sendToIPv4Address, int sendToPort, int bufferCapacity, int ttl) {
        this(NetworkFacadeImpl.INSTANCE, interfaceIPv4Address, sendToIPv4Address, sendToPort, bufferCapacity, ttl);
    }

    public LineProtoSender(NetworkFacade nf, int interfaceIPv4Address, int sendToIPv4Address, int sendToPort, int capacity, int ttl) {
        this.nf = nf;
        this.capacity = capacity;
        this.fd = nf.socketUdp();
        if (this.fd == -1L) {
            throw NetworkError.instance(nf.errno()).put("could not create UDP socket");
        }
        if (nf.setMulticastInterface(this.fd, interfaceIPv4Address) != 0) {
            int errno = nf.errno();
            nf.close(this.fd, LOG);
            throw NetworkError.instance(errno).put("could not bind to ").ip(interfaceIPv4Address);
        }
        if (nf.setMulticastTtl(this.fd, ttl) != 0) {
            int errno = nf.errno();
            nf.close(this.fd, LOG);
            throw NetworkError.instance(errno).put("could not set ttl [fd=").put(this.fd).put(", ttl=").put(ttl).put(']');
        }
        this.sockaddr = nf.sockaddr(sendToIPv4Address, sendToPort);
        this.bufA = Unsafe.malloc(capacity);
        this.bufB = Unsafe.malloc(capacity);
        this.lo = this.bufA;
        this.hi = this.lo + (long)capacity;
        this.ptr = this.lo;
        this.lineStart = this.lo;
    }

    public void $(long timestamp) {
        this.put(' ').put(timestamp);
        this.$();
    }

    public void $() {
        this.put('\n');
        this.lineStart = this.ptr;
        this.hasMetric = false;
        this.noFields = true;
    }

    @Override
    public void close() {
        if (this.nf.close(this.fd) != 0) {
            LOG.error().$("failed to close UDP socket [fd=").$(this.fd).$(", errno=").$(this.nf.errno()).$(']').$();
        }
        this.nf.freeSockAddr(this.sockaddr);
        Unsafe.free(this.bufA, this.capacity);
        Unsafe.free(this.bufB, this.capacity);
    }

    public LineProtoSender field(CharSequence name, long value) {
        this.field(name).put(value).put('i');
        return this;
    }

    public LineProtoSender field(CharSequence name, CharSequence value) {
        this.field(name).putQuoted(value);
        return this;
    }

    public LineProtoSender field(CharSequence name, double value) {
        this.field(name).put(value);
        return this;
    }

    public LineProtoSender field(CharSequence name, boolean value) {
        this.field(name).put(value ? (char)'t' : 'f');
        return this;
    }

    @Override
    public void flush() {
        this.send();
        this.ptr = this.lineStart = this.lo;
    }

    @Override
    public LineProtoSender put(CharSequence cs) {
        int l = cs.length();
        if (this.ptr + (long)l < this.hi) {
            Chars.asciiStrCpy(cs, l, this.ptr);
        } else {
            this.send00();
            if (this.ptr + (long)l < this.hi) {
                Chars.asciiStrCpy(cs, l, this.ptr);
            } else {
                throw CairoException.instance(0).put("value too long");
            }
        }
        this.ptr += (long)l;
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        if (this.ptr + (long)len < this.hi) {
            Chars.asciiCopyTo(chars, start, len, this.ptr);
        } else {
            this.send00();
            if (this.ptr + (long)len < this.hi) {
                Chars.asciiCopyTo(chars, start, len, this.ptr);
            } else {
                throw CairoException.instance(0).put("value too long");
            }
        }
        this.ptr += (long)len;
        return this;
    }

    public LineProtoSender metric(CharSequence metric) {
        if (this.hasMetric) {
            throw CairoException.instance(0).put("duplicate metric");
        }
        this.hasMetric = true;
        return this.put(metric);
    }

    @Override
    public LineProtoSender put(char c) {
        if (this.ptr >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putByte(this.ptr++, (byte)c);
        return this;
    }

    public LineProtoSender tag(CharSequence tag, CharSequence value) {
        if (this.hasMetric) {
            this.put(',').putNameEscaped(tag).put('=').encodeUtf8(value);
            return this;
        }
        throw CairoException.instance(0).put("metric expected");
    }

    private CharSink field(CharSequence name) {
        if (this.hasMetric) {
            if (this.noFields) {
                this.put(' ');
                this.noFields = false;
            } else {
                this.put(',');
            }
            return this.putNameEscaped(name).put('=');
        }
        throw CairoException.instance(0).put("metric expected");
    }

    private LineProtoSender putNameEscaped(CharSequence name) {
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case ' ': 
                case ',': 
                case '=': {
                    this.put('\\');
                }
            }
            this.put(c);
        }
        return this;
    }

    private void send() {
        int len;
        if (this.lo < this.lineStart && this.nf.sendTo(this.fd, this.lo, len = (int)(this.lineStart - this.lo), this.sockaddr) != len) {
            throw NetworkError.instance(this.nf.errno()).put("send error");
        }
    }

    private void send00() {
        int len = (int)(this.ptr - this.lineStart);
        if (len == 0) {
            this.send();
            this.ptr = this.lineStart = this.lo;
        } else if (len < this.capacity) {
            long target = this.lo == this.bufA ? this.bufB : this.bufA;
            Unsafe.getUnsafe().copyMemory(this.lineStart, target, len);
            this.send();
            this.lineStart = this.lo = target;
            this.ptr = target + (long)len;
            this.hi = this.lo + (long)this.capacity;
        } else {
            throw NetworkError.instance(0).put("line too long");
        }
    }
}

