/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertStatement;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.BindVariableSetter;
import io.questdb.cutlass.pgwire.PGAuthenticator;
import io.questdb.cutlass.pgwire.PGBasicAuthenticator;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.engine.functions.bind.BindVariableService;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.IOContext;
import io.questdb.network.IODispatcher;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StdoutSink;
import io.questdb.std.time.DateFormatUtils;
import io.questdb.std.time.DateLocaleFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PGConnectionContext
implements IOContext,
Mutable {
    private static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    private static final int INIT_SSL_REQUEST = 80877103;
    private static final int INIT_STARTUP_MESSAGE = 196608;
    private static final int INIT_CANCEL_REQUEST = 80877102;
    private static final int TAIL_NONE = 0;
    private static final int TAIL_SUCCESS = 1;
    private static final int TAIL_ERROR = 2;
    private static final byte MESSAGE_TYPE_COMMAND_COMPLETE = 67;
    private static final byte MESSAGE_TYPE_DATA_ROW = 68;
    private static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    private static final Log LOG = LogFactory.getLog(PGConnectionContext.class);
    private static final IntList typeOids = new IntList();
    private static final int PREFIXED_MESSAGE_HEADER_LEN = 5;
    private static final byte MESSAGE_TYPE_LOGIN_RESPONSE = 82;
    private static final byte MESSAGE_TYPE_PARAMETER_STATUS = 83;
    private static final byte MESSAGE_TYPE_ROW_DESCRIPTION = 84;
    private static final byte MESSAGE_TYPE_PARSE_COMPLETE = 49;
    private static final byte MESSAGE_TYPE_COPY_IN_RESPONSE = 71;
    private final long recvBuffer;
    private final long sendBuffer;
    private final int recvBufferSize;
    private final CharacterStore connectionCharacterStore;
    private final CharacterStore queryCharacterStore;
    private final BindVariableService bindVariableService = new BindVariableService();
    private final long sendBufferLimit;
    private final int sendBufferSize;
    private final ResponseAsciiSink responseAsciiSink = new ResponseAsciiSink();
    private final DirectByteCharSequence dbcs = new DirectByteCharSequence();
    private final int maxBlobSizeOnQuery;
    private final NetworkFacade nf;
    private final boolean dumpNetworkTraffic;
    private final int idleSendCountBeforeGivingUp;
    private final int idleRecvCountBeforeGivingUp;
    private final String serverVersion;
    private final PGAuthenticator authenticator;
    private final SqlExecutionContextImpl sqlExecutionContext = new SqlExecutionContextImpl();
    private final Path path = new Path();
    private final BindVariableSetter doubleSetter = this::setDoubleBindVariable;
    private final BindVariableSetter doubleTxtSetter = this::setDoubleTextBindVariable;
    private final BindVariableSetter intSetter = this::setIntBindVariable;
    private final BindVariableSetter intTxtSetter = this::setIntTextBindVariable;
    private final BindVariableSetter longSetter = this::setLongBindVariable;
    private final BindVariableSetter longTxtSetter = this::setLongTextBindVariable;
    private final BindVariableSetter floatSetter = this::setFloatBindVariable;
    private final BindVariableSetter floatTxtSetter = this::setFloatTextBindVariable;
    private final BindVariableSetter byteSetter = this::setByteBindVariable;
    private final BindVariableSetter byteTxtSetter = this::setByteTextBindVariable;
    private final BindVariableSetter booleanSetter = this::setBooleanBindVariable;
    private final BindVariableSetter strSetter = this::setStrBindVariable;
    private final BindVariableSetter noopSetter = this::setNoopBindVariable;
    private final BindVariableSetter dateSetter = this::setDateBindVariable;
    private final ObjList<ColumnAppender> columnAppenders = new ObjList();
    @Nullable
    private final MessageBus messageBus;
    private int sendCurrentCursorTail = 0;
    private long sendBufferPtr;
    private boolean requireInitalMessage = false;
    private long recvBufferWriteOffset = 0L;
    private long recvBufferReadOffset = 0L;
    private int bufferRemainingOffset = 0;
    private int bufferRemainingSize = 0;
    private RecordCursor currentCursor = null;
    private RecordCursorFactory currentFactory = null;
    private InsertStatement currentInsertStatement = null;
    private long fd;
    private CharSequence queryText;
    private CharSequence username;
    private boolean authenticationRequired = true;
    private long transientCopyBuffer = 0L;
    private IODispatcher<PGConnectionContext> dispatcher;

    public PGConnectionContext(PGWireConfiguration configuration, @Nullable MessageBus messageBus) {
        this.nf = configuration.getNetworkFacade();
        this.recvBufferSize = Numbers.ceilPow2(configuration.getRecvBufferSize());
        this.recvBuffer = Unsafe.malloc(this.recvBufferSize);
        this.sendBufferSize = Numbers.ceilPow2(configuration.getSendBufferSize());
        this.sendBufferPtr = this.sendBuffer = Unsafe.malloc(this.sendBufferSize);
        this.sendBufferLimit = this.sendBuffer + (long)this.sendBufferSize;
        this.queryCharacterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
        this.connectionCharacterStore = new CharacterStore(256, 2);
        this.maxBlobSizeOnQuery = configuration.getMaxBlobSizeOnQuery();
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.idleSendCountBeforeGivingUp = configuration.getIdleSendCountBeforeGivingUp();
        this.idleRecvCountBeforeGivingUp = configuration.getIdleRecvCountBeforeGivingUp();
        this.serverVersion = configuration.getServerVersion();
        this.authenticator = new PGBasicAuthenticator(configuration.getDefaultUsername(), configuration.getDefaultPassword());
        this.messageBus = messageBus;
        this.populateAppender();
    }

    public static int getInt(long address) {
        int b = Unsafe.getUnsafe().getByte(address) & 0xFF;
        b = b << 8 | Unsafe.getUnsafe().getByte(address + 1L) & 0xFF;
        b = b << 8 | Unsafe.getUnsafe().getByte(address + 2L) & 0xFF;
        return b << 8 | Unsafe.getUnsafe().getByte(address + 3L) & 0xFF;
    }

    public static long getLong(long address) {
        long b = Unsafe.getUnsafe().getByte(address) & 0xFF;
        b = b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 1L) & 0xFF);
        b = b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 2L) & 0xFF);
        b = b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 3L) & 0xFF);
        b = b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 4L) & 0xFF);
        b = b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 5L) & 0xFF);
        b = b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 6L) & 0xFF);
        return b << 8 | (long)(Unsafe.getUnsafe().getByte(address + 7L) & 0xFF);
    }

    public static short getShort(long address) {
        int b = Unsafe.getUnsafe().getByte(address) & 0xFF;
        return (short)(b << 8 | Unsafe.getUnsafe().getByte(address + 1L) & 0xFF);
    }

    public static long getStringLength(long x, long limit) {
        return Unsafe.getUnsafe().getByte(x) == 0 ? x : PGConnectionContext.getStringLengthTedious(x, limit);
    }

    public static long getStringLengthTedious(long x, long limit) {
        for (long i = x; i < limit; ++i) {
            if (Unsafe.getUnsafe().getByte(i) != 0) continue;
            return i;
        }
        return -1L;
    }

    public static void putInt(long address, int value) {
        Unsafe.getUnsafe().putByte(address, (byte)(value >>> 24));
        Unsafe.getUnsafe().putByte(address + 1L, (byte)(value >>> 16));
        Unsafe.getUnsafe().putByte(address + 2L, (byte)(value >>> 8));
        Unsafe.getUnsafe().putByte(address + 3L, (byte)value);
    }

    public static void putShort(long address, short value) {
        Unsafe.getUnsafe().putByte(address, (byte)(value >>> 8));
        Unsafe.getUnsafe().putByte(address + 1L, (byte)value);
    }

    private static void ensureValueLength(int required, int valueLen) throws BadProtocolException {
        if (required != valueLen) {
            LOG.error().$("bad parameter value length [required=").$(required).$(", actual=").$(valueLen).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
    }

    private static void ensureData(long lo, int required, long msgLimit, int j) throws BadProtocolException {
        if (lo + (long)required > msgLimit) {
            LOG.info().$("not enough bytes for parameter [index=").$(j).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
    }

    private static void prepareParams(ResponseAsciiSink sink, String name, String value) {
        sink.put((byte)83);
        long addr = sink.skip();
        sink.encodeUtf8Z(name);
        sink.encodeUtf8Z(value);
        sink.putLen(addr);
    }

    static void prepareReadyForQuery(ResponseAsciiSink responseAsciiSink) {
        responseAsciiSink.put((byte)90);
        responseAsciiSink.putNetworkInt(5);
        responseAsciiSink.put('I');
    }

    @Override
    public void clear() {
        this.sendCurrentCursorTail = 0;
        this.sendBufferPtr = this.sendBuffer;
        this.requireInitalMessage = true;
        this.recvBufferWriteOffset = 0L;
        this.recvBufferReadOffset = 0L;
        this.bufferRemainingOffset = 0;
        this.bufferRemainingSize = 0;
        this.responseAsciiSink.reset();
        this.prepareForNewQuery();
        this.authenticationRequired = true;
        this.username = null;
    }

    @Override
    public void close() {
        this.clear();
        this.fd = -1L;
        Unsafe.free(this.sendBuffer, this.sendBufferSize);
        Unsafe.free(this.recvBuffer, this.recvBufferSize);
        Misc.free(this.path);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public boolean invalid() {
        return this.fd == -1L;
    }

    public void handleClientOperation(SqlCompiler compiler, AssociativeCache<Object> factoryCache, ObjList<BindVariableSetter> binsVariableSetters) throws PeerDisconnectedException, PeerIsSlowToReadException, PeerIsSlowToWriteException, BadProtocolException {
        if (this.bufferRemainingSize > 0) {
            this.doSend(this.bufferRemainingOffset, this.bufferRemainingSize);
        }
        this.sendExecuteTail();
        if (this.recvBufferReadOffset == this.recvBufferWriteOffset) {
            this.recv();
        }
        try {
            long readOffsetBeforeParse = this.recvBufferReadOffset;
            this.parse(this.recvBuffer + this.recvBufferReadOffset, (int)(this.recvBufferWriteOffset - this.recvBufferReadOffset), compiler, factoryCache, binsVariableSetters);
            if (readOffsetBeforeParse == this.recvBufferReadOffset) {
                if (readOffsetBeforeParse < this.recvBufferWriteOffset) {
                    this.recv();
                    if (readOffsetBeforeParse == this.recvBufferReadOffset) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (this.recvBufferWriteOffset - this.recvBufferReadOffset > 0L) {
                do {
                    readOffsetBeforeParse = this.recvBufferReadOffset;
                    this.parse(this.recvBuffer + this.recvBufferReadOffset, (int)(this.recvBufferWriteOffset - this.recvBufferReadOffset), compiler, factoryCache, binsVariableSetters);
                    if (readOffsetBeforeParse != this.recvBufferReadOffset) continue;
                    Unsafe.getUnsafe().copyMemory(this.recvBuffer + readOffsetBeforeParse, this.recvBuffer, this.recvBufferWriteOffset - readOffsetBeforeParse);
                    this.recvBufferWriteOffset -= readOffsetBeforeParse;
                    this.recvBufferReadOffset = 0L;
                    return;
                } while (this.recvBufferReadOffset < this.recvBufferWriteOffset);
            }
            this.clearRecvBuffer();
        }
        catch (SqlException e) {
            this.sendExecuteTail(2);
            this.clearRecvBuffer();
        }
    }

    public PGConnectionContext of(long clientFd, IODispatcher<PGConnectionContext> dispatcher) {
        this.fd = clientFd;
        this.dispatcher = dispatcher;
        this.clear();
        return this;
    }

    public IODispatcher<PGConnectionContext> getDispatcher() {
        return this.dispatcher;
    }

    public void setBooleanBindVariable(int index, long address, int valueLen) throws SqlException {
        if (valueLen != 4 && valueLen != 5) {
            throw SqlException.$(0, "bad value for BOOLEAN parameter [index=").put(index).put(", valueLen=").put(valueLen).put(']');
        }
        this.bindVariableService.setBoolean(index, valueLen == 4);
    }

    public void setByteBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        PGConnectionContext.ensureValueLength(2, valueLen);
        this.bindVariableService.setByte(index, (byte)PGConnectionContext.getShort(address));
    }

    public void setByteTextBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        try {
            this.bindVariableService.setByte(index, (byte)Numbers.parseInt(this.dbcs.of(address, address + (long)valueLen)));
        }
        catch (NumericException e) {
            LOG.error().$("bad byte variable value [index=").$(index).$(", value=`").$(this.dbcs).$("`").$();
            throw BadProtocolException.INSTANCE;
        }
    }

    public void setDateBindVariable(int index, long address, int valueLen) throws SqlException {
        this.dbcs.of(address, address + (long)valueLen);
        try {
            this.bindVariableService.setDate(index, DateFormatUtils.PG_DATE_Z_FORMAT.parse(this.dbcs, DateLocaleFactory.INSTANCE.getDefaultDateLocale()));
        }
        catch (NumericException ex) {
            try {
                this.bindVariableService.setDate(index, DateFormatUtils.PG_DATE_TIME_Z_FORMAT.parse(this.dbcs, DateLocaleFactory.INSTANCE.getDefaultDateLocale()));
            }
            catch (NumericException exc) {
                throw SqlException.$(0, "bad parameter value [index=").put(index).put(", value=").put(this.dbcs).put(']');
            }
        }
    }

    public void setDoubleBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        PGConnectionContext.ensureValueLength(8, valueLen);
        this.bindVariableService.setDouble(index, Double.longBitsToDouble(PGConnectionContext.getLong(address)));
    }

    public void setDoubleTextBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        try {
            this.bindVariableService.setDouble(index, Numbers.parseDouble(this.dbcs.of(address, address + (long)valueLen)));
        }
        catch (NumericException e) {
            LOG.error().$("bad double variable value [index=").$(index).$(", value=`").$(this.dbcs).$("`]").$();
            throw BadProtocolException.INSTANCE;
        }
    }

    public void setFloatBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        PGConnectionContext.ensureValueLength(4, valueLen);
        this.bindVariableService.setFloat(index, Float.intBitsToFloat(PGConnectionContext.getInt(address)));
    }

    public void setFloatTextBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        try {
            this.bindVariableService.setFloat(index, Numbers.parseFloat(this.dbcs.of(address, address + (long)valueLen)));
        }
        catch (NumericException e) {
            throw BadProtocolException.INSTANCE;
        }
    }

    public void setIntBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        PGConnectionContext.ensureValueLength(4, valueLen);
        this.bindVariableService.setInt(index, PGConnectionContext.getInt(address));
    }

    public void setIntTextBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        try {
            this.bindVariableService.setInt(index, Numbers.parseInt(this.dbcs.of(address, address + (long)valueLen)));
        }
        catch (NumericException e) {
            LOG.error().$("bad int variable value [index=").$(index).$(", value=`").$(this.dbcs).$("`]").$();
            throw BadProtocolException.INSTANCE;
        }
    }

    public void setLongBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        PGConnectionContext.ensureValueLength(8, valueLen);
        this.bindVariableService.setLong(index, PGConnectionContext.getLong(address));
    }

    public void setLongTextBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        try {
            this.bindVariableService.setLong(index, Numbers.parseLong(this.dbcs.of(address, address + (long)valueLen)));
        }
        catch (NumericException e) {
            LOG.error().$("bad long variable value [index=").$(index).$(", value=`").$(this.dbcs).$("`]").$();
            throw BadProtocolException.INSTANCE;
        }
    }

    public void setNoopBindVariable(int index, long address, int valueLen) {
    }

    public void setStrBindVariable(int index, long address, int valueLen) throws BadProtocolException {
        CharacterStoreEntry e = this.queryCharacterStore.newEntry();
        if (!Chars.utf8Decode(address, address + (long)valueLen, e)) {
            LOG.error().$("invalid UTF8 bytes [index=").$(index).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.bindVariableService.setStr(index, this.queryCharacterStore.toImmutable());
    }

    private void populateAppender() {
        this.columnAppenders.extendAndSet(4, this::appendIntCol);
        this.columnAppenders.extendAndSet(10, this::appendStrColumn);
        this.columnAppenders.extendAndSet(11, this::appendSymbolColumn);
        this.columnAppenders.extendAndSet(5, this::appendLongColumn);
        this.columnAppenders.extendAndSet(2, this::appendShortColumn);
        this.columnAppenders.extendAndSet(9, this::appendDoubleColumn);
        this.columnAppenders.extendAndSet(8, this::appendFloatColumn);
        this.columnAppenders.extendAndSet(7, this::appendTimestampColumn);
        this.columnAppenders.extendAndSet(6, this::appendDateColumn);
        this.columnAppenders.extendAndSet(0, this::appendBooleanColumn);
        this.columnAppenders.extendAndSet(1, this::appendByteColumn);
        this.columnAppenders.extendAndSet(13, this::appendBinColumn);
    }

    private void appendRecord(Record record, RecordMetadata metadata, int columnCount) throws SqlException {
        this.responseAsciiSink.put((byte)68);
        long offset = this.responseAsciiSink.skip();
        this.responseAsciiSink.putNetworkShort((short)columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.columnAppenders.getQuick(metadata.getColumnType(i)).append(record, i);
        }
        this.responseAsciiSink.putLen(offset);
    }

    private void appendBinColumn(Record record, int i) throws SqlException {
        BinarySequence sequence = record.getBin(i);
        if (sequence == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long blobSize = sequence.length();
            if (blobSize < (long)this.maxBlobSizeOnQuery) {
                this.responseAsciiSink.put(sequence);
            } else {
                throw SqlException.position(0).put("blob is too large [blobSize=").put(blobSize).put(", max=").put(this.maxBlobSizeOnQuery).put(", columnIndex=").put(i).put(']');
            }
        }
    }

    private void appendBooleanColumn(Record record, int columnIndex) {
        this.responseAsciiSink.putNetworkInt(1);
        this.responseAsciiSink.put(record.getBool(columnIndex) ? (char)'t' : 'f');
    }

    private void appendByteColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.put((int)record.getByte(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendLongColumn(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(longValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendShortColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.put(record.getShort(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendFloatColumn(Record record, int columnIndex) {
        float floatValue = record.getFloat(columnIndex);
        if (Float.isNaN(floatValue)) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(floatValue, 3);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendDoubleColumn(Record record, int columnIndex) {
        double doubleValue = record.getDouble(columnIndex);
        if (Double.isNaN(doubleValue)) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(doubleValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendDateColumn(Record record, int columnIndex) {
        long longValue = record.getDate(columnIndex);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            DateFormatUtils.PG_DATE_TIME_Z_FORMAT.format(longValue, DateFormatUtils.defaultLocale, "", this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendTimestampColumn(Record record, int i) {
        long longValue = record.getTimestamp(i);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            io.questdb.std.microtime.DateFormatUtils.PG_TIMESTAMP_FORMAT.format(longValue, io.questdb.std.microtime.DateFormatUtils.defaultLocale, "", this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendSymbolColumn(Record record, int columnIndex) {
        CharSequence strValue = record.getSym(columnIndex);
        if (strValue == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.encodeUtf8(strValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendStrColumn(Record record, int columnIndex) {
        CharSequence strValue = record.getStr(columnIndex);
        if (strValue == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.encodeUtf8(strValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendIntCol(Record record, int i) {
        int intValue = record.getInt(i);
        if (intValue == Integer.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(intValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void bindVariables(long lo, long msgLimit, short parameterCount, ObjList<BindVariableSetter> bindVariableSetters) throws BadProtocolException, SqlException {
        int j;
        if (lo + (long)(2 * parameterCount) > msgLimit) {
            LOG.error().$("invalid format code count [value=").$(parameterCount).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        for (j = 0; j < parameterCount; ++j) {
            short code = PGConnectionContext.getShort(lo + (long)(j * 2));
            if (code == 1) continue;
            if (code == 0) {
                bindVariableSetters.setQuick(j * 2, bindVariableSetters.getQuick(j * 2 + 1));
                continue;
            }
            LOG.error().$("unsupported code [index=").$(j).$(", code=").$(code).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.checkNotTrue((lo += (long)(parameterCount * 2)) + 2L > msgLimit, "could not read parameter value count");
        parameterCount = PGConnectionContext.getShort(lo);
        if (parameterCount != this.bindVariableService.getIndexedVariableCount()) {
            LOG.error().$("parameter count from parse message does not match parameter value count [valueCount=").$(parameterCount).$(", typeCount=").$(this.bindVariableService.getIndexedVariableCount()).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        lo += 2L;
        for (j = 0; j < parameterCount; ++j) {
            if (lo + 4L > msgLimit) {
                LOG.error().$("could not read parameter value length [index=").$(j).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            int valueLen = PGConnectionContext.getInt(lo);
            lo += 4L;
            if (valueLen == -1) continue;
            if (lo + (long)valueLen > msgLimit) {
                LOG.error().$("value length is outside of buffer [parameterIndex=").$(j).$(", valueLen=").$(valueLen).$(", messageRemaining=").$(msgLimit - lo).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            PGConnectionContext.ensureData(lo, valueLen, msgLimit, j);
            bindVariableSetters.getQuick(j * 2).set(j, lo, valueLen);
            lo += (long)valueLen;
        }
    }

    void clearRecvBuffer() {
        this.recvBufferWriteOffset = 0L;
        this.recvBufferReadOffset = 0L;
    }

    int doReceive(int remaining) {
        long data = this.recvBuffer + this.recvBufferWriteOffset;
        int n = this.nf.recv(this.getFd(), data, remaining);
        this.dumpBuffer('>', data, n);
        return n;
    }

    void doSend(int offset, int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int n = this.nf.send(this.getFd(), this.sendBuffer + (long)offset, size);
        this.dumpBuffer('<', this.sendBuffer + (long)offset, n);
        if (n < 0) {
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n < size) {
            this.doSendWithRetries(n, size - n);
        }
        this.sendBufferPtr = this.sendBuffer;
        this.bufferRemainingSize = 0;
        this.bufferRemainingOffset = 0;
    }

    private void doSendWithRetries(int bufferOffset, int bufferSize) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int offset = bufferOffset;
        int remaining = bufferSize;
        int idleSendCount = 0;
        while (remaining > 0 && idleSendCount < this.idleSendCountBeforeGivingUp) {
            int m = this.nf.send(this.getFd(), this.sendBuffer + (long)offset, remaining);
            if (m < 0) {
                throw PeerDisconnectedException.INSTANCE;
            }
            this.dumpBuffer('<', this.sendBuffer + (long)offset, m);
            if (m > 0) {
                remaining -= m;
                offset += m;
                continue;
            }
            ++idleSendCount;
        }
        if (remaining > 0) {
            this.bufferRemainingOffset = offset;
            this.bufferRemainingSize = remaining;
            throw PeerIsSlowToReadException.INSTANCE;
        }
    }

    private void dumpBuffer(char direction, long buffer, int len) {
        if (this.dumpNetworkTraffic && len > 0) {
            StdoutSink.INSTANCE.put(direction);
            Net.dump(buffer, len);
        }
    }

    private void parse(long address, int len, SqlCompiler compiler, AssociativeCache<Object> factoryCache, ObjList<BindVariableSetter> bindVariableSetters) throws PeerDisconnectedException, PeerIsSlowToReadException, BadProtocolException, SqlException {
        long limit = address + (long)len;
        int remaining = (int)(limit - address);
        if (this.requireInitalMessage) {
            this.processInitialMessage(address, remaining);
            return;
        }
        if (remaining < 5) {
            return;
        }
        byte type = Unsafe.getUnsafe().getByte(address);
        LOG.debug().$("received msg [type=").$((char)type).$(']').$();
        int msgLen = PGConnectionContext.getInt(address + 1L);
        if (msgLen < 1) {
            LOG.error().$("invalid message length [type=").$(type).$(", msgLen=").$(msgLen).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        if (msgLen > remaining - 1) {
            return;
        }
        this.recvBufferReadOffset += (long)(msgLen + 1);
        long msgLimit = address + (long)msgLen + 1L;
        long lo = address + 5L;
        if (this.authenticationRequired) {
            CairoSecurityContext cairoSecurityContext;
            try {
                cairoSecurityContext = this.authenticator.authenticate(this.username, lo, msgLimit);
            }
            catch (SqlException e) {
                this.prepareError(e);
                this.send();
                return;
            }
            if (cairoSecurityContext != null) {
                this.sqlExecutionContext.with(cairoSecurityContext, this.bindVariableService, this.messageBus);
                this.authenticationRequired = false;
                this.prepareLoginOk(this.responseAsciiSink);
                this.send();
            }
            return;
        }
        switch (type) {
            case 80: {
                this.processParse(address, lo, msgLimit, compiler, factoryCache, bindVariableSetters);
                break;
            }
            case 88: {
                throw PeerDisconnectedException.INSTANCE;
            }
            case 67: {
                this.processClose();
                break;
            }
            case 66: {
                this.processBind(bindVariableSetters, msgLimit, lo);
                break;
            }
            case 69: {
                this.processExecute();
                break;
            }
            case 83: {
                break;
            }
            case 68: {
                this.processDescribe();
                break;
            }
            case 81: {
                this.processQuery(lo, limit, compiler, factoryCache);
                break;
            }
            case 100: {
                System.out.println("data " + msgLen);
                break;
            }
            default: {
                LOG.error().$("unknown message [type=").$(type).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void processQuery(long lo, long limit, SqlCompiler compiler, AssociativeCache<Object> factoryCache) throws BadProtocolException, SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareForNewQuery();
        this.parseQueryText(lo, limit - 1L);
        Object statement = factoryCache.peek(this.queryText);
        if (statement == null) {
            CompiledQuery cc = compiler.compile(this.queryText, this.sqlExecutionContext);
            if (cc.getType() == 0) {
                RecordCursorFactory factory = cc.getRecordCursorFactory();
                factoryCache.put(this.queryText, factory);
                this.executeSelect(factory);
            } else if (cc.getType() == 10) {
                this.sendCopyInResponse(compiler.getEngine(), cc.getTextLoader());
            } else if (cc.getType() == 1) {
                this.currentInsertStatement = cc.getInsertStatement();
                this.executeInsert();
            } else {
                this.sendExecuteTail(1);
            }
        } else if (statement instanceof RecordCursorFactory) {
            this.executeSelect((RecordCursorFactory)statement);
        }
    }

    private void executeSelect(@NotNull RecordCursorFactory factory) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.currentFactory = factory;
        this.currentCursor = factory.getCursor(this.sqlExecutionContext);
        this.prepareRowDescription();
        this.sendCursor();
    }

    private void processDescribe() throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.currentFactory != null) {
            this.prepareRowDescription();
            this.send();
            LOG.info().$("described").$();
        }
    }

    private void processExecute() throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.currentFactory != null) {
            LOG.info().$("executing query").$();
            this.currentCursor = this.currentFactory.getCursor(this.sqlExecutionContext);
            this.sendCursor();
        } else if (this.currentInsertStatement != null) {
            this.executeInsert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsert() throws PeerDisconnectedException, PeerIsSlowToReadException {
        try (InsertMethod m = this.currentInsertStatement.createMethod(this.sqlExecutionContext);){
            m.execute();
            m.commit();
            this.sendExecuteTail(1);
        }
        catch (CairoException e) {
            this.responseAsciiSink.put((byte)69);
            long addr = this.responseAsciiSink.skip();
            this.responseAsciiSink.put('M');
            this.responseAsciiSink.encodeUtf8Z(e.getFlyweightMessage());
            this.responseAsciiSink.put('S');
            this.responseAsciiSink.encodeUtf8Z("ERROR");
            this.responseAsciiSink.put('\u0000');
            this.responseAsciiSink.putLen(addr);
            this.sendExecuteTail(2);
        }
        finally {
            this.currentInsertStatement = null;
        }
    }

    private void processBind(ObjList<BindVariableSetter> bindVariableSetters, long msgLimit, long lo) throws BadProtocolException, SqlException {
        long hi = PGConnectionContext.getStringLength(lo, msgLimit);
        this.checkNotTrue(hi == -1L, "bad portal name length [msgType='B']");
        lo = hi + 1L;
        hi = PGConnectionContext.getStringLength(lo, msgLimit);
        this.checkNotTrue(hi == -1L, "bad prepared statement name length [msgType='B']");
        lo = hi + 1L;
        this.checkNotTrue(lo + 2L > msgLimit, "could not read parameter format code count");
        short parameterCount = PGConnectionContext.getShort(lo);
        if (parameterCount != this.bindVariableService.getIndexedVariableCount()) {
            LOG.error().$("parameter count from parse message does not match format code count [fmtCodeCount=").$(parameterCount).$(", typeCount=").$(this.bindVariableService.getIndexedVariableCount()).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        if (parameterCount > 0) {
            this.bindVariables(lo += 2L, msgLimit, parameterCount, bindVariableSetters);
        }
    }

    private void processClose() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareForNewQuery();
        this.sink().put('3');
        this.sink().putNetworkInt(4);
        this.send();
    }

    private void processParse(long address, long lo, long msgLimit, SqlCompiler compiler, AssociativeCache<Object> factoryCache, ObjList<BindVariableSetter> bindVariableSetters) throws BadProtocolException, SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        long hi = PGConnectionContext.getStringLength(lo, msgLimit);
        this.checkNotTrue(hi == -1L, "bad prepared statement name length");
        lo = hi + 1L;
        hi = PGConnectionContext.getStringLength(lo, msgLimit);
        this.checkNotTrue(hi == -1L, "bad query text length");
        this.prepareForNewQuery();
        this.parseQueryText(lo, hi);
        lo = hi + 1L;
        this.checkNotTrue(lo + 2L > msgLimit, "could not read parameter count");
        short parameterCount = PGConnectionContext.getShort(lo);
        if (parameterCount > 0) {
            if (lo + 2L + (long)(parameterCount * 4) > msgLimit) {
                LOG.error().$("could not read parameters [parameterCount=").$(parameterCount).$(", offset=").$(lo - address).$(", remaining=").$(msgLimit - lo).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            LOG.debug().$("params [count=").$(parameterCount).$(']').$();
            this.bindVariableService.clear();
            this.setupBindVariables(lo += 2L, parameterCount, bindVariableSetters);
        } else if (parameterCount < 0) {
            LOG.error().$("invalid parameter count [parameterCount=").$(parameterCount).$(", offset=").$(lo - address).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.responseAsciiSink.reset();
        Object statement = factoryCache.peek(this.queryText);
        if (statement == null) {
            CompiledQuery cc = compiler.compile(this.queryText, this.sqlExecutionContext);
            if (cc.getType() == 0) {
                this.currentFactory = cc.getRecordCursorFactory();
                factoryCache.put(this.queryText, this.currentFactory);
            } else if (cc.getType() == 1) {
                this.currentInsertStatement = cc.getInsertStatement();
                factoryCache.put(this.queryText, this.currentInsertStatement);
            } else if (cc.getType() == 7) {
                this.sendCopyInResponse(compiler.getEngine(), cc.getTextLoader());
            } else {
                this.prepareParseComplete();
                PGConnectionContext.prepareReadyForQuery(this.responseAsciiSink);
                LOG.info().$("executed DDL").$();
                this.send();
            }
        } else if (statement instanceof RecordCursorFactory) {
            this.currentFactory = (RecordCursorFactory)statement;
        } else if (statement instanceof InsertStatement) {
            this.currentInsertStatement = (InsertStatement)statement;
        } else assert (false);
    }

    private void checkNotTrue(boolean check, String message) throws BadProtocolException {
        if (check) {
            LOG.error().$(message).$();
            throw BadProtocolException.INSTANCE;
        }
    }

    private void parseQueryText(long lo, long hi) throws BadProtocolException {
        CharacterStoreEntry e = this.queryCharacterStore.newEntry();
        if (!Chars.utf8Decode(lo, hi, e)) {
            LOG.error().$("invalid UTF8 bytes in parse query").$();
            throw BadProtocolException.INSTANCE;
        }
        this.queryText = this.queryCharacterStore.toImmutable();
        LOG.info().$("parse [q=").utf8(this.queryText).$(']').$();
    }

    void prepareCommandComplete() {
        this.responseAsciiSink.put((byte)67);
        long addr = this.responseAsciiSink.skip();
        this.responseAsciiSink.encodeUtf8(this.queryText).put('\u0000');
        this.responseAsciiSink.putLen(addr);
    }

    private void prepareError(SqlException e) {
        this.responseAsciiSink.put((byte)69);
        long addr = this.responseAsciiSink.skip();
        this.responseAsciiSink.put('M');
        this.responseAsciiSink.encodeUtf8Z(e.getFlyweightMessage());
        this.responseAsciiSink.put('S');
        this.responseAsciiSink.encodeUtf8Z("ERROR");
        if (e.getPosition() > -1) {
            this.responseAsciiSink.put('P').put(e.getPosition() + 1).put('\u0000');
        }
        this.responseAsciiSink.put('\u0000');
        this.responseAsciiSink.putLen(addr);
    }

    private void prepareForNewQuery() {
        this.queryCharacterStore.clear();
        this.bindVariableService.clear();
        this.currentCursor = Misc.free(this.currentCursor);
        this.currentFactory = null;
        this.currentInsertStatement = null;
    }

    private void prepareLoginOk(ResponseAsciiSink sink) {
        sink.reset();
        sink.put((byte)82);
        sink.putNetworkInt(8);
        sink.putNetworkInt(0);
        PGConnectionContext.prepareParams(sink, "TimeZone", "GMT");
        PGConnectionContext.prepareParams(sink, "application_name", "QuestDB");
        PGConnectionContext.prepareParams(sink, "server_version", this.serverVersion);
        PGConnectionContext.prepareParams(sink, "integer_datetimes", "on");
        PGConnectionContext.prepareReadyForQuery(sink);
    }

    private void prepareParseComplete() {
        this.responseAsciiSink.put((byte)49);
        this.responseAsciiSink.putNetworkInt(4);
    }

    private void prepareRowDescription() {
        RecordMetadata metadata = this.currentFactory.getMetadata();
        ResponseAsciiSink sink = this.responseAsciiSink;
        sink.put((byte)84);
        long addr = sink.skip();
        int n = metadata.getColumnCount();
        sink.putNetworkShort((short)n);
        for (int i = 0; i < n; ++i) {
            int columnType = metadata.getColumnType(i);
            sink.encodeUtf8Z(metadata.getColumnName(i));
            sink.putNetworkInt(0);
            sink.putNetworkShort((short)0);
            sink.putNetworkInt(typeOids.get(columnType));
            sink.putNetworkShort((short)0);
            sink.putNetworkInt(0);
            sink.putNetworkShort((short)(columnType == 13 ? 1 : 0));
        }
        sink.putLen(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInitialMessage(long address, int remaining) throws PeerDisconnectedException, PeerIsSlowToReadException, BadProtocolException {
        if (remaining < 8) {
            return;
        }
        int msgLen = PGConnectionContext.getInt(address);
        if (msgLen > remaining) {
            return;
        }
        this.recvBufferReadOffset += (long)msgLen;
        int protocol = PGConnectionContext.getInt(address + 4L);
        switch (protocol) {
            case 80877103: {
                this.responseAsciiSink.put('N');
                this.send();
                return;
            }
            case 196608: {
                this.requireInitalMessage = false;
                long msgLimit = address + (long)msgLen;
                long lo = address + 8L;
                LOG.info().$("protocol [major=").$(protocol >> 16).$(", minor=").$((short)protocol).$(']').$();
                this.connectionCharacterStore.clear();
                while (lo < msgLimit - 1L) {
                    LogRecord log = LOG.info();
                    log.$("property [");
                    try {
                        long hi = PGConnectionContext.getStringLength(lo, msgLimit);
                        if (hi == -1L) {
                            log.$("malformed property name");
                            throw BadProtocolException.INSTANCE;
                        }
                        log.$("name=").$(this.dbcs.of(lo, hi));
                        boolean username = Chars.equals((CharSequence)"user", this.dbcs);
                        lo = hi + 1L;
                        hi = PGConnectionContext.getStringLength(lo, msgLimit);
                        if (hi == -1L) {
                            log.$(", malformed property value");
                            throw BadProtocolException.INSTANCE;
                        }
                        log.$(", value=").$(this.dbcs.of(lo, hi));
                        lo = hi + 1L;
                        if (!username) continue;
                        CharacterStoreEntry e = this.connectionCharacterStore.newEntry();
                        e.put(this.dbcs);
                        this.username = e.toImmutable();
                    }
                    finally {
                        log.$(']').$();
                    }
                }
                this.checkNotTrue(this.username == null, "user is not specified");
                this.sendClearTextPasswordChallenge();
                break;
            }
            case 80877102: {
                LOG.info().$("cancel request").$();
                throw PeerDisconnectedException.INSTANCE;
            }
            default: {
                LOG.error().$("unknown init message [protocol=").$(protocol).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    void recv() throws PeerDisconnectedException, PeerIsSlowToWriteException, BadProtocolException {
        int remaining = (int)((long)this.recvBufferSize - this.recvBufferWriteOffset);
        this.checkNotTrue(remaining < 1, "undersized receive buffer or someone is abusing protocol");
        int n = this.doReceive(remaining);
        if (n < 0) {
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n == 0) {
            int retriesRemaining;
            for (retriesRemaining = this.idleRecvCountBeforeGivingUp; retriesRemaining > 0; --retriesRemaining) {
                n = this.doReceive(remaining);
                if (n == 0) {
                    continue;
                }
                if (n >= 0) break;
                LOG.info().$("disconnect [code=").$(n).$(']').$();
                throw PeerDisconnectedException.INSTANCE;
            }
            if (retriesRemaining == 0) {
                throw PeerIsSlowToWriteException.INSTANCE;
            }
        }
        this.recvBufferWriteOffset += (long)n;
    }

    private void send(int tailType) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.sendCurrentCursorTail = tailType;
        this.send();
    }

    private void send() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doSend(0, (int)(this.sendBufferPtr - this.sendBuffer));
    }

    private void sendClearTextPasswordChallenge() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.responseAsciiSink.reset();
        this.responseAsciiSink.put((byte)82);
        this.responseAsciiSink.putNetworkInt(8);
        this.responseAsciiSink.putNetworkInt(3);
        this.send();
    }

    private void sendCopyInResponse(CairoEngine engine, TextLoader textLoader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (0 == engine.getStatus(this.sqlExecutionContext.getCairoSecurityContext(), this.path, textLoader.getTableName())) {
            this.responseAsciiSink.put((byte)71);
            long addr = this.responseAsciiSink.skip();
            this.responseAsciiSink.put((byte)0);
            try (TableWriter writer = engine.getWriter(this.sqlExecutionContext.getCairoSecurityContext(), textLoader.getTableName());){
                RecordMetadata metadata = writer.getMetadata();
                this.responseAsciiSink.putNetworkShort((short)metadata.getColumnCount());
                int n = metadata.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    this.responseAsciiSink.putNetworkShort((short)typeOids.get(metadata.getColumnType(i)));
                }
            }
            this.responseAsciiSink.putLen(addr);
            this.transientCopyBuffer = Unsafe.malloc(0x100000L);
            this.send();
        } else {
            this.prepareError(SqlException.$(0, "table '").put(textLoader.getTableName()).put("' does not exist"));
            PGConnectionContext.prepareReadyForQuery(this.responseAsciiSink);
            this.send();
        }
    }

    private void sendCursor() throws PeerDisconnectedException, PeerIsSlowToReadException {
        Record record = this.currentCursor.getRecord();
        RecordMetadata metadata = this.currentFactory.getMetadata();
        int columnCount = metadata.getColumnCount();
        while (this.currentCursor.hasNext()) {
            this.responseAsciiSink.bookmark();
            try {
                try {
                    this.appendRecord(record, metadata, columnCount);
                }
                catch (NoSpaceLeftInResponseBufferException e) {
                    this.responseAsciiSink.resetToBookmark();
                    this.send();
                    this.appendRecord(record, metadata, columnCount);
                }
            }
            catch (SqlException e) {
                this.responseAsciiSink.resetToBookmark();
                LOG.error().$(e.getFlyweightMessage()).$();
                this.prepareForNewQuery();
                this.send(2);
                return;
            }
        }
        this.prepareForNewQuery();
        this.send(1);
        this.sendExecuteTail();
    }

    private void sendExecuteTail(int tail) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.sendCurrentCursorTail = tail;
        this.sendExecuteTail();
    }

    private void sendExecuteTail() throws PeerDisconnectedException, PeerIsSlowToReadException {
        switch (this.sendCurrentCursorTail) {
            case 1: {
                this.prepareCommandComplete();
                PGConnectionContext.prepareReadyForQuery(this.responseAsciiSink);
                LOG.info().$("executed query").$();
                break;
            }
            case 2: {
                SqlException e = SqlException.last();
                this.prepareError(e);
                PGConnectionContext.prepareReadyForQuery(this.responseAsciiSink);
                LOG.info().$("SQL exception [pos=").$(e.getPosition()).$(", msg=").$(e.getFlyweightMessage()).$(']').$();
                break;
            }
        }
        this.send(0);
    }

    private void setupBindVariables(long lo, short pc, ObjList<BindVariableSetter> bindVariableSetters) throws SqlException {
        bindVariableSetters.clear();
        block11: for (int j = 0; j < pc; ++j) {
            int pgType = PGConnectionContext.getInt(lo + (long)(j * 4));
            switch (pgType) {
                case 701: {
                    this.bindVariableService.setDouble(j, Double.NaN);
                    bindVariableSetters.add(this.doubleSetter);
                    bindVariableSetters.add(this.doubleTxtSetter);
                    continue block11;
                }
                case 23: {
                    this.bindVariableService.setInt(j, Integer.MIN_VALUE);
                    bindVariableSetters.add(this.intSetter);
                    bindVariableSetters.add(this.intTxtSetter);
                    continue block11;
                }
                case 20: {
                    this.bindVariableService.setLong(j, Long.MIN_VALUE);
                    bindVariableSetters.add(this.longSetter);
                    bindVariableSetters.add(this.longTxtSetter);
                    continue block11;
                }
                case 700: {
                    this.bindVariableService.setFloat(j, Float.NaN);
                    bindVariableSetters.add(this.floatSetter);
                    bindVariableSetters.add(this.floatTxtSetter);
                    continue block11;
                }
                case 21: {
                    this.bindVariableService.setByte(j, (byte)0);
                    bindVariableSetters.add(this.byteSetter);
                    bindVariableSetters.add(this.byteTxtSetter);
                    continue block11;
                }
                case 16: {
                    this.bindVariableService.setBoolean(j, false);
                    bindVariableSetters.add(this.booleanSetter);
                    bindVariableSetters.add(this.booleanSetter);
                    continue block11;
                }
                case 1043: {
                    this.bindVariableService.setStr(j, null);
                    bindVariableSetters.add(this.strSetter);
                    bindVariableSetters.add(this.strSetter);
                    continue block11;
                }
                case 1082: {
                    this.bindVariableService.setDate(j, Long.MIN_VALUE);
                    bindVariableSetters.add(this.noopSetter);
                    bindVariableSetters.add(this.noopSetter);
                    continue block11;
                }
                case 0: 
                case 1114: 
                case 1184: {
                    this.bindVariableService.setDate(j, Long.MIN_VALUE);
                    bindVariableSetters.add(this.dateSetter);
                    bindVariableSetters.add(this.dateSetter);
                    continue block11;
                }
                default: {
                    throw SqlException.$(0, "unsupported parameter [type=").put(pgType).put(", index=").put(j).put(']');
                }
            }
        }
    }

    ResponseAsciiSink sink() {
        return this.responseAsciiSink;
    }

    static {
        typeOids.extendAndSet(10, 1043);
        typeOids.extendAndSet(7, 1114);
        typeOids.extendAndSet(9, 701);
        typeOids.extendAndSet(8, 700);
        typeOids.extendAndSet(4, 23);
        typeOids.extendAndSet(2, 21);
        typeOids.extendAndSet(3, 18);
        typeOids.extendAndSet(11, 1043);
        typeOids.extendAndSet(5, 20);
        typeOids.extendAndSet(1, 21);
        typeOids.extendAndSet(0, 16);
        typeOids.extendAndSet(6, 1114);
        typeOids.extendAndSet(13, 17);
    }

    class ResponseAsciiSink
    extends AbstractCharSink {
        private long bookmarkPtr = -1L;

        ResponseAsciiSink() {
        }

        public void bookmark() {
            this.bookmarkPtr = PGConnectionContext.this.sendBufferPtr;
        }

        @Override
        public CharSink put(CharSequence cs) {
            if (cs == null) {
                return this;
            }
            int len = cs.length();
            if (len == 0) {
                return this;
            }
            this.ensureCapacity(len);
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + (long)i, (byte)cs.charAt(i));
            }
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)len;
            return this;
        }

        @Override
        public CharSink put(char c) {
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)c);
            return this;
        }

        public CharSink put(byte b) {
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, b);
            return this;
        }

        public void put(BinarySequence sequence) {
            long len = sequence.length();
            if (len > (long)PGConnectionContext.this.maxBlobSizeOnQuery) {
                this.setNullValue();
            } else {
                this.ensureCapacity((int)(len + 4L));
                PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, (int)len);
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
                for (long x = 0L; x < len; ++x) {
                    Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + x, sequence.byteAt(x));
                }
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + len;
            }
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            this.ensureCapacity(len);
            Chars.asciiCopyTo(chars, start, len, PGConnectionContext.this.sendBufferPtr);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)len;
            return this;
        }

        public void putLen(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start));
        }

        public void putLenEx(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start - 4L));
        }

        public void putNetworkInt(int len) {
            this.ensureCapacity(4);
            PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, len);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putNetworkShort(short value) {
            this.ensureCapacity(2);
            PGConnectionContext.putShort(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 2L;
        }

        public void resetToBookmark() {
            assert (this.bookmarkPtr != -1L);
            PGConnectionContext.this.sendBufferPtr = this.bookmarkPtr;
            this.bookmarkPtr = -1L;
        }

        void encodeUtf8Z(CharSequence value) {
            this.encodeUtf8(value);
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)0);
        }

        private void ensureCapacity(int size) {
            if (PGConnectionContext.this.sendBufferPtr + (long)size < PGConnectionContext.this.sendBufferLimit) {
                return;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        void reset() {
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBuffer;
        }

        void setNullValue() {
            this.putNetworkInt(-1);
        }

        long skip() {
            this.ensureCapacity(4);
            long checkpoint = PGConnectionContext.this.sendBufferPtr;
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
            return checkpoint;
        }
    }

    @FunctionalInterface
    private static interface ColumnAppender {
        public void append(Record var1, int var2) throws SqlException;
    }
}

