/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.MessageBus;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGJobContext;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.Job;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.std.Misc;
import io.questdb.std.ThreadLocal;
import io.questdb.std.WeakObjectPool;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class PGWireServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PGWireServer.class);
    private final IODispatcher<PGConnectionContext> dispatcher;
    private final PGConnectionContextFactory contextFactory;

    public PGWireServer(PGWireConfiguration configuration, CairoEngine engine, WorkerPool pool, MessageBus messageBus) {
        this.contextFactory = new PGConnectionContextFactory(configuration, messageBus);
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), this.contextFactory);
        pool.assign(this.dispatcher);
        int n = pool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            final PGJobContext jobContext = new PGJobContext(configuration, engine);
            pool.assign(i, new Job(){
                private final IORequestProcessor<PGConnectionContext> processor = (operation, context) -> {
                    try {
                        jobContext.handleClientOperation((PGConnectionContext)context);
                        context.getDispatcher().registerChannel((PGConnectionContext)context, 1);
                    }
                    catch (PeerIsSlowToWriteException e) {
                        context.getDispatcher().registerChannel((PGConnectionContext)context, 1);
                    }
                    catch (PeerIsSlowToReadException e) {
                        context.getDispatcher().registerChannel((PGConnectionContext)context, 4);
                    }
                    catch (BadProtocolException | PeerDisconnectedException e) {
                        context.getDispatcher().disconnect((PGConnectionContext)context);
                    }
                };

                @Override
                public boolean run() {
                    return PGWireServer.this.dispatcher.processIOQueue(this.processor);
                }
            });
            pool.assign(i, () -> {
                Misc.free(jobContext);
                this.contextFactory.closeContextPool();
            });
        }
    }

    @Nullable
    public static PGWireServer create(PGWireConfiguration configuration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, MessageBus messageBus) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, log, cairoEngine, (conf, engine, workerPool, local, bus) -> new PGWireServer((PGWireConfiguration)conf, cairoEngine, workerPool, bus), messageBus);
    }

    @Override
    public void close() {
        Misc.free(this.contextFactory);
        Misc.free(this.dispatcher);
    }

    private static class PGConnectionContextFactory
    implements IOContextFactory<PGConnectionContext>,
    Closeable,
    EagerThreadSetup {
        private final ThreadLocal<WeakObjectPool<PGConnectionContext>> contextPool = new ThreadLocal<WeakObjectPool>(() -> new WeakObjectPool<PGConnectionContext>(() -> new PGConnectionContext(configuration, messageBus), configuration.getConnectionPoolInitialCapacity()));
        private boolean closed = false;

        public PGConnectionContextFactory(PGWireConfiguration configuration, MessageBus messageBus) {
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public PGConnectionContext newInstance(long fd, IODispatcher<PGConnectionContext> dispatcher) {
            return ((PGConnectionContext)((WeakObjectPool)this.contextPool.get()).pop()).of(fd, dispatcher);
        }

        @Override
        public void done(PGConnectionContext context) {
            if (this.closed) {
                Misc.free(context);
            } else {
                context.of(-1L, null);
                ((WeakObjectPool)this.contextPool.get()).push(context);
                LOG.info().$("pushed").$();
            }
        }

        @Override
        public void setup() {
            this.contextPool.get();
        }

        private void closeContextPool() {
            Misc.free(this.contextPool.get());
            LOG.info().$("closed").$();
        }
    }
}

