/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextLexer;
import io.questdb.cutlass.text.types.BadDateAdapter;
import io.questdb.cutlass.text.types.BadTimestampAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class CairoTextWriter
implements TextLexer.Listener,
Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(CairoTextWriter.class);
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final LongList columnErrorCounts = new LongList();
    private final DirectCharSink utf8Sink;
    private final AppendMemory appendMemory = new AppendMemory();
    private final Path path;
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final TypeManager typeManager;
    private CharSequence tableName;
    private TableWriter writer;
    private long _size;
    private boolean overwrite;
    private boolean durable;
    private int atomicity;
    private ObjList<TypeAdapter> types;

    public CairoTextWriter(CairoEngine engine, Path path, TextConfiguration textConfiguration, TypeManager typeManager) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.path = path;
        this.utf8Sink = new DirectCharSink(textConfiguration.getUtf8SinkSize());
        this.typeManager = typeManager;
    }

    @Override
    public void clear() {
        this.writer = Misc.free(this.writer);
        this.columnErrorCounts.clear();
        this._size = 0L;
    }

    @Override
    public void close() {
        this.clear();
        this.utf8Sink.close();
        this.appendMemory.close();
    }

    public void commit() {
        if (this.writer != null) {
            if (this.durable) {
                assert (false);
            } else {
                this.writer.commit();
            }
        }
    }

    public LongList getColumnErrorCounts() {
        return this.columnErrorCounts;
    }

    public RecordMetadata getMetadata() {
        return this.writer == null ? null : this.writer.getMetadata();
    }

    public int getPartitionBy() {
        return this.writer == null ? 3 : this.writer.getPartitionBy();
    }

    public CharSequence getTableName() {
        return this.tableName;
    }

    public long getWrittenLineCount() {
        return this.writer == null ? 0L : this.writer.size() - this._size;
    }

    public void of(CharSequence name, boolean overwrite, boolean durable, int atomicity) {
        this.tableName = name;
        this.overwrite = overwrite;
        this.durable = durable;
        this.atomicity = atomicity;
    }

    @Override
    public void onFields(long line, ObjList<DirectByteCharSequence> values, int valuesLength) {
        TableWriter.Row w = this.writer.newRow();
        for (int i = 0; i < valuesLength; ++i) {
            DirectByteCharSequence dbcs = values.getQuick(i);
            if (dbcs.length() == 0) continue;
            try {
                this.types.getQuick(i).write(w, i, dbcs);
                continue;
            }
            catch (Exception ignore) {
                this.logError(line, i, dbcs);
                switch (this.atomicity) {
                    case 0: {
                        this.writer.rollback();
                        throw CairoException.instance(0).put("bad syntax [line=").put(line).put(", col=").put(i).put(']');
                    }
                    case 1: {
                        w.cancel();
                        return;
                    }
                }
            }
        }
        w.append();
    }

    private void logError(long line, int i, DirectByteCharSequence dbcs) {
        LogRecord logRecord = LOG.error().$("type syntax [type=").$(ColumnType.nameOf(this.types.getQuick(i).getType())).$("]\n\t");
        logRecord.$('[').$(line).$(':').$(i).$("] -> ").$(dbcs).$();
        this.columnErrorCounts.increment(i);
    }

    private void createTable(ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes, CairoSecurityContext cairoSecurityContext) {
        this.engine.creatTable(cairoSecurityContext, this.appendMemory, this.path, this.tableStructureAdapter.of(names, detectedTypes));
        this.types = detectedTypes;
    }

    private void logTypeError(int i) {
        LOG.info().$("mis-detected [table=").$(this.tableName).$(", column=").$(i).$(", type=").$(ColumnType.nameOf(this.types.getQuick(i).getType())).$(']').$();
    }

    private TableWriter openWriterAndOverrideImportTypes(CairoSecurityContext cairoSecurityContext, ObjList<TypeAdapter> detectedTypes) {
        TableWriter writer = this.engine.getWriter(cairoSecurityContext, this.tableName);
        RecordMetadata metadata = writer.getMetadata();
        if (metadata.getColumnCount() < detectedTypes.size()) {
            writer.close();
            throw CairoException.instance(0).put("column count mismatch [textColumnCount=").put(detectedTypes.size()).put(", tableColumnCount=").put(metadata.getColumnCount()).put(", table=").put(this.tableName).put(']');
        }
        this.types = detectedTypes;
        int n = this.types.size();
        block5: for (int i = 0; i < n; ++i) {
            int columnType = metadata.getColumnType(i);
            if (this.types.getQuick(i).getType() == columnType) continue;
            switch (columnType) {
                case 6: {
                    this.logTypeError(i);
                    this.types.setQuick(i, BadDateAdapter.INSTANCE);
                    continue block5;
                }
                case 7: {
                    this.logTypeError(i);
                    this.types.setQuick(i, BadTimestampAdapter.INSTANCE);
                    continue block5;
                }
                case 13: {
                    writer.close();
                    throw CairoException.instance(0).put("cannot import text into BINARY column [index=").put(i).put(']');
                }
                default: {
                    this.types.setQuick(i, this.typeManager.getTypeAdapter(columnType));
                }
            }
        }
        return writer;
    }

    void prepareTable(CairoSecurityContext cairoSecurityContext, ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes) {
        assert (this.writer == null);
        if (detectedTypes.size() == 0) {
            throw CairoException.instance(0).put("cannot determine text structure");
        }
        switch (this.engine.getStatus(cairoSecurityContext, this.path, this.tableName)) {
            case 1: {
                this.createTable(names, detectedTypes, cairoSecurityContext);
                this.writer = this.engine.getWriter(cairoSecurityContext, this.tableName);
                break;
            }
            case 0: {
                if (this.overwrite) {
                    this.engine.remove(cairoSecurityContext, this.path, this.tableName);
                    this.createTable(names, detectedTypes, cairoSecurityContext);
                    this.writer = this.engine.getWriter(cairoSecurityContext, this.tableName);
                    break;
                }
                this.writer = this.openWriterAndOverrideImportTypes(cairoSecurityContext, detectedTypes);
                break;
            }
            default: {
                throw CairoException.instance(0).put("name is reserved [table=").put(this.tableName).put(']');
            }
        }
        this._size = this.writer.size();
        this.columnErrorCounts.seed(this.writer.getMetadata().getColumnCount(), 0L);
    }

    private class TableStructureAdapter
    implements TableStructure {
        private ObjList<CharSequence> names;
        private ObjList<TypeAdapter> types;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.types.size();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.names.getQuick(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            return this.types.getQuick(columnIndex).getType();
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return 0;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return false;
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return false;
        }

        @Override
        public int getPartitionBy() {
            return 3;
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            return CairoTextWriter.this.configuration.getDefaultSymbolCacheFlag();
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            return CairoTextWriter.this.configuration.getDefaultSymbolCapacity();
        }

        @Override
        public CharSequence getTableName() {
            return CairoTextWriter.this.tableName;
        }

        @Override
        public int getTimestampIndex() {
            return -1;
        }

        TableStructureAdapter of(ObjList<CharSequence> names, ObjList<TypeAdapter> types) {
            this.names = names;
            this.types = types;
            return this;
        }
    }
}

