/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.text.CairoTextWriter;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextDelimiterScanner;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLexer;
import io.questdb.cutlass.text.TextMetadataParser;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TextLoader
implements Closeable,
Mutable {
    public static final int LOAD_JSON_METADATA = 0;
    public static final int ANALYZE_STRUCTURE = 1;
    public static final int LOAD_DATA = 2;
    private static final Log LOG = LogFactory.getLog(TextLoader.class);
    private final CairoTextWriter textWriter;
    private final TextMetadataParser textMetadataParser;
    private final TextLexer textLexer;
    private final JsonLexer jsonLexer;
    private final Path path = new Path();
    private final int textAnalysisMaxLines;
    private final TextDelimiterScanner textDelimiterScanner;
    private final DirectCharSink utf8Sink;
    private final TypeManager typeManager;
    private final ObjList<ParserMethod> parseMethods = new ObjList();
    private int state;
    private boolean forceHeaders = false;
    private byte columnDelimiter = (byte)-1;

    public TextLoader(CairoEngine engine) {
        TextConfiguration textConfiguration = engine.getConfiguration().getTextConfiguration();
        this.utf8Sink = new DirectCharSink(textConfiguration.getUtf8SinkSize());
        this.jsonLexer = new JsonLexer(textConfiguration.getJsonCacheSize(), textConfiguration.getJsonCacheLimit());
        this.typeManager = new TypeManager(textConfiguration, this.utf8Sink);
        this.textLexer = new TextLexer(textConfiguration, this.typeManager);
        this.textWriter = new CairoTextWriter(engine, this.path, textConfiguration, this.typeManager);
        this.textMetadataParser = new TextMetadataParser(textConfiguration, this.typeManager);
        this.textAnalysisMaxLines = textConfiguration.getTextAnalysisMaxLines();
        this.textDelimiterScanner = new TextDelimiterScanner(textConfiguration);
        this.parseMethods.extendAndSet(0, this::parseJsonMetadata);
        this.parseMethods.extendAndSet(1, this::parseStructure);
        this.parseMethods.extendAndSet(2, this::parseData);
        this.textLexer.setSkipLinesWithExtraValues(true);
    }

    @Override
    public void clear() {
        this.textWriter.clear();
        this.textLexer.clear();
        this.textMetadataParser.clear();
        this.jsonLexer.clear();
        this.forceHeaders = false;
        this.columnDelimiter = (byte)-1;
        this.typeManager.clear();
    }

    @Override
    public void close() {
        Misc.free(this.textWriter);
        Misc.free(this.textLexer);
        Misc.free(this.textMetadataParser);
        Misc.free(this.jsonLexer);
        Misc.free(this.path);
        Misc.free(this.textDelimiterScanner);
        Misc.free(this.utf8Sink);
    }

    public void configureColumnDelimiter(byte columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        assert (this.columnDelimiter > 0);
    }

    public void configureDestination(CharSequence tableName, boolean overwrite, boolean durable, int atomicity) {
        this.textWriter.of(tableName, overwrite, durable, atomicity);
        this.textDelimiterScanner.setTableName(tableName);
        this.textMetadataParser.setTableName(tableName);
        this.textLexer.setTableName(tableName);
        LOG.info().$("configured [table=`").$(tableName).$("`, overwrite=").$(overwrite).$(", durable=").$(durable).$(", atomicity=").$(atomicity).$(']').$();
    }

    public byte getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public LongList getColumnErrorCounts() {
        return this.textWriter.getColumnErrorCounts();
    }

    public RecordMetadata getMetadata() {
        return this.textWriter.getMetadata();
    }

    public long getParsedLineCount() {
        return this.textLexer.getLineCount();
    }

    public long getErrorLineCount() {
        return this.textLexer.getErrorCount();
    }

    public int getPartitionBy() {
        return this.textWriter.getPartitionBy();
    }

    public CharSequence getTableName() {
        return this.textWriter.getTableName();
    }

    public long getWrittenLineCount() {
        return this.textWriter.getWrittenLineCount();
    }

    public boolean hasHeader() {
        return this.textLexer.isHeaderDetected();
    }

    public boolean isForceHeaders() {
        return this.forceHeaders;
    }

    public void setForceHeaders(boolean forceHeaders) {
        this.forceHeaders = forceHeaders;
    }

    public void setSkipRowsWithExtraValues(boolean skipRowsWithExtraValues) {
        this.textLexer.setSkipLinesWithExtraValues(skipRowsWithExtraValues);
    }

    public void parse(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        this.parseMethods.getQuick(this.state).parse(lo, hi, cairoSecurityContext);
    }

    public void setState(int state) {
        LOG.debug().$("state change [old=").$(this.state).$(", new=").$(state).$(']').$();
        this.state = state;
        this.jsonLexer.clear();
    }

    public void wrapUp() throws TextException {
        switch (this.state) {
            case 0: {
                try {
                    this.jsonLexer.parseLast();
                    break;
                }
                catch (JsonException e) {
                    throw TextException.$(e.getFlyweightMessage());
                }
            }
            case 1: 
            case 2: {
                this.textLexer.parseLast();
                this.textWriter.commit();
                break;
            }
        }
    }

    private void parseData(long lo, long hi, CairoSecurityContext cairoSecurityContext) {
        this.textLexer.parse(lo, hi, Integer.MAX_VALUE, this.textWriter);
    }

    private void parseJsonMetadata(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        try {
            this.jsonLexer.parse(lo, hi, this.textMetadataParser);
        }
        catch (JsonException e) {
            throw TextException.$(e.getFlyweightMessage());
        }
    }

    private void parseStructure(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        if (this.columnDelimiter > 0) {
            this.textLexer.of(this.columnDelimiter);
        } else {
            this.textLexer.of(this.textDelimiterScanner.scan(lo, hi));
        }
        this.textLexer.analyseStructure(lo, hi, this.textAnalysisMaxLines, this.forceHeaders, this.textMetadataParser.getColumnNames(), this.textMetadataParser.getColumnTypes());
        this.textWriter.prepareTable(cairoSecurityContext, this.textLexer.getColumnNames(), this.textLexer.getColumnTypes());
        this.textLexer.parse(lo, hi, Integer.MAX_VALUE, this.textWriter);
        this.state = 2;
    }

    @FunctionalInterface
    private static interface ParserMethod {
        public void parse(long var1, long var3, CairoSecurityContext var5) throws TextException;
    }
}

