/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;

public class TextUtil {
    public static void utf8Decode(long lo, long hi, CharSink sink) throws Utf8Exception {
        long p = lo;
        int quoteCount = 0;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Chars.utf8DecodeMultiByte(p, hi, b, sink);
                if (n == -1) {
                    throw Utf8Exception.INSTANCE;
                }
                p += (long)n;
                continue;
            }
            if (b == 34) {
                if (quoteCount++ % 2 == 0) {
                    sink.put('\"');
                }
            } else {
                sink.put((char)b);
            }
            ++p;
        }
    }
}

