/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectByteCharSequence;

public final class LongAdapter
extends AbstractTypeAdapter {
    public static final LongAdapter INSTANCE = new LongAdapter();

    private LongAdapter() {
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean probe(CharSequence text) {
        if (text.length() > 2 && text.charAt(0) == '0' && text.charAt(1) != '.') {
            return false;
        }
        try {
            Numbers.parseLong(text);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putLong(column, Numbers.parseLong(value));
    }
}

