/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.Mutable;
import io.questdb.std.NumericException;
import io.questdb.std.microtime.TimestampFormat;
import io.questdb.std.microtime.TimestampLocale;
import io.questdb.std.str.DirectByteCharSequence;

public class TimestampAdapter
extends AbstractTypeAdapter
implements Mutable {
    private TimestampLocale locale;
    private TimestampFormat format;

    @Override
    public void clear() {
        this.format = null;
        this.locale = null;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public boolean probe(CharSequence text) {
        try {
            this.format.parse(text, this.locale);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putDate(column, this.format.parse(value, this.locale));
    }

    public TimestampAdapter of(TimestampFormat format, TimestampLocale locale) {
        this.format = format;
        this.locale = locale;
        return this;
    }
}

