/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.BooleanAdapter;
import io.questdb.cutlass.text.types.ByteAdapter;
import io.questdb.cutlass.text.types.CharAdapter;
import io.questdb.cutlass.text.types.DateAdapter;
import io.questdb.cutlass.text.types.DateUtf8Adapter;
import io.questdb.cutlass.text.types.DoubleAdapter;
import io.questdb.cutlass.text.types.FloatAdapter;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.cutlass.text.types.IntAdapter;
import io.questdb.cutlass.text.types.Long256Adapter;
import io.questdb.cutlass.text.types.LongAdapter;
import io.questdb.cutlass.text.types.ShortAdapter;
import io.questdb.cutlass.text.types.StringAdapter;
import io.questdb.cutlass.text.types.SymbolAdapter;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TimestampUtf8Adapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.microtime.TimestampFormat;
import io.questdb.std.microtime.TimestampLocale;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.time.DateFormat;
import io.questdb.std.time.DateLocale;

public class TypeManager
implements Mutable {
    private final ObjList<TypeAdapter> probes = new ObjList();
    private final int probeCount;
    private final StringAdapter stringAdapter;
    private final ObjectPool<DateUtf8Adapter> dateAdapterPool;
    private final ObjectPool<TimestampUtf8Adapter> timestampUtf8AdapterPool;
    private final ObjectPool<TimestampAdapter> timestampAdapterPool;
    private final SymbolAdapter symbolAdapter;
    private final InputFormatConfiguration inputFormatConfiguration;

    public TypeManager(TextConfiguration configuration, DirectCharSink utf8Sink) {
        this.dateAdapterPool = new ObjectPool<DateUtf8Adapter>(() -> new DateUtf8Adapter(utf8Sink), configuration.getDateAdapterPoolCapacity());
        this.timestampUtf8AdapterPool = new ObjectPool<TimestampUtf8Adapter>(() -> new TimestampUtf8Adapter(utf8Sink), configuration.getTimestampAdapterPoolCapacity());
        this.timestampAdapterPool = new ObjectPool<TimestampAdapter>(TimestampAdapter::new, configuration.getTimestampAdapterPoolCapacity());
        this.inputFormatConfiguration = configuration.getInputFormatConfiguration();
        this.stringAdapter = new StringAdapter(utf8Sink);
        this.symbolAdapter = new SymbolAdapter(utf8Sink);
        this.addDefaultProbes();
        ObjList<DateFormat> dateFormats = this.inputFormatConfiguration.getDateFormats();
        ObjList<DateLocale> dateLocales = this.inputFormatConfiguration.getDateLocales();
        IntList dateUtf8Flags = this.inputFormatConfiguration.getDateUtf8Flags();
        int n = dateFormats.size();
        for (int i = 0; i < n; ++i) {
            if (dateUtf8Flags.getQuick(i) == 1) {
                this.probes.add(new DateUtf8Adapter(utf8Sink).of(dateFormats.getQuick(i), dateLocales.getQuick(i)));
                continue;
            }
            this.probes.add(new DateAdapter().of(dateFormats.getQuick(i), dateLocales.getQuick(i)));
        }
        ObjList<TimestampFormat> timestampFormats = this.inputFormatConfiguration.getTimestampFormats();
        ObjList<TimestampLocale> timestampLocales = this.inputFormatConfiguration.getTimestampLocales();
        IntList timestampUtf8Flags = this.inputFormatConfiguration.getTimestampUtf8Flags();
        int n2 = timestampFormats.size();
        for (int i = 0; i < n2; ++i) {
            if (timestampUtf8Flags.getQuick(i) == 1) {
                this.probes.add(new TimestampUtf8Adapter(utf8Sink).of(timestampFormats.getQuick(i), timestampLocales.getQuick(i)));
                continue;
            }
            this.probes.add(new TimestampAdapter().of(timestampFormats.getQuick(i), timestampLocales.getQuick(i)));
        }
        this.probeCount = this.probes.size();
    }

    @Override
    public void clear() {
        this.dateAdapterPool.clear();
        this.timestampUtf8AdapterPool.clear();
        this.timestampAdapterPool.clear();
    }

    public InputFormatConfiguration getInputFormatConfiguration() {
        return this.inputFormatConfiguration;
    }

    public TypeAdapter getProbe(int index) {
        return this.probes.getQuick(index);
    }

    public int getProbeCount() {
        return this.probeCount;
    }

    public TypeAdapter getTypeAdapter(int columnType) {
        switch (columnType) {
            case 1: {
                return ByteAdapter.INSTANCE;
            }
            case 2: {
                return ShortAdapter.INSTANCE;
            }
            case 3: {
                return CharAdapter.INSTANCE;
            }
            case 4: {
                return IntAdapter.INSTANCE;
            }
            case 5: {
                return LongAdapter.INSTANCE;
            }
            case 0: {
                return BooleanAdapter.INSTANCE;
            }
            case 8: {
                return FloatAdapter.INSTANCE;
            }
            case 9: {
                return DoubleAdapter.INSTANCE;
            }
            case 10: {
                return this.stringAdapter;
            }
            case 11: {
                return this.symbolAdapter;
            }
            case 12: {
                return Long256Adapter.INSTANCE;
            }
        }
        throw CairoException.instance(0).put("no adapter for type [id=").put(columnType).put(", name=").put(ColumnType.nameOf(columnType)).put(']');
    }

    public DateUtf8Adapter nextDateAdapter() {
        return this.dateAdapterPool.next();
    }

    public TypeAdapter nextTimestampAdapter(boolean decodeUtf8, TimestampFormat format, TimestampLocale locale) {
        if (decodeUtf8) {
            TimestampUtf8Adapter adapter = this.timestampUtf8AdapterPool.next();
            adapter.of(format, locale);
            return adapter;
        }
        TimestampAdapter adapter = this.timestampAdapterPool.next();
        adapter.of(format, locale);
        return adapter;
    }

    private void addDefaultProbes() {
        this.probes.add(this.getTypeAdapter(3));
        this.probes.add(this.getTypeAdapter(4));
        this.probes.add(this.getTypeAdapter(5));
        this.probes.add(this.getTypeAdapter(9));
        this.probes.add(this.getTypeAdapter(0));
        this.probes.add(this.getTypeAdapter(12));
    }

    ObjList<TypeAdapter> getAllAdapters() {
        return this.probes;
    }
}

