/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntStack;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.ObjStack;
import io.questdb.std.ObjectPool;

class ExpressionParser {
    private static final IntHashSet nonLiteralBranches = new IntHashSet();
    private static final int BRANCH_NONE = 0;
    private static final int BRANCH_COMMA = 1;
    private static final int BRANCH_LEFT_BRACE = 2;
    private static final int BRANCH_RIGHT_BRACE = 3;
    private static final int BRANCH_CONSTANT = 4;
    private static final int BRANCH_OPERATOR = 5;
    private static final int BRANCH_LITERAL = 6;
    private static final int BRANCH_LAMBDA = 7;
    private static final int BRANCH_CASE_START = 9;
    private static final int BRANCH_CASE_CONTROL = 10;
    private static final int BRANCH_CAST_AS = 11;
    private static final LowerCaseAsciiCharSequenceIntHashMap caseKeywords = new LowerCaseAsciiCharSequenceIntHashMap();
    private final ObjStack<ExpressionNode> opStack = new ObjStack();
    private final IntStack paramCountStack = new IntStack();
    private final IntStack argStackDepthStack = new IntStack();
    private final IntStack castBraceCountStack = new IntStack();
    private final IntStack caseBraceCountStack = new IntStack();
    private final IntStack backupParamCountStack = new IntStack();
    private final IntStack backupArgStackDepthStack = new IntStack();
    private final IntStack backupCastBraceCountStack = new IntStack();
    private final IntStack backupCaseBraceCountStack = new IntStack();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final SqlParser sqlParser;

    ExpressionParser(ObjectPool<ExpressionNode> expressionNodePool, SqlParser sqlParser) {
        this.expressionNodePool = expressionNodePool;
        this.sqlParser = sqlParser;
    }

    private static SqlException missingArgs(int position) {
        return SqlException.$(position, "missing arguments");
    }

    void parseExpr(GenericLexer lexer, ExpressionParserListener listener) throws SqlException {
        try {
            ExpressionNode node;
            CharSequence tok;
            int paramCount = 0;
            int braceCount = 0;
            int caseCount = 0;
            int argStackDepth = 0;
            int castAsCount = 0;
            int thisBranch = 0;
            block25: while ((tok = SqlUtil.fetchNext(lexer)) != null) {
                char thisChar = tok.charAt(0);
                int prevBranch = thisBranch;
                boolean processDefaultBranch = false;
                switch (thisChar) {
                    case ',': {
                        if (prevBranch == 1 || prevBranch == 2) {
                            throw ExpressionParser.missingArgs(lexer.lastTokenPosition());
                        }
                        thisBranch = 1;
                        if (braceCount == 0) {
                            lexer.unparse();
                            break block25;
                        }
                        if (this.castBraceCountStack.peek() == braceCount) {
                            throw SqlException.$(lexer.lastTokenPosition(), "',' is not expected here");
                        }
                        while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                            argStackDepth = this.onNode(listener, node, argStackDepth);
                        }
                        if (node != null) {
                            this.opStack.push(node);
                        }
                        ++paramCount;
                        break;
                    }
                    case '(': {
                        thisBranch = 2;
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        this.opStack.push(this.expressionNodePool.next().of(16, "(", Integer.MAX_VALUE, lexer.lastTokenPosition()));
                        if (this.castBraceCountStack.size() > 0 && this.castBraceCountStack.peek() == -1) {
                            this.castBraceCountStack.update(braceCount + 1);
                        }
                        ++braceCount;
                        break;
                    }
                    case ')': {
                        boolean thisWasCast;
                        int localParamCount;
                        if (prevBranch == 1) {
                            throw ExpressionParser.missingArgs(lexer.lastTokenPosition());
                        }
                        if (braceCount == 0) {
                            lexer.unparse();
                            break block25;
                        }
                        thisBranch = 3;
                        int n = localParamCount = prevBranch == 2 ? 0 : paramCount + 1;
                        if (this.castBraceCountStack.size() > 0 && this.castBraceCountStack.peek() == braceCount) {
                            if (castAsCount == 0) {
                                throw SqlException.$(lexer.lastTokenPosition(), "'as' missing");
                            }
                            --castAsCount;
                            this.castBraceCountStack.pop();
                            thisWasCast = true;
                        } else {
                            thisWasCast = false;
                        }
                        --braceCount;
                        while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                            if (Chars.equals(node.token, '*') && argStackDepth == 0 && this.isCount()) {
                                argStackDepth = this.onNode(listener, node, 2);
                                continue;
                            }
                            if (thisWasCast) {
                                int columnType = ColumnType.columnTypeOf(node.token);
                                if (columnType < 0 || columnType > 12) {
                                    throw SqlException.$(node.position, "invalid type");
                                }
                                node.type = 2;
                            }
                            argStackDepth = this.onNode(listener, node, argStackDepth);
                        }
                        if (this.argStackDepthStack.notEmpty()) {
                            argStackDepth += this.argStackDepthStack.pop();
                        }
                        if ((node = this.opStack.peek()) != null && (node.type == 4 || node.type == 32)) {
                            node.paramCount = localParamCount + (node.paramCount == 2 ? 1 : 0);
                            node.type = 8;
                            argStackDepth = this.onNode(listener, node, argStackDepth);
                            this.opStack.pop();
                        } else if (localParamCount > 1 && (node = this.opStack.peek()) != null && node.token.charAt(0) == '(') {
                            throw SqlException.$(lexer.lastTokenPosition(), "no function or operator?");
                        }
                        if (!this.paramCountStack.notEmpty()) break;
                        paramCount = this.paramCountStack.pop();
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (Chars.equalsLowerCaseAscii(tok, "cast")) {
                            this.castBraceCountStack.push(-1);
                            thisBranch = 5;
                            this.opStack.push(this.expressionNodePool.next().of(4, "cast", Integer.MIN_VALUE, lexer.lastTokenPosition()));
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        if (Chars.equalsLowerCaseAscii(tok, "as")) {
                            if (castAsCount < this.castBraceCountStack.size()) {
                                thisBranch = 11;
                                while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                                    argStackDepth = this.onNode(listener, node, argStackDepth);
                                }
                                if (node != null) {
                                    this.opStack.push(node);
                                }
                                ++paramCount;
                                ++castAsCount;
                                break;
                            }
                            processDefaultBranch = true;
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (Chars.equalsLowerCaseAscii(tok, "select")) {
                            thisBranch = 7;
                            argStackDepth = this.processLambdaQuery(lexer, listener, argStackDepth);
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (nonLiteralBranches.excludes(thisBranch)) {
                            thisBranch = 4;
                            this.opStack.push(this.expressionNodePool.next().of(2, GenericLexer.immutableOf(tok), 0, lexer.lastTokenPosition()));
                            break;
                        }
                        if (this.opStack.size() > 1) {
                            throw SqlException.$(lexer.lastTokenPosition(), "dangling expression");
                        }
                        lexer.unparse();
                        break block25;
                    }
                    case 'F': 
                    case 'N': 
                    case 'T': 
                    case 'f': 
                    case 'n': 
                    case 't': {
                        if (Chars.equalsLowerCaseAscii(tok, "nan") || Chars.equalsLowerCaseAscii(tok, "null") || Chars.equalsLowerCaseAscii(tok, "true") || Chars.equalsLowerCaseAscii(tok, "false")) {
                            thisBranch = 4;
                            this.opStack.push(this.expressionNodePool.next().of(2, GenericLexer.immutableOf(tok), 0, lexer.lastTokenPosition()));
                            break;
                        }
                    }
                    default: {
                        processDefaultBranch = true;
                    }
                }
                if (!processDefaultBranch) continue;
                OperatorExpression op = OperatorExpression.opMap.get(tok);
                if (op != null) {
                    ExpressionNode other;
                    thisBranch = 5;
                    int operatorType = op.type;
                    if (thisChar == '-') {
                        switch (prevBranch) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 5: 
                            case 10: {
                                operatorType = 1;
                                break;
                            }
                        }
                    }
                    while ((other = this.opStack.peek()) != null) {
                        boolean greaterPrecedence;
                        boolean bl = greaterPrecedence = op.leftAssociative && op.precedence >= other.precedence || !op.leftAssociative && op.precedence > other.precedence;
                        if (!greaterPrecedence || operatorType == 1 && (operatorType != 1 || other.paramCount != 1)) break;
                        argStackDepth = this.onNode(listener, other, argStackDepth);
                        this.opStack.pop();
                    }
                    node = this.expressionNodePool.next().of(op.type == 3 ? 32 : 1, op.token, op.precedence, lexer.lastTokenPosition());
                    node.paramCount = operatorType == 1 ? 1 : 2;
                    this.opStack.push(node);
                    continue;
                }
                if (caseCount > 0 || nonLiteralBranches.excludes(thisBranch)) {
                    if (Chars.toLowerCaseAscii(thisChar) == 'c' && Chars.equalsLowerCaseAscii(tok, "case")) {
                        ++caseCount;
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.caseBraceCountStack.push(braceCount);
                        braceCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        this.opStack.push(this.expressionNodePool.next().of(8, "case", Integer.MAX_VALUE, lexer.lastTokenPosition()));
                        thisBranch = 9;
                        continue;
                    }
                    thisBranch = 6;
                    if (caseCount > 0) {
                        switch (Chars.toLowerCaseAscii(thisChar)) {
                            case 'e': {
                                if (Chars.equalsLowerCaseAscii(tok, "end")) {
                                    if (prevBranch == 10) {
                                        throw ExpressionParser.missingArgs(lexer.lastTokenPosition());
                                    }
                                    if (paramCount == 0) {
                                        throw SqlException.$(lexer.lastTokenPosition(), "'when' expected");
                                    }
                                    while ((node = this.opStack.pop()) != null && !Chars.equalsLowerCaseAscii(node.token, "case")) {
                                        argStackDepth = this.onNode(listener, node, argStackDepth);
                                    }
                                    if (this.argStackDepthStack.notEmpty()) {
                                        argStackDepth += this.argStackDepthStack.pop();
                                    }
                                    if (this.caseBraceCountStack.notEmpty()) {
                                        braceCount = this.caseBraceCountStack.pop();
                                    }
                                    node.paramCount = paramCount;
                                    argStackDepth = this.onNode(listener, node, argStackDepth + paramCount);
                                    if (this.paramCountStack.notEmpty()) {
                                        paramCount = this.paramCountStack.pop();
                                    }
                                    --caseCount;
                                    continue block25;
                                }
                            }
                            case 't': 
                            case 'w': {
                                int keywordIndex = caseKeywords.get(tok);
                                if (keywordIndex <= -1) break;
                                if (prevBranch == 10) {
                                    throw ExpressionParser.missingArgs(lexer.lastTokenPosition());
                                }
                                int argCount = 0;
                                while ((node = this.opStack.pop()) != null && !Chars.equalsLowerCaseAscii(node.token, "case")) {
                                    argStackDepth = this.onNode(listener, node, argStackDepth);
                                    ++argCount;
                                }
                                if (paramCount == 0) {
                                    if (argCount == 0) {
                                        this.onNode(listener, this.expressionNodePool.next().of(4, null, Integer.MIN_VALUE, -1), argStackDepth);
                                    }
                                    ++paramCount;
                                }
                                switch (keywordIndex) {
                                    case 0: 
                                    case 2: {
                                        if (paramCount % 2 != 0) break;
                                        throw SqlException.$(lexer.lastTokenPosition(), "'then' expected");
                                    }
                                    default: {
                                        if (paramCount % 2 == 0) break;
                                        throw SqlException.$(lexer.lastTokenPosition(), "'when' expected");
                                    }
                                }
                                if (node != null) {
                                    this.opStack.push(node);
                                }
                                argStackDepth = 0;
                                ++paramCount;
                                thisBranch = 10;
                                continue block25;
                            }
                        }
                    }
                    this.opStack.push(this.expressionNodePool.next().of(4, GenericLexer.immutableOf(tok), Integer.MIN_VALUE, lexer.lastTokenPosition()));
                    continue;
                }
                lexer.unparse();
                break;
            }
            while ((node = this.opStack.pop()) != null) {
                if (node.token.charAt(0) == '(') {
                    throw SqlException.$(node.position, "unbalanced (");
                }
                if (Chars.equalsLowerCaseAscii(node.token, "case")) {
                    throw SqlException.$(node.position, "unbalanced 'case'");
                }
                if (node.type == 16) {
                    this.opStack.push(node);
                    break;
                }
                argStackDepth = this.onNode(listener, node, argStackDepth);
            }
        }
        catch (SqlException e) {
            this.opStack.clear();
            this.backupCastBraceCountStack.clear();
            this.backupParamCountStack.clear();
            this.backupArgStackDepthStack.clear();
            throw e;
        }
        finally {
            this.argStackDepthStack.clear();
            this.paramCountStack.clear();
            this.castBraceCountStack.clear();
        }
    }

    private boolean isCount() {
        return this.opStack.size() == 2 && Chars.equals(this.opStack.peek().token, '(') && Chars.equals((CharSequence)"count", this.opStack.peek((int)1).token);
    }

    private int processLambdaQuery(GenericLexer lexer, ExpressionParserListener listener, int argStackDepth) throws SqlException {
        this.opStack.push(this.expressionNodePool.next().of(16, "|", Integer.MAX_VALUE, lexer.lastTokenPosition()));
        int paramCountStackSize = this.paramCountStack.size();
        this.paramCountStack.copyTo(this.backupParamCountStack, paramCountStackSize);
        int argStackDepthStackSize = this.argStackDepthStack.size();
        this.argStackDepthStack.copyTo(this.backupArgStackDepthStack, argStackDepthStackSize);
        int castBraceCountStackSize = this.castBraceCountStack.size();
        this.castBraceCountStack.copyTo(this.backupCastBraceCountStack, castBraceCountStackSize);
        int caseBraceCountStackSize = this.caseBraceCountStack.size();
        this.caseBraceCountStack.copyTo(this.backupCaseBraceCountStack, caseBraceCountStackSize);
        int pos = lexer.lastTokenPosition();
        lexer.unparse();
        ExpressionNode node = this.expressionNodePool.next().of(65, null, 0, pos);
        this.onNode(listener, node, argStackDepth);
        node.queryModel = this.sqlParser.parseAsSubQuery(lexer);
        argStackDepth = this.onNode(listener, node, argStackDepth);
        ExpressionNode control = this.opStack.peek();
        if (control != null && control.type == 16 && Chars.equals(control.token, '|')) {
            this.opStack.pop();
        }
        this.backupParamCountStack.copyTo(this.paramCountStack, paramCountStackSize);
        this.backupArgStackDepthStack.copyTo(this.argStackDepthStack, argStackDepthStackSize);
        this.backupCastBraceCountStack.copyTo(this.castBraceCountStack, castBraceCountStackSize);
        this.backupCaseBraceCountStack.copyTo(this.caseBraceCountStack, caseBraceCountStackSize);
        lexer.unparse();
        return argStackDepth;
    }

    private int onNode(ExpressionParserListener listener, ExpressionNode node, int argStackDepth) throws SqlException {
        if (argStackDepth < node.paramCount) {
            throw SqlException.position(node.position).put("too few arguments for '").put(node.token).put("' [found=").put(argStackDepth).put(",expected=").put(node.paramCount).put(']');
        }
        listener.onNode(node);
        return argStackDepth - node.paramCount + 1;
    }

    static {
        nonLiteralBranches.add(3);
        nonLiteralBranches.add(4);
        nonLiteralBranches.add(6);
        nonLiteralBranches.add(7);
        caseKeywords.put("when", 0);
        caseKeywords.put("then", 1);
        caseKeywords.put("else", 2);
    }
}

