/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.TypeConstant;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.bind.BindVariableService;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.SymbolColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.griffin.engine.functions.constants.DateConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.Long256Constant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.NullStrConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class FunctionParser
implements PostOrderTreeTraversalAlgo.Visitor {
    private static final Log LOG = LogFactory.getLog(FunctionParser.class);
    private static final int MATCH_NO_MATCH = 0;
    private static final int MATCH_FUZZY_MATCH = 1;
    private static final int MATCH_PARTIAL_MATCH = 2;
    private static final int MATCH_EXACT_MATCH = 3;
    private static final IntHashSet invalidFunctionNameChars = new IntHashSet();
    private static final CharSequenceHashSet invalidFunctionNames = new CharSequenceHashSet();
    private final ObjList<Function> mutableArgs = new ObjList();
    private final ArrayDeque<Function> stack = new ArrayDeque();
    private final PostOrderTreeTraversalAlgo traverseAlgo = new PostOrderTreeTraversalAlgo();
    private final CairoConfiguration configuration;
    private final CharSequenceObjHashMap<ObjList<FunctionFactory>> factories = new CharSequenceObjHashMap();
    private final CharSequenceHashSet groupByFunctionNames = new CharSequenceHashSet();
    private final ArrayDeque<RecordMetadata> metadataStack = new ArrayDeque();
    private RecordMetadata metadata;
    private SqlCodeGenerator sqlCodeGenerator;
    private SqlExecutionContext sqlExecutionContext;

    public FunctionParser(CairoConfiguration configuration, Iterable<FunctionFactory> functionFactories) {
        this.configuration = configuration;
        this.loadFunctionFactories(functionFactories);
    }

    public static int getArgType(char c) {
        int sigArgType;
        switch (Character.toUpperCase(c)) {
            case 'D': {
                sigArgType = 9;
                break;
            }
            case 'B': {
                sigArgType = 1;
                break;
            }
            case 'E': {
                sigArgType = 2;
                break;
            }
            case 'A': {
                sigArgType = 3;
                break;
            }
            case 'F': {
                sigArgType = 8;
                break;
            }
            case 'I': {
                sigArgType = 4;
                break;
            }
            case 'L': {
                sigArgType = 5;
                break;
            }
            case 'S': {
                sigArgType = 10;
                break;
            }
            case 'T': {
                sigArgType = 0;
                break;
            }
            case 'K': {
                sigArgType = 11;
                break;
            }
            case 'M': {
                sigArgType = 6;
                break;
            }
            case 'N': {
                sigArgType = 7;
                break;
            }
            case 'U': {
                sigArgType = 13;
                break;
            }
            case 'V': {
                sigArgType = 100;
                break;
            }
            case 'C': {
                sigArgType = 101;
                break;
            }
            case 'H': {
                sigArgType = 12;
                break;
            }
            default: {
                sigArgType = -1;
            }
        }
        return sigArgType;
    }

    public static int validateSignatureAndGetNameSeparator(String sig) throws SqlException {
        int i;
        if (sig == null) {
            throw SqlException.$(0, "NULL signature");
        }
        int openBraceIndex = sig.indexOf(40);
        if (openBraceIndex == -1) {
            throw SqlException.$(0, "open brace expected");
        }
        if (openBraceIndex == 0) {
            throw SqlException.$(0, "empty function name");
        }
        if (sig.charAt(sig.length() - 1) != ')') {
            throw SqlException.$(0, "close brace expected");
        }
        char c = sig.charAt(0);
        if (c >= '0' && c <= '9') {
            throw SqlException.$(0, "name must not start with digit");
        }
        for (i = 0; i < openBraceIndex; ++i) {
            char cc = sig.charAt(i);
            if (!invalidFunctionNameChars.contains(cc)) continue;
            throw SqlException.position(0).put("invalid character: ").put(cc);
        }
        if (invalidFunctionNames.keyIndex(sig, 0, openBraceIndex) < 0) {
            throw SqlException.position(0).put("invalid function name character: ").put(sig);
        }
        int n = sig.length() - 1;
        for (i = openBraceIndex + 1; i < n; ++i) {
            char cc = sig.charAt(i);
            if (FunctionParser.getArgType(cc) != -1) continue;
            throw SqlException.position(0).put("illegal argument type: ").put(cc);
        }
        return openBraceIndex;
    }

    private static SqlException invalidFunction(CharSequence message, ExpressionNode node, ObjList<Function> args) {
        SqlException ex = SqlException.position(node.position);
        ex.put(message);
        ex.put(": ");
        ex.put(node.token);
        ex.put('(');
        if (args != null) {
            int n = args.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                ex.put(ColumnType.nameOf(args.getQuick(i).getType()));
            }
        }
        ex.put(')');
        return ex;
    }

    public Function createIndexParameter(int variableIndex, ExpressionNode node) throws SqlException {
        Function function = this.getBindVariableService().getFunction(variableIndex);
        if (function == null) {
            throw SqlException.position(node.position).put("no bind variable defined at index ").put(variableIndex);
        }
        return new IndexedParameterLinkFunction(variableIndex, function.getType(), node.position);
    }

    public Function createNamedParameter(ExpressionNode node) throws SqlException {
        Function function = this.getBindVariableService().getFunction(node.token);
        if (function == null) {
            throw SqlException.position(node.position).put("undefined bind variable: ").put(node.token);
        }
        return new NamedParameterLinkFunction(Chars.toString(node.token), function.getType(), node.position);
    }

    @NotNull
    private BindVariableService getBindVariableService() throws SqlException {
        BindVariableService bindVariableService = this.sqlExecutionContext.getBindVariableService();
        if (bindVariableService == null) {
            throw SqlException.$(0, "bind variable service is not provided");
        }
        return bindVariableService;
    }

    public boolean isGroupBy(CharSequence name) {
        return this.groupByFunctionNames.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function parseFunction(ExpressionNode node, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        this.sqlExecutionContext = executionContext;
        if (this.metadata != null) {
            this.metadataStack.push(this.metadata);
        }
        try {
            this.metadata = metadata;
            this.traverseAlgo.traverse(node, this);
            Function function = this.stack.poll();
            return function;
        }
        finally {
            this.metadata = this.metadataStack.size() == 0 ? null : this.metadataStack.poll();
        }
    }

    public void setSqlCodeGenerator(SqlCodeGenerator sqlCodeGenerator) {
        this.sqlCodeGenerator = sqlCodeGenerator;
    }

    @Override
    public void visit(ExpressionNode node) throws SqlException {
        int argCount = node.paramCount;
        if (argCount == 0) {
            switch (node.type) {
                case 4: {
                    if (Chars.startsWith(node.token, ':')) {
                        this.stack.push(this.createNamedParameter(node));
                        break;
                    }
                    if (Chars.startsWith(node.token, '$')) {
                        try {
                            int variableIndex = Numbers.parseInt(node.token, 1, node.token.length());
                            if (variableIndex < 1) {
                                throw SqlException.$(node.position, "invalid bind variable index [value=").put(variableIndex).put(']');
                            }
                            this.stack.push(this.createIndexParameter(variableIndex - 1, node));
                        }
                        catch (NumericException e) {
                            this.stack.push(this.createColumn(node));
                        }
                        break;
                    }
                    this.stack.push(this.createColumn(node));
                    break;
                }
                case 2: {
                    this.stack.push(this.createConstant(node));
                    break;
                }
                case 65: {
                    this.stack.push(this.createCursorFunction(node));
                    break;
                }
                default: {
                    this.stack.push(this.createFunction(node, null));
                    break;
                }
            }
        } else {
            this.mutableArgs.clear();
            this.mutableArgs.setPos(argCount);
            for (int n = 0; n < argCount; ++n) {
                this.mutableArgs.setQuick(n, this.stack.poll());
            }
            this.stack.push(this.createFunction(node, this.mutableArgs));
        }
    }

    private Function checkAndCreateFunction(FunctionFactory factory, ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        Function function;
        try {
            function = factory.newInstance(args, position, configuration);
        }
        catch (SqlException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error().$("exception in function factory: ").$(e).$();
            throw SqlException.position(position).put("exception in function factory");
        }
        if (function == null) {
            LOG.error().$("NULL function").$(" [signature=").$(factory.getSignature()).$(",class=").$(factory.getClass().getName()).$(']').$();
            throw SqlException.position(position).put("bad function factory (NULL), check log");
        }
        if (function.isConstant()) {
            return this.functionToConstant(position, function);
        }
        return function;
    }

    private Function createColumn(ExpressionNode node) throws SqlException {
        int index = this.metadata.getColumnIndexQuiet(node.token);
        if (index == -1) {
            throw SqlException.invalidColumn(node.position, node.token);
        }
        switch (this.metadata.getColumnType(index)) {
            case 0: {
                return new BooleanColumn(node.position, index);
            }
            case 1: {
                return new ByteColumn(node.position, index);
            }
            case 2: {
                return new ShortColumn(node.position, index);
            }
            case 3: {
                return new CharColumn(node.position, index);
            }
            case 4: {
                return new IntColumn(node.position, index);
            }
            case 5: {
                return new LongColumn(node.position, index);
            }
            case 8: {
                return new FloatColumn(node.position, index);
            }
            case 9: {
                return new DoubleColumn(node.position, index);
            }
            case 10: {
                return new StrColumn(node.position, index);
            }
            case 11: {
                return new SymbolColumn(node.position, index, this.metadata.isSymbolTableStatic(index));
            }
            case 13: {
                return new BinColumn(node.position, index);
            }
            case 6: {
                return new DateColumn(node.position, index);
            }
            case 7: {
                return new TimestampColumn(node.position, index);
            }
        }
        return new Long256Column(node.position, index);
    }

    private Function createConstant(ExpressionNode node) throws SqlException {
        if (Chars.equalsLowerCaseAscii(node.token, "null")) {
            return new NullStrConstant(node.position);
        }
        if (Chars.isQuoted(node.token)) {
            if (node.token.length() == 3) {
                return new CharConstant(node.position, node.token.charAt(1));
            }
            if (node.token.length() == 2) {
                return new CharConstant(node.position, '\u0000');
            }
            return new StrConstant(node.position, node.token);
        }
        if (Chars.equalsLowerCaseAscii(node.token, "true")) {
            return new BooleanConstant(node.position, true);
        }
        if (Chars.equalsLowerCaseAscii(node.token, "false")) {
            return new BooleanConstant(node.position, false);
        }
        try {
            return new IntConstant(node.position, Numbers.parseInt(node.token));
        }
        catch (NumericException numericException) {
            try {
                return new LongConstant(node.position, Numbers.parseLong(node.token));
            }
            catch (NumericException numericException2) {
                try {
                    return new DoubleConstant(node.position, Numbers.parseDouble(node.token));
                }
                catch (NumericException numericException3) {
                    try {
                        return new FloatConstant(node.position, Numbers.parseFloat(node.token));
                    }
                    catch (NumericException numericException4) {
                        int columnType = ColumnType.columnTypeOf(node.token);
                        if (columnType > -1) {
                            return Constants.getTypeConstant(columnType);
                        }
                        throw SqlException.position(node.position).put("invalid constant: ").put(node.token);
                    }
                }
            }
        }
    }

    private Function createCursorFunction(ExpressionNode node) throws SqlException {
        assert (node.queryModel != null);
        return new CursorFunction(node.position, this.sqlCodeGenerator.generate(node.queryModel, this.sqlExecutionContext));
    }

    private Function createFunction(ExpressionNode node, ObjList<Function> args) throws SqlException {
        ObjList<FunctionFactory> overload = this.factories.get(node.token);
        if (overload == null) {
            throw FunctionParser.invalidFunction("unknown function name", node, args);
        }
        int argCount = args == null ? 0 : args.size();
        FunctionFactory candidate = null;
        String candidateSignature = null;
        boolean candidateSigVarArgConst = false;
        int candidateSigArgCount = 0;
        int fuzzyMatchCount = 0;
        int bestMatch = 0;
        int n = overload.size();
        for (int i = 0; i < n; ++i) {
            boolean sigVarArgConst;
            boolean sigVarArg;
            FunctionFactory factory = overload.getQuick(i);
            String signature = factory.getSignature();
            int sigArgOffset = signature.indexOf(40) + 1;
            int sigArgCount = signature.length() - 1 - sigArgOffset;
            if (sigArgCount > 0) {
                char c = signature.charAt(sigArgOffset + sigArgCount - 1);
                sigVarArg = FunctionParser.getArgType(Character.toUpperCase(c)) == 100;
                sigVarArgConst = Character.isLowerCase(c);
            } else {
                sigVarArg = false;
                sigVarArgConst = false;
            }
            if (sigVarArg) {
                --sigArgCount;
            }
            if (argCount == 0 && sigArgCount == 0) {
                return this.checkAndCreateFunction(factory, args, node.position, this.configuration);
            }
            if (sigArgCount != argCount && (!sigVarArg || argCount < sigArgCount)) continue;
            int match = 0;
            if (sigArgCount == 0) {
                match = 3;
            }
            for (int k = 0; k < sigArgCount; ++k) {
                boolean overloadPossible;
                Function arg = args.getQuick(k);
                char c = signature.charAt(sigArgOffset + k);
                if (Character.isLowerCase(c) && !arg.isConstant()) {
                    match = 0;
                    break;
                }
                int sigArgType = FunctionParser.getArgType(c);
                if (sigArgType == arg.getType()) {
                    switch (match) {
                        case 0: {
                            match = 3;
                            break;
                        }
                        case 1: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                boolean bl = overloadPossible = arg.getType() >= 1 && arg.getType() <= 9 && sigArgType >= 1 && sigArgType <= 9 && arg.getType() < sigArgType || arg.getType() == 9 && arg.isConstant() && Double.isNaN(arg.getDouble(null)) && (sigArgType == 5 || sigArgType == 4) && (!(arg instanceof TypeConstant) || arg.getType() != sigArgType);
                if (overloadPossible) {
                    switch (match) {
                        case 0: {
                            match = 1;
                            break;
                        }
                        case 3: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                match = 0;
                break;
            }
            if (match == 0 || match != 3 && match < bestMatch) continue;
            candidate = factory;
            candidateSignature = signature;
            candidateSigArgCount = sigArgCount;
            candidateSigVarArgConst = sigVarArgConst;
            if (match != 3) {
                fuzzyMatchCount = match == 1 ? ++fuzzyMatchCount : 0;
                bestMatch = match;
                continue;
            }
            fuzzyMatchCount = 0;
            break;
        }
        if (fuzzyMatchCount > 1) {
            throw FunctionParser.invalidFunction("ambiguous function call", node, args);
        }
        if (candidate == null) {
            throw FunctionParser.invalidFunction("unknown function", node, args);
        }
        if (candidateSigVarArgConst) {
            for (int k = candidateSigArgCount; k < argCount; ++k) {
                Function func = args.getQuick(k);
                if (func.isConstant()) continue;
                throw SqlException.$(func.getPosition(), "constant expected");
            }
        }
        int sigArgOffset = candidateSignature.indexOf(40) + 1;
        for (int k = 0; k < candidateSigArgCount; ++k) {
            Function arg = args.getQuick(k);
            char c = candidateSignature.charAt(sigArgOffset + k);
            int sigArgType = FunctionParser.getArgType(c);
            if (arg.getType() != 9 || !arg.isConstant() || !Double.isNaN(arg.getDouble(null))) continue;
            if (sigArgType == 5) {
                args.setQuick(k, new LongConstant(arg.getPosition(), Long.MIN_VALUE));
                continue;
            }
            if (sigArgType != 4) continue;
            args.setQuick(k, new IntConstant(arg.getPosition(), Integer.MIN_VALUE));
        }
        LOG.info().$("call ").$(node).$(" -> ").$(candidate.getSignature()).$();
        return this.checkAndCreateFunction(candidate, args, node.position, this.configuration);
    }

    private Function functionToConstant(int position, Function function) {
        switch (function.getType()) {
            case 4: {
                if (function instanceof IntConstant) {
                    return function;
                }
                return new IntConstant(position, function.getInt(null));
            }
            case 0: {
                if (function instanceof BooleanConstant) {
                    return function;
                }
                return new BooleanConstant(position, function.getBool(null));
            }
            case 1: {
                if (function instanceof ByteConstant) {
                    return function;
                }
                return new ByteConstant(position, function.getByte(null));
            }
            case 2: {
                if (function instanceof ShortConstant) {
                    return function;
                }
                return new ShortConstant(position, function.getShort(null));
            }
            case 3: {
                if (function instanceof CharConstant) {
                    return function;
                }
                return new CharConstant(position, function.getChar(null));
            }
            case 8: {
                if (function instanceof FloatConstant) {
                    return function;
                }
                return new FloatConstant(position, function.getFloat(null));
            }
            case 9: {
                if (function instanceof DoubleConstant) {
                    return function;
                }
                return new DoubleConstant(position, function.getDouble(null));
            }
            case 5: {
                if (function instanceof LongConstant) {
                    return function;
                }
                return new LongConstant(position, function.getLong(null));
            }
            case 12: {
                if (function instanceof Long256Constant) {
                    return function;
                }
                return new Long256Constant(position, function.getLong256A(null));
            }
            case 6: {
                if (function instanceof DateConstant) {
                    return function;
                }
                return new DateConstant(position, function.getDate(null));
            }
            case 10: {
                if (function instanceof StrConstant || function instanceof NullStrConstant) {
                    return function;
                }
                CharSequence value = function.getStr(null);
                if (value == null) {
                    return new NullStrConstant(position);
                }
                return new StrConstant(position, value);
            }
            case 11: {
                if (function instanceof SymbolConstant) {
                    return function;
                }
                return new SymbolConstant(position, Chars.toString(function.getSymbol(null)), 0);
            }
            case 7: {
                if (function instanceof TimestampConstant) {
                    return function;
                }
                return new TimestampConstant(position, function.getTimestamp(null));
            }
        }
        return function;
    }

    int getFunctionCount() {
        return this.factories.size();
    }

    private void loadFunctionFactories(Iterable<FunctionFactory> functionFactories) {
        for (FunctionFactory factory : functionFactories) {
            ObjList<Object> overload;
            int openBraceIndex;
            String sig = factory.getSignature();
            try {
                openBraceIndex = FunctionParser.validateSignatureAndGetNameSeparator(sig);
            }
            catch (SqlException e) {
                LOG.error().$(e).$(" [signature=").$(factory.getSignature()).$(",class=").$(factory.getClass().getName()).$(']').$();
                continue;
            }
            String name = sig.substring(0, openBraceIndex);
            int index = this.factories.keyIndex(name);
            if (index < 0) {
                overload = this.factories.valueAtQuick(index);
            } else {
                overload = new ObjList(4);
                this.factories.putAt(index, name, overload);
            }
            overload.add(factory);
            if (!factory.isGroupBy()) continue;
            this.groupByFunctionNames.add(name);
        }
    }

    static {
        int n = SqlCompiler.sqlControlSymbols.size();
        for (int i = 0; i < n; ++i) {
            invalidFunctionNames.add(SqlCompiler.sqlControlSymbols.getQuick(i));
        }
        invalidFunctionNameChars.add(32);
        invalidFunctionNameChars.add(34);
        invalidFunctionNameChars.add(39);
    }
}

