/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertStatement;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WriterOutOfDateException;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class InsertStatementImpl
implements InsertStatement {
    private final VirtualRecord virtualRecord;
    private final SqlCompiler.RecordToRowCopier copier;
    private final Function timestampFunction;
    private final RowFactory rowFactory;
    private final long structureVersion;
    private final String tableName;
    private final InsertMethodImpl insertMethod = new InsertMethodImpl();
    private final CairoEngine engine;
    private SqlExecutionContext lastUsedContext;

    public InsertStatementImpl(CairoEngine engine, String tableName, VirtualRecord virtualRecord, SqlCompiler.RecordToRowCopier copier, Function timestampFunction, long structureVersion) {
        this.engine = engine;
        this.tableName = tableName;
        this.virtualRecord = virtualRecord;
        this.copier = copier;
        this.timestampFunction = timestampFunction;
        this.rowFactory = timestampFunction != null ? this::getRowWithTimestamp : this::getRowWithoutTimestamp;
        this.structureVersion = structureVersion;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public long getStructureVersion() {
        return this.structureVersion;
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext) {
        this.initContext(executionContext);
        TableWriter writer = this.engine.getWriter(executionContext.getCairoSecurityContext(), this.tableName);
        if (writer.getStructureVersion() != this.getStructureVersion()) {
            writer.close();
            throw WriterOutOfDateException.INSTANCE;
        }
        this.insertMethod.writer = writer;
        return this.insertMethod;
    }

    private TableWriter.Row getRowWithTimestamp(TableWriter tableWriter) {
        return tableWriter.newRow(this.timestampFunction.getTimestamp(null));
    }

    private TableWriter.Row getRowWithoutTimestamp(TableWriter tableWriter) {
        return tableWriter.newRow();
    }

    private void initContext(SqlExecutionContext executionContext) {
        this.lastUsedContext = executionContext;
        ObjList<? extends Function> functions = this.virtualRecord.getFunctions();
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            functions.getQuick(i).init(null, executionContext);
        }
        if (this.timestampFunction != null) {
            this.timestampFunction.init(null, executionContext);
        }
    }

    private class InsertMethodImpl
    implements InsertMethod {
        private TableWriter writer = null;

        private InsertMethodImpl() {
        }

        @Override
        public void execute() {
            TableWriter.Row row = InsertStatementImpl.this.rowFactory.getRow(this.writer);
            InsertStatementImpl.this.copier.copy(InsertStatementImpl.this.virtualRecord, row);
            row.append();
        }

        @Override
        public void commit() {
            this.writer.commit();
        }

        @Override
        public void close() {
            this.writer = Misc.free(this.writer);
        }
    }

    @FunctionalInterface
    private static interface RowFactory {
        public TableWriter.Row getRow(TableWriter var1);
    }
}

