/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.AbstractDataFrameCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.FullBwdDataFrameCursorFactory;
import io.questdb.cairo.FullFwdDataFrameCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IntervalBwdDataFrameCursorFactory;
import io.questdb.cairo.IntervalFwdDataFrameCursorFactory;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursorFactory;
import io.questdb.cairo.map.RecordValueSinkFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.WhereClauseParser;
import io.questdb.griffin.engine.EmptyTableRecordCursorFactory;
import io.questdb.griffin.engine.LimitRecordCursorFactory;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.groupby.CountRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctSymbolRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SampleByFillNoneNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByInterpolateRecordCursorFactory;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.groupby.vect.AvgDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.MaxDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.griffin.engine.join.AsOfJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.CrossJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.SpliceJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.FilterOnSubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestBySubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.SelectedRecordCursorFactory;
import io.questdb.griffin.engine.table.SortedSymbolIndexRecordCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.VirtualRecordCursorFactory;
import io.questdb.griffin.engine.union.UnionAllRecordCursorFactory;
import io.questdb.griffin.engine.union.UnionRecordCursorFactory;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.microtime.Timestamps;
import org.jetbrains.annotations.NotNull;

public class SqlCodeGenerator {
    private static final IntHashSet limitTypes = new IntHashSet();
    private final WhereClauseParser filterAnalyser = new WhereClauseParser();
    private final FunctionParser functionParser;
    private final CairoEngine engine;
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final ListColumnFilter listColumnFilterA = new ListColumnFilter();
    private final ListColumnFilter listColumnFilterB = new ListColumnFilter();
    private final CairoConfiguration configuration;
    private final RecordComparatorCompiler recordComparatorCompiler;
    private final IntHashSet intHashSet = new IntHashSet();
    private final ArrayColumnTypes keyTypes = new ArrayColumnTypes();
    private final ArrayColumnTypes valueTypes = new ArrayColumnTypes();
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final ObjList<CharSequence> symbolValueList = new ObjList();
    private boolean fullFatJoins = false;

    public SqlCodeGenerator(CairoEngine engine, CairoConfiguration configuration, FunctionParser functionParser) {
        this.engine = engine;
        this.configuration = configuration;
        this.functionParser = functionParser;
        this.recordComparatorCompiler = new RecordComparatorCompiler(this.asm);
    }

    private GenericRecordMetadata copyMetadata(RecordMetadata that) {
        return GenericRecordMetadata.copyOf(that);
    }

    private RecordCursorFactory createAsOfJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.reset();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        return new AsOfJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    @NotNull
    private RecordCursorFactory createFullFatAsOfJoin(RecordCursorFactory master, RecordMetadata masterMetadata, CharSequence masterAlias, RecordCursorFactory slave, RecordMetadata slaveMetadata, CharSequence slaveAlias, int joinPosition) throws SqlException {
        int i;
        this.intHashSet.clear();
        int n = this.listColumnFilterA.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            this.intHashSet.add(this.listColumnFilterA.getColumnIndex(i2));
        }
        int m = slaveMetadata.getColumnCount();
        for (int k = 0; k < m; ++k) {
            int type;
            if (!this.intHashSet.excludes(k) || (type = slaveMetadata.getColumnType(k)) != 10 && type != 13) continue;
            throw SqlException.position(joinPosition).put("right side column '").put(slaveMetadata.getColumnName(k)).put("' is of unsupported type");
        }
        RecordSink masterSink = RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true);
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
        IntList columnIndex = new IntList(slaveMetadata.getColumnCount());
        this.listColumnFilterB.clear();
        this.valueTypes.reset();
        ArrayColumnTypes slaveTypes = new ArrayColumnTypes();
        int n2 = slaveMetadata.getColumnCount();
        for (i = 0; i < n2; ++i) {
            if (!this.intHashSet.excludes(i)) continue;
            int type = slaveMetadata.getColumnType(i);
            metadata.add(slaveAlias, slaveMetadata.getColumnName(i), type, slaveMetadata.isColumnIndexed(i), slaveMetadata.getIndexValueBlockCapacity(i), slaveMetadata.isSymbolTableStatic(i));
            this.listColumnFilterB.add(i);
            columnIndex.add(i);
            this.valueTypes.add(type);
            slaveTypes.add(type);
        }
        n2 = this.listColumnFilterA.getColumnCount();
        for (i = 0; i < n2; ++i) {
            int index = this.listColumnFilterA.getColumnIndex(i);
            int type = slaveMetadata.getColumnType(index);
            if (type == 11) {
                type = 10;
            }
            metadata.add(slaveAlias, slaveMetadata.getColumnName(index), type, slaveMetadata.isColumnIndexed(i), slaveMetadata.getIndexValueBlockCapacity(i), slaveMetadata.isSymbolTableStatic(i));
            columnIndex.add(index);
            slaveTypes.add(type);
        }
        if (masterMetadata.getTimestampIndex() != -1) {
            metadata.setTimestampIndex(masterMetadata.getTimestampIndex());
        }
        master = new AsOfJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, slaveTypes, masterSink, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount(), RecordValueSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterB), columnIndex);
        return master;
    }

    private RecordCursorFactory createHashJoin(RecordMetadata metadata, RecordCursorFactory master, RecordCursorFactory slave, int joinType) {
        RecordMetadata masterMetadata = master.getMetadata();
        RecordMetadata slaveMetadata = slave.getMetadata();
        RecordSink masterKeySink = RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true);
        RecordSink slaveKeySink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true);
        this.valueTypes.reset();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        if (slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
            if (joinType == 1) {
                return new HashJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount());
            }
            return new HashOuterJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount());
        }
        this.entityColumnFilter.of(slaveMetadata.getColumnCount());
        RecordSink slaveSink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.entityColumnFilter, false);
        if (joinType == 1) {
            return new HashJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount());
        }
        return new HashOuterJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata) {
        return this.createJoinMetadata(masterAlias, masterMetadata, slaveAlias, slaveMetadata, masterMetadata.getTimestampIndex());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata, int timestampIndex) {
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
        metadata.copyColumnMetadataFrom(slaveAlias, slaveMetadata);
        if (timestampIndex != -1) {
            metadata.setTimestampIndex(timestampIndex);
        }
        return metadata;
    }

    private RecordCursorFactory createSpliceJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.reset();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        return new SpliceJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    private ObjList<VectorAggregateFunction> createVectorAggregateFunctions(ObjList<QueryColumn> columns, RecordMetadata metadata) {
        ObjList<VectorAggregateFunction> vafList = new ObjList<VectorAggregateFunction>();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            int type;
            int columnIndex;
            QueryColumn qc = columns.getQuick(i);
            ExpressionNode ast = qc.getAst();
            if (this.isSingleColumnFunction(ast, "sum")) {
                columnIndex = metadata.getColumnIndex(ast.rhs.token);
                type = metadata.getColumnType(columnIndex);
                if (type == 9) {
                    vafList.add(new SumDoubleVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 4) {
                    vafList.add(new SumIntVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 5) {
                    vafList.add(new SumLongVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
            } else if (this.isSingleColumnFunction(ast, "avg")) {
                columnIndex = metadata.getColumnIndex(ast.rhs.token);
                type = metadata.getColumnType(columnIndex);
                if (type == 9) {
                    vafList.add(new AvgDoubleVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 4) {
                    vafList.add(new AvgIntVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 5) {
                    vafList.add(new AvgLongVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
            } else if (this.isSingleColumnFunction(ast, "min")) {
                columnIndex = metadata.getColumnIndex(ast.rhs.token);
                type = metadata.getColumnType(columnIndex);
                if (type == 9) {
                    vafList.add(new MinDoubleVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 4) {
                    vafList.add(new MinIntVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 5) {
                    vafList.add(new MinLongVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
            } else if (this.isSingleColumnFunction(ast, "max")) {
                columnIndex = metadata.getColumnIndex(ast.rhs.token);
                type = metadata.getColumnType(columnIndex);
                if (type == 9) {
                    vafList.add(new MaxDoubleVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 4) {
                    vafList.add(new MaxIntVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
                if (type == 5) {
                    vafList.add(new MaxLongVectorAggregateFunction(ast.rhs.position, columnIndex));
                    continue;
                }
            }
            return null;
        }
        return vafList;
    }

    RecordCursorFactory generate(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.generateQuery(model, executionContext, true);
    }

    private RecordCursorFactory generateFunctionQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        Function function = model.getTableNameFunction();
        assert (function != null);
        if (function.getType() != 101) {
            throw SqlException.position(model.getTableName().position).put("function must return CURSOR [actual=").put(ColumnType.nameOf(function.getType())).put(']');
        }
        RecordCursorFactory factory = function.getRecordCursorFactory();
        ExpressionNode filter = model.getWhereClause();
        if (filter != null) {
            factory = new FilteredRecordCursorFactory(factory, this.functionParser.parseFunction(filter, factory.getMetadata(), executionContext));
        }
        return factory;
    }

    private RecordCursorFactory generateJoins(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        IntList ordered = model.getOrderedJoinModels();
        RecordCursorFactory master = null;
        CharSequence masterAlias = null;
        try {
            Function function;
            int n = ordered.size();
            assert (n > 0);
            for (int i = 0; i < n; ++i) {
                int index = ordered.getQuick(i);
                QueryModel slaveModel = joinModels.getQuick(index);
                RecordCursorFactory slave = this.generateQuery(slaveModel, executionContext, i > 0);
                if (master == null) {
                    master = slave;
                    masterAlias = slaveModel.getName();
                } else {
                    int joinType = slaveModel.getJoinType();
                    RecordMetadata masterMetadata = master.getMetadata();
                    RecordMetadata slaveMetadata = slave.getMetadata();
                    switch (joinType) {
                        case 3: {
                            return new CrossJoinRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount());
                        }
                        case 4: {
                            this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                            this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                            master = slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins ? (this.listColumnFilterA.size() > 0 && this.listColumnFilterB.size() > 0 ? this.createAsOfJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount()) : new AsOfJoinNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount())) : this.createFullFatAsOfJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition());
                            masterAlias = null;
                            break;
                        }
                        case 5: {
                            this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                            this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                            if (slave.recordCursorSupportsRandomAccess() && master.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
                                master = this.createSpliceJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata, -1), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount());
                                break;
                            }
                            assert (false);
                            break;
                        }
                        default: {
                            this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                            master = this.createHashJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, joinType);
                            masterAlias = null;
                        }
                    }
                }
                ExpressionNode filter = slaveModel.getPostJoinWhereClause();
                if (filter == null) continue;
                master = new FilteredRecordCursorFactory(master, this.functionParser.parseFunction(filter, master.getMetadata(), executionContext));
            }
            ExpressionNode constFilter = model.getConstWhereClause();
            if (constFilter != null && !(function = this.functionParser.parseFunction(constFilter, null, executionContext)).getBool(null)) {
                JoinRecordMetadata metadata = (JoinRecordMetadata)master.getMetadata();
                metadata.incrementRefCount();
                EmptyTableRecordCursorFactory factory = new EmptyTableRecordCursorFactory(metadata);
                Misc.free(master);
                return factory;
            }
            return master;
        }
        catch (CairoException | SqlException e) {
            Misc.free(master);
            throw e;
        }
    }

    @NotNull
    private RecordCursorFactory generateLatestByQuery(QueryModel model, TableReader reader, RecordMetadata metadata, String tableName, IntrinsicModel intrinsicModel, Function filter, SqlExecutionContext executionContext, int timestampIndex) throws SqlException {
        AbstractDataFrameCursorFactory dataFrameCursorFactory = intrinsicModel.intervals != null ? new IntervalBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion(), intrinsicModel.intervals, timestampIndex) : new FullBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion());
        if (this.listColumnFilterA.size() == 1) {
            int latestByIndex = this.listColumnFilterA.getColumnIndex(0);
            boolean indexed = metadata.isColumnIndexed(latestByIndex);
            if (intrinsicModel.keyColumn != null) {
                assert (latestByIndex == metadata.getColumnIndexQuiet(intrinsicModel.keyColumn));
                if (intrinsicModel.keySubQuery != null) {
                    RecordCursorFactory rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                    this.validateSubQueryColumnAndGetType(intrinsicModel, rcf.getMetadata());
                    return new LatestBySubQueryRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, rcf, filter, indexed);
                }
                int nKeyValues = intrinsicModel.keyValues.size();
                if (indexed) {
                    assert (nKeyValues > 0);
                    SymbolMapReader symbolMapReader = reader.getSymbolMapReader(latestByIndex);
                    if (nKeyValues == 1) {
                        CharSequence symbolValue = intrinsicModel.keyValues.get(0);
                        int symbol = symbolMapReader.keyOf(symbolValue);
                        if (filter == null) {
                            RowCursorFactory rcf = symbol == -2 ? new LatestByValueDeferredIndexedRowCursorFactory(latestByIndex, Chars.toString(symbolValue), false) : new LatestByValueIndexedRowCursorFactory(latestByIndex, symbol, false);
                            return new DataFrameRecordCursorFactory(metadata, dataFrameCursorFactory, rcf, false, null);
                        }
                        if (symbol == -2) {
                            return new LatestByValueDeferredIndexedFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, Chars.toString(symbolValue), filter);
                        }
                        return new LatestByValueIndexedFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbol, filter);
                    }
                    return new LatestByValuesIndexedFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, intrinsicModel.keyValues, symbolMapReader, filter);
                }
                assert (nKeyValues > 0);
                SymbolMapReader symbolMapReader = reader.getSymbolMapReader(latestByIndex);
                if (nKeyValues > 1) {
                    return new LatestByValuesFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, intrinsicModel.keyValues, symbolMapReader, filter);
                }
                int symbolKey = symbolMapReader.keyOf(intrinsicModel.keyValues.get(0));
                if (symbolKey == -2) {
                    return new LatestByValueDeferredFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, Chars.toString(intrinsicModel.keyValues.get(0)), filter);
                }
                return new LatestByValueFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbolKey, filter);
            }
            assert (intrinsicModel.keyValues.size() == 0);
            if (indexed) {
                return new LatestByAllIndexedFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, filter);
            }
        }
        return new LatestByAllFilteredRecordCursorFactory(metadata, this.configuration, dataFrameCursorFactory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, filter);
    }

    private RecordCursorFactory generateLimit(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        Function hiFunc;
        int type;
        Function loFunc;
        ExpressionNode limitLo = model.getLimitLo();
        ExpressionNode limitHi = model.getLimitHi();
        if (limitLo == null && limitHi == null) {
            return factory;
        }
        if (limitLo == null) {
            loFunc = new LongConstant(0, 0L);
        } else {
            loFunc = this.functionParser.parseFunction(limitLo, EmptyRecordMetadata.INSTANCE, executionContext);
            type = loFunc.getType();
            if (limitTypes.excludes(type)) {
                throw SqlException.$(limitLo.position, "invalid type: ").put(ColumnType.nameOf(type));
            }
        }
        if (limitHi != null) {
            hiFunc = this.functionParser.parseFunction(limitHi, EmptyRecordMetadata.INSTANCE, executionContext);
            type = hiFunc.getType();
            if (limitTypes.excludes(type)) {
                throw SqlException.$(limitHi.position, "invalid type: ").put(ColumnType.nameOf(type));
            }
        } else {
            hiFunc = null;
        }
        return new LimitRecordCursorFactory(factory, loFunc, hiFunc);
    }

    private RecordCursorFactory generateNoSelect(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableName = model.getTableName();
        if (tableName != null) {
            if (tableName.type == 8) {
                return this.generateFunctionQuery(model, executionContext);
            }
            return this.generateTableQuery(model, executionContext);
        }
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        ExpressionNode filter = model.getWhereClause();
        if (filter != null) {
            return new FilteredRecordCursorFactory(factory, this.functionParser.parseFunction(filter, factory.getMetadata(), executionContext));
        }
        return factory;
    }

    private RecordCursorFactory generateOrderBy(RecordCursorFactory recordCursorFactory, QueryModel model) throws SqlException {
        if (recordCursorFactory.followedOrderByAdvice()) {
            return recordCursorFactory;
        }
        try {
            CharSequenceIntHashMap orderBy = model.getOrderHash();
            ObjList<CharSequence> columnNames = orderBy.keys();
            int size = columnNames.size();
            if (size > 0) {
                GenericRecordMetadata orderedMetadata;
                RecordMetadata metadata = recordCursorFactory.getMetadata();
                this.listColumnFilterA.clear();
                this.intHashSet.clear();
                for (int i = 0; i < size; ++i) {
                    CharSequence column = columnNames.getQuick(i);
                    int index = metadata.getColumnIndexQuiet(column);
                    if (metadata.getColumnType(index) == 13) {
                        ObjList<ExpressionNode> nodes = model.getOrderBy();
                        int position = 0;
                        int y = nodes.size();
                        for (int j = 0; j < y; ++j) {
                            if (!Chars.equals(column, nodes.getQuick((int)i).token)) continue;
                            position = nodes.getQuick((int)i).position;
                            break;
                        }
                        throw SqlException.$(position, "unsupported column type: ").put(ColumnType.nameOf(metadata.getColumnType(index)));
                    }
                    if (!this.intHashSet.add(index)) continue;
                    if (orderBy.get(column) == 1) {
                        this.listColumnFilterA.add(-index - 1);
                        continue;
                    }
                    this.listColumnFilterA.add(index + 1);
                }
                if (metadata.getTimestampIndex() == -1) {
                    orderedMetadata = GenericRecordMetadata.copyOfSansTimestamp(metadata);
                } else {
                    int index = metadata.getColumnIndexQuiet(columnNames.getQuick(0));
                    if (index == metadata.getTimestampIndex()) {
                        if (size == 1) {
                            return recordCursorFactory;
                        }
                        orderedMetadata = this.copyMetadata(metadata);
                    } else {
                        orderedMetadata = GenericRecordMetadata.copyOfSansTimestamp(metadata);
                    }
                }
                if (recordCursorFactory.recordCursorSupportsRandomAccess()) {
                    return new SortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA));
                }
                this.entityColumnFilter.of(orderedMetadata.getColumnCount());
                return new SortedRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, orderedMetadata, RecordSinkFactory.getInstance(this.asm, orderedMetadata, this.entityColumnFilter, false), this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA));
            }
            return recordCursorFactory;
        }
        catch (CairoException | SqlException e) {
            recordCursorFactory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateQuery(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        RecordCursorFactory factory = this.generateQuery0(model, executionContext, processJoins);
        if (model.getUnionModel() != null) {
            return this.generateSetFactory(model, factory, executionContext);
        }
        return factory;
    }

    private RecordCursorFactory generateQuery0(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        return this.generateLimit(this.generateOrderBy(this.generateSelect(model, executionContext, processJoins), model), model, executionContext);
    }

    private boolean isSingleColumnFunction(ExpressionNode ast, CharSequence name) {
        return ast.type == 8 && ast.paramCount == 1 && Chars.equals(ast.token, name) && ast.rhs.type == 4;
    }

    @NotNull
    private RecordCursorFactory generateSampleBy(QueryModel model, SqlExecutionContext executionContext, ExpressionNode sampleByNode) throws SqlException {
        executionContext.pushTimestampRequiredFlag(true);
        try {
            int fillCount;
            TimestampSampler timestampSampler;
            ObjList<ExpressionNode> sampleByFill;
            int timestampIndex;
            RecordMetadata metadata;
            RecordCursorFactory factory;
            block24: {
                factory = this.generateSubQuery(model, executionContext);
                metadata = factory.getMetadata();
                ExpressionNode timestamp = model.getTimestamp();
                timestampIndex = timestamp != null ? this.getTimestampIndex(factory, metadata, timestamp) : metadata.getTimestampIndex();
                if (timestampIndex == -1) {
                    throw SqlException.$(model.getSampleBy().position, "base query does not provide dedicated TIMESTAMP column");
                }
                sampleByFill = model.getSampleByFill();
                timestampSampler = TimestampSamplerFactory.getInstance(sampleByNode.token, sampleByNode.position);
                assert (model.getNestedModel() != null);
                fillCount = sampleByFill.size();
                try {
                    this.keyTypes.reset();
                    this.valueTypes.reset();
                    this.listColumnFilterA.clear();
                    if (fillCount != 1 || !Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "linear")) break block24;
                    SampleByInterpolateRecordCursorFactory sampleByInterpolateRecordCursorFactory = new SampleByInterpolateRecordCursorFactory(this.configuration, factory, timestampSampler, model, this.listColumnFilterA, this.functionParser, executionContext, this.asm, this.keyTypes, this.valueTypes, this.entityColumnFilter, timestampIndex);
                    return sampleByInterpolateRecordCursorFactory;
                }
                catch (CairoException | SqlException e) {
                    factory.close();
                    throw e;
                }
            }
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            this.valueTypes.add(7);
            GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, this.valueTypes);
            ObjList<Function> recordFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
            IntList symbolTableSkewIndex = GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions, recordFunctions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), false, timestampIndex);
            if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "prev")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    SampleByFillPrevNotKeyedRecordCursorFactory sampleByFillPrevNotKeyedRecordCursorFactory = new SampleByFillPrevNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, timestampIndex);
                    return sampleByFillPrevNotKeyedRecordCursorFactory;
                }
                SampleByFillPrevRecordCursorFactory sampleByFillPrevRecordCursorFactory = new SampleByFillPrevRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, timestampIndex);
                return sampleByFillPrevRecordCursorFactory;
            }
            if (fillCount == 0 || fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "none")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    SampleByFillNoneNotKeyedRecordCursorFactory sampleByFillNoneNotKeyedRecordCursorFactory = new SampleByFillNoneNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, this.valueTypes.getColumnCount(), timestampIndex);
                    return sampleByFillNoneNotKeyedRecordCursorFactory;
                }
                SampleByFillNoneRecordCursorFactory sampleByFillNoneRecordCursorFactory = new SampleByFillNoneRecordCursorFactory(this.configuration, factory, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, timestampIndex);
                return sampleByFillNoneRecordCursorFactory;
            }
            if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "null")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    SampleByFillNullNotKeyedRecordCursorFactory sampleByFillNullNotKeyedRecordCursorFactory = new SampleByFillNullNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, this.valueTypes.getColumnCount(), timestampIndex);
                    return sampleByFillNullNotKeyedRecordCursorFactory;
                }
                SampleByFillNullRecordCursorFactory sampleByFillNullRecordCursorFactory = new SampleByFillNullRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, timestampIndex);
                return sampleByFillNullRecordCursorFactory;
            }
            assert (fillCount > 0);
            if (this.keyTypes.getColumnCount() == 0) {
                SampleByFillValueNotKeyedRecordCursorFactory sampleByFillValueNotKeyedRecordCursorFactory = new SampleByFillValueNotKeyedRecordCursorFactory(factory, timestampSampler, sampleByFill, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, this.valueTypes.getColumnCount(), timestampIndex);
                return sampleByFillValueNotKeyedRecordCursorFactory;
            }
            SampleByFillValueRecordCursorFactory sampleByFillValueRecordCursorFactory = new SampleByFillValueRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, sampleByFill, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex, timestampIndex);
            return sampleByFillValueRecordCursorFactory;
        }
        finally {
            executionContext.popTimestampRequiredFlag();
        }
    }

    private RecordCursorFactory generateSelect(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        switch (model.getSelectModelType()) {
            case 1: {
                return this.generateSelectChoose(model, executionContext);
            }
            case 4: {
                return this.generateSelectGroupBy(model, executionContext);
            }
            case 2: {
                return this.generateSelectVirtual(model, executionContext);
            }
            case 3: {
                return this.generateSelectAnalytic(model, executionContext);
            }
            case 5: {
                return this.generateSelectDistinct(model, executionContext);
            }
        }
        if (model.getJoinModels().size() > 1 && processJoins) {
            return this.generateJoins(model, executionContext);
        }
        return this.generateNoSelect(model, executionContext);
    }

    private RecordCursorFactory generateSelectAnalytic(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.generateSubQuery(model, executionContext);
    }

    private RecordCursorFactory generateSelectChoose(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        int timestampIndex;
        boolean entity;
        assert (model.getNestedModel() != null);
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        RecordMetadata metadata = factory.getMetadata();
        ObjList<QueryColumn> columns = model.getTopDownColumns().size() > 0 ? model.getTopDownColumns() : model.getColumns();
        int selectColumnCount = columns.size();
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp == null && metadata.getColumnCount() == selectColumnCount) {
            entity = true;
            for (int i = 0; i < selectColumnCount; ++i) {
                QueryColumn qc = columns.getQuick(i);
                if (Chars.equals((CharSequence)metadata.getColumnName(i), qc.getAst().token) && (qc.getAlias() == null || Chars.equals(qc.getAlias(), qc.getAst().token))) continue;
                entity = false;
                break;
            }
        } else {
            entity = false;
        }
        if (entity) {
            return factory;
        }
        IntList columnCrossIndex = new IntList(selectColumnCount);
        GenericRecordMetadata selectMetadata = new GenericRecordMetadata();
        if (timestamp == null) {
            timestampIndex = metadata.getTimestampIndex();
        } else {
            timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
            if (timestampIndex == -1) {
                throw SqlException.invalidColumn(timestamp.position, timestamp.token);
            }
        }
        boolean timestampSet = false;
        for (int i = 0; i < selectColumnCount; ++i) {
            QueryColumn queryColumn = columns.getQuick(i);
            int index = metadata.getColumnIndexQuiet(queryColumn.getAst().token);
            assert (index > -1) : "wtf? " + queryColumn.getAst().token;
            columnCrossIndex.add(index);
            selectMetadata.add(new TableColumnMetadata(Chars.toString(queryColumn.getName()), metadata.getColumnType(index), metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index)));
            if (index != timestampIndex) continue;
            selectMetadata.setTimestampIndex(i);
            timestampSet = true;
        }
        if (!timestampSet && executionContext.isTimestampRequired()) {
            assert (timestampIndex != -1);
            selectMetadata.add(new TableColumnMetadata(Chars.toString(metadata.getColumnName(timestampIndex)), metadata.getColumnType(timestampIndex), metadata.isColumnIndexed(timestampIndex), metadata.getIndexValueBlockCapacity(timestampIndex), metadata.isSymbolTableStatic(timestampIndex)));
        }
        return new SelectedRecordCursorFactory(selectMetadata, columnCrossIndex, factory);
    }

    private RecordCursorFactory generateSelectDistinct(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (model.getColumns().size() == 1 && model.getNestedModel() != null && model.getNestedModel().getNestedModel() != null && model.getNestedModel().getNestedModel().getTableName() != null) {
            ExpressionNode tableNameExpressionNode = model.getNestedModel().getNestedModel().getTableName();
            CharSequence tableName = tableNameExpressionNode.token;
            try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), tableName);){
                CharSequence columnName = model.getBottomUpColumnNames().get(0);
                TableReaderMetadata readerMetadata = (TableReaderMetadata)reader.getMetadata();
                int columnIndex = readerMetadata.getColumnIndex(columnName);
                int columnType = readerMetadata.getColumnType(columnIndex);
                if (readerMetadata.getVersion() >= 416 && columnType == 11) {
                    GenericRecordMetadata distinctSymbolMetadata = new GenericRecordMetadata();
                    long tableVersion = reader.getVersion();
                    distinctSymbolMetadata.add(new TableColumnMetadata(Chars.toString(columnName), readerMetadata.getColumnType(columnIndex), readerMetadata.isColumnIndexed(columnIndex), readerMetadata.getIndexValueBlockCapacity(columnIndex), readerMetadata.isSymbolTableStatic(columnIndex)));
                    DistinctSymbolRecordCursorFactory distinctSymbolRecordCursorFactory = new DistinctSymbolRecordCursorFactory(this.engine, distinctSymbolMetadata, Chars.toString(tableName), columnIndex, tableVersion);
                    return distinctSymbolRecordCursorFactory;
                }
            }
        }
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            return new DistinctRecordCursorFactory(this.configuration, factory, this.entityColumnFilter, this.asm);
        }
        catch (CairoException e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSelectGroupBy(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode sampleByNode = model.getSampleBy();
        if (sampleByNode != null) {
            return this.generateSampleBy(model, executionContext, sampleByNode);
        }
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            ObjList<VectorAggregateFunction> vafList;
            ObjList<QueryColumn> columns = model.getColumns();
            if (columns.size() == 1) {
                QueryColumn column = columns.getQuick(0);
                if (column.getAst().type == 8 && Chars.equalsLowerCaseAscii(column.getAst().token, "count")) {
                    if (Chars.equalsLowerCaseAscii(column.getName(), "count")) {
                        return new CountRecordCursorFactory(CountRecordCursorFactory.DEFAULT_COUNT_METADATA, factory);
                    }
                    GenericRecordMetadata metadata = new GenericRecordMetadata();
                    metadata.add(new TableColumnMetadata(Chars.toString(column.getName()), 5));
                    return new CountRecordCursorFactory(metadata, factory);
                }
            }
            RecordMetadata metadata = factory.getMetadata();
            if (factory.supportPageFrameCursor() && (vafList = this.createVectorAggregateFunctions(columns, metadata)) != null) {
                GenericRecordMetadata m = new GenericRecordMetadata();
                int n = vafList.size();
                for (int i = 0; i < n; ++i) {
                    m.add(new TableColumnMetadata(Chars.toString(columns.getQuick(i).getName()), vafList.getQuick(i).getType()));
                }
                return new GroupByNotKeyedVectorRecordCursorFactory(factory, m, vafList);
            }
            ExpressionNode timestamp = model.getTimestamp();
            int timestampIndex = -1;
            if (timestamp != null) {
                timestampIndex = this.getTimestampIndex(factory, metadata, timestamp);
            } else {
                timestamp = model.getNestedModel().getTimestamp();
                if (timestamp != null) {
                    timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
                }
            }
            this.keyTypes.reset();
            this.valueTypes.reset();
            this.listColumnFilterA.clear();
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, this.valueTypes);
            ObjList<Function> recordFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
            IntList symbolTableSkewIndex = GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions, recordFunctions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), true, timestampIndex);
            if (this.keyTypes.getColumnCount() == 0) {
                return new GroupByNotKeyedRecordCursorFactory(factory, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount());
            }
            return new GroupByRecordCursorFactory(this.configuration, factory, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, symbolTableSkewIndex);
        }
        catch (CairoException e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSelectVirtual(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        assert (model.getNestedModel() != null);
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            int columnCount = model.getColumns().size();
            RecordMetadata metadata = factory.getMetadata();
            ObjList<Function> functions = new ObjList<Function>(columnCount);
            GenericRecordMetadata virtualMetadata = new GenericRecordMetadata();
            int timestampIndex = metadata.getTimestampIndex();
            String timestampColumn = timestampIndex > -1 ? metadata.getColumnName(timestampIndex) : null;
            for (int i = 0; i < columnCount; ++i) {
                QueryColumn column = model.getColumns().getQuick(i);
                ExpressionNode node = column.getAst();
                if (timestampColumn != null && node.type == 4 && Chars.equals((CharSequence)timestampColumn, node.token)) {
                    virtualMetadata.setTimestampIndex(i);
                }
                Function function = this.functionParser.parseFunction(column.getAst(), metadata, executionContext);
                functions.add(function);
                if (function instanceof SymbolFunction) {
                    virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), function.getType(), false, 0, ((SymbolFunction)function).isSymbolTableStatic()));
                    continue;
                }
                virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), function.getType()));
            }
            return new VirtualRecordCursorFactory(virtualMetadata, functions, factory);
        }
        catch (CairoException | SqlException e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSetFactory(QueryModel model, RecordCursorFactory masterFactory, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory slaveFactory = this.generateQuery0(model.getUnionModel(), executionContext, true);
        if (model.getUnionModelType() == 1) {
            return this.generateUnionFactory(model, masterFactory, executionContext, slaveFactory);
        }
        if (model.getUnionModelType() == 0) {
            return this.generateUnionAllFactory(model, masterFactory, executionContext, slaveFactory);
        }
        assert (false);
        return null;
    }

    private RecordCursorFactory generateSubQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        assert (model.getNestedModel() != null);
        return this.generateQuery(model.getNestedModel(), executionContext, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RecordCursorFactory generateTableQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        ExpressionNode whereClause = model.getWhereClause();
        try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), model.getTableName().token, model.getTableVersion());){
            int timestampIndex;
            RecordMetadata readerMeta = reader.getMetadata();
            GenericRecordMetadata metadata = this.copyMetadata(readerMeta);
            ExpressionNode timestamp = model.getTimestamp();
            if (timestamp != null) {
                timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
                metadata.setTimestampIndex(timestampIndex);
            } else {
                timestampIndex = -1;
            }
            this.listColumnFilterA.clear();
            int latestByColumnCount = latestBy.size();
            if (latestBy.size() > 0) {
                for (int i = 0; i < latestByColumnCount; ++i) {
                    int index = metadata.getColumnIndexQuiet(latestBy.getQuick((int)i).token);
                    if (index == -1) {
                        throw SqlException.invalidColumn(latestBy.getQuick((int)i).position, latestBy.getQuick((int)i).token);
                    }
                    this.keyTypes.add(metadata.getColumnType(index));
                    this.listColumnFilterA.add(index);
                }
            }
            String tableName = reader.getTableName();
            if (whereClause != null) {
                Object orderByAdvice;
                int orderByAdviceSize;
                boolean intervalHitsOnlyOnePartition;
                AbstractDataFrameCursorFactory dfcFactory;
                Function filter;
                IntrinsicModel intrinsicModel = this.filterAnalyser.extract(model, whereClause, metadata, latestByColumnCount > 0 ? latestBy.getQuick((int)0).token : null, timestampIndex);
                if (intrinsicModel.intrinsicValue == 2) {
                    EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(metadata);
                    return emptyTableRecordCursorFactory;
                }
                if (intrinsicModel.filter != null) {
                    filter = this.functionParser.parseFunction(intrinsicModel.filter, metadata, executionContext);
                    if (filter.getType() != 0) {
                        throw SqlException.$(intrinsicModel.filter.position, "boolean expression expected");
                    }
                    if (filter.isConstant()) {
                        if (!filter.getBool(null)) {
                            EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(metadata);
                            return emptyTableRecordCursorFactory;
                        }
                        filter = null;
                    }
                } else {
                    filter = null;
                }
                if (latestByColumnCount > 0) {
                    RecordCursorFactory recordCursorFactory = this.generateLatestByQuery(model, reader, metadata, tableName, intrinsicModel, filter, executionContext, timestampIndex);
                    return recordCursorFactory;
                }
                if (intrinsicModel.intervals != null) {
                    dfcFactory = new IntervalFwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion(), intrinsicModel.intervals, timestampIndex);
                    switch (reader.getPartitionedBy()) {
                        case 0: {
                            intervalHitsOnlyOnePartition = this.isFocused(intrinsicModel.intervals, Timestamps.FLOOR_DD);
                            break;
                        }
                        case 1: {
                            intervalHitsOnlyOnePartition = this.isFocused(intrinsicModel.intervals, Timestamps.FLOOR_MM);
                            break;
                        }
                        case 2: {
                            intervalHitsOnlyOnePartition = this.isFocused(intrinsicModel.intervals, Timestamps.FLOOR_YYYY);
                            break;
                        }
                        default: {
                            intervalHitsOnlyOnePartition = true;
                            break;
                        }
                    }
                } else {
                    dfcFactory = new FullFwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion());
                    intervalHitsOnlyOnePartition = false;
                }
                if (intrinsicModel.keyColumn != null) {
                    ObjList<ExpressionNode> orderByAdvice2;
                    int orderByAdviceSize2;
                    int keyColumnIndex = reader.getMetadata().getColumnIndexQuiet(intrinsicModel.keyColumn);
                    int nKeyValues = intrinsicModel.keyValues.size();
                    if (intrinsicModel.keySubQuery != null) {
                        RecordCursorFactory rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                        this.validateSubQueryColumnAndGetType(intrinsicModel, rcf.getMetadata());
                        FilterOnSubQueryRecordCursorFactory filterOnSubQueryRecordCursorFactory = new FilterOnSubQueryRecordCursorFactory(metadata, dfcFactory, rcf, keyColumnIndex, filter);
                        return filterOnSubQueryRecordCursorFactory;
                    }
                    assert (nKeyValues > 0);
                    boolean orderByKeyColumn = false;
                    int indexDirection = 1;
                    if (intervalHitsOnlyOnePartition && (orderByAdviceSize2 = (orderByAdvice2 = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize2 < 3 && Chars.equals(orderByAdvice2.getQuick((int)0).token, intrinsicModel.keyColumn)) {
                        if (orderByAdviceSize2 == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(orderByAdvice2.getQuick((int)1).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (model.getOrderByDirectionAdvice().getQuick(1) == 1) {
                                indexDirection = 2;
                            }
                        }
                    }
                    if (nKeyValues == 1) {
                        CharSequence symbol = intrinsicModel.keyValues.get(0);
                        int symbolKey = reader.getSymbolMapReader(keyColumnIndex).keyOf(symbol);
                        RowCursorFactory rcf = symbolKey == -2 ? (filter == null ? new DeferredSymbolIndexRowCursorFactory(keyColumnIndex, Chars.toString(symbol), true, indexDirection) : new DeferredSymbolIndexFilteredRowCursorFactory(keyColumnIndex, Chars.toString(symbol), filter, true, indexDirection)) : (filter == null ? new SymbolIndexRowCursorFactory(keyColumnIndex, symbolKey, true, indexDirection) : new SymbolIndexFilteredRowCursorFactory(keyColumnIndex, symbolKey, filter, true, indexDirection));
                        DataFrameRecordCursorFactory dataFrameRecordCursorFactory = new DataFrameRecordCursorFactory(metadata, dfcFactory, rcf, orderByKeyColumn, filter);
                        return dataFrameRecordCursorFactory;
                    }
                    this.symbolValueList.clear();
                    int n = intrinsicModel.keyValues.size();
                    for (int i = 0; i < n; ++i) {
                        this.symbolValueList.add(intrinsicModel.keyValues.get(i));
                    }
                    if (orderByKeyColumn) {
                        if (model.getOrderByDirectionAdvice().getQuick(0) == 0) {
                            this.symbolValueList.sort(Chars.CHAR_SEQUENCE_COMPARATOR);
                        } else {
                            this.symbolValueList.sort(Chars.CHAR_SEQUENCE_COMPARATOR_DESC);
                        }
                    }
                    FilterOnValuesRecordCursorFactory i = new FilterOnValuesRecordCursorFactory(metadata, dfcFactory, this.symbolValueList, keyColumnIndex, reader, filter, model.getOrderByAdviceMnemonic(), orderByKeyColumn, indexDirection);
                    return i;
                }
                if (filter != null) {
                    FilteredRecordCursorFactory keyColumnIndex = new FilteredRecordCursorFactory(new DataFrameRecordCursorFactory(metadata, dfcFactory, new DataFrameRowCursorFactory(), false, null), filter);
                    return keyColumnIndex;
                }
                if (intervalHitsOnlyOnePartition && (orderByAdviceSize = ((ObjList)(orderByAdvice = model.getOrderByAdvice())).size()) > 0 && orderByAdviceSize < 3 && intrinsicModel.intervals != null) {
                    int columnIndex = metadata.getColumnIndexQuiet(model.getOrderByAdvice().getQuick((int)0).token);
                    assert (columnIndex > -1);
                    if (metadata.isColumnIndexed(columnIndex)) {
                        boolean orderByKeyColumn = false;
                        int indexDirection = 1;
                        if (orderByAdviceSize == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(((ExpressionNode)((ObjList)orderByAdvice).getQuick((int)1)).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (model.getOrderByDirectionAdvice().getQuick(1) == 1) {
                                indexDirection = 2;
                            }
                        }
                        if (orderByKeyColumn) {
                            metadata.setTimestampIndex(-1);
                            SortedSymbolIndexRecordCursorFactory n = new SortedSymbolIndexRecordCursorFactory(metadata, dfcFactory, columnIndex, model.getOrderByDirectionAdvice().getQuick(0) == 0, indexDirection);
                            return n;
                        }
                    }
                }
                orderByAdvice = new DataFrameRecordCursorFactory(metadata, dfcFactory, new DataFrameRowCursorFactory(), false, null);
                return orderByAdvice;
            }
            if (latestByColumnCount == 0) {
                boolean framingSupported;
                ObjList<QueryColumn> topDownColumns = model.getTopDownColumns();
                int topDownColumnCount = topDownColumns.size();
                IntList columnIndexes = new IntList();
                IntList columnSizes = new IntList();
                GenericRecordMetadata mm = new GenericRecordMetadata();
                int readerTimestampIndex = model.getTimestamp() == null ? readerMeta.getTimestampIndex() : readerMeta.getColumnIndex(model.getTimestamp().token);
                if (topDownColumnCount > 0) {
                    framingSupported = true;
                    for (int i = 0; i < topDownColumnCount; ++i) {
                        int columnIndex = readerMeta.getColumnIndexQuiet(topDownColumns.getQuick(i).getName());
                        int type = readerMeta.getColumnType(columnIndex);
                        int typeSize = ColumnType.sizeOf(type);
                        if (framingSupported && (typeSize < 1 || typeSize > 8)) {
                            framingSupported = false;
                        }
                        columnIndexes.add(columnIndex);
                        columnSizes.add(Numbers.msb(typeSize));
                        mm.add(new TableColumnMetadata(Chars.toString(topDownColumns.getQuick(i).getName()), type, readerMeta.isColumnIndexed(columnIndex), readerMeta.getIndexValueBlockCapacity(columnIndex), readerMeta.isSymbolTableStatic(columnIndex)));
                        if (columnIndex != readerTimestampIndex) continue;
                        mm.setTimestampIndex(mm.getColumnCount() - 1);
                    }
                    if (readerTimestampIndex != -1 && mm.getTimestampIndex() == -1 && executionContext.isTimestampRequired()) {
                        mm.add(new TableColumnMetadata(readerMeta.getColumnName(readerTimestampIndex), readerMeta.getColumnType(readerTimestampIndex)));
                        mm.setTimestampIndex(mm.getColumnCount() - 1);
                        columnIndexes.add(readerTimestampIndex);
                        columnSizes.add(Numbers.msb(7));
                    }
                } else {
                    framingSupported = false;
                }
                TableReaderRecordCursorFactory tableReaderRecordCursorFactory = new TableReaderRecordCursorFactory(mm, this.engine, tableName, model.getTableVersion(), columnIndexes, columnSizes, framingSupported);
                return tableReaderRecordCursorFactory;
            }
            if (latestByColumnCount == 1 && metadata.isColumnIndexed(this.listColumnFilterA.getQuick(0))) {
                LatestByAllIndexedFilteredRecordCursorFactory latestByAllIndexedFilteredRecordCursorFactory = new LatestByAllIndexedFilteredRecordCursorFactory(this.configuration, metadata, new FullBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion()), this.listColumnFilterA.getQuick(0), null);
                return latestByAllIndexedFilteredRecordCursorFactory;
            }
            LatestByAllFilteredRecordCursorFactory latestByAllFilteredRecordCursorFactory = new LatestByAllFilteredRecordCursorFactory(metadata, this.configuration, new FullBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion()), RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, null);
            return latestByAllFilteredRecordCursorFactory;
        }
    }

    private RecordCursorFactory generateUnionAllFactory(QueryModel model, RecordCursorFactory masterFactory, SqlExecutionContext executionContext, RecordCursorFactory slaveFactory) throws SqlException {
        this.validateJoinColumnTypes(model, masterFactory, slaveFactory);
        UnionAllRecordCursorFactory unionAllFactory = new UnionAllRecordCursorFactory(masterFactory, slaveFactory);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionAllFactory, executionContext);
        }
        return unionAllFactory;
    }

    private RecordCursorFactory generateUnionFactory(QueryModel model, RecordCursorFactory masterFactory, SqlExecutionContext executionContext, RecordCursorFactory slaveFactory) throws SqlException {
        this.validateJoinColumnTypes(model, masterFactory, slaveFactory);
        this.entityColumnFilter.of(masterFactory.getMetadata().getColumnCount());
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, masterFactory.getMetadata(), this.entityColumnFilter, true);
        this.valueTypes.reset();
        UnionRecordCursorFactory unionFactory = new UnionRecordCursorFactory(this.configuration, masterFactory, slaveFactory, recordSink, this.valueTypes);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionFactory, executionContext);
        }
        return unionFactory;
    }

    private int getTimestampIndex(RecordCursorFactory factory, RecordMetadata metadata, ExpressionNode timestamp) throws SqlException {
        int timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
        if (timestampIndex == -1) {
            Misc.free(factory);
            throw SqlException.invalidColumn(timestamp.position, timestamp.token);
        }
        if (metadata.getColumnType(timestampIndex) != 7) {
            Misc.free(factory);
            throw SqlException.$(timestamp.position, "not a TIMESTAMP");
        }
        return timestampIndex;
    }

    private boolean isFocused(LongList intervals, Timestamps.TimestampFloorMethod floorMethod) {
        long floor = floorMethod.floor(intervals.getQuick(0));
        int n = intervals.size();
        for (int i = 1; i < n; ++i) {
            if (floor == floorMethod.floor(intervals.getQuick(i))) continue;
            return false;
        }
        return true;
    }

    private void lookupColumnIndexes(ListColumnFilter filter, ObjList<ExpressionNode> columnNames, RecordMetadata masterMetadata) {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            filter.add(masterMetadata.getColumnIndex(columnNames.getQuick((int)i).token));
        }
    }

    private void lookupColumnIndexesUsingVanillaNames(ListColumnFilter filter, ObjList<CharSequence> columnNames, RecordMetadata metadata) {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            filter.add(metadata.getColumnIndex(columnNames.getQuick(i)));
        }
    }

    private void processJoinContext(boolean vanillaMaster, JoinContext jc, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterA, jc.aNames, slaveMetadata);
        if (vanillaMaster) {
            this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterB, jc.bNames, masterMetadata);
        } else {
            this.lookupColumnIndexes(this.listColumnFilterB, jc.bNodes, masterMetadata);
        }
        this.keyTypes.reset();
        int m = this.listColumnFilterA.getColumnCount();
        for (int k = 0; k < m; ++k) {
            int columnType = masterMetadata.getColumnType(this.listColumnFilterB.getColumnIndex(k));
            if (columnType != slaveMetadata.getColumnType(this.listColumnFilterA.getColumnIndex(k))) {
                throw SqlException.$(jc.aNodes.getQuick((int)k).position, "join column type mismatch");
            }
            this.keyTypes.add(columnType == 11 ? 10 : columnType);
        }
    }

    void setFullFatJoins(boolean fullFatJoins) {
        this.fullFatJoins = fullFatJoins;
    }

    private void validateBothTimestamps(QueryModel slaveModel, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        if (masterMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "left side of time series join has no timestamp");
        }
        if (slaveMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "right side of time series join has no timestamp");
        }
    }

    private void validateJoinColumnTypes(QueryModel model, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory) throws SqlException {
        RecordMetadata metadata = masterFactory.getMetadata();
        RecordMetadata slaveMetadata = slaveFactory.getMetadata();
        int columnCount = metadata.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (metadata.getColumnType(i) == slaveMetadata.getColumnType(i)) continue;
            throw SqlException.$(model.getUnionModel().getModelPosition(), "column type mismatch [index=").put(i).put(", A=").put(ColumnType.nameOf(metadata.getColumnType(i))).put(", B=").put(ColumnType.nameOf(slaveMetadata.getColumnType(i))).put(']');
        }
    }

    private void validateSubQueryColumnAndGetType(IntrinsicModel intrinsicModel, RecordMetadata metadata) throws SqlException {
        int firstColumnType = metadata.getColumnType(0);
        if (firstColumnType != 10 && firstColumnType != 11) {
            assert (intrinsicModel.keySubQuery.getColumns() != null);
            assert (intrinsicModel.keySubQuery.getColumns().size() > 0);
            throw SqlException.position(intrinsicModel.keySubQuery.getColumns().getQuick((int)0).getAst().position).put("unsupported column type: ").put(metadata.getColumnName(0)).put(": ").put(ColumnType.nameOf(firstColumnType));
        }
    }

    static {
        limitTypes.add(5);
        limitTypes.add(1);
        limitTypes.add(2);
        limitTypes.add(4);
    }
}

