/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.CompiledQueryImpl;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.InsertStatementImpl;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompiler
implements Closeable {
    public static final ObjList<String> sqlControlSymbols = new ObjList(8);
    private static final Log LOG = LogFactory.getLog(SqlCompiler.class);
    private static final IntList castGroups = new IntList();
    private final SqlOptimiser optimiser;
    private final SqlParser parser;
    private final ObjectPool<ExpressionNode> sqlNodePool;
    private final CharacterStore characterStore;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final GenericLexer lexer;
    private final SqlCodeGenerator codeGenerator;
    private final CairoConfiguration configuration;
    private final Path path = new Path();
    private final Path renamePath = new Path();
    private final AppendMemory mem = new AppendMemory();
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final MessageBus messageBus;
    private final CairoEngine engine;
    private final ListColumnFilter listColumnFilter = new ListColumnFilter();
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final IntIntHashMap typeCast = new IntIntHashMap();
    private final ObjList<TableWriter> tableWriters = new ObjList();
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final FunctionParser functionParser;
    private final CharSequenceObjHashMap<KeywordBasedExecutor> keywordBasedExecutors = new CharSequenceObjHashMap();
    private final CompiledQueryImpl compiledQuery = new CompiledQueryImpl();
    private final ExecutableMethod insertAsSelectMethod = this::insertAsSelect;
    private final ExecutableMethod createTableMethod = this::createTable;
    private final TextLoader textLoader;
    private final FilesFacade ff;

    public SqlCompiler(CairoEngine engine) {
        this(engine, null);
    }

    public SqlCompiler(CairoEngine engine, @Nullable MessageBus messageBus) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
        this.messageBus = messageBus;
        this.sqlNodePool = new ObjectPool<ExpressionNode>(ExpressionNode.FACTORY, this.configuration.getSqlExpressionPoolCapacity());
        this.queryColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, this.configuration.getSqlColumnPoolCapacity());
        this.queryModelPool = new ObjectPool<QueryModel>(QueryModel.FACTORY, this.configuration.getSqlModelPoolCapacity());
        this.characterStore = new CharacterStore(this.configuration.getSqlCharacterStoreCapacity(), this.configuration.getSqlCharacterStoreSequencePoolCapacity());
        this.lexer = new GenericLexer(this.configuration.getSqlLexerPoolCapacity());
        this.functionParser = new FunctionParser(this.configuration, ServiceLoader.load(FunctionFactory.class));
        this.codeGenerator = new SqlCodeGenerator(engine, this.configuration, this.functionParser);
        this.functionParser.setSqlCodeGenerator(this.codeGenerator);
        this.keywordBasedExecutors.put("truncate", this::truncateTables);
        this.keywordBasedExecutors.put("TRUNCATE", this::truncateTables);
        this.keywordBasedExecutors.put("alter", this::alterTable);
        this.keywordBasedExecutors.put("ALTER", this::alterTable);
        this.keywordBasedExecutors.put("repair", this::repairTables);
        this.keywordBasedExecutors.put("REPAIR", this::repairTables);
        this.keywordBasedExecutors.put("set", this::compileSet);
        this.keywordBasedExecutors.put("SET", this::compileSet);
        this.keywordBasedExecutors.put("drop", this::dropTable);
        this.keywordBasedExecutors.put("DROP", this::dropTable);
        SqlCompiler.configureLexer(this.lexer);
        PostOrderTreeTraversalAlgo postOrderTreeTraversalAlgo = new PostOrderTreeTraversalAlgo();
        this.optimiser = new SqlOptimiser(this.configuration, engine, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo, this.functionParser, this.path);
        this.parser = new SqlParser(this.configuration, this.optimiser, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo);
        this.textLoader = new TextLoader(engine);
    }

    public static void configureLexer(GenericLexer lexer) {
        int i;
        int k = sqlControlSymbols.size();
        for (i = 0; i < k; ++i) {
            lexer.defineSymbol(sqlControlSymbols.getQuick(i));
        }
        k = OperatorExpression.operators.size();
        for (i = 0; i < k; ++i) {
            OperatorExpression op = OperatorExpression.operators.getQuick(i);
            if (!op.symbol) continue;
            lexer.defineSymbol(op.token);
        }
    }

    private static RecordToRowCopier assembleRecordToRowCopier(BytecodeAssembler asm, ColumnTypes from, RecordMetadata to, ColumnFilter toColumnFilter) {
        int timestampIndex = to.getTimestampIndex();
        asm.init(RecordToRowCopier.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("questdbasm"));
        int interfaceClassIndex = asm.poolClass(RecordToRowCopier.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetLong256 = asm.poolInterfaceMethod(Record.class, "getLong256A", "(I)Lio/questdb/std/Long256;");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int rGetSym = asm.poolInterfaceMethod(Record.class, "getSym", "(I)Ljava/lang/CharSequence;");
        int rGetStr = asm.poolInterfaceMethod(Record.class, "getStr", "(I)Ljava/lang/CharSequence;");
        int rGetBin = asm.poolInterfaceMethod(Record.class, "getBin", "(I)Lio/questdb/std/BinarySequence;");
        int wPutInt = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putInt", (CharSequence)"(II)V");
        int wPutLong = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putLong", (CharSequence)"(IJ)V");
        int wPutLong256 = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putLong256", (CharSequence)"(ILio/questdb/std/Long256;)V");
        int wPutDate = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putDate", (CharSequence)"(IJ)V");
        int wPutTimestamp = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putTimestamp", (CharSequence)"(IJ)V");
        int wPutByte = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putByte", (CharSequence)"(IB)V");
        int wPutShort = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putShort", (CharSequence)"(IS)V");
        int wPutBool = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putBool", (CharSequence)"(IZ)V");
        int wPutFloat = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putFloat", (CharSequence)"(IF)V");
        int wPutDouble = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putDouble", (CharSequence)"(ID)V");
        int wPutSym = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putSym", (CharSequence)"(ILjava/lang/CharSequence;)V");
        int wPutStr = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putStr", (CharSequence)"(ILjava/lang/CharSequence;)V");
        int wPutStrChar = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putStr", (CharSequence)"(IC)V");
        int wPutChar = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putChar", (CharSequence)"(IC)V");
        int wPutBin = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putBin", (CharSequence)"(ILio/questdb/std/BinarySequence;)V");
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/TableWriter$Row;)V");
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(0);
        asm.methodCount(2);
        asm.defineDefaultConstructor();
        asm.startMethod(copyNameIndex, copySigIndex, 4, 3);
        int n = toColumnFilter.getColumnCount();
        block88: for (int i = 0; i < n; ++i) {
            int toColumnIndex = toColumnFilter.getColumnIndex(i);
            if (toColumnIndex == timestampIndex) continue;
            asm.aload(2);
            asm.iconst(toColumnIndex);
            asm.aload(1);
            asm.iconst(i);
            switch (from.getColumnType(i)) {
                case 4: {
                    asm.invokeInterface(rGetInt, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 5: {
                            asm.i2l();
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 2: {
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 1: {
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 8: {
                            asm.i2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                        case 9: {
                            asm.i2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutInt);
                    continue block88;
                }
                case 5: {
                    asm.invokeInterface(rGetLong, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.l2i();
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 6: {
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                        case 7: {
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 2: {
                            asm.l2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 1: {
                            asm.l2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 8: {
                            asm.l2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                        case 9: {
                            asm.l2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutLong);
                    continue block88;
                }
                case 6: {
                    asm.invokeInterface(rGetDate, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.l2i();
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 5: {
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 7: {
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 2: {
                            asm.l2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 1: {
                            asm.l2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 8: {
                            asm.l2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                        case 9: {
                            asm.l2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutDate);
                    continue block88;
                }
                case 7: {
                    asm.invokeInterface(rGetTimestamp, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.l2i();
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 5: {
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 2: {
                            asm.l2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 1: {
                            asm.l2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 8: {
                            asm.l2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                        case 9: {
                            asm.l2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                        case 6: {
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutTimestamp);
                    continue block88;
                }
                case 1: {
                    asm.invokeInterface(rGetByte, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 5: {
                            asm.i2l();
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 2: {
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 8: {
                            asm.i2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                        case 9: {
                            asm.i2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutByte);
                    continue block88;
                }
                case 2: {
                    asm.invokeInterface(rGetShort, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 5: {
                            asm.i2l();
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 1: {
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 8: {
                            asm.i2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                        case 9: {
                            asm.i2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutShort);
                    continue block88;
                }
                case 0: {
                    asm.invokeInterface(rGetBool, 1);
                    asm.invokeVirtual(wPutBool);
                    continue block88;
                }
                case 8: {
                    asm.invokeInterface(rGetFloat, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.f2i();
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 5: {
                            asm.f2l();
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 6: {
                            asm.f2l();
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                        case 7: {
                            asm.f2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 2: {
                            asm.f2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 1: {
                            asm.f2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 9: {
                            asm.f2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutFloat);
                    continue block88;
                }
                case 9: {
                    asm.invokeInterface(rGetDouble, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.d2i();
                            asm.invokeVirtual(wPutInt);
                            continue block88;
                        }
                        case 5: {
                            asm.d2l();
                            asm.invokeVirtual(wPutLong);
                            continue block88;
                        }
                        case 6: {
                            asm.d2l();
                            asm.invokeVirtual(wPutDate);
                            continue block88;
                        }
                        case 7: {
                            asm.d2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block88;
                        }
                        case 2: {
                            asm.d2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block88;
                        }
                        case 1: {
                            asm.d2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block88;
                        }
                        case 8: {
                            asm.d2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block88;
                        }
                    }
                    asm.invokeVirtual(wPutDouble);
                    continue block88;
                }
                case 3: {
                    asm.invokeInterface(rGetChar, 1);
                    if (to.getColumnType(toColumnIndex) == 10) {
                        asm.invokeVirtual(wPutStrChar);
                        continue block88;
                    }
                    asm.invokeVirtual(wPutChar);
                    continue block88;
                }
                case 11: {
                    asm.invokeInterface(rGetSym, 1);
                    if (to.getColumnType(toColumnIndex) == 10) {
                        asm.invokeVirtual(wPutStr);
                        continue block88;
                    }
                    asm.invokeVirtual(wPutSym);
                    continue block88;
                }
                case 10: {
                    asm.invokeInterface(rGetStr, 1);
                    if (to.getColumnType(toColumnIndex) == 11) {
                        asm.invokeVirtual(wPutSym);
                        continue block88;
                    }
                    asm.invokeVirtual(wPutStr);
                    continue block88;
                }
                case 13: {
                    asm.invokeInterface(rGetBin, 1);
                    asm.invokeVirtual(wPutBin);
                    continue block88;
                }
                case 12: {
                    asm.invokeInterface(rGetLong256, 1);
                    asm.invokeVirtual(wPutLong256);
                    continue block88;
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        asm.putShort(0);
        return (RecordToRowCopier)asm.newInstance();
    }

    private static boolean isCompatibleCase(int from, int to) {
        return castGroups.getQuick(from) == castGroups.getQuick(to);
    }

    public static boolean isAssignableFrom(int to, int from) {
        return to == from || from >= 1 && to >= 1 && to <= 9 && from < to || from == 10 && to == 11 || from == 11 && to == 10 || from == 3 && to == 10;
    }

    private static void expectKeyword(GenericLexer lexer, CharSequence keyword) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(keyword).put("' expected");
        }
        if (!Chars.equalsLowerCaseAscii(tok, keyword)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(keyword).put("' expected");
        }
    }

    private static CharSequence expectToken(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    @Override
    public void close() {
        Misc.free(this.path);
        Misc.free(this.renamePath);
        Misc.free(this.textLoader);
    }

    @NotNull
    public CompiledQuery compile(@NotNull CharSequence query, @NotNull SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(0, "empty query");
        }
        KeywordBasedExecutor executor = this.keywordBasedExecutors.get(tok);
        if (executor == null) {
            return this.compileUsingModel(executionContext);
        }
        return executor.execute(executionContext);
    }

    public CairoEngine getEngine() {
        return this.engine;
    }

    private CompiledQuery alterTable(SqlExecutionContext executionContext) throws SqlException {
        block19: {
            SqlCompiler.expectKeyword(this.lexer, "table");
            int tableNamePosition = this.lexer.getPosition();
            CharSequence tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
            this.tableExistsOrFail(tableNamePosition, tok, executionContext);
            CharSequence tableName = GenericLexer.immutableOf(tok);
            try (TableWriter writer = this.engine.getWriter(executionContext.getCairoSecurityContext(), tableName);){
                tok = SqlCompiler.expectToken(this.lexer, "'add', 'alter' or 'drop'");
                if (Chars.equalsLowerCaseAscii("add", tok)) {
                    this.alterTableAddColumn(tableNamePosition, writer);
                    break block19;
                }
                if (Chars.equalsLowerCaseAscii("drop", tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column' or 'partition'");
                    if (Chars.equalsLowerCaseAscii(tok, "column")) {
                        this.alterTableDropColumn(tableNamePosition, writer);
                        break block19;
                    }
                    if (Chars.equalsLowerCaseAscii(tok, "partition")) {
                        this.alterTableDropPartition(writer);
                        break block19;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                }
                if (Chars.equalsLowerCaseAscii("alter", tok)) {
                    this.alterTableColumnAddIndex(executionContext, tableNamePosition, tableName);
                    break block19;
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), "'add' or 'drop' expected");
            }
            catch (CairoException e) {
                LOG.info().$("failed to lock table for alter: ").$(e).$();
                throw SqlException.$(tableNamePosition, "table '").put(tableName).put("' is busy");
            }
        }
        return this.compiledQuery.ofAlter();
    }

    private void alterTableColumnAddIndex(SqlExecutionContext executionContext, int tableNamePosition, CharSequence tableName) throws SqlException {
        SqlCompiler.expectKeyword(this.lexer, "column");
        CharSequence columnName = GenericLexer.immutableOf(SqlCompiler.expectToken(this.lexer, "column name"));
        int columnNamePosition = this.lexer.lastTokenPosition();
        SqlCompiler.expectKeyword(this.lexer, "add");
        SqlCompiler.expectKeyword(this.lexer, "index");
        try (TableWriter w = this.engine.getWriter(executionContext.getCairoSecurityContext(), tableName);){
            if (w.getMetadata().getColumnIndexQuiet(columnName) == -1) {
                throw SqlException.invalidColumn(columnNamePosition, columnName);
            }
            w.addIndex(columnName, this.configuration.getIndexValueBlockSize());
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage());
        }
    }

    private void alterTableAddColumn(int tableNamePosition, TableWriter writer) throws SqlException {
        block23: {
            CharSequence tok;
            SqlCompiler.expectKeyword(this.lexer, "column");
            do {
                int indexValueBlockCapacity;
                boolean indexed;
                boolean cache;
                int symbolCapacity;
                tok = SqlCompiler.expectToken(this.lexer, "column name");
                int index = writer.getMetadata().getColumnIndexQuiet(tok);
                if (index != -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "column '").put(tok).put("' already exists");
                }
                CharSequence columnName = GenericLexer.immutableOf(tok);
                tok = SqlCompiler.expectToken(this.lexer, "column type");
                int type = ColumnType.columnTypeOf(tok);
                if (type == -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "invalid type");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (type == 11 && tok != null && !Chars.equals(tok, ',')) {
                    if (Chars.equalsLowerCaseAscii(tok, "capacity")) {
                        boolean negative;
                        tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        int errorPos = this.lexer.lastTokenPosition();
                        if (Chars.equals(tok, '-')) {
                            negative = true;
                            tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        } else {
                            negative = false;
                        }
                        try {
                            symbolCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        if (negative) {
                            symbolCapacity = -symbolCapacity;
                        }
                        TableUtils.validateSymbolCapacity(errorPos, symbolCapacity);
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    }
                    if (Chars.equalsLowerCaseAsciiNc(tok, "cache")) {
                        cache = true;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else if (Chars.equalsLowerCaseAsciiNc(tok, "nocache")) {
                        cache = false;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        cache = this.configuration.getDefaultSymbolCacheFlag();
                    }
                    TableUtils.validateSymbolCapacityCached(cache, symbolCapacity, this.lexer.lastTokenPosition());
                    indexed = Chars.equalsLowerCaseAsciiNc(tok, "index");
                    if (indexed) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (Chars.equalsLowerCaseAsciiNc(tok, "capacity")) {
                        tok = SqlCompiler.expectToken(this.lexer, "symbol index capacity");
                        try {
                            indexValueBlockCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    }
                } else {
                    cache = false;
                    indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    indexed = false;
                }
                try {
                    writer.addColumn(columnName, type, Numbers.ceilPow2(symbolCapacity), cache, indexed, Numbers.ceilPow2(indexValueBlockCapacity), false);
                }
                catch (CairoException e) {
                    LOG.error().$("Cannot add column '").$(writer.getName()).$('.').$(columnName).$("'. Exception: ").$(e).$();
                    throw SqlException.$(tableNamePosition, "Cannot add column [error=").put(e.getFlyweightMessage()).put(']');
                }
                if (tok == null) break block23;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    private void alterTableDropColumn(int tableNamePosition, TableWriter writer) throws SqlException {
        block4: {
            CharSequence tok;
            RecordMetadata metadata = writer.getMetadata();
            do {
                if (metadata.getColumnIndexQuiet(tok = SqlCompiler.expectToken(this.lexer, "column name")) == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                try {
                    writer.removeColumn(tok);
                }
                catch (CairoException e) {
                    LOG.error().$("Cannot drop column '").$(writer.getName()).$('.').$(tok).$("'. Exception: ").$(e).$();
                    throw SqlException.$(tableNamePosition, "Cannot add column. Try again later.");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null) break block4;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    private void alterTableDropPartition(TableWriter writer) throws SqlException {
        block5: {
            CharSequence tok;
            do {
                long timestamp;
                if (Chars.equals(tok = SqlCompiler.expectToken(this.lexer, "partition name"), ',')) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "partition name missing");
                }
                CharSequence unquoted = GenericLexer.unquote(tok);
                try {
                    timestamp = writer.partitionNameToTimestamp(unquoted);
                }
                catch (CairoException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), e.getFlyweightMessage());
                }
                if (!writer.removePartition(timestamp)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "could not remove partition '").put(unquoted).put('\'');
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null) break block5;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    private void clear() {
        this.sqlNodePool.clear();
        this.characterStore.clear();
        this.queryColumnPool.clear();
        this.queryModelPool.clear();
        this.optimiser.clear();
        this.parser.clear();
    }

    private ExecutionModel compileExecutionModel(SqlExecutionContext executionContext) throws SqlException {
        ExecutionModel model = this.parser.parse(this.lexer, executionContext);
        switch (model.getModelType()) {
            case 1: {
                return this.optimiser.optimise((QueryModel)model, executionContext);
            }
            case 4: {
                InsertModel insertModel = (InsertModel)model;
                if (insertModel.getQueryModel() != null) {
                    return this.validateAndOptimiseInsertAsSelect(insertModel, executionContext);
                }
                return this.lightlyValidateInsertModel(insertModel);
            }
        }
        return model;
    }

    private CompiledQuery compileSet(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofSet();
    }

    @NotNull
    private CompiledQuery compileUsingModel(SqlExecutionContext executionContext) throws SqlException {
        this.lexer.unparse();
        ExecutionModel executionModel = this.compileExecutionModel(executionContext);
        switch (executionModel.getModelType()) {
            case 1: {
                return this.compiledQuery.of(this.generate((QueryModel)executionModel, executionContext));
            }
            case 2: {
                return this.createTableWithRetries(executionModel, executionContext);
            }
            case 5: {
                return this.executeCopy(executionContext, (CopyModel)executionModel);
            }
            case 3: {
                RenameTableModel rtm = (RenameTableModel)executionModel;
                this.engine.rename(executionContext.getCairoSecurityContext(), this.path, GenericLexer.unquote(rtm.getFrom().token), this.renamePath, GenericLexer.unquote(rtm.getTo().token));
                return this.compiledQuery.ofRenameTable();
            }
        }
        InsertModel insertModel = (InsertModel)executionModel;
        if (insertModel.getQueryModel() != null) {
            return this.executeWithRetries(this.insertAsSelectMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
        }
        return this.insert(executionModel, executionContext);
    }

    private void copyOrdered(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
        }
        writer.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTable(SqlExecutionContext executionContext, CopyModel model) throws SqlException {
        try {
            int len = this.configuration.getSqlCopyBufferSize();
            long buf = Unsafe.malloc(len);
            try {
                CharSequence name = GenericLexer.unhack(GenericLexer.unquote(model.getFileName().token));
                if (name == null) {
                    throw SqlException.$(model.getFileName().position, "we don't like hacks");
                }
                this.path.of(this.configuration.getInputRoot()).concat(name).$();
                long fd = this.ff.openRO(this.path);
                if (fd == -1L) {
                    throw SqlException.$(model.getFileName().position, "could not open file [errno=").put(Os.errno()).put(", path=").put(this.path).put(']');
                }
                try {
                    long n;
                    long fileLen = this.ff.length(fd);
                    if (n > 0L) {
                        int read;
                        this.textLoader.setSkipRowsWithExtraValues(false);
                        this.textLoader.parse(buf, buf + n, executionContext.getCairoSecurityContext());
                        this.textLoader.setState(2);
                        for (n = this.ff.read(fd, buf, len, 0L); n < fileLen; n += (long)read) {
                            read = (int)this.ff.read(fd, buf, len, n);
                            if (read < 1) {
                                throw SqlException.$(model.getFileName().position, "could not read file [errno=").put(this.ff.errno()).put(']');
                            }
                            this.textLoader.parse(buf, buf + (long)read, executionContext.getCairoSecurityContext());
                        }
                        this.textLoader.wrapUp();
                    }
                }
                finally {
                    this.ff.close(fd);
                }
            }
            finally {
                this.textLoader.clear();
                Unsafe.free(buf, len);
            }
        }
        catch (TextException textException) {
        }
        finally {
            LOG.info().$("copied").$();
        }
    }

    private TableWriter copyTableData(CharSequence tableName, RecordCursor cursor, RecordMetadata cursorMetadata) {
        TableWriter writer = new TableWriter(this.configuration, tableName, this.messageBus, false, DefaultLifecycleManager.INSTANCE);
        try {
            RecordMetadata writerMetadata = writer.getMetadata();
            this.entityColumnFilter.of(writerMetadata.getColumnCount());
            RecordToRowCopier recordToRowCopier = SqlCompiler.assembleRecordToRowCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
            int timestampIndex = writerMetadata.getTimestampIndex();
            if (timestampIndex == -1) {
                this.copyUnordered(cursor, writer, recordToRowCopier);
            } else {
                this.copyOrdered(writer, cursor, recordToRowCopier, timestampIndex);
            }
            return writer;
        }
        catch (CairoException e) {
            writer.close();
            throw e;
        }
    }

    private void copyUnordered(RecordCursor cursor, TableWriter writer, RecordToRowCopier ccopier) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow();
            ccopier.copy(record, row);
            row.append();
        }
        writer.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledQuery createTable(ExecutionModel model, SqlExecutionContext executionContext) throws SqlException {
        CreateTableModel createTableModel = (CreateTableModel)model;
        ExpressionNode name = createTableModel.getName();
        if (this.engine.lock(executionContext.getCairoSecurityContext(), name.token)) {
            TableWriter writer = null;
            try {
                if (this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, name.token) != 1) {
                    throw SqlException.$(name.position, "table already exists");
                }
                try {
                    if (createTableModel.getQueryModel() == null) {
                        this.engine.creatTable(executionContext.getCairoSecurityContext(), this.mem, this.path, createTableModel);
                    } else {
                        writer = this.createTableFromCursor(createTableModel, executionContext);
                    }
                }
                catch (CairoException e) {
                    LOG.error().$("could not create table [error=").$(e).$(']').$();
                    throw SqlException.$(name.position, "Could not create table. See log for details.");
                }
                this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer);
            }
            catch (Throwable throwable) {
                this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer);
                throw throwable;
            }
        }
        throw SqlException.$(name.position, "cannot acquire table lock");
        return this.compiledQuery.ofCreateTable();
    }

    /*
     * Exception decompiling
     */
    private TableWriter createTableFromCursor(CreateTableModel model, SqlExecutionContext executionContext) throws SqlException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CompiledQuery createTableWithRetries(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        return this.executeWithRetries(this.createTableMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
    }

    private CompiledQuery dropTable(SqlExecutionContext executionContext) throws SqlException {
        SqlCompiler.expectKeyword(this.lexer, "table");
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        this.tableExistsOrFail(tableNamePosition, tok, executionContext);
        CharSequence tableName = GenericLexer.immutableOf(tok);
        this.engine.remove(executionContext.getCairoSecurityContext(), this.path, tableName);
        return this.compiledQuery.ofDrop();
    }

    @NotNull
    private CompiledQuery executeCopy(SqlExecutionContext executionContext, CopyModel executionModel) throws SqlException {
        this.setupTextLoaderFromModel(executionModel);
        if (Chars.equalsLowerCaseAscii(executionModel.getFileName().token, "stdin")) {
            return this.compiledQuery.ofCopyRemote(this.textLoader);
        }
        this.copyTable(executionContext, executionModel);
        return this.compiledQuery.ofCopyLocal();
    }

    private CompiledQuery executeWithRetries(ExecutableMethod method, ExecutionModel executionModel, int retries, SqlExecutionContext executionContext) throws SqlException {
        int attemptsLeft = retries;
        while (true) {
            try {
                return method.execute(executionModel, executionContext);
            }
            catch (ReaderOutOfDateException e) {
                this.clear();
                this.lexer.restart();
                executionModel = this.compileExecutionModel(executionContext);
                if (--attemptsLeft > 0) continue;
                throw SqlException.position(0).put("underlying cursor is extremely volatile");
            }
            break;
        }
    }

    RecordCursorFactory generate(QueryModel queryModel, SqlExecutionContext executionContext) throws SqlException {
        return this.codeGenerator.generate(queryModel, executionContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery insert(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        Function timestampFunction;
        int writerTimestampIndex;
        RecordMetadata metadata;
        long structureVersion;
        Throwable throwable;
        TableReader reader;
        ObjList<Function> valueFunctions;
        ExpressionNode name;
        block25: {
            int columnSetSize;
            CharSequenceHashSet columnSet;
            InsertModel model;
            block24: {
                model = (InsertModel)executionModel;
                name = model.getTableName();
                this.tableExistsOrFail(name.position, name.token, executionContext);
                valueFunctions = null;
                try {
                    reader = this.engine.getReader(executionContext.getCairoSecurityContext(), name.token, -1L);
                    throwable = null;
                    try {
                        ObjList<ExpressionNode> values;
                        int valueCount;
                        structureVersion = reader.getVersion();
                        metadata = reader.getMetadata();
                        writerTimestampIndex = metadata.getTimestampIndex();
                        columnSet = model.getColumnSet();
                        columnSetSize = columnSet.size();
                        timestampFunction = null;
                        this.listColumnFilter.clear();
                        if (columnSetSize > 0) {
                            this.listColumnFilter.clear();
                            valueFunctions = new ObjList<Function>(columnSetSize);
                            break block24;
                        }
                        int columnCount = metadata.getColumnCount();
                        if (columnCount != (valueCount = (values = model.getColumnValues()).size())) {
                            throw SqlException.$(model.getEndOfValuesPosition(), "not enough values [expected=").put(columnCount).put(", actual=").put(values.size()).put(']');
                        }
                        valueFunctions = new ObjList(columnCount);
                        for (int i = 0; i < columnCount; ++i) {
                            Function function = this.functionParser.parseFunction(values.getQuick(i), EmptyRecordMetadata.INSTANCE, executionContext);
                            if (!SqlCompiler.isAssignableFrom(metadata.getColumnType(i), function.getType())) {
                                throw SqlException.inconvertibleTypes(model.getQueryModel().getColumns().getQuick((int)i).getAst().position, function.getType(), model.getColumnValues().getQuick((int)i).token, metadata.getColumnType(i), metadata.getColumnName(i));
                            }
                            if (i == writerTimestampIndex) {
                                timestampFunction = function;
                                continue;
                            }
                            valueFunctions.add(function);
                            this.listColumnFilter.add(i);
                        }
                        break block25;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (SqlException e) {
                    Misc.freeObjList(valueFunctions);
                    throw e;
                }
            }
            for (int i = 0; i < columnSetSize; ++i) {
                int index = metadata.getColumnIndex(columnSet.get(i));
                if (index < 0) {
                    throw SqlException.invalidColumn(model.getColumnPosition(i), columnSet.get(i));
                }
                Function function = this.functionParser.parseFunction(model.getColumnValues().getQuick(i), GenericRecordMetadata.EMPTY, executionContext);
                if (!SqlCompiler.isAssignableFrom(metadata.getColumnType(index), function.getType())) {
                    throw SqlException.inconvertibleTypes(model.getQueryModel().getColumns().getQuick((int)i).getAst().position, function.getType(), model.getColumnValues().getQuick((int)i).token, metadata.getColumnType(index), metadata.getColumnName(index));
                }
                if (index == writerTimestampIndex) {
                    timestampFunction = function;
                    continue;
                }
                valueFunctions.add(function);
                this.listColumnFilter.add(index);
            }
        }
        if (writerTimestampIndex > -1 && timestampFunction == null) {
            throw SqlException.$(0, "insert statement must populate timestamp");
        }
        VirtualRecord record = new VirtualRecord(valueFunctions);
        RecordToRowCopier copier = SqlCompiler.assembleRecordToRowCopier(this.asm, record, metadata, this.listColumnFilter);
        return this.compiledQuery.ofInsert(new InsertStatementImpl(this.engine, Chars.toString(name.token), record, copier, timestampFunction, structureVersion));
        finally {
            if (reader != null) {
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    private CompiledQuery insertAsSelect(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        InsertModel model = (InsertModel)executionModel;
        ExpressionNode name = model.getTableName();
        this.tableExistsOrFail(name.position, name.token, executionContext);
        try (TableWriter writer = this.engine.getWriter(executionContext.getCairoSecurityContext(), name.token);
             RecordCursorFactory factory = this.generate(model.getQueryModel(), executionContext);){
            RecordToRowCopier copier;
            RecordMetadata cursorMetadata = factory.getMetadata();
            RecordMetadata writerMetadata = writer.getMetadata();
            int writerTimestampIndex = writerMetadata.getTimestampIndex();
            int cursorTimestampIndex = cursorMetadata.getTimestampIndex();
            if (writerTimestampIndex > -1 && cursorTimestampIndex == -1) {
                throw SqlException.$(name.position, "select clause must provide timestamp column");
            }
            boolean noTimestampColumn = true;
            CharSequenceHashSet columnSet = model.getColumnSet();
            int columnSetSize = columnSet.size();
            if (columnSetSize > 0) {
                this.listColumnFilter.clear();
                for (int i = 0; i < columnSetSize; ++i) {
                    CharSequence columnName = columnSet.get(i);
                    int index = writerMetadata.getColumnIndexQuiet(columnName);
                    if (index == -1) {
                        throw SqlException.invalidColumn(model.getColumnPosition(i), columnName);
                    }
                    if (index == writerTimestampIndex) {
                        noTimestampColumn = false;
                    }
                    int fromType = cursorMetadata.getColumnType(i);
                    int toType = writerMetadata.getColumnType(index);
                    if (!SqlCompiler.isAssignableFrom(toType, fromType)) {
                        throw SqlException.inconvertibleTypes(model.getColumnPosition(i), fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                    }
                    this.listColumnFilter.add(index);
                }
                if (writerTimestampIndex > -1 && noTimestampColumn) {
                    throw SqlException.$(model.getColumnPosition(0), "column list must include timestamp");
                }
                copier = SqlCompiler.assembleRecordToRowCopier(this.asm, cursorMetadata, writerMetadata, this.listColumnFilter);
            } else {
                int n = writerMetadata.getColumnCount();
                if (n > cursorMetadata.getColumnCount()) {
                    throw SqlException.$(model.getSelectKeywordPosition(), "not enough columns selected");
                }
                for (int i = 0; i < n; ++i) {
                    int fromType = cursorMetadata.getColumnType(i);
                    int toType = writerMetadata.getColumnType(i);
                    if (SqlCompiler.isAssignableFrom(toType, fromType)) continue;
                    assert (i < model.getQueryModel().getColumns().size());
                    throw SqlException.inconvertibleTypes(model.getQueryModel().getColumns().getQuick((int)i).getAst().position, fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                }
                this.entityColumnFilter.of(writerMetadata.getColumnCount());
                copier = SqlCompiler.assembleRecordToRowCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
            }
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                try {
                    if (writerTimestampIndex == -1) {
                        this.copyUnordered(cursor, writer, copier);
                    } else {
                        this.copyOrdered(writer, cursor, copier, cursorTimestampIndex);
                    }
                }
                catch (CairoException e) {
                    writer.rollback();
                    throw e;
                }
            }
        }
        return this.compiledQuery.ofInsertAsSelect();
    }

    private ExecutionModel lightlyValidateInsertModel(InsertModel model) throws SqlException {
        ExpressionNode tableName = model.getTableName();
        if (tableName.type != 4) {
            throw SqlException.$(tableName.position, "literal expected");
        }
        if (model.getColumnSet().size() > 0 && model.getColumnSet().size() != model.getColumnValues().size()) {
            throw SqlException.$(model.getColumnPosition(0), "value count does not match column count");
        }
        return model;
    }

    private boolean removeTableDirectory(CreateTableModel model) {
        if (this.engine.removeDirectory(this.path, model.getName().token)) {
            return true;
        }
        LOG.error().$("failed to clean up after create table failure [path=").$(this.path).$(", errno=").$(this.configuration.getFilesFacade().errno()).$(']').$();
        return false;
    }

    private CompiledQuery repairTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !Chars.equalsLowerCaseAscii(tok, "table")) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        do {
            if ((tok = SqlUtil.fetchNext(this.lexer)) == null || Chars.equals(tok, ',')) {
                throw SqlException.$(this.lexer.getPosition(), "table name expected");
            }
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
            try {
                this.engine.migrateNullFlag(executionContext.getCairoSecurityContext(), tok);
            }
            catch (CairoException e) {
                LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).$(']').$();
                throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' is busy");
            }
        } while ((tok = SqlUtil.fetchNext(this.lexer)) != null && Chars.equals(tok, ','));
        return this.compiledQuery.ofRepair();
    }

    void setFullSatJoins(boolean value) {
        this.codeGenerator.setFullFatJoins(value);
    }

    private void setupTextLoaderFromModel(CopyModel model) {
        this.textLoader.clear();
        this.textLoader.setState(1);
        this.textLoader.configureDestination(model.getTableName().token, false, false, 1);
    }

    private void tableExistsOrFail(int position, CharSequence tableName, SqlExecutionContext executionContext) throws SqlException {
        if (this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName) == 1) {
            throw SqlException.$(position, "table '").put(tableName).put("' does not exist");
        }
    }

    ExecutionModel testCompileModel(CharSequence query, SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        return this.compileExecutionModel(executionContext);
    }

    ExpressionNode testParseExpression(CharSequence expression, QueryModel model) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        return this.parser.expr(this.lexer, model);
    }

    void testParseExpression(CharSequence expression, ExpressionParserListener listener) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        this.parser.expr(this.lexer, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledQuery truncateTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.getPosition(), "'table' expected");
        }
        if (!Chars.equalsLowerCaseAscii(tok, "table")) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        this.tableWriters.clear();
        try {
            try {
                do {
                    if ((tok = SqlUtil.fetchNext(this.lexer)) == null || Chars.equals(tok, ',')) {
                        throw SqlException.$(this.lexer.getPosition(), "table name expected");
                    }
                    if (Chars.isQuoted(tok)) {
                        tok = GenericLexer.unquote(tok);
                    }
                    this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
                    try {
                        this.tableWriters.add(this.engine.getWriter(executionContext.getCairoSecurityContext(), tok));
                    }
                    catch (CairoException e) {
                        LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).$(']').$();
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' is busy");
                    }
                } while ((tok = SqlUtil.fetchNext(this.lexer)) != null && Chars.equals(tok, ','));
            }
            catch (SqlException e) {
                int n = this.tableWriters.size();
                for (int i = 0; i < n; ++i) {
                    this.tableWriters.getQuick(i).close();
                }
                throw e;
            }
            int n = this.tableWriters.size();
            for (int i = 0; i < n; ++i) {
                try (TableWriter writer = this.tableWriters.getQuick(i);){
                    try {
                        if (this.engine.lockReaders(writer.getName())) {
                            try {
                                writer.truncate();
                                continue;
                            }
                            finally {
                                this.engine.unlockReaders(writer.getName());
                            }
                        }
                        throw SqlException.$(0, "there is an active query against '").put(writer.getName()).put("'. Try again.");
                    }
                    catch (CairoError | CairoException e) {
                        LOG.error().$("could truncate [table=").$(writer.getName()).$(", e=").$((Sinkable)((Object)e)).$(']').$();
                        throw e;
                    }
                }
            }
        }
        finally {
            this.tableWriters.clear();
        }
        return this.compiledQuery.ofTruncate();
    }

    private InsertModel validateAndOptimiseInsertAsSelect(InsertModel model, SqlExecutionContext executionContext) throws SqlException {
        QueryModel queryModel = this.optimiser.optimise(model.getQueryModel(), executionContext);
        int targetColumnCount = model.getColumnSet().size();
        if (targetColumnCount > 0 && queryModel.getColumns().size() != targetColumnCount) {
            throw SqlException.$(model.getTableName().position, "column count mismatch");
        }
        model.setQueryModel(queryModel);
        return model;
    }

    private void validateTableModelAndCreateTypeCast(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) throws SqlException {
        CharSequenceObjHashMap<ColumnCastModel> castModels = model.getColumnCastModels();
        ObjList<CharSequence> castColumnNames = castModels.keys();
        int n = castColumnNames.size();
        for (int i = 0; i < n; ++i) {
            int to;
            CharSequence columnName = castColumnNames.getQuick(i);
            int index = metadata.getColumnIndexQuiet(columnName);
            if (index == -1) {
                throw SqlException.invalidColumn(castModels.get(columnName).getColumnNamePos(), columnName);
            }
            ColumnCastModel ccm = castModels.get(columnName);
            int from = metadata.getColumnType(index);
            if (!SqlCompiler.isCompatibleCase(from, to = ccm.getColumnType())) {
                throw SqlException.$(ccm.getColumnTypePos(), "unsupported cast [from=").put(ColumnType.nameOf(from)).put(",to=").put(ColumnType.nameOf(to)).put(']');
            }
            typeCast.put(index, to);
        }
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null && metadata.getColumnType(timestamp.token) != 7) {
            throw SqlException.position(timestamp.position).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(metadata.getColumnType(timestamp.token))).put(']');
        }
        if (model.getPartitionBy() != 3 && model.getTimestampIndex() == -1 && metadata.getTimestampIndex() == -1) {
            throw SqlException.position(0).put("timestamp is not defined");
        }
    }

    static {
        castGroups.extendAndSet(0, 2);
        castGroups.extendAndSet(1, 1);
        castGroups.extendAndSet(2, 1);
        castGroups.extendAndSet(3, 1);
        castGroups.extendAndSet(4, 1);
        castGroups.extendAndSet(5, 1);
        castGroups.extendAndSet(8, 1);
        castGroups.extendAndSet(9, 1);
        castGroups.extendAndSet(6, 1);
        castGroups.extendAndSet(7, 1);
        castGroups.extendAndSet(10, 3);
        castGroups.extendAndSet(11, 3);
        castGroups.extendAndSet(13, 4);
        sqlControlSymbols.add("(");
        sqlControlSymbols.add(";");
        sqlControlSymbols.add(")");
        sqlControlSymbols.add(",");
        sqlControlSymbols.add("/*");
        sqlControlSymbols.add("*/");
        sqlControlSymbols.add("--");
    }

    private static class TableStructureAdapter
    implements TableStructure {
        private CreateTableModel model;
        private RecordMetadata metadata;
        private IntIntHashMap typeCast;
        private int timestampIndex;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            int castIndex = this.typeCast.keyIndex(columnIndex);
            if (castIndex < 0) {
                return this.typeCast.valueAt(castIndex);
            }
            return this.metadata.getColumnType(columnIndex);
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return this.model.getIndexBlockCapacity(columnIndex);
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return this.model.isIndexed(columnIndex);
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return this.model.isSequential(columnIndex);
        }

        @Override
        public int getPartitionBy() {
            return this.model.getPartitionBy();
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCacheFlag();
            }
            return this.model.getSymbolCacheFlag(columnIndex);
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCapacity();
            }
            return this.model.getSymbolCapacity(columnIndex);
        }

        @Override
        public CharSequence getTableName() {
            return this.model.getTableName();
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }

        TableStructureAdapter of(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) {
            this.timestampIndex = model.getTimestampIndex() != -1 ? model.getTimestampIndex() : metadata.getTimestampIndex();
            this.model = model;
            this.metadata = metadata;
            this.typeCast = typeCast;
            return this;
        }
    }

    public static interface RecordToRowCopier {
        public void copy(Record var1, TableWriter.Row var2);
    }

    @FunctionalInterface
    private static interface ExecutableMethod {
        public CompiledQuery execute(ExecutionModel var1, SqlExecutionContext var2) throws SqlException;
    }

    @FunctionalInterface
    private static interface KeywordBasedExecutor {
        public CompiledQuery execute(SqlExecutionContext var1) throws SqlException;
    }
}

