/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class SqlException
extends Exception
implements Sinkable {
    private static final ThreadLocal<SqlException> tlException = new ThreadLocal<SqlException>(SqlException::new);
    private final StringSink message = new StringSink();
    private int position;

    public static SqlException $(int position, CharSequence message) {
        return SqlException.position(position).put(message);
    }

    public static SqlException ambiguousColumn(int position) {
        return SqlException.position(position).put("Ambiguous column name");
    }

    public static SqlException invalidColumn(int position, CharSequence column) {
        return SqlException.position(position).put("Invalid column: ").put(column);
    }

    public static SqlException last() {
        return (SqlException)tlException.get();
    }

    public static SqlException invalidDate(int position) {
        return SqlException.position(position).put("Invalid date");
    }

    public static SqlException position(int position) {
        SqlException ex = (SqlException)tlException.get();
        ex.message.clear();
        ex.position = position;
        return ex;
    }

    public static SqlException unexpectedToken(int position, CharSequence token) {
        return SqlException.position(position).put("unexpected token: ").put(token);
    }

    public static SqlException inconvertibleTypes(int position, int fromType, CharSequence fromName, int toType, CharSequence toName) {
        return SqlException.$(position, "inconvertible types: ").put(ColumnType.nameOf(fromType)).put(" -> ").put(ColumnType.nameOf(toType)).put(" [from=").put(fromName).put(", to=").put(toName).put(']');
    }

    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return "[" + this.position + "] " + this.message.toString();
    }

    public int getPosition() {
        return this.position;
    }

    public SqlException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public SqlException put(char c) {
        this.message.put(c);
        return this;
    }

    public SqlException put(int value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(long value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(Sinkable sinkable) {
        this.message.put(sinkable);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.position).put("]: ").put(this.message);
    }
}

