/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.bind.BindVariableService;
import io.questdb.std.IntStack;
import org.jetbrains.annotations.Nullable;

public class SqlExecutionContextImpl
implements SqlExecutionContext {
    private final IntStack timestampRequiredStack = new IntStack();
    private BindVariableService bindVariableService;
    private CairoSecurityContext cairoSecurityContext;
    @Nullable
    private MessageBus messageBus;

    @Override
    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    @Override
    public CairoSecurityContext getCairoSecurityContext() {
        return this.cairoSecurityContext;
    }

    @Override
    @Nullable
    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    @Override
    public boolean isTimestampRequired() {
        return this.timestampRequiredStack.notEmpty() && this.timestampRequiredStack.peek() == 1;
    }

    @Override
    public void popTimestampRequiredFlag() {
        this.timestampRequiredStack.pop();
    }

    @Override
    public void pushTimestampRequiredFlag(boolean flag) {
        this.timestampRequiredStack.push(flag ? 1 : 0);
    }

    public SqlExecutionContextImpl with(CairoSecurityContext cairoSecurityContext, BindVariableService bindVariableService, @Nullable MessageBus messageBus) {
        this.cairoSecurityContext = cairoSecurityContext;
        this.bindVariableService = bindVariableService;
        this.messageBus = messageBus;
        return this;
    }
}

