/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.IntPriorityQueue;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.FlyweightCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlOptimiser {
    private static final CharSequenceIntHashMap notOps = new CharSequenceIntHashMap();
    private static final int NOT_OP_NOT = 1;
    private static final int NOT_OP_AND = 2;
    private static final int NOT_OP_OR = 3;
    private static final int NOT_OP_GREATER = 4;
    private static final int NOT_OP_GREATER_EQ = 5;
    private static final int NOT_OP_LESS = 6;
    private static final int NOT_OP_LESS_EQ = 7;
    private static final int NOT_OP_EQUAL = 8;
    private static final int NOT_OP_NOT_EQ = 9;
    private static final IntHashSet joinBarriers;
    private static final CharSequenceHashSet nullConstants;
    private static final CharSequenceIntHashMap joinOps;
    private static final int JOIN_OP_EQUAL = 1;
    private static final int JOIN_OP_AND = 2;
    private static final int JOIN_OP_OR = 3;
    private static final int JOIN_OP_REGEX = 4;
    private static final IntHashSet flexColumnModelTypes;
    private final CairoEngine engine;
    private final FlyweightCharSequence tableLookupSequence = new FlyweightCharSequence();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final CharacterStore characterStore;
    private final ObjList<JoinContext> joinClausesSwap1 = new ObjList();
    private final ObjList<JoinContext> joinClausesSwap2 = new ObjList();
    private final IntList tempCrosses = new IntList();
    private final LiteralCollector literalCollector = new LiteralCollector();
    private final IntHashSet tablesSoFar = new IntHashSet();
    private final IntHashSet postFilterRemoved = new IntHashSet();
    private final IntList nullCounts = new IntList();
    private final ObjList<IntList> postFilterTableRefs = new ObjList();
    private final LiteralCheckingVisitor literalCheckingVisitor = new LiteralCheckingVisitor();
    private final LiteralRewritingVisitor literalRewritingVisitor = new LiteralRewritingVisitor();
    private final IntList literalCollectorAIndexes = new IntList();
    private final ObjList<CharSequence> literalCollectorANames = new ObjList();
    private final IntList literalCollectorBIndexes = new IntList();
    private final ObjList<CharSequence> literalCollectorBNames = new ObjList();
    private final PostOrderTreeTraversalAlgo traversalAlgo;
    private final ArrayDeque<ExpressionNode> sqlNodeStack = new ArrayDeque();
    private final ObjectPool<JoinContext> contextPool;
    private final IntHashSet deletedContexts = new IntHashSet();
    private final CharSequenceObjHashMap<CharSequence> constNameToToken = new CharSequenceObjHashMap();
    private final CharSequenceIntHashMap constNameToIndex = new CharSequenceIntHashMap();
    private final CharSequenceObjHashMap<ExpressionNode> constNameToNode = new CharSequenceObjHashMap();
    private final IntList tempCrossIndexes = new IntList();
    private final IntList clausesToSteal = new IntList();
    private final ObjectPool<IntList> intListPool = new ObjectPool<IntList>(IntList::new, 16);
    private final ObjectPool<QueryModel> queryModelPool;
    private final IntPriorityQueue orderingStack = new IntPriorityQueue();
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final FunctionParser functionParser;
    private final ColumnPrefixEraser columnPrefixEraser = new ColumnPrefixEraser();
    private final Path path;
    private final ObjList<ExpressionNode> orderByAdvice = new ObjList();
    private int defaultAliasCount = 0;
    private ObjList<JoinContext> emittedJoinClauses;

    SqlOptimiser(CairoConfiguration configuration, CairoEngine engine, CharacterStore characterStore, ObjectPool<ExpressionNode> expressionNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo traversalAlgo, FunctionParser functionParser, Path path) {
        this.engine = engine;
        this.expressionNodePool = expressionNodePool;
        this.characterStore = characterStore;
        this.traversalAlgo = traversalAlgo;
        this.queryModelPool = queryModelPool;
        this.queryColumnPool = queryColumnPool;
        this.functionParser = functionParser;
        this.contextPool = new ObjectPool<JoinContext>(JoinContext.FACTORY, configuration.getSqlJoinContextPoolCapacity());
        this.path = path;
    }

    private static void linkDependencies(QueryModel model, int parent, int child) {
        model.getJoinModels().getQuick(parent).addDependency(child);
    }

    private static void unlinkDependencies(QueryModel model, int parent, int child) {
        model.getJoinModels().getQuick(parent).removeDependency(child);
    }

    private static boolean isNotBindVariable(CharSequence token) {
        int len = token.length();
        if (len < 1) {
            return true;
        }
        char first = token.charAt(0);
        if (first == ':') {
            return false;
        }
        if (first == '?' && len == 1) {
            return false;
        }
        if (first == '$') {
            try {
                Numbers.parseInt(token, 1, len);
                return false;
            }
            catch (NumericException e) {
                return true;
            }
        }
        return true;
    }

    private static boolean modelIsFlex(QueryModel model) {
        return model != null && flexColumnModelTypes.contains(model.getSelectModelType());
    }

    private void addColumnToTranslatingModel(QueryColumn column, QueryModel translatingModel, QueryModel validatingModel) throws SqlException {
        if (validatingModel != null) {
            CharSequence refColumn = column.getAst().token;
            int dot = Chars.indexOf(refColumn, '.');
            this.getIndexOfTableForColumn(validatingModel, refColumn, dot, column.getAst().position);
            if (dot != -1 && validatingModel.getJoinModels().size() == 1) {
                ExpressionNode base = column.getAst();
                column.of(column.getAlias(), this.expressionNodePool.next().of(base.type, base.token.subSequence(dot + 1, base.token.length()), base.precedence, base.position));
            }
        }
        translatingModel.addBottomUpColumn(column);
    }

    private void addFilterOrEmitJoin(QueryModel parent, int idx, int ai, CharSequence an, ExpressionNode ao, int bi, CharSequence bn, ExpressionNode bo) {
        if (ai == bi && Chars.equals(an, bn)) {
            this.deletedContexts.add(idx);
            return;
        }
        if (ai == bi) {
            ExpressionNode node = this.expressionNodePool.next().of(1, "=", 0, 0);
            node.paramCount = 2;
            node.lhs = ao;
            node.rhs = bo;
            this.addWhereNode(parent, ai, node);
        } else {
            JoinContext jc = this.contextPool.next();
            jc.aIndexes.add(ai);
            jc.aNames.add(an);
            jc.aNodes.add(ao);
            jc.bIndexes.add(bi);
            jc.bNames.add(bn);
            jc.bNodes.add(bo);
            jc.slaveIndex = Math.max(ai, bi);
            jc.parents.add(Math.min(ai, bi));
            this.emittedJoinClauses.add(jc);
        }
        this.deletedContexts.add(idx);
    }

    private void addFunction(QueryColumn qc, QueryModel baseModel, QueryModel translatingModel, QueryModel innerModel, QueryModel analyticModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        innerModel.addBottomUpColumn(qc);
        QueryColumn innerColumn = this.nextColumn(qc.getAlias());
        this.emitLiterals(qc.getAst(), translatingModel, null, baseModel);
        groupByModel.addBottomUpColumn(innerColumn);
        analyticModel.addBottomUpColumn(innerColumn);
        outerModel.addBottomUpColumn(innerColumn);
        distinctModel.addBottomUpColumn(innerColumn);
    }

    private void addJoinContext(QueryModel parent, JoinContext context) {
        QueryModel jm = parent.getJoinModels().getQuick(context.slaveIndex);
        JoinContext other = jm.getContext();
        if (other == null) {
            jm.setContext(context);
        } else {
            jm.setContext(this.mergeContexts(parent, other, context));
        }
    }

    private void addTopDownColumn(ExpressionNode node, QueryModel model) {
        if (node != null && node.type == 4) {
            ObjList<QueryModel> joinModels = model.getJoinModels();
            int joinCount = joinModels.size();
            CharSequence columnName = node.token;
            int dotIndex = Chars.indexOf(columnName, '.');
            if (dotIndex == -1) {
                for (int i = 0; i < joinCount; ++i) {
                    QueryModel m = joinModels.getQuick(i);
                    QueryColumn column = m.getAliasToColumnMap().get(columnName);
                    if (column == null) continue;
                    m.addTopDownColumn(column, columnName);
                    break;
                }
            } else {
                int modelIndex = model.getAliasIndex(node.token, 0, dotIndex);
                if (modelIndex < 0) {
                    return;
                }
                this.addTopDownColumn0(node, joinModels.getQuick(modelIndex), node.token.subSequence(dotIndex + 1, node.token.length()));
            }
        }
    }

    private void addTopDownColumn0(ExpressionNode node, QueryModel model, CharSequence name) {
        if (model.isTopDownNameMissing(name)) {
            model.addTopDownColumn(this.queryColumnPool.next().of(name, this.expressionNodePool.next().of(node.type, name, node.precedence, node.position)), name);
        }
    }

    private void addTransitiveFilters(QueryModel model) {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            JoinContext jc = joinModels.getQuick(i).getContext();
            if (jc == null) continue;
            int kn = jc.bNames.size();
            for (int k = 0; k < kn; ++k) {
                CharSequence name = jc.bNames.getQuick(k);
                if (this.constNameToIndex.get(name) != jc.bIndexes.getQuick(k)) continue;
                ExpressionNode node = this.expressionNodePool.next().of(1, this.constNameToToken.get(name), 0, 0);
                node.lhs = jc.aNodes.getQuick(k);
                node.rhs = this.constNameToNode.get(name);
                node.paramCount = 2;
                this.addWhereNode(model, jc.slaveIndex, node);
            }
        }
    }

    private void addWhereNode(QueryModel model, int joinModelIndex, ExpressionNode node) {
        this.addWhereNode(model.getJoinModels().getQuick(joinModelIndex), node);
    }

    private void addWhereNode(QueryModel model, ExpressionNode node) {
        model.setWhereClause(this.concatFilters(model.getWhereClause(), node));
    }

    private void alignJoinClauses(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            JoinContext jc = joinModels.getQuick(i).getContext();
            if (jc == null) continue;
            int index = jc.slaveIndex;
            int kc = jc.aIndexes.size();
            for (int k = 0; k < kc; ++k) {
                if (jc.aIndexes.getQuick(k) == index) continue;
                int idx = jc.aIndexes.getQuick(k);
                CharSequence name = jc.aNames.getQuick(k);
                ExpressionNode node = jc.aNodes.getQuick(k);
                jc.aIndexes.setQuick(k, jc.bIndexes.getQuick(k));
                jc.aNames.setQuick(k, jc.bNames.getQuick(k));
                jc.aNodes.setQuick(k, jc.bNodes.getQuick(k));
                jc.bIndexes.setQuick(k, idx);
                jc.bNames.setQuick(k, name);
                jc.bNodes.setQuick(k, node);
            }
        }
    }

    private void analyseEquals(QueryModel parent, ExpressionNode node) throws SqlException {
        this.traverseNamesAndIndices(parent, node);
        int aSize = this.literalCollectorAIndexes.size();
        int bSize = this.literalCollectorBIndexes.size();
        switch (aSize) {
            case 0: {
                if (bSize == 1 && this.literalCollector.nullCount == 0 && joinBarriers.excludes(parent.getJoinModels().get(this.literalCollectorBIndexes.getQuick(0)).getJoinType())) {
                    JoinContext jc = this.contextPool.next();
                    jc.slaveIndex = this.literalCollectorBIndexes.getQuick(0);
                    this.addWhereNode(parent, jc.slaveIndex, node);
                    this.addJoinContext(parent, jc);
                    CharSequence cs = this.literalCollectorBNames.getQuick(0);
                    this.constNameToIndex.put(cs, jc.slaveIndex);
                    this.constNameToNode.put(cs, node.lhs);
                    this.constNameToToken.put(cs, node.token);
                    break;
                }
                parent.addParsedWhereNode(node);
                break;
            }
            case 1: {
                JoinContext jc = this.contextPool.next();
                int lhi = this.literalCollectorAIndexes.getQuick(0);
                if (bSize == 1) {
                    int rhi = this.literalCollectorBIndexes.getQuick(0);
                    if (lhi == rhi) {
                        jc.slaveIndex = lhi;
                        this.addWhereNode(parent, lhi, node);
                    } else {
                        jc.aNodes.add(node.lhs);
                        jc.bNodes.add(node.rhs);
                        jc.aNames.add(this.literalCollectorANames.getQuick(0));
                        jc.bNames.add(this.literalCollectorBNames.getQuick(0));
                        jc.aIndexes.add(lhi);
                        jc.bIndexes.add(rhi);
                        int max = Math.max(lhi, rhi);
                        int min = Math.min(lhi, rhi);
                        jc.slaveIndex = max;
                        jc.parents.add(min);
                        SqlOptimiser.linkDependencies(parent, min, max);
                    }
                    this.addJoinContext(parent, jc);
                    break;
                }
                if (bSize == 0 && this.literalCollector.nullCount == 0 && joinBarriers.excludes(parent.getJoinModels().get(this.literalCollectorAIndexes.getQuick(0)).getJoinType())) {
                    jc.slaveIndex = lhi;
                    this.addWhereNode(parent, lhi, node);
                    this.addJoinContext(parent, jc);
                    CharSequence cs = this.literalCollectorANames.getQuick(0);
                    this.constNameToIndex.put(cs, lhi);
                    this.constNameToNode.put(cs, node.rhs);
                    this.constNameToToken.put(cs, node.token);
                    break;
                }
                parent.addParsedWhereNode(node);
                break;
            }
            default: {
                parent.addParsedWhereNode(node);
            }
        }
    }

    private void analyseRegex(QueryModel parent, ExpressionNode node) throws SqlException {
        this.traverseNamesAndIndices(parent, node);
        if (this.literalCollector.nullCount == 0) {
            int aSize = this.literalCollectorAIndexes.size();
            int bSize = this.literalCollectorBIndexes.size();
            if (aSize == 1 && bSize == 0) {
                CharSequence name = this.literalCollectorANames.getQuick(0);
                this.constNameToIndex.put(name, this.literalCollectorAIndexes.getQuick(0));
                this.constNameToNode.put(name, node.rhs);
                this.constNameToToken.put(name, node.token);
            }
        }
    }

    private void assignFilters(QueryModel parent) throws SqlException {
        this.tablesSoFar.clear();
        this.postFilterRemoved.clear();
        this.postFilterTableRefs.clear();
        this.nullCounts.clear();
        this.literalCollector.withModel(parent);
        ObjList<ExpressionNode> filterNodes = parent.getParsedWhere();
        int pc = filterNodes.size();
        for (int i = 0; i < pc; ++i) {
            IntList indexes = this.intListPool.next();
            this.literalCollector.resetNullCount();
            this.traversalAlgo.traverse(filterNodes.getQuick(i), this.literalCollector.to(indexes));
            this.postFilterTableRefs.add(indexes);
            this.nullCounts.add(this.literalCollector.nullCount);
        }
        IntList ordered = parent.getOrderedJoinModels();
        int n = ordered.size();
        for (int i = 0; i < n; ++i) {
            int index = ordered.getQuick(i);
            this.tablesSoFar.add(index);
            for (int k = 0; k < pc; ++k) {
                if (this.postFilterRemoved.contains(k)) continue;
                IntList refs = this.postFilterTableRefs.getQuick(k);
                int rs = refs.size();
                if (rs == 0) {
                    this.postFilterRemoved.add(k);
                    parent.setConstWhereClause(this.concatFilters(parent.getConstWhereClause(), filterNodes.getQuick(k)));
                    continue;
                }
                if (rs == 1 && this.nullCounts.getQuick(k) == 0 && joinBarriers.excludes(parent.getJoinModels().getQuick(refs.getQuick(0)).getJoinType())) {
                    this.addWhereNode(parent, refs.getQuick(0), filterNodes.getQuick(k));
                    this.postFilterRemoved.add(k);
                    continue;
                }
                boolean qualifies = true;
                for (int y = 0; y < rs; ++y) {
                    if (!this.tablesSoFar.excludes(refs.getQuick(y))) continue;
                    qualifies = false;
                    break;
                }
                if (!qualifies) continue;
                this.postFilterRemoved.add(k);
                QueryModel m = parent.getJoinModels().getQuick(index);
                m.setPostJoinWhereClause(this.concatFilters(m.getPostJoinWhereClause(), filterNodes.getQuick(k)));
            }
        }
        assert (this.postFilterRemoved.size() == pc);
    }

    void clear() {
        this.contextPool.clear();
        this.intListPool.clear();
        this.joinClausesSwap1.clear();
        this.joinClausesSwap2.clear();
        this.constNameToIndex.clear();
        this.constNameToNode.clear();
        this.constNameToToken.clear();
        this.literalCollectorAIndexes.clear();
        this.literalCollectorBIndexes.clear();
        this.literalCollectorANames.clear();
        this.literalCollectorBNames.clear();
        this.defaultAliasCount = 0;
        this.expressionNodePool.clear();
        this.characterStore.clear();
        this.tablesSoFar.clear();
        this.clausesToSteal.clear();
    }

    private void collectAlias(QueryModel parent, int modelIndex, QueryModel model) throws SqlException {
        ExpressionNode alias;
        ExpressionNode expressionNode = alias = model.getAlias() != null ? model.getAlias() : model.getTableName();
        if (parent.addAliasIndex(alias, modelIndex)) {
            return;
        }
        throw SqlException.position(alias.position).put("duplicate table or alias: ").put(alias.token);
    }

    private ExpressionNode concatFilters(ExpressionNode old, ExpressionNode filter) {
        if (old == null) {
            return filter;
        }
        ExpressionNode n = this.expressionNodePool.next().of(1, "and", 0, 0);
        n.paramCount = 2;
        n.lhs = old;
        n.rhs = filter;
        return n;
    }

    private void copyColumnsFromMetadata(QueryModel model, RecordMetadata m) throws SqlException {
        int k = m.getColumnCount();
        for (int i = 0; i < k; ++i) {
            CharSequence columnName = this.createColumnAlias(m.getColumnName(i), model);
            model.addField(this.queryColumnPool.next().of(columnName, this.expressionNodePool.next().of(4, columnName, 0, 0)));
        }
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp == null) {
            if (m.getTimestampIndex() != -1) {
                model.setTimestamp(this.expressionNodePool.next().of(4, m.getColumnName(m.getTimestampIndex()), 0, 0));
            }
        } else {
            int index = m.getColumnIndexQuiet(timestamp.token);
            if (index == -1) {
                throw SqlException.invalidColumn(timestamp.position, timestamp.token);
            }
            if (m.getColumnType(index) != 7) {
                throw SqlException.$(timestamp.position, "not a TIMESTAMP");
            }
        }
    }

    private CharSequence createColumnAlias(CharSequence name, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, name, -1, model.getAliasToColumnMap());
    }

    private CharSequence createColumnAlias(ExpressionNode node, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, node.token, Chars.indexOf(node.token, '.'), model.getAliasToColumnMap());
    }

    private void createImpliedDependencies(QueryModel parent) {
        ObjList<QueryModel> models = parent.getJoinModels();
        int n = models.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = models.getQuick(i);
            if (m.getJoinType() != 4 && m.getJoinType() != 5) continue;
            SqlOptimiser.linkDependencies(parent, 0, i);
            if (m.getContext() != null) continue;
            JoinContext jc = this.contextPool.next();
            m.setContext(jc);
            jc.parents.add(0);
            jc.slaveIndex = i;
        }
    }

    private void createOrderHash(QueryModel model) {
        int i;
        CharSequenceIntHashMap hash = model.getOrderHash();
        hash.clear();
        ObjList<ExpressionNode> orderBy = model.getOrderBy();
        int n = orderBy.size();
        ObjList<QueryColumn> columns = model.getColumns();
        int m = columns.size();
        QueryModel nestedModel = model.getNestedModel();
        if (n > 0) {
            IntList orderByDirection = model.getOrderByDirection();
            for (i = 0; i < n; ++i) {
                hash.put(orderBy.getQuick((int)i).token, orderByDirection.getQuick(i));
            }
        }
        if (nestedModel != null) {
            CharSequenceIntHashMap thatHash;
            this.createOrderHash(nestedModel);
            if (m > 0 && (thatHash = nestedModel.getOrderHash()).size() > 0) {
                for (i = 0; i < m; ++i) {
                    int direction;
                    QueryColumn column = columns.getQuick(i);
                    ExpressionNode node = column.getAst();
                    if (node.type != 4 || (direction = thatHash.get(node.token)) == -1) continue;
                    hash.put(column.getName(), direction);
                }
            }
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int z = joinModels.size();
        for (i = 1; i < z; ++i) {
            this.createOrderHash(joinModels.getQuick(i));
        }
        QueryModel union = model.getUnionModel();
        if (union != null) {
            this.createOrderHash(union);
        }
    }

    private void createSelectColumn(CharSequence columnName, ExpressionNode columnAst, QueryModel validatingModel, QueryModel translatingModel, QueryModel innerModel, QueryModel analyticModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        CharSequenceObjHashMap<CharSequence> translatingAliasMap = translatingModel.getColumnNameToAliasMap();
        int index = translatingAliasMap.keyIndex(columnAst.token);
        if (index < 0) {
            CharSequence translatedColumnName = translatingAliasMap.valueAtQuick(index);
            CharSequence alias = this.createColumnAlias(columnName, groupByModel);
            QueryColumn translatedColumn = this.nextColumn(alias, translatedColumnName);
            innerModel.addBottomUpColumn(translatedColumn);
            groupByModel.addBottomUpColumn(translatedColumn);
            analyticModel.addBottomUpColumn(translatedColumn);
            outerModel.addBottomUpColumn(translatedColumn);
            distinctModel.addBottomUpColumn(translatedColumn);
        } else {
            CharSequence alias = this.createColumnAlias(columnName, translatingModel);
            this.addColumnToTranslatingModel(this.queryColumnPool.next().of(alias, columnAst), translatingModel, validatingModel);
            QueryColumn translatedColumn = this.nextColumn(alias);
            innerModel.addBottomUpColumn(translatedColumn);
            analyticModel.addBottomUpColumn(translatedColumn);
            groupByModel.addBottomUpColumn(translatedColumn);
            outerModel.addBottomUpColumn(translatedColumn);
            distinctModel.addBottomUpColumn(translatedColumn);
        }
    }

    private void createSelectColumnsForWildcard(QueryColumn qc, boolean hasJoins, QueryModel baseModel, QueryModel translatingModel, QueryModel innerModel, QueryModel analyticModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        int dot = Chars.indexOf(qc.getAst().token, '.');
        if (dot > -1) {
            int index = baseModel.getAliasIndex(qc.getAst().token, 0, dot);
            if (index == -1) {
                throw SqlException.$(qc.getAst().position, "invalid table alias");
            }
            this.createSelectColumnsForWildcard0(baseModel.getJoinModels().getQuick(index), hasJoins, qc.getAst().position, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
        } else {
            ObjList<QueryModel> models = baseModel.getJoinModels();
            int z = models.size();
            for (int j = 0; j < z; ++j) {
                this.createSelectColumnsForWildcard0(models.getQuick(j), hasJoins, qc.getAst().position, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
            }
        }
    }

    private void createSelectColumnsForWildcard0(QueryModel srcModel, boolean hasJoins, int wildcardPosition, QueryModel translatingModel, QueryModel innerModel, QueryModel analyticModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        ObjList<CharSequence> columnNames = srcModel.getBottomUpColumnNames();
        int z = columnNames.size();
        for (int j = 0; j < z; ++j) {
            CharSequence token;
            CharSequence name = columnNames.getQuick(j);
            if (hasJoins) {
                CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
                characterStoreEntry.put(srcModel.getName());
                characterStoreEntry.put('.');
                characterStoreEntry.put(name);
                token = characterStoreEntry.toImmutable();
            } else {
                token = name;
            }
            this.createSelectColumn(name, this.nextLiteral(token, wildcardPosition), null, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
        }
    }

    private int doReorderTables(QueryModel parent, IntList ordered) {
        int i;
        this.tempCrossIndexes.clear();
        ordered.clear();
        this.orderingStack.clear();
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int cost = 0;
        int n = joinModels.size();
        for (i = 0; i < n; ++i) {
            QueryModel q = joinModels.getQuick(i);
            if (q.getJoinType() == 3 || q.getContext() == null || q.getContext().parents.size() == 0) {
                if (q.getDependencies().size() > 0) {
                    this.orderingStack.push(i);
                    continue;
                }
                this.tempCrossIndexes.add(i);
                continue;
            }
            q.getContext().inCount = q.getContext().parents.size();
        }
        while (this.orderingStack.notEmpty()) {
            int index = this.orderingStack.pop();
            ordered.add(index);
            QueryModel m = joinModels.getQuick(index);
            cost = m.getJoinType() == 3 ? (cost += 10) : (cost += 5);
            IntHashSet dependencies = m.getDependencies();
            int k = dependencies.size();
            for (int i2 = 0; i2 < k; ++i2) {
                int depIndex = dependencies.get(i2);
                JoinContext jc = joinModels.getQuick(depIndex).getContext();
                if (--jc.inCount != 0) continue;
                this.orderingStack.push(depIndex);
            }
        }
        n = joinModels.size();
        for (i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            if (m.getContext() == null || m.getContext().inCount <= 0) continue;
            return Integer.MAX_VALUE;
        }
        n = this.tempCrossIndexes.size();
        for (i = 0; i < n; ++i) {
            ordered.add(this.tempCrossIndexes.getQuick(i));
        }
        return cost;
    }

    private ExpressionNode doReplaceLiteral(ExpressionNode node, QueryModel translatingModel, QueryModel innerModel, QueryModel validatingModel) throws SqlException {
        CharSequenceObjHashMap<CharSequence> map = translatingModel.getColumnNameToAliasMap();
        int index = map.keyIndex(node.token);
        if (index > -1) {
            int joinCount = validatingModel.getJoinModels().size();
            if (joinCount > 1) {
                boolean found = false;
                StringSink sink = Misc.getThreadLocalBuilder();
                sink.clear();
                for (int i = 0; i < joinCount; ++i) {
                    QueryModel jm = validatingModel.getJoinModels().getQuick(i);
                    if (jm.getAliasToColumnMap().keyIndex(node.token) >= 0) continue;
                    if (found) {
                        throw SqlException.ambiguousColumn(node.position);
                    }
                    if (jm.getAlias() != null) {
                        sink.put(jm.getAlias().token);
                    } else {
                        sink.put(jm.getTableName().token);
                    }
                    sink.put('.');
                    sink.put(node.token);
                    index = map.keyIndex(sink);
                    if (index >= 0) continue;
                    found = true;
                }
                if (found) {
                    return this.nextLiteral(map.valueAtQuick(index), node.position);
                }
            }
            CharSequence alias = this.createColumnAlias(node, translatingModel);
            QueryColumn column = this.queryColumnPool.next().of(alias, node);
            this.addColumnToTranslatingModel(column, translatingModel, validatingModel);
            if (innerModel != null) {
                innerModel.addBottomUpColumn(column);
            }
            return this.nextLiteral(alias, node.position);
        }
        return this.nextLiteral(map.valueAtQuick(index), node.position);
    }

    private void doRewriteOrderByPositionForUnionModels(QueryModel model, QueryModel parent, QueryModel next) throws SqlException {
        int columnCount = model.getColumns().size();
        while (next != null) {
            if (next.getColumns().size() != columnCount) {
                throw SqlException.$(next.getModelPosition(), "queries have different number of columns");
            }
            parent.setUnionModel(this.rewriteOrderByPosition(next));
            parent = next;
            next = next.getUnionModel();
        }
    }

    private void emitAggregates(ExpressionNode node, QueryModel model) {
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                ExpressionNode n;
                if (node.rhs != null) {
                    n = this.replaceIfAggregate(node.rhs, model);
                    if (node.rhs == n) {
                        this.sqlNodeStack.push(node.rhs);
                    } else {
                        node.rhs = n;
                    }
                }
                if ((n = this.replaceIfAggregate(node.lhs, model)) == node.lhs) {
                    node = node.lhs;
                    continue;
                }
                node.lhs = n;
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void emitLiterals(ExpressionNode node, QueryModel translatingModel, QueryModel innerModel, QueryModel validatingModel) throws SqlException {
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                ExpressionNode n;
                if (node.paramCount < 3) {
                    ExpressionNode n2;
                    if (node.rhs != null) {
                        n2 = this.replaceLiteral(node.rhs, translatingModel, innerModel, validatingModel);
                        if (node.rhs == n2) {
                            this.sqlNodeStack.push(node.rhs);
                        } else {
                            node.rhs = n2;
                        }
                    }
                    if ((n2 = this.replaceLiteral(node.lhs, translatingModel, innerModel, validatingModel)) == node.lhs) {
                        node = node.lhs;
                        continue;
                    }
                    node.lhs = n2;
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode n3;
                    ExpressionNode e = node.args.getQuick(i);
                    if (e == (n3 = this.replaceLiteral(e, translatingModel, innerModel, validatingModel))) {
                        this.sqlNodeStack.push(e);
                        continue;
                    }
                    node.args.setQuick(i, n3);
                }
                ExpressionNode e = node.args.getQuick(0);
                if (e == (n = this.replaceLiteral(e, translatingModel, innerModel, validatingModel))) {
                    node = e;
                    continue;
                }
                node.args.setQuick(0, n);
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void emitLiteralsTopDown(ExpressionNode node, QueryModel model) {
        this.sqlNodeStack.clear();
        this.addTopDownColumn(node, model);
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (node.paramCount < 3) {
                    if (node.rhs != null) {
                        this.addTopDownColumn(node.rhs, model);
                        this.sqlNodeStack.push(node.rhs);
                    }
                    if (node.lhs != null) {
                        this.addTopDownColumn(node.lhs, model);
                    }
                    node = node.lhs;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = node.args.getQuick(i);
                    this.addTopDownColumn(e, model);
                    this.sqlNodeStack.push(e);
                }
                ExpressionNode e = node.args.getQuick(0);
                this.addTopDownColumn(e, model);
                node = e;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void enumerateTableColumns(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ObjList<QueryModel> jm = model.getJoinModels();
        ExpressionNode tableName = model.getTableName();
        if (tableName != null) {
            if (tableName.type == 8) {
                this.parseFunctionAndEnumerateColumns(model, executionContext);
            } else {
                this.openReaderAndEnumerateColumns(executionContext, model);
            }
        } else if (model.getNestedModel() != null) {
            this.enumerateTableColumns(model.getNestedModel(), executionContext);
            model.copyColumnsFrom(model.getNestedModel());
        }
        int n = jm.size();
        for (int i = 1; i < n; ++i) {
            this.enumerateTableColumns(jm.getQuick(i), executionContext);
        }
        if (model.getUnionModel() != null) {
            this.enumerateTableColumns(model.getUnionModel(), executionContext);
        }
    }

    private void eraseColumnPrefixInWhereClauses(QueryModel model) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            QueryModel nested;
            QueryModel m = joinModels.getQuick(i);
            ExpressionNode where = m.getWhereClause();
            if (where != null) {
                if (where.type == 4) {
                    m.setWhereClause(this.columnPrefixEraser.rewrite(where));
                } else {
                    this.traversalAlgo.traverse(where, this.columnPrefixEraser);
                }
            }
            if ((nested = m.getNestedModel()) != null) {
                this.eraseColumnPrefixInWhereClauses(nested);
            }
            if ((nested = m.getUnionModel()) == null) continue;
            this.eraseColumnPrefixInWhereClauses(nested);
        }
    }

    private int getIndexOfTableForColumn(QueryModel model, CharSequence column, int dot, int position) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int index = -1;
        if (dot == -1) {
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                if (joinModels.getQuick(i).getAliasToColumnMap().excludes(column)) continue;
                if (index != -1) {
                    throw SqlException.ambiguousColumn(position);
                }
                index = i;
            }
            if (index == -1) {
                throw SqlException.invalidColumn(position, column);
            }
        } else {
            index = model.getAliasIndex(column, 0, dot);
            if (index == -1) {
                throw SqlException.$(position, "Invalid table name or alias");
            }
            if (joinModels.getQuick(index).getAliasToColumnMap().excludes(column, dot + 1, column.length())) {
                throw SqlException.invalidColumn(position, column);
            }
        }
        return index;
    }

    private ObjList<ExpressionNode> getOrderByAdvice(QueryModel model) {
        this.orderByAdvice.clear();
        ObjList<ExpressionNode> orderBy = model.getOrderBy();
        int len = orderBy.size();
        if (len == 0) {
            return this.orderByAdvice;
        }
        CharSequenceObjHashMap<CharSequence> map = model.getAliasToColumnNameMap();
        for (int i = 0; i < len; ++i) {
            this.orderByAdvice.add(this.nextLiteral(map.get(orderBy.getQuick((int)i).token)));
        }
        return this.orderByAdvice;
    }

    private boolean hasAggregates(ExpressionNode node) {
        this.sqlNodeStack.clear();
        block4: while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                switch (node.type) {
                    case 4: {
                        node = null;
                        continue block4;
                    }
                    case 8: {
                        if (!this.functionParser.isGroupBy(node.token)) break;
                        return true;
                    }
                    default: {
                        if (node.rhs == null) break;
                        this.sqlNodeStack.push(node.rhs);
                    }
                }
                node = node.lhs;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
        return false;
    }

    private void homogenizeCrossJoins(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            JoinContext c = m.getContext();
            if (m.getJoinType() == 3) {
                if (c == null || c.parents.size() <= 0) continue;
                m.setJoinType(1);
                continue;
            }
            if (m.getJoinType() == 4 || m.getJoinType() == 5 || c != null && c.parents.size() != 0) continue;
            m.setJoinType(3);
        }
    }

    private ExpressionNode makeJoinAlias(int index) {
        CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
        characterStoreEntry.put("_xQdbA").put(index);
        return this.nextLiteral(characterStoreEntry.toImmutable());
    }

    private ExpressionNode makeModelAlias(CharSequence modelAlias, ExpressionNode node) {
        CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
        characterStoreEntry.put(modelAlias).put('.').put(node.token);
        return this.nextLiteral(characterStoreEntry.toImmutable(), node.position);
    }

    private ExpressionNode makeOperation(CharSequence token, ExpressionNode lhs, ExpressionNode rhs) {
        ExpressionNode expr = this.expressionNodePool.next().of(1, token, 0, 0);
        expr.paramCount = 2;
        expr.lhs = lhs;
        expr.rhs = rhs;
        return expr;
    }

    private JoinContext mergeContexts(QueryModel parent, JoinContext a, JoinContext b) {
        int i;
        assert (a.slaveIndex == b.slaveIndex);
        this.deletedContexts.clear();
        JoinContext r = this.contextPool.next();
        int n = b.aNames.size();
        for (i = 0; i < n; ++i) {
            CharSequence ban = b.aNames.getQuick(i);
            int bai = b.aIndexes.getQuick(i);
            ExpressionNode bao = b.aNodes.getQuick(i);
            CharSequence bbn = b.bNames.getQuick(i);
            int bbi = b.bIndexes.getQuick(i);
            ExpressionNode bbo = b.bNodes.getQuick(i);
            int z = a.aNames.size();
            for (int k = 0; k < z; ++k) {
                CharSequence aan = a.aNames.getQuick(k);
                int aai = a.aIndexes.getQuick(k);
                ExpressionNode aao = a.aNodes.getQuick(k);
                CharSequence abn = a.bNames.getQuick(k);
                int abi = a.bIndexes.getQuick(k);
                ExpressionNode abo = a.bNodes.getQuick(k);
                if (aai == bai && Chars.equals(aan, ban)) {
                    this.addFilterOrEmitJoin(parent, k, abi, abn, abo, bbi, bbn, bbo);
                    break;
                }
                if (abi == bai && Chars.equals(abn, ban)) {
                    this.addFilterOrEmitJoin(parent, k, aai, aan, aao, bbi, bbn, bbo);
                    break;
                }
                if (aai == bbi && Chars.equals(aan, bbn)) {
                    this.addFilterOrEmitJoin(parent, k, abi, abn, abo, bai, ban, bao);
                    break;
                }
                if (abi != bbi || !Chars.equals(abn, bbn)) continue;
                this.addFilterOrEmitJoin(parent, k, aai, aan, aao, bai, ban, bao);
                break;
            }
            r.aIndexes.add(bai);
            r.aNames.add(ban);
            r.aNodes.add(bao);
            r.bIndexes.add(bbi);
            r.bNames.add(bbn);
            r.bNodes.add(bbo);
            int max = Math.max(bai, bbi);
            int min = Math.min(bai, bbi);
            r.slaveIndex = max;
            r.parents.add(min);
            SqlOptimiser.linkDependencies(parent, min, max);
        }
        n = a.aNames.size();
        for (i = 0; i < n; ++i) {
            int max;
            int min;
            int abi;
            int aai = a.aIndexes.getQuick(i);
            if (aai < (abi = a.bIndexes.getQuick(i))) {
                min = aai;
                max = abi;
            } else {
                min = abi;
                max = aai;
            }
            if (this.deletedContexts.contains(i)) {
                if (!r.parents.excludes(min)) continue;
                SqlOptimiser.unlinkDependencies(parent, min, max);
                continue;
            }
            r.aNames.add(a.aNames.getQuick(i));
            r.bNames.add(a.bNames.getQuick(i));
            r.aIndexes.add(aai);
            r.bIndexes.add(abi);
            r.aNodes.add(a.aNodes.getQuick(i));
            r.bNodes.add(a.bNodes.getQuick(i));
            r.parents.add(min);
            SqlOptimiser.linkDependencies(parent, min, max);
        }
        return r;
    }

    private JoinContext moveClauses(QueryModel parent, JoinContext from, JoinContext to, IntList positions) {
        int p = 0;
        int m = positions.size();
        JoinContext result = this.contextPool.next();
        result.slaveIndex = from.slaveIndex;
        int n = from.aIndexes.size();
        for (int i = 0; i < n; ++i) {
            JoinContext t = p < m && i == positions.getQuick(p) ? to : result;
            int ai = from.aIndexes.getQuick(i);
            int bi = from.bIndexes.getQuick(i);
            t.aIndexes.add(ai);
            t.aNames.add(from.aNames.getQuick(i));
            t.aNodes.add(from.aNodes.getQuick(i));
            t.bIndexes.add(bi);
            t.bNames.add(from.bNames.getQuick(i));
            t.bNodes.add(from.bNodes.getQuick(i));
            if (ai != t.slaveIndex) {
                t.parents.add(ai);
                SqlOptimiser.linkDependencies(parent, ai, bi);
                continue;
            }
            t.parents.add(bi);
            SqlOptimiser.linkDependencies(parent, bi, ai);
        }
        return result;
    }

    private void moveTimestampToChooseModel(QueryModel model) {
        QueryModel nested = model.getNestedModel();
        if (nested != null) {
            this.moveTimestampToChooseModel(nested);
            ExpressionNode timestamp = nested.getTimestamp();
            if (timestamp != null && nested.getSelectModelType() == 0 && nested.getTableName() == null && nested.getTableNameFunction() == null) {
                model.setTimestamp(timestamp);
                nested.setTimestamp(null);
            }
        }
        if ((nested = model.getUnionModel()) != null) {
            this.moveTimestampToChooseModel(nested);
        }
    }

    private void moveWhereInsideSubQueries(QueryModel model) throws SqlException {
        QueryModel nested;
        model.getParsedWhere().clear();
        ObjList<ExpressionNode> nodes = model.parseWhereClause();
        model.setWhereClause(null);
        int n = nodes.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ExpressionNode node = nodes.getQuick(i);
                this.literalCollectorAIndexes.clear();
                this.literalCollectorANames.clear();
                this.literalCollector.withModel(model);
                this.literalCollector.resetNullCount();
                this.traversalAlgo.traverse(node, this.literalCollector.lhs());
                if (this.literalCollectorAIndexes.size() == 0) {
                    this.addWhereNode(model, node);
                    continue;
                }
                int tableIndex = this.literalCollectorAIndexes.getQuick(0);
                QueryModel parent = model.getJoinModels().getQuick(tableIndex);
                int joinType = parent.getJoinType();
                if (tableIndex > 0 && joinBarriers.contains(joinType) && this.literalCollector.nullCount > 0) {
                    model.setPostJoinWhereClause(this.concatFilters(model.getPostJoinWhereClause(), node));
                    continue;
                }
                QueryModel nested2 = parent.getNestedModel();
                if (nested2 == null) {
                    this.addWhereNode(parent, node);
                    continue;
                }
                try {
                    this.traversalAlgo.traverse(node, this.literalCheckingVisitor.of(parent.getAliasToColumnMap()));
                    this.traversalAlgo.traverse(node, this.literalRewritingVisitor.of(parent.getAliasToColumnNameMap()));
                    this.addWhereNode(nested2, node);
                    continue;
                }
                catch (NonLiteralException ignore) {
                    this.addWhereNode(parent, node);
                }
            }
            model.getParsedWhere().clear();
        }
        if ((nested = model.getNestedModel()) != null) {
            this.moveWhereInsideSubQueries(nested);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int m = joinModels.size();
        for (int i = 1; i < m; ++i) {
            nested = joinModels.getQuick(i);
            if (nested == model) continue;
            this.moveWhereInsideSubQueries(nested);
        }
        nested = model.getUnionModel();
        if (nested != null) {
            this.moveWhereInsideSubQueries(nested);
        }
    }

    private QueryColumn nextColumn(CharSequence name) {
        return SqlUtil.nextColumn(this.queryColumnPool, this.expressionNodePool, name, name);
    }

    private QueryColumn nextColumn(CharSequence alias, CharSequence column) {
        return SqlUtil.nextColumn(this.queryColumnPool, this.expressionNodePool, alias, column);
    }

    private ExpressionNode nextLiteral(CharSequence token, int position) {
        return SqlUtil.nextLiteral(this.expressionNodePool, token, position);
    }

    private ExpressionNode nextLiteral(CharSequence token) {
        return this.nextLiteral(token, 0);
    }

    private void openReaderAndEnumerateColumns(SqlExecutionContext executionContext, QueryModel model) throws SqlException {
        ExpressionNode tableNameNode = model.getTableName();
        CharSequence tableName = tableNameNode.token;
        int tableNamePosition = tableNameNode.position;
        int lo = 0;
        int hi = tableName.length();
        if (Chars.startsWith(tableName, "*!*")) {
            lo += "*!*".length();
        }
        if (lo == hi) {
            throw SqlException.$(tableNamePosition, "come on, where is table name?");
        }
        int status = this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName, lo, hi);
        if (status == 1) {
            try {
                model.getTableName().type = 8;
                this.parseFunctionAndEnumerateColumns(model, executionContext);
                return;
            }
            catch (SqlException e) {
                throw SqlException.$(tableNamePosition, "table does not exist [name=").put(tableName).put(']');
            }
        }
        if (status == 2) {
            throw SqlException.$(tableNamePosition, "table directory is of unknown format");
        }
        try (TableReader r = this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableLookupSequence.of(tableName, lo, hi - lo), -1L);){
            model.setTableVersion(r.getVersion());
            this.copyColumnsFromMetadata(model, r.getMetadata());
        }
        catch (EntryLockedException e) {
            throw SqlException.position(tableNamePosition).put("table is locked: ").put(this.tableLookupSequence);
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e);
        }
    }

    QueryModel optimise(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        this.optimiseExpressionModels(model, executionContext);
        this.enumerateTableColumns(model, executionContext);
        this.resolveJoinColumns(model);
        this.optimiseBooleanNot(model);
        QueryModel rewrittenModel = this.rewriteOrderBy(this.rewriteOrderByPositionForUnionModels(this.rewriteOrderByPosition(this.rewriteSelectClause(model, true))));
        this.optimiseOrderBy(rewrittenModel, 0);
        this.createOrderHash(rewrittenModel);
        this.optimiseJoins(rewrittenModel);
        this.moveWhereInsideSubQueries(rewrittenModel);
        this.eraseColumnPrefixInWhereClauses(rewrittenModel);
        this.moveTimestampToChooseModel(rewrittenModel);
        this.propagateTopDownColumns(rewrittenModel, true, null);
        return rewrittenModel;
    }

    private ExpressionNode optimiseBooleanNot(ExpressionNode node, boolean reverse) {
        switch (notOps.get(node.token)) {
            case 1: {
                if (reverse) {
                    return this.optimiseBooleanNot(node.rhs, false);
                }
                switch (node.rhs.type) {
                    case 2: 
                    case 4: {
                        return node;
                    }
                }
                return this.optimiseBooleanNot(node.rhs, true);
            }
            case 2: {
                if (reverse) {
                    node.token = "or";
                }
                node.lhs = this.optimiseBooleanNot(node.lhs, reverse);
                node.rhs = this.optimiseBooleanNot(node.rhs, reverse);
                return node;
            }
            case 3: {
                if (reverse) {
                    node.token = "and";
                }
                node.lhs = this.optimiseBooleanNot(node.lhs, reverse);
                node.rhs = this.optimiseBooleanNot(node.rhs, reverse);
                return node;
            }
            case 4: {
                if (reverse) {
                    node.token = "<=";
                }
                return node;
            }
            case 5: {
                if (reverse) {
                    node.token = "<";
                }
                return node;
            }
            case 6: {
                if (reverse) {
                    node.token = ">=";
                }
                return node;
            }
            case 7: {
                if (reverse) {
                    node.token = ">";
                }
                return node;
            }
            case 8: {
                if (reverse) {
                    node.token = "!=";
                }
                return node;
            }
            case 9: {
                if (reverse) {
                    node.token = "=";
                }
                return node;
            }
        }
        if (reverse) {
            ExpressionNode n = this.expressionNodePool.next();
            n.token = "not";
            n.paramCount = 1;
            n.rhs = node;
            n.type = 1;
            return n;
        }
        return node;
    }

    private void optimiseBooleanNot(QueryModel model) {
        ExpressionNode where = model.getWhereClause();
        if (where != null) {
            model.setWhereClause(this.optimiseBooleanNot(where, false));
        }
        if (model.getNestedModel() != null) {
            this.optimiseBooleanNot(model.getNestedModel());
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.optimiseBooleanNot(joinModels.getQuick(i));
        }
        if (model.getUnionModel() != null) {
            this.optimiseBooleanNot(model.getNestedModel());
        }
    }

    private void optimiseExpressionModels(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ObjList<QueryModel> joinModels;
        int m;
        ObjList<ExpressionNode> expressionModels = model.getExpressionModels();
        int n = expressionModels.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ExpressionNode node = expressionModels.getQuick(i);
                assert (node.queryModel != null);
                QueryModel optimised = this.optimise(node.queryModel, executionContext);
                if (optimised == node.queryModel) continue;
                node.queryModel = optimised;
            }
        }
        if (model.getNestedModel() != null) {
            this.optimiseExpressionModels(model.getNestedModel(), executionContext);
        }
        if ((m = (joinModels = model.getJoinModels()).size()) > 1) {
            for (int i = 1; i < m; ++i) {
                this.optimiseExpressionModels(joinModels.getQuick(i), executionContext);
            }
        }
        if (model.getUnionModel() != null) {
            this.optimiseExpressionModels(model.getUnionModel(), executionContext);
        }
    }

    private void optimiseJoins(QueryModel model) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        if (n > 1) {
            this.emittedJoinClauses = this.joinClausesSwap1;
            this.emittedJoinClauses.clear();
            ExpressionNode where = model.getWhereClause();
            model.setWhereClause(null);
            this.processJoinConditions(model, where);
            for (int i = 1; i < n; ++i) {
                this.processJoinConditions(model, joinModels.getQuick(i).getJoinCriteria());
            }
            this.processEmittedJoinClauses(model);
            this.createImpliedDependencies(model);
            this.homogenizeCrossJoins(model);
            this.reorderTables(model);
            this.assignFilters(model);
            this.alignJoinClauses(model);
            this.addTransitiveFilters(model);
        }
        for (int i = 0; i < n; ++i) {
            QueryModel m = model.getJoinModels().getQuick(i).getNestedModel();
            if (m != null) {
                this.optimiseJoins(m);
            }
            if ((m = model.getJoinModels().getQuick(i).getUnionModel()) == null) continue;
            this.optimiseJoins(m);
        }
    }

    private void optimiseOrderBy(QueryModel model, int topLevelOrderByMnemonic) {
        int orderByMnemonic;
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        block0 : switch (topLevelOrderByMnemonic) {
            case 0: {
                orderByMnemonic = model.getOrderBy().size() > 0 && model.getSampleBy() == null ? 2 : 1;
                if (model.getSampleBy() != null) break;
                for (int i = 0; i < n; ++i) {
                    QueryColumn col = columns.getQuick(i);
                    if (!this.hasAggregates(col.getAst())) continue;
                    orderByMnemonic = 2;
                    break block0;
                }
                break;
            }
            case 1: {
                if (model.getOrderBy().size() > 0) {
                    orderByMnemonic = 2;
                    break;
                }
                orderByMnemonic = 1;
                break;
            }
            default: {
                model.getOrderBy().clear();
                orderByMnemonic = model.getSampleBy() != null ? 1 : 2;
            }
        }
        ObjList<ExpressionNode> orderByAdvice = this.getOrderByAdvice(model);
        IntList orderByDirectionAdvice = model.getOrderByDirection();
        ObjList<QueryModel> jm = model.getJoinModels();
        int k = jm.size();
        for (int i = 0; i < k; ++i) {
            QueryModel qm = jm.getQuick(i).getNestedModel();
            if (qm == null) continue;
            qm.setOrderByAdviceMnemonic(orderByMnemonic);
            qm.copyOrderByAdvice(orderByAdvice);
            qm.copyOrderByDirectionAdvice(orderByDirectionAdvice);
            this.optimiseOrderBy(qm, orderByMnemonic);
        }
        QueryModel union = model.getUnionModel();
        if (union != null) {
            union.copyOrderByAdvice(orderByAdvice);
            union.copyOrderByDirectionAdvice(orderByDirectionAdvice);
            union.setOrderByAdviceMnemonic(orderByMnemonic);
            this.optimiseOrderBy(union, orderByMnemonic);
        }
    }

    private void parseFunctionAndEnumerateColumns(@NotNull QueryModel model, @NotNull SqlExecutionContext executionContext) throws SqlException {
        assert (model.getTableNameFunction() == null);
        Function function = this.functionParser.parseFunction(model.getTableName(), EmptyRecordMetadata.INSTANCE, executionContext);
        if (function.getType() != 101) {
            throw SqlException.$(model.getTableName().position, "function must return CURSOR");
        }
        model.setTableNameFunction(function);
        this.copyColumnsFromMetadata(model, function.getMetadata());
    }

    private void processEmittedJoinClauses(QueryModel model) {
        int k = this.emittedJoinClauses.size();
        for (int i = 0; i < k; ++i) {
            this.addJoinContext(model, this.emittedJoinClauses.getQuick(i));
        }
    }

    private void processJoinConditions(QueryModel parent, ExpressionNode node) throws SqlException {
        ExpressionNode n = node;
        this.sqlNodeStack.clear();
        block6: while (!this.sqlNodeStack.isEmpty() || n != null) {
            if (n != null) {
                switch (joinOps.get(n.token)) {
                    case 1: {
                        this.analyseEquals(parent, n);
                        n = null;
                        continue block6;
                    }
                    case 2: {
                        if (n.rhs != null) {
                            this.sqlNodeStack.push(n.rhs);
                        }
                        n = n.lhs;
                        continue block6;
                    }
                    case 3: {
                        this.processOrConditions(parent, n);
                        n = null;
                        continue block6;
                    }
                    case 4: {
                        this.analyseRegex(parent, n);
                    }
                }
                parent.addParsedWhereNode(n);
                n = null;
                continue;
            }
            n = this.sqlNodeStack.poll();
        }
    }

    private void processOrConditions(QueryModel parent, ExpressionNode node) {
        parent.addParsedWhereNode(node);
    }

    private void propagateTopDownColumns(QueryModel model, boolean topLevel, @Nullable QueryModel papaModel) {
        QueryModel unionModel;
        ObjList<ExpressionNode> orderBy;
        int orderBySize;
        int i;
        int n;
        QueryModel union;
        QueryModel nested = this.skipNoneTypeModels(model.getNestedModel());
        boolean nestedIsFlex = SqlOptimiser.modelIsFlex(nested);
        if (nestedIsFlex) {
            ObjList<QueryColumn> columns = model.getTopDownColumns().size() > 0 ? model.getTopDownColumns() : model.getColumns();
            int n2 = columns.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.emitLiteralsTopDown(columns.getQuick(i2).getAst(), nested);
            }
        }
        if (SqlOptimiser.modelIsFlex(union = this.skipNoneTypeModels(model.getUnionModel()))) {
            ObjList<QueryColumn> columns = model.getTopDownColumns().size() > 0 ? model.getTopDownColumns() : model.getColumns();
            n = columns.size();
            for (i = 0; i < n; ++i) {
                this.emitLiteralsTopDown(columns.getQuick(i).getAst(), union);
            }
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        n = joinModels.size();
        for (i = 1; i < n; ++i) {
            QueryModel jm = joinModels.getQuick(i);
            JoinContext jc = jm.getContext();
            if (jc != null && jc.aIndexes.size() > 0) {
                int z = jc.aIndexes.size();
                for (int k = 0; k < z; ++k) {
                    this.emitLiteralsTopDown(jc.aNodes.getQuick(k), model);
                    this.emitLiteralsTopDown(jc.bNodes.getQuick(k), model);
                    if (papaModel == null) continue;
                    this.emitLiteralsTopDown(jc.aNodes.getQuick(k), papaModel);
                    this.emitLiteralsTopDown(jc.bNodes.getQuick(k), papaModel);
                }
            }
            this.propagateTopDownColumns(jm, false, model);
            ExpressionNode postJoinWhere = jm.getPostJoinWhereClause();
            if (postJoinWhere == null) continue;
            this.emitLiteralsTopDown(postJoinWhere, jm);
            this.emitLiteralsTopDown(postJoinWhere, model);
        }
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        int latestBySize = latestBy.size();
        if (latestBySize > 0) {
            for (int i3 = 0; i3 < latestBySize; ++i3) {
                this.emitLiteralsTopDown(latestBy.getQuick(i3), model);
            }
        }
        if (model.getTimestamp() != null && nestedIsFlex) {
            this.emitLiteralsTopDown(model.getTimestamp(), nested);
        }
        if (model.getWhereClause() != null) {
            this.emitLiteralsTopDown(model.getWhereClause(), model);
        }
        if (!topLevel && (orderBySize = (orderBy = model.getOrderBy()).size()) > 0) {
            for (int i4 = 0; i4 < orderBySize; ++i4) {
                this.emitLiteralsTopDown(orderBy.getQuick(i4), model);
            }
        }
        if (nested != null) {
            this.propagateTopDownColumns(nested, false, null);
        }
        if ((unionModel = model.getUnionModel()) != null) {
            this.propagateTopDownColumns(unionModel, true, null);
        }
    }

    private void reorderTables(QueryModel model) {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        this.tempCrosses.clear();
        for (int i = 0; i < n; ++i) {
            QueryModel q = joinModels.getQuick(i);
            if (q.getContext() != null && q.getContext().parents.size() != 0) continue;
            this.tempCrosses.add(i);
        }
        int cost = Integer.MAX_VALUE;
        int root = -1;
        int zc = this.tempCrosses.size();
        for (int z = 0; z < zc; ++z) {
            for (int i = 0; i < zc; ++i) {
                int k;
                if (z == i) continue;
                int to = this.tempCrosses.getQuick(i);
                JoinContext jc = joinModels.getQuick(to).getContext();
                for (k = i - 1; k > -1 && this.swapJoinOrder(model, to, k, jc); --k) {
                }
                for (k = i + 1; k < n && this.swapJoinOrder(model, to, k, jc); ++k) {
                }
            }
            IntList ordered = model.nextOrderedJoinModels();
            int thisCost = this.doReorderTables(model, ordered);
            if (thisCost >= cost) continue;
            root = z;
            cost = thisCost;
            model.setOrderedJoinModels(ordered);
        }
        assert (root != -1);
    }

    private ExpressionNode replaceIfAggregate(ExpressionNode node, QueryModel model) {
        if (node != null && this.functionParser.isGroupBy(node.token)) {
            QueryColumn c = this.queryColumnPool.next().of(this.createColumnAlias(node, model), node);
            model.addBottomUpColumn(c);
            return this.nextLiteral(c.getAlias());
        }
        return node;
    }

    private ExpressionNode replaceLiteral(ExpressionNode node, QueryModel translatingModel, QueryModel innerModel, QueryModel validatingModel) throws SqlException {
        return node != null && node.type == 4 ? this.doReplaceLiteral(node, translatingModel, innerModel, validatingModel) : node;
    }

    private void resolveJoinColumns(QueryModel model) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int size = joinModels.size();
        CharSequence modelAlias = this.setAndGetModelAlias(model);
        this.collectAlias(model, 0, model);
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                QueryModel jm = joinModels.getQuick(i);
                ObjList<ExpressionNode> jc = jm.getJoinColumns();
                int joinColumnsSize = jc.size();
                if (joinColumnsSize > 0) {
                    CharSequence jmAlias = this.setAndGetModelAlias(jm);
                    ExpressionNode joinCriteria = jm.getJoinCriteria();
                    for (int j = 0; j < joinColumnsSize; ++j) {
                        ExpressionNode node = jc.getQuick(j);
                        ExpressionNode eq = this.makeOperation("=", this.makeModelAlias(modelAlias, node), this.makeModelAlias(jmAlias, node));
                        joinCriteria = joinCriteria == null ? eq : this.makeOperation("and", joinCriteria, eq);
                    }
                    jm.setJoinCriteria(joinCriteria);
                }
                this.resolveJoinColumns(jm);
                this.collectAlias(model, i, jm);
            }
        }
        if (model.getNestedModel() != null) {
            this.resolveJoinColumns(model.getNestedModel());
        }
        if (model.getUnionModel() != null) {
            this.resolveJoinColumns(model.getUnionModel());
        }
    }

    private QueryModel rewriteOrderBy(QueryModel model) throws SqlException {
        QueryModel rewritten;
        QueryModel union;
        QueryModel rewritten2;
        QueryModel nested;
        QueryModel result = model;
        QueryModel base = model;
        QueryModel baseParent = model;
        QueryModel wrapper = null;
        int modelColumnCount = model.getColumns().size();
        boolean groupBy = false;
        while (base.getColumns().size() > 0 && !base.isNestedModelIsSubQuery()) {
            baseParent = base;
            base = base.getNestedModel();
            groupBy = groupBy || baseParent.getSelectModelType() == 4;
        }
        ObjList<ExpressionNode> orderByNodes = base.getOrderBy();
        int sz = orderByNodes.size();
        if (sz > 0) {
            boolean ascendColumns = true;
            for (int i = 0; i < sz; ++i) {
                ExpressionNode orderBy = orderByNodes.getQuick(i);
                CharSequence column = orderBy.token;
                int dot = Chars.indexOf(column, '.');
                if (dot > -1 || model.getAliasToColumnMap().excludes(column)) {
                    this.getIndexOfTableForColumn(base, column, dot, orderBy.position);
                    if (ascendColumns && base != model) {
                        CharSequenceObjHashMap<CharSequence> map = baseParent.getColumnNameToAliasMap();
                        CharSequence alias = null;
                        int index = map.keyIndex(column);
                        if (index > -1 && dot > -1) {
                            index = map.keyIndex(column, dot + 1, column.length());
                        }
                        if (index < 0) {
                            orderBy.token = map.valueAtQuick(index);
                        } else if (groupBy) {
                            ascendColumns = false;
                        } else {
                            if (baseParent.getSelectModelType() != 1) {
                                QueryModel synthetic = this.queryModelPool.next();
                                synthetic.setSelectModelType(1);
                                int z = baseParent.getColumns().size();
                                for (int j = 0; j < z; ++j) {
                                    QueryColumn qc = baseParent.getColumns().getQuick(j);
                                    if (qc.getAst().type == 8 || qc.getAst().type == 1) {
                                        this.emitLiterals(qc.getAst(), synthetic, null, baseParent.getNestedModel());
                                        continue;
                                    }
                                    synthetic.addBottomUpColumn(qc);
                                }
                                synthetic.setNestedModel(base);
                                baseParent.setNestedModel(synthetic);
                                baseParent = synthetic;
                                index = synthetic.getColumnNameToAliasMap().keyIndex(column);
                                if (index > -1 && dot > -1) {
                                    index = synthetic.getColumnNameToAliasMap().keyIndex(column, dot + 1, column.length());
                                }
                                if (index < 0) {
                                    alias = synthetic.getColumnNameToAliasMap().valueAtQuick(index);
                                }
                            }
                            if (alias == null) {
                                alias = SqlUtil.createColumnAlias(this.characterStore, column, dot, baseParent.getAliasToColumnMap());
                                baseParent.addBottomUpColumn(this.nextColumn(alias, column));
                            }
                            if (model != baseParent) {
                                QueryModel m = model;
                                do {
                                    m.addBottomUpColumn(this.nextColumn(alias));
                                } while ((m = m.getNestedModel()) != baseParent);
                            }
                            orderBy.token = alias;
                            if (wrapper == null) {
                                wrapper = this.queryModelPool.next();
                                wrapper.setSelectModelType(1);
                                for (int j = 0; j < modelColumnCount; ++j) {
                                    wrapper.addBottomUpColumn(this.nextColumn(model.getColumns().getQuick(j).getAlias()));
                                }
                                result = wrapper;
                                wrapper.setNestedModel(model);
                            }
                        }
                    }
                }
                if (!ascendColumns || base == baseParent) continue;
                model.addOrderBy(orderBy, base.getOrderByDirection().getQuick(i));
            }
            if (base != model) {
                base.clearOrderBy();
            }
        }
        if ((nested = base.getNestedModel()) != null && (rewritten2 = this.rewriteOrderBy(nested)) != nested) {
            base.setNestedModel(rewritten2);
        }
        if ((union = base.getUnionModel()) != null && (rewritten = this.rewriteOrderBy(union)) != union) {
            base.setUnionModel(rewritten);
        }
        ObjList<QueryModel> joinModels = base.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteOrderBy(joinModels.getQuick(i));
        }
        return result;
    }

    private QueryModel rewriteOrderByPosition(QueryModel model) throws SqlException {
        QueryModel nested;
        int i;
        QueryModel base = model;
        QueryModel baseParent = model;
        while (base.getColumns().size() > 0) {
            baseParent = base;
            base = base.getNestedModel();
        }
        ObjList<ExpressionNode> orderByNodes = base.getOrderBy();
        int sz = orderByNodes.size();
        if (sz > 0) {
            ObjList<QueryColumn> columns = baseParent.getColumns();
            int columnCount = columns.size();
            for (i = 0; i < sz; ++i) {
                ExpressionNode orderBy = orderByNodes.getQuick(i);
                CharSequence column = orderBy.token;
                char first = column.charAt(0);
                if (first < '0' || first > '9') continue;
                try {
                    int position = Numbers.parseInt(column);
                    if (position < 1 || position > columnCount) {
                        throw SqlException.$(orderBy.position, "order column position is out of range [max=").put(columnCount).put(']');
                    }
                    orderByNodes.setQuick(i, this.expressionNodePool.next().of(4, columns.get(position - 1).getName(), -1, orderBy.position));
                    continue;
                }
                catch (NumericException e) {
                    throw SqlException.invalidColumn(orderBy.position, column);
                }
            }
        }
        if ((nested = base.getNestedModel()) != null) {
            this.rewriteOrderByPosition(nested);
        }
        ObjList<QueryModel> joinModels = base.getJoinModels();
        int n = joinModels.size();
        for (i = 1; i < n; ++i) {
            this.rewriteOrderByPosition(joinModels.getQuick(i));
        }
        return model;
    }

    private QueryModel rewriteOrderByPositionForUnionModels(QueryModel model) throws SqlException {
        QueryModel next = model.getUnionModel();
        if (next != null) {
            this.doRewriteOrderByPositionForUnionModels(model, model, next);
        }
        if ((next = model.getNestedModel()) != null) {
            this.rewriteOrderByPositionForUnionModels(next);
        }
        return model;
    }

    private QueryModel rewriteSelectClause(QueryModel model, boolean flatParent) throws SqlException {
        QueryModel rewrittenUnionModel;
        if (model.getUnionModel() != null && (rewrittenUnionModel = this.rewriteSelectClause(model.getUnionModel(), true)) != model.getUnionModel()) {
            model.setUnionModel(rewrittenUnionModel);
        }
        ObjList<QueryModel> models = model.getJoinModels();
        int n = models.size();
        for (int i = 0; i < n; ++i) {
            QueryModel rewritten;
            QueryModel m = models.getQuick(i);
            boolean flatModel = m.getColumns().size() == 0;
            QueryModel nestedModel = m.getNestedModel();
            if (nestedModel != null && (rewritten = this.rewriteSelectClause(nestedModel, flatModel)) != nestedModel) {
                m.setNestedModel(rewritten);
                m.copyColumnsFrom(rewritten);
            }
            if (flatModel) {
                if (!flatParent || m.getSampleBy() == null) continue;
                throw SqlException.$(m.getSampleBy().position, "'sample by' must be used with 'select' clause, which contains aggerate expression(s)");
            }
            model.replaceJoinModel(i, this.rewriteSelectClause0(m));
        }
        return models.getQuick(0);
    }

    @NotNull
    private QueryModel rewriteSelectClause0(QueryModel model) throws SqlException {
        QueryModel limitSource;
        QueryModel root;
        boolean translationIsRedundant;
        assert (model.getNestedModel() != null);
        QueryModel groupByModel = this.queryModelPool.next();
        groupByModel.setSelectModelType(4);
        QueryModel distinctModel = this.queryModelPool.next();
        distinctModel.setSelectModelType(5);
        QueryModel outerModel = this.queryModelPool.next();
        outerModel.setSelectModelType(2);
        QueryModel innerModel = this.queryModelPool.next();
        innerModel.setSelectModelType(2);
        QueryModel analyticModel = this.queryModelPool.next();
        analyticModel.setSelectModelType(3);
        QueryModel translatingModel = this.queryModelPool.next();
        translatingModel.setSelectModelType(1);
        boolean useInnerModel = false;
        boolean useAnalyticModel = false;
        boolean useGroupByModel = false;
        boolean useOuterModel = false;
        boolean useDistinctModel = model.isDistinct();
        ObjList<QueryColumn> columns = model.getColumns();
        QueryModel baseModel = model.getNestedModel();
        boolean hasJoins = baseModel.getJoinModels().size() > 1;
        ExpressionNode sampleBy = baseModel.getSampleBy();
        if (sampleBy != null) {
            groupByModel.moveSampleByFrom(baseModel);
        }
        int k = columns.size();
        for (int i = 0; i < k; ++i) {
            QueryColumn qc = columns.getQuick(i);
            boolean analytic = qc instanceof AnalyticColumn;
            if (analytic && qc.getAst().type != 8) {
                throw SqlException.$(qc.getAst().position, "Analytic function expected");
            }
            if (qc.getAst().type == 4) {
                if (!SqlOptimiser.isNotBindVariable(qc.getAst().token)) {
                    this.addFunction(qc, baseModel, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
                    useInnerModel = true;
                    continue;
                }
                if (Chars.endsWith(qc.getAst().token, '*')) {
                    this.createSelectColumnsForWildcard(qc, hasJoins, baseModel, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
                    continue;
                }
                this.createSelectColumn(qc.getAlias(), qc.getAst(), baseModel, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
                continue;
            }
            if (qc.getAst().type == 8) {
                if (analytic) {
                    analyticModel.addBottomUpColumn(qc);
                    this.emitLiterals(qc.getAst(), translatingModel, innerModel, baseModel);
                    useAnalyticModel = true;
                    continue;
                }
                if (this.functionParser.isGroupBy(qc.getAst().token)) {
                    CharSequence alias = this.createColumnAlias(qc.getAlias(), groupByModel);
                    if (alias != qc.getAlias()) {
                        qc = this.queryColumnPool.next().of(alias, qc.getAst());
                    }
                    groupByModel.addBottomUpColumn(qc);
                    QueryColumn aggregateRef = this.nextColumn(qc.getAlias());
                    outerModel.addBottomUpColumn(aggregateRef);
                    distinctModel.addBottomUpColumn(aggregateRef);
                    this.emitLiterals(qc.getAst(), translatingModel, innerModel, baseModel);
                    useGroupByModel = true;
                    continue;
                }
            }
            int beforeSplit = groupByModel.getColumns().size();
            this.emitAggregates(qc.getAst(), groupByModel);
            if (beforeSplit < groupByModel.getColumns().size()) {
                outerModel.addBottomUpColumn(qc);
                distinctModel.addBottomUpColumn(this.nextColumn(qc.getAlias()));
                int n = groupByModel.getColumns().size();
                for (int j = beforeSplit; j < n; ++j) {
                    this.emitLiterals(groupByModel.getColumns().getQuick(i).getAst(), translatingModel, innerModel, baseModel);
                }
                useGroupByModel = true;
                useOuterModel = true;
                continue;
            }
            this.addFunction(qc, baseModel, translatingModel, innerModel, analyticModel, groupByModel, outerModel, distinctModel);
            useInnerModel = true;
        }
        if (useAnalyticModel && useGroupByModel) {
            throw SqlException.$(0, "Analytic function is not allowed in context of aggregation. Use sub-query.");
        }
        boolean bl = translationIsRedundant = useInnerModel || useGroupByModel || useAnalyticModel;
        if (translationIsRedundant) {
            int n = translatingModel.getColumns().size();
            for (int i = 0; i < n; ++i) {
                QueryColumn column = translatingModel.getColumns().getQuick(i);
                if (column.getAst().token.equals(column.getAlias())) continue;
                translationIsRedundant = false;
            }
        }
        if (translationIsRedundant) {
            root = baseModel;
            limitSource = model;
        } else {
            root = translatingModel;
            limitSource = translatingModel;
            translatingModel.setNestedModel(baseModel);
            translatingModel.moveLimitFrom(model);
        }
        if (useInnerModel) {
            innerModel.setNestedModel(root);
            innerModel.moveLimitFrom(limitSource);
            root = innerModel;
            limitSource = innerModel;
        }
        if (useAnalyticModel) {
            analyticModel.setNestedModel(root);
            analyticModel.moveLimitFrom(limitSource);
            root = analyticModel;
            limitSource = analyticModel;
        } else if (useGroupByModel) {
            groupByModel.setNestedModel(root);
            groupByModel.moveLimitFrom(limitSource);
            root = groupByModel;
            limitSource = groupByModel;
            if (useOuterModel) {
                outerModel.setNestedModel(root);
                outerModel.moveLimitFrom(limitSource);
                root = outerModel;
                limitSource = outerModel;
            }
        }
        if (root != outerModel && root.getColumns().size() < outerModel.getColumns().size()) {
            outerModel.setNestedModel(root);
            outerModel.moveLimitFrom(limitSource);
            outerModel.setSelectModelType(1);
            root = outerModel;
        }
        if (useDistinctModel) {
            distinctModel.setNestedModel(root);
            root = distinctModel;
        }
        if (!useGroupByModel && groupByModel.getSampleBy() != null) {
            throw SqlException.$(groupByModel.getSampleBy().position, "at least one aggregation function must be present in 'select' clause");
        }
        if (model != root) {
            root.setUnionModel(model.getUnionModel());
            root.setUnionModelType(model.getUnionModelType());
            root.setModelPosition(model.getModelPosition());
        }
        return root;
    }

    private CharSequence setAndGetModelAlias(QueryModel model) {
        CharSequence name = model.getName();
        if (name != null) {
            return name;
        }
        ExpressionNode alias = this.makeJoinAlias(this.defaultAliasCount++);
        model.setAlias(alias);
        return alias.token;
    }

    private QueryModel skipNoneTypeModels(QueryModel model) {
        while (model != null && model.getSelectModelType() == 0 && model.getTableName() == null && model.getTableNameFunction() == null && model.getJoinModels().size() == 1) {
            model = model.getNestedModel();
        }
        return model;
    }

    private boolean swapJoinOrder(QueryModel parent, int to, int from, JoinContext context) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        QueryModel jm = joinModels.getQuick(from);
        if (joinBarriers.contains(jm.getJoinType())) {
            return false;
        }
        JoinContext that = jm.getContext();
        if (that != null && that.parents.contains(to)) {
            this.swapJoinOrder0(parent, jm, to, context);
        }
        return true;
    }

    private void swapJoinOrder0(QueryModel parent, QueryModel jm, int to, JoinContext jc) {
        JoinContext that = jm.getContext();
        this.clausesToSteal.clear();
        int zc = that.aIndexes.size();
        for (int z = 0; z < zc; ++z) {
            if (that.aIndexes.getQuick(z) != to && that.bIndexes.getQuick(z) != to) continue;
            this.clausesToSteal.add(z);
        }
        assert (this.clausesToSteal.size() > 0);
        if (this.clausesToSteal.size() < zc) {
            QueryModel target = parent.getJoinModels().getQuick(to);
            target.getDependencies().clear();
            if (jc == null) {
                jc = this.contextPool.next();
                target.setContext(jc);
            }
            jc.slaveIndex = to;
            jm.setContext(this.moveClauses(parent, that, jc, this.clausesToSteal));
            if (target.getJoinType() == 3) {
                target.setJoinType(1);
            }
        }
    }

    private void traverseNamesAndIndices(QueryModel parent, ExpressionNode node) throws SqlException {
        this.literalCollectorAIndexes.clear();
        this.literalCollectorBIndexes.clear();
        this.literalCollectorANames.clear();
        this.literalCollectorBNames.clear();
        this.literalCollector.withModel(parent);
        this.literalCollector.resetNullCount();
        this.traversalAlgo.traverse(node.lhs, this.literalCollector.lhs());
        this.traversalAlgo.traverse(node.rhs, this.literalCollector.rhs());
    }

    static {
        nullConstants = new CharSequenceHashSet();
        joinOps = new CharSequenceIntHashMap();
        flexColumnModelTypes = new IntHashSet();
        notOps.put("not", 1);
        notOps.put("and", 2);
        notOps.put("or", 3);
        notOps.put(">", 4);
        notOps.put(">=", 5);
        notOps.put("<", 6);
        notOps.put("<=", 7);
        notOps.put("=", 8);
        notOps.put("!=", 9);
        joinBarriers = new IntHashSet();
        joinBarriers.add(2);
        joinBarriers.add(4);
        joinBarriers.add(5);
        nullConstants.add("null");
        nullConstants.add("NaN");
        joinOps.put("=", 1);
        joinOps.put("and", 2);
        joinOps.put("or", 3);
        joinOps.put("~", 4);
        flexColumnModelTypes.add(1);
        flexColumnModelTypes.add(0);
        flexColumnModelTypes.add(2);
    }

    private class LiteralCollector
    implements PostOrderTreeTraversalAlgo.Visitor {
        private IntList indexes;
        private ObjList<CharSequence> names;
        private int nullCount;
        private QueryModel model;

        private LiteralCollector() {
        }

        @Override
        public void visit(ExpressionNode node) throws SqlException {
            switch (node.type) {
                case 4: {
                    if (!SqlOptimiser.isNotBindVariable(node.token)) break;
                    int dot = Chars.indexOf(node.token, '.');
                    CharSequence name = this.extractColumnName(node.token, dot);
                    this.indexes.add(SqlOptimiser.this.getIndexOfTableForColumn(this.model, node.token, dot, node.position));
                    if (this.names == null) break;
                    this.names.add(name);
                    break;
                }
                case 2: {
                    if (!nullConstants.contains(node.token)) break;
                    ++this.nullCount;
                    break;
                }
            }
        }

        private CharSequence extractColumnName(CharSequence token, int dot) {
            return dot == -1 ? token : token.subSequence(dot + 1, token.length());
        }

        private PostOrderTreeTraversalAlgo.Visitor lhs() {
            this.indexes = SqlOptimiser.this.literalCollectorAIndexes;
            this.names = SqlOptimiser.this.literalCollectorANames;
            return this;
        }

        private void resetNullCount() {
            this.nullCount = 0;
        }

        private PostOrderTreeTraversalAlgo.Visitor rhs() {
            this.indexes = SqlOptimiser.this.literalCollectorBIndexes;
            this.names = SqlOptimiser.this.literalCollectorBNames;
            return this;
        }

        private PostOrderTreeTraversalAlgo.Visitor to(IntList indexes) {
            this.indexes = indexes;
            this.names = null;
            return this;
        }

        private void withModel(QueryModel model) {
            this.model = model;
        }
    }

    private class ColumnPrefixEraser
    implements PostOrderTreeTraversalAlgo.Visitor {
        private ColumnPrefixEraser() {
        }

        @Override
        public void visit(ExpressionNode node) {
            switch (node.type) {
                case 1: 
                case 8: 
                case 32: {
                    if (node.paramCount < 3) {
                        node.lhs = this.rewrite(node.lhs);
                        node.rhs = this.rewrite(node.rhs);
                        break;
                    }
                    int n = node.paramCount;
                    for (int i = 0; i < n; ++i) {
                        node.args.setQuick(i, this.rewrite(node.args.getQuick(i)));
                    }
                    break;
                }
            }
        }

        private ExpressionNode rewrite(ExpressionNode node) {
            int dot;
            if (node != null && node.type == 4 && (dot = Chars.indexOf(node.token, '.')) != -1) {
                return SqlOptimiser.this.nextLiteral(node.token.subSequence(dot + 1, node.token.length()));
            }
            return node;
        }
    }

    private static class LiteralRewritingVisitor
    implements PostOrderTreeTraversalAlgo.Visitor {
        private CharSequenceObjHashMap<CharSequence> aliasToColumnMap;

        private LiteralRewritingVisitor() {
        }

        @Override
        public void visit(ExpressionNode node) {
            if (node.type == 4) {
                int index;
                int dot = Chars.indexOf(node.token, '.');
                int n = index = dot == -1 ? this.aliasToColumnMap.keyIndex(node.token) : this.aliasToColumnMap.keyIndex(node.token, dot + 1, node.token.length());
                if (index < 0) {
                    CharSequence column = this.aliasToColumnMap.valueAtQuick(index);
                    assert (column != null);
                    if (!Chars.equals(node.token, column)) {
                        node.token = column;
                    }
                }
            }
        }

        PostOrderTreeTraversalAlgo.Visitor of(CharSequenceObjHashMap<CharSequence> aliasToColumnMap) {
            this.aliasToColumnMap = aliasToColumnMap;
            return this;
        }
    }

    private static class LiteralCheckingVisitor
    implements PostOrderTreeTraversalAlgo.Visitor {
        private CharSequenceObjHashMap<QueryColumn> nameTypeMap;

        private LiteralCheckingVisitor() {
        }

        @Override
        public void visit(ExpressionNode node) {
            if (node.type == 4) {
                int index;
                int dot = Chars.indexOf(node.token, '.');
                int n = index = dot == -1 ? this.nameTypeMap.keyIndex(node.token) : this.nameTypeMap.keyIndex(node.token, dot + 1, node.token.length());
                assert (index < 0);
                if (this.nameTypeMap.valueAt((int)index).getAst().type != 4) {
                    throw NonLiteralException.INSTANCE;
                }
            }
        }

        PostOrderTreeTraversalAlgo.Visitor of(CharSequenceObjHashMap<QueryColumn> nameTypeMap) {
            this.nameTypeMap = nameTypeMap;
            return this;
        }
    }

    private static class NonLiteralException
    extends RuntimeException {
        private static final NonLiteralException INSTANCE = new NonLiteralException();

        private NonLiteralException() {
        }
    }
}

