/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.ExpressionParser;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.ExpressionTreeBuilder;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.griffin.model.WithClauseModel;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.LowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import org.jetbrains.annotations.NotNull;

public final class SqlParser {
    public static final int MAX_ORDER_BY_COLUMNS = 1560;
    private static final LowerCaseAsciiCharSequenceHashSet tableAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet columnAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet groupByStopSet = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceIntHashMap joinStartSet = new LowerCaseAsciiCharSequenceIntHashMap();
    private final ObjectPool<ExpressionNode> sqlNodePool;
    private final ExpressionTreeBuilder expressionTreeBuilder = new ExpressionTreeBuilder();
    private final ObjectPool<QueryModel> queryModelPool;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<AnalyticColumn> analyticColumnPool;
    private final ObjectPool<CreateTableModel> createTableModelPool;
    private final ObjectPool<ColumnCastModel> columnCastModelPool;
    private final ObjectPool<RenameTableModel> renameTableModelPool;
    private final ObjectPool<WithClauseModel> withClauseModelPool;
    private final ObjectPool<InsertModel> insertModelPool;
    private final ObjectPool<CopyModel> copyModelPool;
    private final ExpressionParser expressionParser;
    private final CairoConfiguration configuration;
    private final PostOrderTreeTraversalAlgo traversalAlgo;
    private final ObjList<ExpressionNode> tempExprNodes = new ObjList();
    private final CharacterStore characterStore;
    private final SqlOptimiser optimiser;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCase0Ref = this::rewriteCase0;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCount0Ref = this::rewriteCount0;
    private boolean subQueryMode = false;

    SqlParser(CairoConfiguration configuration, SqlOptimiser optimiser, CharacterStore characterStore, ObjectPool<ExpressionNode> sqlNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo traversalAlgo) {
        this.sqlNodePool = sqlNodePool;
        this.queryModelPool = queryModelPool;
        this.queryColumnPool = queryColumnPool;
        this.analyticColumnPool = new ObjectPool<AnalyticColumn>(AnalyticColumn.FACTORY, configuration.getAnalyticColumnPoolCapacity());
        this.createTableModelPool = new ObjectPool<CreateTableModel>(CreateTableModel.FACTORY, configuration.getCreateTableModelPoolCapacity());
        this.columnCastModelPool = new ObjectPool<ColumnCastModel>(ColumnCastModel.FACTORY, configuration.getColumnCastModelPoolCapacity());
        this.renameTableModelPool = new ObjectPool<RenameTableModel>(RenameTableModel.FACTORY, configuration.getRenameTableModelPoolCapacity());
        this.withClauseModelPool = new ObjectPool<WithClauseModel>(WithClauseModel.FACTORY, configuration.getWithClauseModelPoolCapacity());
        this.insertModelPool = new ObjectPool<InsertModel>(InsertModel.FACTORY, configuration.getInsertPoolCapacity());
        this.copyModelPool = new ObjectPool<CopyModel>(CopyModel.FACTORY, configuration.getCopyPoolCapacity());
        this.configuration = configuration;
        this.traversalAlgo = traversalAlgo;
        this.characterStore = characterStore;
        this.optimiser = optimiser;
        this.expressionParser = new ExpressionParser(sqlNodePool, this);
    }

    private static SqlException err(GenericLexer lexer, String msg) {
        return SqlException.$(lexer.lastTokenPosition(), msg);
    }

    private static SqlException errUnexpected(GenericLexer lexer, CharSequence token) {
        return SqlException.unexpectedToken(lexer.lastTokenPosition(), token);
    }

    void clear() {
        this.queryModelPool.clear();
        this.queryColumnPool.clear();
        this.sqlNodePool.clear();
        this.analyticColumnPool.clear();
        this.createTableModelPool.clear();
        this.columnCastModelPool.clear();
        this.renameTableModelPool.clear();
        this.withClauseModelPool.clear();
        this.subQueryMode = false;
        this.characterStore.clear();
        this.insertModelPool.clear();
        this.expressionTreeBuilder.reset();
        this.copyModelPool.clear();
    }

    private CharSequence createColumnAlias(ExpressionNode node, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, node.token, Chars.indexOf(node.token, '.'), model.getAliasToColumnMap());
    }

    private ExpressionNode expectExpr(GenericLexer lexer) throws SqlException {
        ExpressionNode n = this.expr(lexer, (QueryModel)null);
        if (n == null) {
            throw SqlException.$(lexer.getUnparsed() == null ? lexer.getPosition() : lexer.lastTokenPosition(), "Expression expected");
        }
        return n;
    }

    private int expectInt(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "integer");
        } else {
            negative = false;
        }
        try {
            int result = Numbers.parseInt(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, "bad integer");
        }
    }

    private ExpressionNode expectLiteral(GenericLexer lexer) throws SqlException {
        return this.expectLiteral(lexer, "literal");
    }

    private ExpressionNode expectLiteral(GenericLexer lexer, String expectedList) throws SqlException {
        CharSequence tok = this.tok(lexer, expectedList);
        int pos = lexer.lastTokenPosition();
        this.validateLiteral(pos, tok, expectedList);
        return this.nextLiteral(GenericLexer.immutableOf(tok), pos);
    }

    private CharSequence expectTableNameOrSubQuery(GenericLexer lexer) throws SqlException {
        return this.tok(lexer, "table name or sub-query");
    }

    private void expectTok(GenericLexer lexer, CharSequence tok, CharSequence expected) throws SqlException {
        if (tok == null || !Chars.equalsLowerCaseAscii(tok, expected)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(expected).put("' expected");
        }
    }

    private void expectTok(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(lexer, tok, expected);
    }

    private void expectTok(GenericLexer lexer, char expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(tok, lexer.lastTokenPosition(), expected);
    }

    private void expectTok(CharSequence tok, int pos, char expected) throws SqlException {
        if (tok == null || !Chars.equals(tok, expected)) {
            throw SqlException.position(pos).put('\'').put(expected).put("' expected");
        }
    }

    ExpressionNode expr(GenericLexer lexer, QueryModel model) throws SqlException {
        try {
            this.expressionTreeBuilder.pushModel(model);
            this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder);
            ExpressionNode expressionNode = this.rewriteCase(this.rewriteCount(this.expressionTreeBuilder.poll()));
            return expressionNode;
        }
        catch (SqlException e) {
            this.expressionTreeBuilder.reset();
            throw e;
        }
        finally {
            this.expressionTreeBuilder.popModel();
        }
    }

    void expr(GenericLexer lexer, ExpressionParserListener listener) throws SqlException {
        this.expressionParser.parseExpr(lexer, listener);
    }

    private int getCreateTableColumnIndex(CreateTableModel model, CharSequence columnName, int position) throws SqlException {
        int index = model.getColumnIndex(columnName);
        if (index == -1) {
            throw SqlException.invalidColumn(position, columnName);
        }
        return index;
    }

    private boolean isFieldTerm(CharSequence tok) {
        return Chars.equals(tok, ')') || Chars.equals(tok, ',');
    }

    private ExpressionNode literal(GenericLexer lexer, CharSequence name) {
        return this.literal(name, lexer.lastTokenPosition());
    }

    private ExpressionNode literal(CharSequence name, int position) {
        return this.sqlNodePool.next().of(4, GenericLexer.unquote(name), 0, position);
    }

    private ExpressionNode nextLiteral(CharSequence token, int position) {
        return SqlUtil.nextLiteral(this.sqlNodePool, token, position);
    }

    private CharSequence notTermTok(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "')' or ','");
        if (this.isFieldTerm(tok)) {
            throw SqlParser.err(lexer, "missing column definition");
        }
        return tok;
    }

    private CharSequence optTok(GenericLexer lexer) {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null || this.subQueryMode && Chars.equals(tok, ')')) {
            return null;
        }
        return tok;
    }

    ExecutionModel parse(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'rename' or 'select'");
        if (Chars.equalsLowerCaseAscii(tok, "select")) {
            return this.parseSelect(lexer);
        }
        if (Chars.equalsLowerCaseAscii(tok, "create")) {
            return this.parseCreateStatement(lexer, executionContext);
        }
        if (Chars.equalsLowerCaseAscii(tok, "rename")) {
            return this.parseRenameStatement(lexer);
        }
        if (Chars.equalsLowerCaseAscii(tok, "insert")) {
            return this.parseInsert(lexer);
        }
        if (Chars.equalsLowerCaseAscii(tok, "copy")) {
            return this.parseCopy(lexer);
        }
        return this.parseSelect(lexer);
    }

    private ExecutionModel parseCopy(GenericLexer lexer) throws SqlException {
        if (this.configuration.getInputRoot() == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "COPY is disabled ['cairo.sql.copy.root' is not set?]");
        }
        ExpressionNode tableName = this.expectExpr(lexer);
        CharSequence tok = this.tok(lexer, "'from' or 'to'");
        if (Chars.equalsLowerCaseAscii(tok, "from")) {
            ExpressionNode fileName = this.expectExpr(lexer);
            if (fileName.token.length() < 3 && Chars.startsWith(fileName.token, '\'')) {
                throw SqlException.$(fileName.position, "file name expected");
            }
            CopyModel model = this.copyModelPool.next();
            model.setTableName(tableName);
            model.setFileName(fileName);
            return model;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'from' expected");
    }

    private ExecutionModel parseCreateStatement(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        this.expectTok(lexer, "table");
        return this.parseCreateTable(lexer, executionContext);
    }

    private ExecutionModel parseCreateTable(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode partitionBy;
        CreateTableModel model = this.createTableModelPool.next();
        CharSequence tableName = this.tok(lexer, "table name");
        if (Chars.indexOf(tableName, '.') != -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "'.' is not allowed here");
        }
        model.setName(this.nextLiteral(GenericLexer.unquote(tableName), lexer.lastTokenPosition()));
        CharSequence tok = this.tok(lexer, "'(' or 'as'");
        if (Chars.equals(tok, '(')) {
            lexer.unparse();
            this.parseCreateTableColumns(lexer, model);
        } else if (Chars.equalsLowerCaseAscii(tok, "as")) {
            this.parseCreateTableAsSelect(lexer, model, executionContext);
        } else {
            throw SqlParser.errUnexpected(lexer, tok);
        }
        while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ',')) {
            tok = this.tok(lexer, "'index' or 'cast'");
            if (Chars.equalsLowerCaseAscii(tok, "index")) {
                this.parseCreateTableIndexDef(lexer, model);
                continue;
            }
            if (Chars.equalsLowerCaseAscii(tok, "cast")) {
                this.parseCreateTableCastDef(lexer, model);
                continue;
            }
            throw SqlParser.errUnexpected(lexer, tok);
        }
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            this.getCreateTableColumnIndex(model, timestamp.token, timestamp.position);
            model.setTimestamp(timestamp);
            tok = this.optTok(lexer);
        }
        if ((partitionBy = this.parseCreateTablePartition(lexer, tok)) != null) {
            if (PartitionBy.fromString(partitionBy.token) == -1) {
                throw SqlException.$(partitionBy.position, "'NONE', 'DAY', 'MONTH' or 'YEAR' expected");
            }
            model.setPartitionBy(partitionBy);
            tok = this.optTok(lexer);
        }
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    private void parseCreateTableAsSelect(GenericLexer lexer, CreateTableModel model, SqlExecutionContext executionContext) throws SqlException {
        this.expectTok(lexer, '(');
        QueryModel queryModel = this.optimiser.optimise(this.parseDml(lexer), executionContext);
        ObjList<QueryColumn> columns = queryModel.getColumns();
        assert (columns.size() > 0);
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            model.addColumn(columns.getQuick(i).getName(), -1, this.configuration.getDefaultSymbolCapacity());
        }
        model.setQueryModel(queryModel);
        this.expectTok(lexer, ')');
    }

    private void parseCreateTableCastDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        if (model.getQueryModel() == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "cast is only supported in 'create table as ...' context");
        }
        this.expectTok(lexer, '(');
        ColumnCastModel columnCastModel = this.columnCastModelPool.next();
        ExpressionNode columnName = this.expectLiteral(lexer);
        columnCastModel.setName(columnName);
        this.expectTok(lexer, "as");
        ExpressionNode columnType = this.expectLiteral(lexer);
        int type = this.toColumnType(lexer, columnType.token);
        columnCastModel.setType(type, columnName.position, columnType.position);
        if (type == 11) {
            boolean cached;
            int symbolCapacity;
            int capacityPosition;
            CharSequence tok = this.tok(lexer, "'capacity', 'nocache', 'cache', 'index' or ')'");
            if (Chars.equalsLowerCaseAscii(tok, "capacity")) {
                capacityPosition = lexer.getPosition();
                symbolCapacity = this.parseSymbolCapacity(lexer);
                columnCastModel.setSymbolCapacity(symbolCapacity);
                tok = this.tok(lexer, "'nocache', 'cache', 'index' or ')'");
            } else {
                columnCastModel.setSymbolCapacity(this.configuration.getDefaultSymbolCapacity());
                symbolCapacity = -1;
                capacityPosition = -1;
            }
            if (Chars.equalsLowerCaseAscii(tok, "nocache")) {
                cached = false;
            } else if (Chars.equalsLowerCaseAscii(tok, "cache")) {
                cached = true;
            } else {
                cached = this.configuration.getDefaultSymbolCacheFlag();
                lexer.unparse();
            }
            columnCastModel.setSymbolCacheFlag(cached);
            if (cached && symbolCapacity != -1) {
                assert (capacityPosition != -1);
                TableUtils.validateSymbolCapacityCached(true, symbolCapacity, capacityPosition);
            }
            if (Chars.equalsLowerCaseAscii(tok = this.tok(lexer, "')', or 'index'"), "index")) {
                columnCastModel.setIndexed(true);
                tok = this.tok(lexer, "')', or 'capacity'");
                if (Chars.equalsLowerCaseAscii(tok, "capacity")) {
                    int errorPosition = lexer.getPosition();
                    int indexValueBlockSize = this.expectInt(lexer);
                    TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
                    columnCastModel.setIndexValueBlockSize(Numbers.ceilPow2(indexValueBlockSize));
                } else {
                    columnCastModel.setIndexValueBlockSize(this.configuration.getIndexValueBlockSize());
                }
            } else {
                columnCastModel.setIndexed(false);
                lexer.unparse();
            }
        }
        this.expectTok(lexer, ')');
        if (!model.addColumnCastModel(columnCastModel)) {
            throw SqlException.$(columnCastModel.getName().position, "duplicate cast");
        }
    }

    private void parseCreateTableColumns(GenericLexer lexer, CreateTableModel model) throws SqlException {
        block12: {
            CharSequence tok;
            this.expectTok(lexer, '(');
            do {
                int type;
                int position = lexer.lastTokenPosition();
                CharSequence name = GenericLexer.immutableOf(this.notTermTok(lexer));
                if (!model.addColumn(name, type = this.toColumnType(lexer, this.notTermTok(lexer)), this.configuration.getDefaultSymbolCapacity())) {
                    throw SqlException.$(position, "Duplicate column");
                }
                if (type == 11) {
                    boolean cached;
                    int symbolCapacity;
                    tok = this.tok(lexer, "'capacity', 'nocache', 'cache', 'index' or ')'");
                    if (Chars.equalsLowerCaseAscii(tok, "capacity")) {
                        symbolCapacity = this.parseSymbolCapacity(lexer);
                        model.symbolCapacity(symbolCapacity);
                        tok = this.tok(lexer, "'nocache', 'cache', 'index' or ')'");
                    } else {
                        symbolCapacity = -1;
                    }
                    if (Chars.equalsLowerCaseAscii(tok, "nocache")) {
                        cached = false;
                    } else if (Chars.equalsLowerCaseAscii(tok, "cache")) {
                        cached = true;
                    } else {
                        cached = this.configuration.getDefaultSymbolCacheFlag();
                        lexer.unparse();
                    }
                    model.cached(cached);
                    if (cached && symbolCapacity != -1) {
                        TableUtils.validateSymbolCapacityCached(true, symbolCapacity, lexer.lastTokenPosition());
                    }
                    tok = this.parseCreateTableInlineIndexDef(lexer, model);
                } else {
                    tok = null;
                }
                if (tok == null) {
                    tok = this.tok(lexer, "',' or ')'");
                }
                if (Chars.equals(tok, ')')) break block12;
            } while (Chars.equals(tok, ','));
            throw SqlParser.err(lexer, "',' or ')' expected");
        }
    }

    private void parseCreateTableIndexDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        this.expectTok(lexer, '(');
        int columnIndex = this.getCreateTableColumnIndex(model, this.expectLiteral((GenericLexer)lexer).token, lexer.lastTokenPosition());
        if (Chars.equalsLowerCaseAscii(this.tok(lexer, "'capacity'"), "capacity")) {
            int errorPosition = lexer.getPosition();
            int indexValueBlockSize = this.expectInt(lexer);
            TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
            model.setIndexFlags(columnIndex, true, Numbers.ceilPow2(indexValueBlockSize));
        } else {
            model.setIndexFlags(columnIndex, true, this.configuration.getIndexValueBlockSize());
            lexer.unparse();
        }
        this.expectTok(lexer, ')');
    }

    private CharSequence parseCreateTableInlineIndexDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        CharSequence tok = this.tok(lexer, "')', or 'index'");
        if (this.isFieldTerm(tok)) {
            model.setIndexFlags(false, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "index");
        tok = this.tok(lexer, ") | , expected");
        if (this.isFieldTerm(tok)) {
            model.setIndexFlags(true, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "capacity");
        int errorPosition = lexer.getPosition();
        int indexValueBlockSize = this.expectInt(lexer);
        TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
        model.setIndexFlags(true, Numbers.ceilPow2(indexValueBlockSize));
        return null;
    }

    private ExpressionNode parseCreateTablePartition(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (Chars.equalsLowerCaseAsciiNc(tok, "partition")) {
            this.expectTok(lexer, "by");
            return this.expectLiteral(lexer);
        }
        return null;
    }

    private QueryModel parseDml(GenericLexer lexer) throws SqlException {
        QueryModel model = null;
        QueryModel prevModel = null;
        while (true) {
            QueryModel unionModel = this.parseDml0(lexer);
            if (prevModel == null) {
                prevModel = model = unionModel;
            } else {
                prevModel.setUnionModel(unionModel);
                prevModel = unionModel;
            }
            CharSequence tok = this.optTok(lexer);
            if (tok == null || !Chars.equalsLowerCaseAscii(tok, "union")) {
                lexer.unparse();
                return model;
            }
            tok = this.tok(lexer, "all or select");
            if (Chars.equalsLowerCaseAscii(tok, "all")) {
                if (!model.isDistinct()) {
                    prevModel.setUnionModelType(0);
                    continue;
                }
                prevModel.setUnionModelType(1);
                continue;
            }
            prevModel.setUnionModelType(1);
            lexer.unparse();
        }
    }

    @NotNull
    private QueryModel parseDml0(GenericLexer lexer) throws SqlException {
        int modelPosition = lexer.getPosition();
        QueryModel model = this.queryModelPool.next();
        model.setModelPosition(modelPosition);
        CharSequence tok = this.tok(lexer, "'select', 'with' or table name expected");
        if (Chars.equalsLowerCaseAscii(tok, "with")) {
            this.parseWithClauses(lexer, model);
            tok = this.tok(lexer, "'select' or table name expected");
        }
        if (Chars.equalsLowerCaseAscii(tok, "select")) {
            this.parseSelectClause(lexer, model);
        } else {
            lexer.unparse();
            model.addBottomUpColumn(SqlUtil.nextColumn(this.queryColumnPool, this.sqlNodePool, "*", "*"));
        }
        QueryModel nestedModel = this.queryModelPool.next();
        nestedModel.setModelPosition(modelPosition);
        this.parseFromClause(lexer, nestedModel, model);
        if (nestedModel.getLimitHi() != null || nestedModel.getLimitLo() != null) {
            model.setLimit(nestedModel.getLimitLo(), nestedModel.getLimitHi());
            nestedModel.setLimit(null, null);
        }
        model.setSelectModelType(1);
        model.setNestedModel(nestedModel);
        return model;
    }

    private void parseFromClause(GenericLexer lexer, QueryModel model, QueryModel masterModel) throws SqlException {
        int joinType;
        CharSequence tok = this.expectTableNameOrSubQuery(lexer);
        if (Chars.equals(tok, '(')) {
            ExpressionNode timestamp;
            model.setNestedModel(this.parseAsSubQueryAndExpectClosingBrace(lexer));
            model.setNestedModelIsSubQuery(true);
            tok = this.optTok(lexer);
            if (tok != null && tableAliasStop.excludes(tok)) {
                model.setAlias(this.literal(lexer, tok));
                tok = this.optTok(lexer);
            }
            if ((timestamp = this.parseTimestamp(lexer, tok)) != null) {
                model.setTimestamp(timestamp);
                tok = this.optTok(lexer);
            }
        } else {
            ExpressionNode timestamp;
            lexer.unparse();
            this.parseSelectFrom(lexer, model, masterModel);
            tok = this.optTok(lexer);
            if (tok != null && tableAliasStop.excludes(tok)) {
                model.setAlias(this.literal(lexer, tok));
                tok = this.optTok(lexer);
            }
            if ((timestamp = this.parseTimestamp(lexer, tok)) != null) {
                model.setTimestamp(timestamp);
                tok = this.optTok(lexer);
            }
            if (Chars.equalsLowerCaseAsciiNc(tok, "latest")) {
                this.parseLatestBy(lexer, model);
                tok = this.optTok(lexer);
            }
        }
        while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
            model.addJoinModel(this.parseJoin(lexer, tok, joinType, masterModel));
            tok = this.optTok(lexer);
        }
        if (tok != null && Chars.equalsLowerCaseAscii(tok, "where")) {
            model.setWhereClause(this.expr(lexer, model));
            tok = this.optTok(lexer);
        }
        if (tok != null && Chars.equalsLowerCaseAscii(tok, "sample")) {
            this.expectTok(lexer, "by");
            model.setSampleBy(this.expectLiteral(lexer));
            tok = this.optTok(lexer);
            if (tok != null && Chars.equalsLowerCaseAscii(tok, "fill")) {
                this.expectTok(lexer, '(');
                while (true) {
                    ExpressionNode fillNode = this.expectLiteral(lexer, "'none', 'prev', 'mid', 'null' or number");
                    model.addSampleByFill(fillNode);
                    tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                    if (Chars.equals(tok, ')')) break;
                    this.expectTok(tok, lexer.lastTokenPosition(), ',');
                }
                tok = this.optTok(lexer);
            }
        }
        if (tok != null && Chars.equalsLowerCaseAscii(tok, "order")) {
            this.expectTok(lexer, "by");
            do {
                ExpressionNode n = this.expectLiteral(lexer);
                tok = this.optTok(lexer);
                if (tok != null && Chars.equalsLowerCaseAscii(tok, "desc")) {
                    model.addOrderBy(n, 1);
                    tok = this.optTok(lexer);
                } else {
                    model.addOrderBy(n, 0);
                    if (tok != null && Chars.equalsLowerCaseAscii(tok, "asc")) {
                        tok = this.optTok(lexer);
                    }
                }
                if (model.getOrderBy().size() < 1560) continue;
                throw SqlParser.err(lexer, "Too many columns");
            } while (tok != null && Chars.equals(tok, ','));
        }
        if (tok != null && Chars.equalsLowerCaseAscii(tok, "limit")) {
            ExpressionNode lo = this.expr(lexer, model);
            ExpressionNode hi = null;
            tok = this.optTok(lexer);
            if (tok != null && Chars.equals(tok, ',')) {
                hi = this.expr(lexer, model);
            } else {
                lexer.unparse();
            }
            model.setLimit(lo, hi);
        } else {
            lexer.unparse();
        }
    }

    private ExecutionModel parseInsert(GenericLexer lexer) throws SqlException {
        this.expectTok(lexer, "into");
        InsertModel model = this.insertModelPool.next();
        model.setTableName(this.expectLiteral(lexer));
        CharSequence tok = this.tok(lexer, "'(' or 'select'");
        if (Chars.equals(tok, '(')) {
            do {
                if (Chars.equals(tok = this.tok(lexer, "column"), ')')) {
                    throw SqlParser.err(lexer, "missing column name");
                }
                if (model.addColumn(GenericLexer.immutableOf(tok), lexer.lastTokenPosition())) continue;
                throw SqlException.position(lexer.lastTokenPosition()).put("duplicate column name: ").put(tok);
            } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
            this.expectTok(tok, lexer.lastTokenPosition(), ')');
            tok = this.optTok(lexer);
        }
        if (tok == null) {
            throw SqlException.$(lexer.getPosition(), "'select' or 'values' expected");
        }
        if (Chars.equalsLowerCaseAscii(tok, "select")) {
            model.setSelectKeywordPosition(lexer.lastTokenPosition());
            lexer.unparse();
            QueryModel queryModel = this.parseDml(lexer);
            model.setQueryModel(queryModel);
            return model;
        }
        if (Chars.equalsLowerCaseAscii(tok, "values")) {
            this.expectTok(lexer, '(');
            do {
                ExpressionNode expr = this.expectExpr(lexer);
                if (Chars.equals(expr.token, ')')) {
                    throw SqlParser.err(lexer, "missing column value");
                }
                model.addColumnValue(expr);
            } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
            this.expectTok(tok, lexer.lastTokenPosition(), ')');
            model.setEndOfValuesPosition(lexer.lastTokenPosition());
            return model;
        }
        throw SqlParser.err(lexer, "'select' or 'values' expected");
    }

    private QueryModel parseJoin(GenericLexer lexer, CharSequence tok, int joinType, QueryModel parent) throws SqlException {
        QueryModel joinModel = this.queryModelPool.next();
        joinModel.setJoinType(joinType);
        joinModel.setJoinKeywordPosition(lexer.lastTokenPosition());
        if (!Chars.equalsLowerCaseAscii(tok, "join")) {
            this.expectTok(lexer, "join");
        }
        if (Chars.equals(tok = this.expectTableNameOrSubQuery(lexer), '(')) {
            joinModel.setNestedModel(this.parseAsSubQueryAndExpectClosingBrace(lexer));
        } else {
            lexer.unparse();
            this.parseSelectFrom(lexer, joinModel, parent);
        }
        tok = this.optTok(lexer);
        if (tok != null && tableAliasStop.excludes(tok)) {
            lexer.unparse();
            joinModel.setAlias(this.literal(lexer, this.optTok(lexer)));
        } else {
            lexer.unparse();
        }
        tok = this.optTok(lexer);
        if (joinType == 3 && tok != null && Chars.equalsLowerCaseAscii(tok, "on")) {
            throw SqlException.$(lexer.lastTokenPosition(), "Cross joins cannot have join clauses");
        }
        block1 : switch (joinType) {
            case 4: 
            case 5: {
                if (tok == null || !Chars.equalsLowerCaseAscii(tok, "on")) {
                    lexer.unparse();
                    break;
                }
            }
            case 1: 
            case 2: {
                this.expectTok(lexer, tok, "on");
                try {
                    this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder);
                    switch (this.expressionTreeBuilder.size()) {
                        case 0: {
                            throw SqlException.$(lexer.lastTokenPosition(), "Expression expected");
                        }
                        case 1: {
                            ExpressionNode expr = this.expressionTreeBuilder.poll();
                            if (expr.type == 4) {
                                do {
                                    joinModel.addJoinColumn(expr);
                                } while ((expr = this.expressionTreeBuilder.poll()) != null);
                                break;
                            }
                            joinModel.setJoinCriteria(this.rewriteCase(this.rewriteCount(expr)));
                            break;
                        }
                        default: {
                            ExpressionNode expr;
                            while ((expr = this.expressionTreeBuilder.poll()) != null) {
                                if (expr.type != 4) {
                                    throw SqlException.$(lexer.lastTokenPosition(), "Column name expected");
                                }
                                joinModel.addJoinColumn(expr);
                            }
                            break block1;
                        }
                    }
                    break;
                }
                catch (SqlException e) {
                    this.expressionTreeBuilder.reset();
                    throw e;
                }
            }
            default: {
                lexer.unparse();
            }
        }
        return joinModel;
    }

    private void parseLatestBy(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        this.expectTok(lexer, "by");
        do {
            model.addLatestBy(this.expectLiteral(lexer));
        } while (Chars.equalsNc(tok = SqlUtil.fetchNext(lexer), ','));
        if (tok != null) {
            lexer.unparse();
        }
    }

    private ExecutionModel parseRenameStatement(GenericLexer lexer) throws SqlException {
        this.expectTok(lexer, "table");
        RenameTableModel model = this.renameTableModelPool.next();
        ExpressionNode e = this.expectExpr(lexer);
        if (e.type != 4 && e.type != 2) {
            throw SqlException.$(e.position, "literal or constant expected");
        }
        model.setFrom(e);
        this.expectTok(lexer, "to");
        e = this.expectExpr(lexer);
        if (e.type != 4 && e.type != 2) {
            throw SqlException.$(e.position, "literal or constant expected");
        }
        model.setTo(e);
        return model;
    }

    private ExecutionModel parseSelect(GenericLexer lexer) throws SqlException {
        lexer.unparse();
        QueryModel model = this.parseDml(lexer);
        CharSequence tok = this.optTok(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSelectClause(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        do {
            CharSequence alias;
            ExpressionNode expr;
            char last;
            if (Chars.equalsLowerCaseAscii(tok = this.tok(lexer, "[distinct] column"), "distinct")) {
                model.setDistinct(true);
                tok = this.tok(lexer, "column");
            }
            if ((last = tok.charAt(tok.length() - 1)) == '*') {
                expr = this.nextLiteral(GenericLexer.immutableOf(tok), lexer.lastTokenPosition());
            } else if (last == '.') {
                int pos = lexer.lastTokenPosition() + tok.length();
                CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
                characterStoreEntry.put(tok);
                tok = this.tok(lexer, "*");
                if (!Chars.equals(tok, '*')) throw SqlException.$(pos, "'*' expected");
                if (lexer.lastTokenPosition() > pos) {
                    throw SqlException.$(pos, "whitespace is not allowed");
                }
                characterStoreEntry.put('*');
                expr = this.nextLiteral(characterStoreEntry.toImmutable(), lexer.lastTokenPosition());
            } else {
                if (Chars.equalsLowerCaseAscii(tok, "from")) {
                    throw SqlException.$(lexer.getPosition(), "column name expected");
                }
                if (Chars.equalsLowerCaseAscii(tok, "select")) {
                    throw SqlException.$(lexer.getPosition(), "reserved name");
                }
                lexer.unparse();
                expr = this.expr(lexer, model);
                if (expr == null) {
                    throw SqlException.$(lexer.lastTokenPosition(), "missing expression");
                }
            }
            tok = this.tok(lexer, "',', 'from', 'over' or literal");
            if (columnAliasStop.excludes(tok)) {
                if (Chars.indexOf(tok, '.') != -1) {
                    throw SqlException.$(lexer.lastTokenPosition(), "'.' is not allowed here");
                }
                alias = Chars.equalsLowerCaseAscii(tok, "as") ? GenericLexer.unquote(GenericLexer.immutableOf(this.tok(lexer, "alias"))) : GenericLexer.immutableOf(tok);
                tok = this.tok(lexer, "',', 'from' or 'over'");
            } else {
                alias = this.createColumnAlias(expr, model);
            }
            if (Chars.equalsLowerCaseAscii(tok, "over")) {
                this.expectTok(lexer, '(');
                AnalyticColumn col = this.analyticColumnPool.next().of(alias, expr);
                tok = this.tok(lexer, "'");
                if (Chars.equalsLowerCaseAscii(tok, "partition")) {
                    this.expectTok(lexer, "by");
                    ObjList<ExpressionNode> partitionBy = col.getPartitionBy();
                    do {
                        partitionBy.add(this.expectLiteral(lexer));
                    } while (Chars.equals(tok = this.tok(lexer, "'order' or ')'"), ','));
                }
                if (Chars.equalsLowerCaseAscii(tok, "order")) {
                    this.expectTok(lexer, "by");
                    do {
                        ExpressionNode e = this.expectLiteral(lexer);
                        tok = this.tok(lexer, "'asc' or 'desc'");
                        if (Chars.equalsLowerCaseAscii(tok, "desc")) {
                            col.addOrderBy(e, 1);
                            tok = this.tok(lexer, "',' or ')'");
                            continue;
                        }
                        col.addOrderBy(e, 0);
                        if (!Chars.equalsLowerCaseAscii(tok, "asc")) continue;
                        tok = this.tok(lexer, "',' or ')'");
                    } while (Chars.equals(tok, ','));
                }
                this.expectTok(tok, lexer.lastTokenPosition(), ')');
                model.addBottomUpColumn(col);
                tok = this.tok(lexer, "'from' or ','");
            } else {
                if (expr.type == 65) {
                    throw SqlException.$(expr.position, "query is not expected, did you mean column?");
                }
                model.addBottomUpColumn(this.queryColumnPool.next().of(alias, expr));
            }
            if (Chars.equalsLowerCaseAscii(tok, "from")) return;
        } while (Chars.equals(tok, ','));
        throw SqlParser.err(lexer, "',' or 'from' expected");
    }

    private void parseSelectFrom(GenericLexer lexer, QueryModel model, QueryModel masterModel) throws SqlException {
        ExpressionNode expr = this.expr(lexer, model);
        if (expr == null) {
            throw SqlException.position(lexer.lastTokenPosition()).put("table name expected");
        }
        CharSequence name = expr.token;
        switch (expr.type) {
            case 2: 
            case 4: {
                ExpressionNode literal = this.literal(name, expr.position);
                WithClauseModel withClause = masterModel.getWithClause(name);
                if (withClause != null) {
                    model.setNestedModel(this.parseWith(lexer, withClause));
                    model.setAlias(literal);
                    break;
                }
                model.setTableName(literal);
                break;
            }
            case 8: {
                model.setTableName(expr);
                break;
            }
            default: {
                throw SqlException.$(expr.position, "function, literal or constant is expected");
            }
        }
    }

    private QueryModel parseAsSubQueryAndExpectClosingBrace(GenericLexer lexer) throws SqlException {
        QueryModel model = this.parseAsSubQuery(lexer);
        this.expectTok(lexer, ')');
        return model;
    }

    QueryModel parseAsSubQuery(GenericLexer lexer) throws SqlException {
        QueryModel model;
        this.subQueryMode = true;
        try {
            model = this.parseDml(lexer);
        }
        finally {
            this.subQueryMode = false;
        }
        return model;
    }

    private int parseSymbolCapacity(GenericLexer lexer) throws SqlException {
        int errorPosition = lexer.getPosition();
        int symbolCapacity = this.expectInt(lexer);
        TableUtils.validateSymbolCapacity(errorPosition, symbolCapacity);
        return Numbers.ceilPow2(symbolCapacity);
    }

    private ExpressionNode parseTimestamp(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (Chars.equalsLowerCaseAsciiNc(tok, "timestamp")) {
            this.expectTok(lexer, '(');
            ExpressionNode result = this.expectLiteral(lexer);
            this.tokIncludingLocalBrace(lexer, "')'");
            return result;
        }
        return null;
    }

    private QueryModel parseWith(GenericLexer lexer, WithClauseModel wcm) throws SqlException {
        QueryModel m = wcm.popModel();
        if (m != null) {
            return m;
        }
        int pos = lexer.getPosition();
        CharSequence unparsed = lexer.getUnparsed();
        lexer.goToPosition(wcm.getPosition(), null);
        m = this.parseAsSubQueryAndExpectClosingBrace(lexer);
        lexer.goToPosition(pos, unparsed);
        return m;
    }

    private void parseWithClauses(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        do {
            ExpressionNode name = this.expectLiteral(lexer);
            if (model.getWithClause(name.token) != null) {
                throw SqlException.$(name.position, "duplicate name");
            }
            this.expectTok(lexer, "as");
            this.expectTok(lexer, '(');
            int lo = lexer.lastTokenPosition();
            WithClauseModel wcm = this.withClauseModelPool.next();
            wcm.of(lo + 1, this.parseAsSubQueryAndExpectClosingBrace(lexer));
            model.addWithClause(name.token, wcm);
        } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        lexer.unparse();
    }

    private ExpressionNode rewriteCase(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCase0Ref);
        return parent;
    }

    private ExpressionNode rewriteCount(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCount0Ref);
        return parent;
    }

    private void rewriteCase0(ExpressionNode node) {
        if (node.type == 8 && Chars.equalsLowerCaseAscii(node.token, "case")) {
            int lim;
            ExpressionNode elseExpr;
            this.tempExprNodes.clear();
            ExpressionNode literal = null;
            boolean convertToSwitch = true;
            int paramCount = node.paramCount;
            if (node.paramCount == 2) {
                ExpressionNode that = node.rhs;
                node.of(that.type, that.token, that.precedence, that.position);
                node.paramCount = that.paramCount;
                if (that.paramCount == 2) {
                    node.lhs = that.lhs;
                    node.rhs = that.rhs;
                } else {
                    node.args.clear();
                    node.args.addAll(that.args);
                }
                return;
            }
            if ((paramCount & 1) == 0) {
                elseExpr = node.args.getQuick(0);
                lim = 0;
            } else {
                elseExpr = null;
                lim = -1;
            }
            ExpressionNode first = node.args.getQuick(paramCount - 1);
            if (first.token != null) {
                node.token = "switch";
                return;
            }
            for (int i = paramCount - 2; i > lim; --i) {
                if ((i & 1) == 1) {
                    this.tempExprNodes.add(node.args.getQuick(i));
                    continue;
                }
                ExpressionNode where = node.args.getQuick(i);
                if (where.type == 1 && where.token.charAt(0) == '=') {
                    ExpressionNode thisLiteral;
                    ExpressionNode thisConstant;
                    if (where.lhs.type == 2 && where.rhs.type == 4) {
                        thisConstant = where.lhs;
                        thisLiteral = where.rhs;
                    } else if (where.lhs.type == 4 && where.rhs.type == 2) {
                        thisConstant = where.rhs;
                        thisLiteral = where.lhs;
                    } else {
                        convertToSwitch = false;
                        break;
                    }
                    if (literal == null) {
                        literal = thisLiteral;
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    if (Chars.equals(literal.token, thisLiteral.token)) {
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    convertToSwitch = false;
                    break;
                }
                convertToSwitch = false;
                break;
            }
            if (convertToSwitch) {
                int n = this.tempExprNodes.size();
                node.token = "switch";
                node.args.clear();
                node.args.add(elseExpr);
                for (int i = n - 1; i > -1; --i) {
                    node.args.add(this.tempExprNodes.getQuick(i));
                }
                node.args.add(literal);
                node.paramCount = n + 2;
            } else {
                node.args.remove(paramCount - 1);
                node.paramCount = paramCount - 1;
            }
        }
    }

    private void rewriteCount0(ExpressionNode node) {
        if (node.type == 8 && Chars.equalsLowerCaseAscii(node.token, "count") && node.paramCount == 1) {
            ExpressionNode that = node.rhs;
            if (Chars.equals(that.token, '*') && that.rhs == null && node.lhs == null) {
                that.paramCount = 0;
                node.rhs = null;
                node.paramCount = 0;
            }
        }
    }

    private int toColumnType(GenericLexer lexer, CharSequence tok) throws SqlException {
        int type = ColumnType.columnTypeOf(tok);
        if (type == -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "unsupported column type: ").put(tok);
        }
        return type;
    }

    @NotNull
    private CharSequence tok(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    @NotNull
    private CharSequence tokIncludingLocalBrace(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    private void validateLiteral(int pos, CharSequence tok, String expectedList) throws SqlException {
        switch (tok.charAt(0)) {
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '`': {
                throw SqlException.position(pos).put(expectedList).put(" expected");
            }
        }
    }

    static {
        tableAliasStop.add("where");
        tableAliasStop.add("latest");
        tableAliasStop.add("join");
        tableAliasStop.add("inner");
        tableAliasStop.add("left");
        tableAliasStop.add("outer");
        tableAliasStop.add("asof");
        tableAliasStop.add("splice");
        tableAliasStop.add("cross");
        tableAliasStop.add("sample");
        tableAliasStop.add("order");
        tableAliasStop.add("on");
        tableAliasStop.add("timestamp");
        tableAliasStop.add("limit");
        tableAliasStop.add(")");
        tableAliasStop.add(";");
        tableAliasStop.add("union");
        columnAliasStop.add("from");
        columnAliasStop.add(",");
        columnAliasStop.add("over");
        groupByStopSet.add("order");
        groupByStopSet.add(")");
        groupByStopSet.add(",");
        joinStartSet.put("left", 1);
        joinStartSet.put("join", 1);
        joinStartSet.put("inner", 1);
        joinStartSet.put("outer", 2);
        joinStartSet.put("cross", 3);
        joinStartSet.put("asof", 4);
        joinStartSet.put("splice", 5);
    }
}

