/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.ObjectPool;

public class SqlUtil {
    static final CharSequenceHashSet disallowedAliases = new CharSequenceHashSet();

    public static CharSequence fetchNext(GenericLexer lexer) {
        int blockCount = 0;
        boolean lineComment = false;
        while (lexer.hasNext()) {
            CharSequence cs = lexer.next();
            if (lineComment) {
                if (!Chars.equals(cs, '\n') && !Chars.equals(cs, '\r')) continue;
                lineComment = false;
                continue;
            }
            if (Chars.equals((CharSequence)"--", cs)) {
                lineComment = true;
                continue;
            }
            if (Chars.equals((CharSequence)"/*", cs)) {
                ++blockCount;
                continue;
            }
            if (Chars.equals((CharSequence)"*/", cs) && blockCount > 0) {
                --blockCount;
                continue;
            }
            if (blockCount != 0 || !GenericLexer.WHITESPACE.excludes(cs)) continue;
            return cs;
        }
        return null;
    }

    static ExpressionNode nextLiteral(ObjectPool<ExpressionNode> pool, CharSequence token, int position) {
        return pool.next().of(4, token, 0, position);
    }

    static CharSequence createColumnAlias(CharacterStore store, CharSequence base, int indexOfDot, CharSequenceObjHashMap<QueryColumn> aliasToColumnMap) {
        CharSequence alias;
        boolean disallowed = disallowedAliases.contains(base);
        if (indexOfDot == -1 && !disallowed && aliasToColumnMap.excludes(base)) {
            return base;
        }
        CharacterStoreEntry characterStoreEntry = store.newEntry();
        if (indexOfDot == -1) {
            if (disallowed) {
                characterStoreEntry.put("column");
            } else {
                characterStoreEntry.put(base);
            }
        } else {
            characterStoreEntry.put(base, indexOfDot + 1, base.length());
        }
        int len = characterStoreEntry.length();
        int sequence = 0;
        do {
            if (sequence > 0) {
                characterStoreEntry.trimTo(len);
                characterStoreEntry.put(sequence);
            }
            ++sequence;
        } while (!aliasToColumnMap.excludes(alias = characterStoreEntry.toImmutable()));
        return alias;
    }

    static QueryColumn nextColumn(ObjectPool<QueryColumn> queryColumnPool, ObjectPool<ExpressionNode> sqlNodePool, CharSequence alias, CharSequence column) {
        return queryColumnPool.next().of(alias, SqlUtil.nextLiteral(sqlNodePool, column, 0));
    }

    static {
        int n = OperatorExpression.operators.size();
        for (int i = 0; i < n; ++i) {
            disallowedAliases.add(OperatorExpression.operators.getQuick((int)i).token);
        }
    }
}

