/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.AliasTranslator;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.microtime.DateFormatUtils;
import io.questdb.std.str.FlyweightCharSequence;
import java.util.ArrayDeque;

final class WhereClauseParser {
    private static final int INTRINCIC_OP_IN = 1;
    private static final int INTRINCIC_OP_GREATER = 2;
    private static final int INTRINCIC_OP_GREATER_EQ = 3;
    private static final int INTRINCIC_OP_LESS = 4;
    private static final int INTRINCIC_OP_LESS_EQ = 5;
    private static final int INTRINCIC_OP_EQUAL = 6;
    private static final int INTRINCIC_OP_NOT_EQ = 7;
    private static final int INTRINCIC_OP_NOT = 8;
    private static final CharSequenceIntHashMap intrinsicOps = new CharSequenceIntHashMap();
    private final ArrayDeque<ExpressionNode> stack = new ArrayDeque();
    private final ObjList<ExpressionNode> keyNodes = new ObjList();
    private final ObjList<ExpressionNode> keyExclNodes = new ObjList();
    private final ObjectPool<IntrinsicModel> models = new ObjectPool<IntrinsicModel>(IntrinsicModel.FACTORY, 8);
    private final CharSequenceHashSet tempKeys = new CharSequenceHashSet();
    private final IntList tempPos = new IntList();
    private final CharSequenceHashSet tempK = new CharSequenceHashSet();
    private final IntList tempP = new IntList();
    private final ObjectPool<FlyweightCharSequence> csPool = new ObjectPool<FlyweightCharSequence>(FlyweightCharSequence.FACTORY, 64);
    private CharSequence timestamp;
    private CharSequence preferredKeyColumn;

    WhereClauseParser() {
    }

    private static void checkNodeValid(ExpressionNode node) throws SqlException {
        if (node.lhs == null || node.rhs == null) {
            throw SqlException.$(node.position, "Argument expected");
        }
    }

    private boolean analyzeEquals(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        return this.analyzeEquals0(translator, model, node, node.lhs, node.rhs, m) || this.analyzeEquals0(translator, model, node, node.rhs, node.lhs, m);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean analyzeEquals0(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, ExpressionNode a, ExpressionNode b, RecordMetadata m) throws SqlException {
        if (Chars.equals(a.token, b.token)) {
            node.intrinsicValue = 1;
            return true;
        }
        if (a.type == 4 && b.type == 2) {
            if (this.isTimestamp(a)) {
                model.intersectIntervals(b.token, 1, b.token.length() - 1, b.position);
                node.intrinsicValue = 1;
                return true;
            }
            CharSequence column = translator.translateAlias(a.token);
            int index = m.getColumnIndexQuiet(column);
            if (index == -1) {
                throw SqlException.invalidColumn(a.position, a.token);
            }
            switch (m.getColumnType(index)) {
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    CharSequence value;
                    boolean preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, column);
                    boolean indexed = m.isColumnIndexed(index);
                    if (!preferred && (!indexed || this.preferredKeyColumn != null)) break;
                    CharSequence charSequence = value = Chars.equalsLowerCaseAscii(b.token, "null") ? null : this.unquote(b.token);
                    if (Chars.equalsIgnoreCaseNc(model.keyColumn, column)) {
                        if (!model.keyValues.contains(value)) {
                            model.intrinsicValue = 2;
                            return false;
                        }
                        if (model.keyValues.size() > 1) {
                            model.keyValues.clear();
                            model.keyValuePositions.clear();
                            model.keyValues.add(value);
                            model.keyValuePositions.add(b.position);
                        }
                    } else {
                        model.keyColumn = column;
                        model.keyValues.clear();
                        model.keyValuePositions.clear();
                        model.keyValues.add(value);
                        model.keyValuePositions.add(b.position);
                        int k = this.keyNodes.size();
                        for (int n = 0; n < k; ++n) {
                            this.keyNodes.getQuick((int)n).intrinsicValue = 0;
                        }
                        this.keyNodes.clear();
                    }
                    this.keyNodes.add(node);
                    node.intrinsicValue = 1;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean analyzeGreater(IntrinsicModel model, ExpressionNode node, int increment) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        if (Chars.equals(node.lhs.token, node.rhs.token)) {
            model.intrinsicValue = 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && Chars.equals(node.lhs.token, this.timestamp)) {
            if (node.rhs.type != 2) {
                return false;
            }
            try {
                model.intersectIntervals(DateFormatUtils.tryParse(node.rhs.token, 1, node.rhs.token.length() - 1), Long.MAX_VALUE);
                node.intrinsicValue = 1;
                return true;
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(node.rhs.position);
            }
        }
        if (node.rhs.type == 4 && Chars.equals(node.rhs.token, this.timestamp)) {
            if (node.lhs.type != 2) {
                return false;
            }
            try {
                model.intersectIntervals(Long.MIN_VALUE, DateFormatUtils.tryParse(node.lhs.token, 1, node.lhs.token.length() - 1) - (long)increment);
                return true;
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(node.lhs.position);
            }
        }
        return false;
    }

    private boolean analyzeIn(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        ExpressionNode col;
        if (node.paramCount < 2) {
            throw SqlException.$(node.position, "Too few arguments for 'in'");
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (metadata.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        return this.analyzeInInterval(model, col, node) || this.analyzeListOfValues(model, column, metadata, node) || this.analyzeInLambda(model, column, metadata, node);
    }

    private boolean analyzeInInterval(IntrinsicModel model, ExpressionNode col, ExpressionNode in) throws SqlException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        if (in.paramCount > 3) {
            throw SqlException.$(in.args.getQuick((int)0).position, "Too many args");
        }
        if (in.paramCount < 3) {
            throw SqlException.$(in.position, "Too few args");
        }
        ExpressionNode lo = in.args.getQuick(1);
        ExpressionNode hi = in.args.getQuick(0);
        if (lo.type == 2 && hi.type == 2) {
            long hiMillis;
            long loMillis;
            try {
                loMillis = DateFormatUtils.tryParse(lo.token, 1, lo.token.length() - 1);
            }
            catch (NumericException ignore) {
                throw SqlException.invalidDate(lo.position);
            }
            try {
                hiMillis = DateFormatUtils.tryParse(hi.token, 1, hi.token.length() - 1);
            }
            catch (NumericException ignore) {
                throw SqlException.invalidDate(hi.position);
            }
            model.intersectIntervals(loMillis, hiMillis);
            in.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeInLambda(IntrinsicModel model, CharSequence columnName, RecordMetadata meta, ExpressionNode node) throws SqlException {
        int columnIndex = meta.getColumnIndex(columnName);
        boolean preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, columnName);
        if (preferred || this.preferredKeyColumn == null && meta.isColumnIndexed(columnIndex)) {
            if (this.preferredKeyColumn != null && !Chars.equalsIgnoreCase(columnName, this.preferredKeyColumn)) {
                return false;
            }
            if (node.rhs == null || node.rhs.type != 65) {
                return false;
            }
            if (model.keyColumn != null && !Chars.equalsIgnoreCase(model.keyColumn, columnName) && meta.getIndexValueBlockCapacity(columnIndex) <= meta.getIndexValueBlockCapacity(model.keyColumn)) {
                return false;
            }
            if (Chars.equalsIgnoreCaseNc(model.keyColumn, columnName) && model.keySubQuery != null || node.paramCount > 2) {
                throw SqlException.$(node.position, "Multiple lambda expressions not supported");
            }
            model.keyValues.clear();
            model.keyValuePositions.clear();
            model.keyValuePositions.add(node.position);
            model.keySubQuery = node.rhs.queryModel;
            int k = this.keyNodes.size();
            for (int n = 0; n < k; ++n) {
                this.keyNodes.getQuick((int)n).intrinsicValue = 0;
            }
            this.keyNodes.clear();
            model.keyColumn = columnName;
            this.keyNodes.add(node);
            node.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeLess(IntrinsicModel model, ExpressionNode node, int inc) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        if (Chars.equals(node.lhs.token, node.rhs.token)) {
            model.intrinsicValue = 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && Chars.equals(node.lhs.token, this.timestamp)) {
            try {
                if (node.rhs.type != 2) {
                    return false;
                }
                long hi = DateFormatUtils.tryParse(node.rhs.token, 1, node.rhs.token.length() - 1) - (long)inc;
                model.intersectIntervals(Long.MIN_VALUE, hi);
                node.intrinsicValue = 1;
                return true;
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(node.rhs.position);
            }
        }
        if (node.rhs.type == 4 && Chars.equals(node.rhs.token, this.timestamp)) {
            try {
                if (node.lhs.type != 2) {
                    return false;
                }
                long lo = DateFormatUtils.tryParse(node.lhs.token, 1, node.lhs.token.length() - 1);
                model.intersectIntervals(lo, Long.MAX_VALUE);
                node.intrinsicValue = 1;
                return true;
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(node.lhs.position);
            }
        }
        return false;
    }

    private boolean analyzeListOfValues(IntrinsicModel model, CharSequence columnName, RecordMetadata meta, ExpressionNode node) {
        int columnIndex = meta.getColumnIndex(columnName);
        boolean newColumn = true;
        boolean preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, columnName);
        if (preferred || this.preferredKeyColumn == null && meta.isColumnIndexed(columnIndex)) {
            if (model.keyColumn != null && (newColumn = !Chars.equals(model.keyColumn, columnName)) && meta.getIndexValueBlockCapacity(columnIndex) <= meta.getIndexValueBlockCapacity(model.keyColumn)) {
                return false;
            }
            int i = node.paramCount - 1;
            this.tempKeys.clear();
            this.tempPos.clear();
            if (i == 1) {
                if (node.rhs == null || node.rhs.type != 2) {
                    return false;
                }
                if (this.tempKeys.add(this.unquote(node.rhs.token))) {
                    this.tempPos.add(node.position);
                }
            } else {
                --i;
                while (i > -1) {
                    ExpressionNode c = node.args.getQuick(i);
                    if (c.type != 2) {
                        return false;
                    }
                    if (Chars.equalsLowerCaseAscii(c.token, "null")) {
                        if (this.tempKeys.add(null)) {
                            this.tempPos.add(c.position);
                        }
                    } else if (this.tempKeys.add(this.unquote(c.token))) {
                        this.tempPos.add(c.position);
                    }
                    --i;
                }
            }
            if (newColumn) {
                model.keyValues.clear();
                model.keyValuePositions.clear();
                model.keyValues.addAll(this.tempKeys);
                model.keyValuePositions.addAll(this.tempPos);
                int k = this.keyNodes.size();
                for (int n = 0; n < k; ++n) {
                    this.keyNodes.getQuick((int)n).intrinsicValue = 0;
                }
                this.keyNodes.clear();
                model.keyColumn = columnName;
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
            if (model.keySubQuery == null) {
                this.replaceAllWithOverlap(model);
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private boolean analyzeNotEquals(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        return this.analyzeNotEquals0(translator, model, node, node.lhs, node.rhs, m) || this.analyzeNotEquals0(translator, model, node, node.rhs, node.lhs, m);
    }

    private boolean analyzeNotEquals0(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, ExpressionNode a, ExpressionNode b, RecordMetadata m) throws SqlException {
        if (Chars.equals(a.token, b.token)) {
            model.intrinsicValue = 2;
            return true;
        }
        if (a.type == 4 && b.type == 2) {
            if (this.isTimestamp(a)) {
                model.subtractIntervals(b.token, 1, b.token.length() - 1, b.position);
                node.intrinsicValue = 1;
                return true;
            }
            CharSequence column = translator.translateAlias(a.token);
            int index = m.getColumnIndexQuiet(column);
            if (index == -1) {
                throw SqlException.invalidColumn(a.position, a.token);
            }
            switch (m.getColumnType(index)) {
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    if (!m.isColumnIndexed(index)) break;
                    if (this.preferredKeyColumn != null && !Chars.equals(this.preferredKeyColumn, column)) {
                        return false;
                    }
                    this.keyExclNodes.add(node);
                    return false;
                }
            }
        }
        return false;
    }

    private boolean analyzeNotIn(AliasTranslator translator, IntrinsicModel model, ExpressionNode notNode, RecordMetadata m) throws SqlException {
        ExpressionNode col;
        ExpressionNode node = notNode.rhs;
        if (node.paramCount < 2) {
            throw SqlException.$(node.position, "Too few arguments for 'in'");
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            throw SqlException.$(col.position, "Column name expected");
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        boolean ok = this.analyzeNotInInterval(model, col, node);
        if (ok) {
            notNode.intrinsicValue = 1;
        } else {
            this.analyzeNotListOfValues(column, m, notNode);
        }
        return ok;
    }

    private boolean analyzeNotInInterval(IntrinsicModel model, ExpressionNode col, ExpressionNode in) throws SqlException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        if (in.paramCount > 3) {
            throw SqlException.$(in.args.getQuick((int)0).position, "Too many args");
        }
        if (in.paramCount < 3) {
            throw SqlException.$(in.position, "Too few args");
        }
        ExpressionNode lo = in.args.getQuick(1);
        ExpressionNode hi = in.args.getQuick(0);
        if (lo.type == 2 && hi.type == 2) {
            long hiMillis;
            long loMillis;
            try {
                loMillis = DateFormatUtils.tryParse(lo.token, 1, lo.token.length() - 1);
            }
            catch (NumericException ignore) {
                throw SqlException.invalidDate(lo.position);
            }
            try {
                hiMillis = DateFormatUtils.tryParse(hi.token, 1, hi.token.length() - 1);
            }
            catch (NumericException ignore) {
                throw SqlException.invalidDate(hi.position);
            }
            model.subtractIntervals(loMillis, hiMillis);
            in.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private void analyzeNotListOfValues(CharSequence columnName, RecordMetadata m, ExpressionNode notNode) {
        int columnIndex = m.getColumnIndex(columnName);
        switch (m.getColumnType(columnIndex)) {
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                if (!m.isColumnIndexed(columnIndex) || this.preferredKeyColumn != null && !Chars.equals(this.preferredKeyColumn, columnName)) break;
                this.keyExclNodes.add(notNode);
                break;
            }
        }
    }

    private void applyKeyExclusions(AliasTranslator translator, IntrinsicModel model) {
        if (model.keyColumn != null && this.keyExclNodes.size() > 0) {
            int n = this.keyExclNodes.size();
            block0: for (int i = 0; i < n; ++i) {
                ExpressionNode col;
                ExpressionNode node;
                ExpressionNode parent = this.keyExclNodes.getQuick(i);
                ExpressionNode expressionNode = node = Chars.equalsLowerCaseAscii(parent.token, "not") ? parent.rhs : parent;
                if (node.paramCount == 2) {
                    ExpressionNode val;
                    if (node.lhs.type == 4) {
                        col = node.lhs;
                        val = node.rhs;
                    } else {
                        col = node.rhs;
                        val = node.lhs;
                    }
                    CharSequence column = translator.translateAlias(col.token);
                    if (Chars.equals(column, model.keyColumn)) {
                        model.excludeValue(val);
                        parent.intrinsicValue = 1;
                        if (model.intrinsicValue == 2) break;
                    }
                }
                if (node.paramCount <= 2) continue;
                col = node.args.getQuick(node.paramCount - 1);
                CharSequence column = translator.translateAlias(col.token);
                if (!Chars.equals(column, model.keyColumn)) continue;
                for (int j = node.paramCount - 2; j > -1; --j) {
                    ExpressionNode val = node.args.getQuick(j);
                    model.excludeValue(val);
                    if (model.intrinsicValue == 2) break block0;
                }
                parent.intrinsicValue = 1;
            }
        }
        this.keyExclNodes.clear();
    }

    private ExpressionNode collapseIntrinsicNodes(ExpressionNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        node.lhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.lhs));
        node.rhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.rhs));
        return this.collapseNulls0(node);
    }

    private ExpressionNode collapseNulls0(ExpressionNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        if (node.queryModel == null && Chars.equalsLowerCaseAscii(node.token, "and")) {
            if (node.lhs == null || node.lhs.intrinsicValue == 1) {
                return node.rhs;
            }
            if (node.rhs == null || node.rhs.intrinsicValue == 1) {
                return node.lhs;
            }
        }
        return node;
    }

    IntrinsicModel extract(AliasTranslator translator, ExpressionNode node, RecordMetadata m, CharSequence preferredKeyColumn, int timestampIndex) throws SqlException {
        this.reset();
        this.timestamp = timestampIndex < 0 ? null : m.getColumnName(timestampIndex);
        this.preferredKeyColumn = preferredKeyColumn;
        IntrinsicModel model = this.models.next();
        if (this.removeAndIntrinsics(translator, model, node, m)) {
            return model;
        }
        ExpressionNode root = node;
        while (!this.stack.isEmpty() || node != null) {
            if (node != null) {
                if (Chars.equalsLowerCaseAscii(node.token, "and")) {
                    if (!this.removeAndIntrinsics(translator, model, node.rhs, m)) {
                        this.stack.push(node.rhs);
                    }
                    node = this.removeAndIntrinsics(translator, model, node.lhs, m) ? null : node.lhs;
                    continue;
                }
                node = this.stack.poll();
                continue;
            }
            node = this.stack.poll();
        }
        this.applyKeyExclusions(translator, model);
        model.filter = this.collapseIntrinsicNodes(root);
        return model;
    }

    private boolean isTimestamp(ExpressionNode n) {
        return this.timestamp != null && Chars.equals(this.timestamp, n.token);
    }

    private boolean removeAndIntrinsics(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m) throws SqlException {
        switch (intrinsicOps.get(node.token)) {
            case 1: {
                return this.analyzeIn(translator, model, node, m);
            }
            case 2: {
                return this.analyzeGreater(model, node, 1);
            }
            case 3: {
                return this.analyzeGreater(model, node, 0);
            }
            case 4: {
                return this.analyzeLess(model, node, 1);
            }
            case 5: {
                return this.analyzeLess(model, node, 0);
            }
            case 6: {
                return this.analyzeEquals(translator, model, node, m);
            }
            case 7: {
                return this.analyzeNotEquals(translator, model, node, m);
            }
            case 8: {
                return Chars.equalsLowerCaseAscii(node.rhs.token, "in") && this.analyzeNotIn(translator, model, node, m);
            }
        }
        return false;
    }

    private void replaceAllWithOverlap(IntrinsicModel model) {
        this.tempK.clear();
        this.tempP.clear();
        int k = this.tempKeys.size();
        for (int i = 0; i < k; ++i) {
            if (!model.keyValues.contains(this.tempKeys.get(i)) || !this.tempK.add(this.tempKeys.get(i))) continue;
            this.tempP.add(this.tempPos.get(i));
        }
        if (this.tempK.size() > 0) {
            model.keyValues.clear();
            model.keyValuePositions.clear();
            model.keyValues.addAll(this.tempK);
            model.keyValuePositions.addAll(this.tempP);
        } else {
            model.intrinsicValue = 2;
        }
    }

    void reset() {
        this.models.clear();
        this.stack.clear();
        this.keyNodes.clear();
        this.csPool.clear();
    }

    private CharSequence unquote(CharSequence value) {
        if (Chars.isQuoted(value)) {
            return this.csPool.next().of(value, 1, value.length() - 2);
        }
        return value;
    }

    static {
        intrinsicOps.put("in", 1);
        intrinsicOps.put(">", 2);
        intrinsicOps.put(">=", 3);
        intrinsicOps.put("<", 4);
        intrinsicOps.put("<=", 5);
        intrinsicOps.put("=", 6);
        intrinsicOps.put("!=", 7);
        intrinsicOps.put("not", 8);
    }
}

