/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.std.MemoryPages;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public abstract class AbstractRedBlackTree
implements Mutable,
Closeable {
    protected static final int O_LEFT = 8;
    private static final int BLOCK_SIZE = 33;
    private static final int O_RIGHT = 16;
    private static final int O_COLOUR = 24;
    private static final int O_REF = 25;
    private static final byte RED = 1;
    private static final byte BLACK = 0;
    protected final MemoryPages mem;
    protected long root = -1L;

    public AbstractRedBlackTree(long keyPageSize) {
        this.mem = new MemoryPages(keyPageSize);
    }

    @Override
    public void clear() {
        this.root = -1L;
        this.mem.clear();
    }

    @Override
    public void close() {
        Misc.free(this.mem);
    }

    public long size() {
        return this.mem.size() / (long)this.getBlockSize();
    }

    protected static void setLeft(long blockAddress, long left) {
        Unsafe.getUnsafe().putLong(blockAddress + 8L, left);
    }

    protected static long rightOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 16L);
    }

    protected static long leftOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 8L);
    }

    protected static void setParent(long blockAddress, long parent) {
        Unsafe.getUnsafe().putLong(blockAddress, parent);
    }

    protected static long refOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 25L);
    }

    protected static void setRef(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 25L, recRef);
    }

    protected static void setRight(long blockAddress, long right) {
        Unsafe.getUnsafe().putLong(blockAddress + 16L, right);
    }

    protected static long parentOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress);
    }

    protected static long parent2Of(long blockAddress) {
        return AbstractRedBlackTree.parentOf(AbstractRedBlackTree.parentOf(blockAddress));
    }

    protected static void setColor(long blockAddress, byte colour) {
        Unsafe.getUnsafe().putByte(blockAddress + 24L, colour);
    }

    protected static byte colorOf(long blockAddress) {
        return blockAddress == -1L ? (byte)0 : Unsafe.getUnsafe().getByte(blockAddress + 24L);
    }

    protected static long successor(long current) {
        long p = AbstractRedBlackTree.rightOf(current);
        if (p != -1L) {
            long l;
            while ((l = AbstractRedBlackTree.leftOf(p)) != -1L) {
                p = l;
            }
        } else {
            p = AbstractRedBlackTree.parentOf(current);
            long ch = current;
            while (p != -1L && ch == AbstractRedBlackTree.rightOf(p)) {
                ch = p;
                p = AbstractRedBlackTree.parentOf(p);
            }
        }
        return p;
    }

    protected long allocateBlock() {
        long p = this.mem.allocate(this.getBlockSize());
        AbstractRedBlackTree.setLeft(p, -1L);
        AbstractRedBlackTree.setRight(p, -1L);
        AbstractRedBlackTree.setColor(p, (byte)0);
        return p;
    }

    protected void fix(long x) {
        long px;
        AbstractRedBlackTree.setColor(x, (byte)1);
        while (x != -1L && x != this.root && AbstractRedBlackTree.colorOf(px = AbstractRedBlackTree.parentOf(x)) == 1) {
            long y;
            long p20x = AbstractRedBlackTree.parent2Of(x);
            if (px == AbstractRedBlackTree.leftOf(p20x)) {
                y = AbstractRedBlackTree.rightOf(p20x);
                if (AbstractRedBlackTree.colorOf(y) == 1) {
                    AbstractRedBlackTree.setColor(px, (byte)0);
                    AbstractRedBlackTree.setColor(y, (byte)0);
                    AbstractRedBlackTree.setColor(p20x, (byte)1);
                    x = p20x;
                    continue;
                }
                if (x == AbstractRedBlackTree.rightOf(px)) {
                    x = px;
                    this.rotateLeft(x);
                    px = AbstractRedBlackTree.parentOf(x);
                    p20x = AbstractRedBlackTree.parent2Of(x);
                }
                AbstractRedBlackTree.setColor(px, (byte)0);
                AbstractRedBlackTree.setColor(p20x, (byte)1);
                this.rotateRight(p20x);
                continue;
            }
            y = AbstractRedBlackTree.leftOf(p20x);
            if (AbstractRedBlackTree.colorOf(y) == 1) {
                AbstractRedBlackTree.setColor(px, (byte)0);
                AbstractRedBlackTree.setColor(y, (byte)0);
                AbstractRedBlackTree.setColor(p20x, (byte)1);
                x = p20x;
                continue;
            }
            if (x == AbstractRedBlackTree.leftOf(px)) {
                x = AbstractRedBlackTree.parentOf(x);
                this.rotateRight(x);
                px = AbstractRedBlackTree.parentOf(x);
                p20x = AbstractRedBlackTree.parent2Of(x);
            }
            AbstractRedBlackTree.setColor(px, (byte)0);
            AbstractRedBlackTree.setColor(p20x, (byte)1);
            this.rotateLeft(p20x);
        }
        AbstractRedBlackTree.setColor(this.root, (byte)0);
    }

    protected int getBlockSize() {
        return 33;
    }

    protected void putParent(long value) {
        this.root = this.allocateBlock();
        AbstractRedBlackTree.setRef(this.root, value);
        AbstractRedBlackTree.setParent(this.root, -1L);
    }

    private void rotateLeft(long p) {
        if (p != -1L) {
            long r = AbstractRedBlackTree.rightOf(p);
            long lr = AbstractRedBlackTree.leftOf(r);
            AbstractRedBlackTree.setRight(p, lr);
            if (lr != -1L) {
                AbstractRedBlackTree.setParent(lr, p);
            }
            long pp = AbstractRedBlackTree.parentOf(p);
            AbstractRedBlackTree.setParent(r, pp);
            if (pp == -1L) {
                this.root = r;
            } else if (AbstractRedBlackTree.leftOf(pp) == p) {
                AbstractRedBlackTree.setLeft(pp, r);
            } else {
                AbstractRedBlackTree.setRight(pp, r);
            }
            AbstractRedBlackTree.setLeft(r, p);
            AbstractRedBlackTree.setParent(p, r);
        }
    }

    private void rotateRight(long p) {
        if (p != -1L) {
            long l = AbstractRedBlackTree.leftOf(p);
            long rl = AbstractRedBlackTree.rightOf(l);
            AbstractRedBlackTree.setLeft(p, rl);
            if (rl != -1L) {
                AbstractRedBlackTree.setParent(rl, p);
            }
            long pp = AbstractRedBlackTree.parentOf(p);
            AbstractRedBlackTree.setParent(l, pp);
            if (pp == -1L) {
                this.root = l;
            } else if (AbstractRedBlackTree.rightOf(pp) == p) {
                AbstractRedBlackTree.setRight(pp, l);
            } else {
                AbstractRedBlackTree.setLeft(pp, l);
            }
            AbstractRedBlackTree.setRight(l, p);
            AbstractRedBlackTree.setParent(p, l);
        }
    }
}

