/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public abstract class AbstractVirtualFunctionRecordCursor
implements RecordCursor {
    protected final VirtualRecord recordA;
    private final VirtualRecord recordB;
    protected RecordCursor baseCursor;

    public AbstractVirtualFunctionRecordCursor(ObjList<Function> functions, boolean supportsRandomAccess) {
        this.recordA = new VirtualRecord(functions);
        this.recordB = supportsRandomAccess ? new VirtualRecord(functions) : null;
    }

    @Override
    public void close() {
        Misc.free(this.baseCursor);
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public boolean hasNext() {
        return this.baseCursor.hasNext();
    }

    @Override
    public long size() {
        return this.baseCursor.size();
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.baseCursor.recordAt(((VirtualRecord)record).getBaseRecord(), atRowId);
    }

    @Override
    public void toTop() {
        this.baseCursor.toTop();
    }

    public void of(RecordCursor cursor) {
        this.baseCursor = cursor;
        this.recordA.of(this.baseCursor.getRecord());
        if (this.recordB != null) {
            this.recordB.of(this.baseCursor.getRecordB());
        }
    }
}

