/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import org.jetbrains.annotations.Nullable;

public class LimitRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final LimitRecordCursor cursor;

    public LimitRecordCursorFactory(RecordCursorFactory base, Function loFunction, @Nullable Function hiFunction) {
        super(base.getMetadata());
        this.base = base;
        this.cursor = new LimitRecordCursor(loFunction, hiFunction);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.base.getCursor(executionContext), executionContext);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    private static class LimitRecordCursor
    implements RecordCursor {
        private final Function loFunction;
        private final Function hiFunction;
        private RecordCursor base;
        private long limit;
        private long size;

        public LimitRecordCursor(Function loFunction, Function hiFunction) {
            this.loFunction = loFunction;
            this.hiFunction = hiFunction;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public long size() {
            if (this.size > -1L) {
                return this.size;
            }
            return -1L;
        }

        @Override
        public Record getRecord() {
            return this.base.getRecord();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            return this.limit-- > 0L && this.base.hasNext();
        }

        @Override
        public Record getRecordB() {
            return this.base.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(record, atRowId);
        }

        public void of(RecordCursor base, SqlExecutionContext executionContext) {
            this.base = base;
            this.loFunction.init(base, executionContext);
            if (this.hiFunction != null) {
                this.hiFunction.init(base, executionContext);
            }
            this.toTop();
        }

        @Override
        public void toTop() {
            this.base.toTop();
            long lo = this.loFunction.getLong(null);
            if (lo < 0L && this.hiFunction == null) {
                long count = this.countRows();
                this.base.toTop();
                if (count > -lo) {
                    this.skipTo(count + lo);
                }
                this.limit = -lo;
                this.size = -lo;
            } else if (lo > -1L && this.hiFunction == null) {
                this.limit = lo;
                this.size = lo;
            } else {
                long hi = this.hiFunction.getLong(null);
                if (lo < 0L) {
                    if (lo < hi) {
                        long count = this.countRows();
                        if (count >= -hi) {
                            this.base.toTop();
                            if (count < -lo) {
                                this.limit = count + hi;
                            } else {
                                this.skipTo(count + lo);
                                this.limit = -lo + hi;
                            }
                            this.size = this.limit;
                        }
                    } else {
                        this.limit = 0L;
                        this.size = 0L;
                    }
                } else {
                    if (hi < 0L) {
                        this.size = this.limit = this.countRows() - lo + hi;
                        this.base.toTop();
                    } else {
                        this.size = this.limit = hi - lo;
                    }
                    if (lo > 0L && this.limit > 0L) {
                        this.skipTo(lo);
                    }
                }
            }
        }

        private long countRows() {
            long count = this.base.size();
            if (count > -1L) {
                return count;
            }
            while (this.base.hasNext()) {
                ++count;
            }
            return count;
        }

        private void skipTo(long count) {
            while (count-- > 0L && this.base.hasNext()) {
            }
        }
    }
}

