/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;

public abstract class BooleanFunction
implements Function {
    private final int position;

    public BooleanFunction(int position) {
        this.position = position;
    }

    @Override
    public final Long256 getLong256A(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Long256 getLong256B(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void getLong256(Record rec, CharSink sink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final char getChar(Record rec) {
        return this.getBool(rec) ? (char)'T' : 'F';
    }

    @Override
    public final BinarySequence getBin(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBinLen(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte getByte(Record rec) {
        return (byte)(!this.getBool(rec) ? 1 : 0);
    }

    @Override
    public final long getDate(Record rec) {
        return this.getBool(rec) ? 0L : 1L;
    }

    @Override
    public final double getDouble(Record rec) {
        return this.getBool(rec) ? 0.0 : 1.0;
    }

    @Override
    public final float getFloat(Record rec) {
        return this.getBool(rec) ? 0.0f : 1.0f;
    }

    @Override
    public final int getInt(Record rec) {
        return this.getBool(rec) ? 0 : 1;
    }

    @Override
    public final long getLong(Record rec) {
        return this.getBool(rec) ? 0L : 1L;
    }

    @Override
    public RecordMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public final RecordCursorFactory getRecordCursorFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final short getShort(Record rec) {
        return (short)(!this.getBool(rec) ? 1 : 0);
    }

    @Override
    public final CharSequence getStr(Record rec) {
        return this.getStr0(rec);
    }

    @Override
    public final void getStr(Record rec, CharSink sink) {
        sink.put(this.getStr0(rec));
    }

    @Override
    public final CharSequence getStrB(Record rec) {
        return this.getStr0(rec);
    }

    private String getStr0(Record rec) {
        return this.getBool(rec) ? "true" : "false";
    }

    @Override
    public final int getStrLen(Record rec) {
        return this.getBool(rec) ? "true".length() : "false".length();
    }

    @Override
    public final CharSequence getSymbol(Record rec) {
        return this.getStr0(rec);
    }

    @Override
    public long getTimestamp(Record rec) {
        return this.getBool(rec) ? 0L : 1L;
    }

    @Override
    public final int getType() {
        return 0;
    }
}

