/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.engine.functions.bind.BinBindVariable;
import io.questdb.griffin.engine.functions.bind.BindException;
import io.questdb.griffin.engine.functions.bind.BooleanBindVariable;
import io.questdb.griffin.engine.functions.bind.ByteBindVariable;
import io.questdb.griffin.engine.functions.bind.CharBindVariable;
import io.questdb.griffin.engine.functions.bind.DateBindVariable;
import io.questdb.griffin.engine.functions.bind.DoubleBindVariable;
import io.questdb.griffin.engine.functions.bind.FloatBindVariable;
import io.questdb.griffin.engine.functions.bind.IntBindVariable;
import io.questdb.griffin.engine.functions.bind.Long256BindVariable;
import io.questdb.griffin.engine.functions.bind.LongBindVariable;
import io.questdb.griffin.engine.functions.bind.ShortBindVariable;
import io.questdb.griffin.engine.functions.bind.StrBindVariable;
import io.questdb.griffin.engine.functions.bind.TimestampBindVariable;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;

public class BindVariableService {
    private final CharSequenceObjHashMap<Function> namedVariables = new CharSequenceObjHashMap();
    private final ObjList<Function> indexedVariables = new ObjList();

    public void clear() {
        this.namedVariables.clear();
        this.indexedVariables.clear();
    }

    public int getIndexedVariableCount() {
        return this.indexedVariables.size();
    }

    public Function getFunction(CharSequence name) {
        assert (name != null);
        assert (Chars.startsWith(name, ':'));
        return this.namedVariables.valueAt(this.namedVariables.keyIndex(name, 1, name.length()));
    }

    public Function getFunction(int index) {
        int n = this.indexedVariables.size();
        if (index < n) {
            return this.indexedVariables.getQuick(index);
        }
        return null;
    }

    public void setBin(CharSequence name, BinarySequence value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new BinBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof BinBindVariable) {
                ((BinBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBin(int index, BinarySequence value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new BinBindVariable(value));
                return;
            } else {
                if (!(function instanceof BinBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((BinBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new BinBindVariable(value));
        }
    }

    public void setBoolean(CharSequence name, boolean value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new BooleanBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof BooleanBindVariable) {
                ((BooleanBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBoolean(int index, boolean value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new BooleanBindVariable(value));
                return;
            } else {
                if (!(function instanceof BooleanBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((BooleanBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new BooleanBindVariable(value));
        }
    }

    public void setByte(CharSequence name, byte value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new ByteBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof ByteBindVariable) {
                ((ByteBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setByte(int index, byte value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new ByteBindVariable(value));
                return;
            } else {
                if (!(function instanceof ByteBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((ByteBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new ByteBindVariable(value));
        }
    }

    public void setDate(CharSequence name, long value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new DateBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof DateBindVariable) {
                ((DateBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    public void setChar(CharSequence name, char value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new CharBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof CharBindVariable) {
                ((CharBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDate(int index, long value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new DateBindVariable(value));
                return;
            } else {
                if (!(function instanceof DateBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((DateBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new DateBindVariable(value));
        }
    }

    public void setDouble(CharSequence name, double value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new DoubleBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof DoubleBindVariable) {
                ((DoubleBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDouble(int index, double value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new DoubleBindVariable(value));
                return;
            } else {
                if (!(function instanceof DoubleBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((DoubleBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new DoubleBindVariable(value));
        }
    }

    public void setFloat(CharSequence name, float value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new FloatBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof FloatBindVariable) {
                ((FloatBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFloat(int index, float value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new FloatBindVariable(value));
                return;
            } else {
                if (!(function instanceof FloatBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((FloatBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new FloatBindVariable(value));
        }
    }

    public void setInt(CharSequence name, int value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new IntBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof IntBindVariable) {
                ((IntBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    public void setLong256Null(CharSequence name) {
        this.setLong256(name, Long256Impl.NULL_LONG256);
    }

    public void setLong256(CharSequence name, long l0, long l1, long l2, long l3) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new Long256BindVariable(l0, l1, l2, l3));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof Long256BindVariable) {
                Long256Impl v = ((Long256BindVariable)function).value;
                v.setLong0(l0);
                v.setLong1(l1);
                v.setLong2(l2);
                v.setLong3(l3);
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    public void setLong256(CharSequence name, Long256 value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new Long256BindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof Long256BindVariable) {
                ((Long256BindVariable)function).value.copyFrom(value);
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInt(int index, int value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new IntBindVariable(value));
                return;
            } else {
                if (!(function instanceof IntBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((IntBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new IntBindVariable(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLong256(int index, long l0, long l1, long l2, long l3) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new Long256BindVariable(l0, l1, l2, l3));
                return;
            } else {
                if (!(function instanceof Long256BindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                Long256Impl v = ((Long256BindVariable)function).value;
                v.setLong0(l0);
                v.setLong1(l1);
                v.setLong2(l2);
                v.setLong3(l3);
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new Long256BindVariable(l0, l1, l2, l3));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChar(int index, char value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new CharBindVariable(value));
                return;
            } else {
                if (!(function instanceof CharBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((CharBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new CharBindVariable(value));
        }
    }

    public void setLong(CharSequence name, long value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new LongBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof LongBindVariable) {
                ((LongBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLong(int index, long value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new LongBindVariable(value));
                return;
            } else {
                if (!(function instanceof LongBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((LongBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new LongBindVariable(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setShort(int index, short value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new ShortBindVariable(value));
                return;
            } else {
                if (!(function instanceof ShortBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((ShortBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new ShortBindVariable(value));
        }
    }

    public void setShort(CharSequence name, short value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new ShortBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof ShortBindVariable) {
                ((ShortBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStr(int index, CharSequence value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new StrBindVariable(value));
                return;
            } else {
                if (!(function instanceof StrBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((StrBindVariable)function).setValue(value);
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new StrBindVariable(value));
        }
    }

    public void setStr(CharSequence name, CharSequence value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new StrBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof StrBindVariable) {
                ((StrBindVariable)function).setValue(value);
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTimestamp(int index, long value) {
        if (index < this.indexedVariables.size()) {
            Function function = this.indexedVariables.getQuick(index);
            if (function == null) {
                this.indexedVariables.setQuick(index, new TimestampBindVariable(value));
                return;
            } else {
                if (!(function instanceof TimestampBindVariable)) throw BindException.init().put("bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
                ((TimestampBindVariable)function).value = value;
            }
            return;
        } else {
            this.indexedVariables.extendAndSet(index, new TimestampBindVariable(value));
        }
    }

    public void setTimestamp(CharSequence name, long value) {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new TimestampBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof TimestampBindVariable) {
                ((TimestampBindVariable)function).value = value;
            } else {
                throw BindException.init().put("bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }
}

