/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

class StrBindVariable
extends StrFunction
implements StatelessFunction,
NoArgFunction {
    private final StringSink sink = new StringSink();
    private boolean isNull = false;

    public StrBindVariable(CharSequence value) {
        super(0);
        if (value == null) {
            this.isNull = true;
        } else {
            this.sink.put(value);
        }
    }

    @Override
    public CharSequence getStr(Record rec) {
        return this.isNull ? null : this.sink;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.isNull ? null : this.sink;
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        if (this.isNull) {
            sink.put((CharSequence)null);
        } else {
            sink.put(this.sink);
        }
    }

    @Override
    public int getStrLen(Record rec) {
        if (this.isNull) {
            return -1;
        }
        return this.sink.length();
    }

    public void setValue(CharSequence value) {
        this.sink.clear();
        if (value == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            this.sink.put(value);
        }
    }
}

