/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.ObjList;

public class AndFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "and(TT)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        Function leftFunc = args.getQuick(0);
        Function rightFunc = args.getQuick(1);
        if (leftFunc.isConstant()) {
            if (leftFunc.getBool(null)) {
                return rightFunc;
            }
            return new BooleanConstant(position, false);
        }
        if (rightFunc.isConstant()) {
            if (rightFunc.getBool(null)) {
                return leftFunc;
            }
            return new BooleanConstant(position, false);
        }
        return new MyBooleanFunction(position, leftFunc, rightFunc);
    }

    private static class MyBooleanFunction
    extends BooleanFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public MyBooleanFunction(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.left.getBool(rec) && this.right.getBool(rec);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

