/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntHashSet;
import io.questdb.std.ObjList;

public class InCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Av)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        IntHashSet set = new IntHashSet();
        int n = args.size();
        if (n == 1) {
            return new BooleanConstant(position, false);
        }
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            if (func.getType() != 3) {
                throw SqlException.$(func.getPosition(), "CHAR constant expected");
            }
            set.add(func.getChar(null));
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            return new BooleanConstant(position, set.contains(var.getChar(null)));
        }
        return new Func(position, var, set);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final IntHashSet set;

        public Func(int position, Function arg, IntHashSet set) {
            super(position);
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.set.contains(this.arg.getChar(rec));
        }
    }
}

