/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;

public class InStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Sv)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        CharSequenceHashSet set = new CharSequenceHashSet();
        int n = args.size();
        if (n == 1) {
            return new BooleanConstant(position, false);
        }
        block4: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (func.getType()) {
                case 10: {
                    CharSequence value = func.getStr(null);
                    if (value == null) {
                        throw SqlException.$(func.getPosition(), "NULL is not allowed");
                    }
                    set.add(Chars.toString(value));
                    continue block4;
                }
                case 3: {
                    set.add(new String(new char[]{func.getChar(null)}));
                    continue block4;
                }
                default: {
                    throw SqlException.$(func.getPosition(), "STRING constant expected");
                }
            }
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            return new BooleanConstant(position, set.contains(var.getStr(null)));
        }
        return new Func(position, var, set);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequenceHashSet set;

        public Func(int position, Function arg, CharSequenceHashSet set) {
            super(position);
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.set.contains(this.arg.getStr(rec));
        }
    }
}

