/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.ObjList;

public class InSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Kv)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        CharSequenceHashSet set = new CharSequenceHashSet();
        int n = args.size();
        if (n == 1) {
            return new BooleanConstant(position, false);
        }
        block4: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (func.getType()) {
                case 10: {
                    CharSequence value = func.getStr(null);
                    if (value == null) {
                        set.add(null);
                        continue block4;
                    }
                    set.add(Chars.toString(value));
                    continue block4;
                }
                case 3: {
                    set.add(new String(new char[]{func.getChar(null)}));
                    continue block4;
                }
                default: {
                    throw SqlException.$(func.getPosition(), "STRING constant expected");
                }
            }
        }
        SymbolFunction var = (SymbolFunction)args.getQuick(0);
        if (var.isConstant()) {
            return new BooleanConstant(position, set.contains(var.getSymbol(null)));
        }
        return new Func(position, var, set);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final CharSequenceHashSet set;
        private final IntHashSet intSet = new IntHashSet();
        private final TestFunc intTest = this::testAsInt;
        private final TestFunc strTest = this::testAsString;
        private TestFunc testFunc;

        public Func(int position, SymbolFunction arg, CharSequenceHashSet set) {
            super(position);
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.testFunc.test(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.arg.init(symbolTableSource, executionContext);
            StaticSymbolTable symbolTable = this.arg.getStaticSymbolTable();
            if (symbolTable != null) {
                this.intSet.clear();
                int n = this.set.size();
                for (int i = 0; i < n; ++i) {
                    this.intSet.add(symbolTable.keyOf(this.set.get(i)));
                }
                this.testFunc = this.intTest;
            } else {
                this.testFunc = this.strTest;
            }
        }

        private boolean testAsString(Record rec) {
            return this.set.contains(this.arg.getSymbol(rec));
        }

        private boolean testAsInt(Record rec) {
            return this.intSet.contains(this.arg.getInt(rec));
        }
    }

    @FunctionalInterface
    private static interface TestFunc {
        public boolean test(Record var1);
    }
}

