/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastCharToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ak)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            char value = arg.getChar(null);
            if (value == '\u0000') {
                return new SymbolConstant(position, null, Integer.MIN_VALUE);
            }
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(value);
            return new SymbolConstant(position, Chars.toString(sink), 0);
        }
        return new Func(position, arg);
    }

    private static class Func
    extends SymbolFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sink = new StringSink();
        private final IntIntHashMap symbolTableShortcut = new IntIntHashMap();
        private final ObjList<String> symbols = new ObjList();
        private int next = 1;

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
            this.symbols.add(null);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            char value = this.arg.getChar(rec);
            if (value == '\u0000') {
                return null;
            }
            int keyIndex = this.symbolTableShortcut.keyIndex(value);
            if (keyIndex < 0) {
                return this.symbols.getQuick(this.symbolTableShortcut.valueAt(keyIndex));
            }
            this.symbolTableShortcut.putAt(keyIndex, value, this.next++);
            this.sink.clear();
            this.sink.put(value);
            String str = Chars.toString(this.sink);
            this.symbols.add(Chars.toString(this.sink));
            return str;
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }

        @Override
        public int getInt(Record rec) {
            char value = this.arg.getChar(rec);
            if (value == '\u0000') {
                return Integer.MIN_VALUE;
            }
            int keyIndex = this.symbolTableShortcut.keyIndex(value);
            if (keyIndex < 0) {
                return this.symbolTableShortcut.valueAt(keyIndex) - 1;
            }
            this.symbolTableShortcut.putAt(keyIndex, value, this.next);
            this.sink.clear();
            this.sink.put(value);
            this.symbols.add(Chars.toString(this.sink));
            return this.next++ - 1;
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.arg.init(symbolTableSource, executionContext);
            this.symbolTableShortcut.clear();
            this.symbols.clear();
            this.symbols.add(null);
            this.next = 1;
        }
    }
}

