/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.time.DateFormatUtils;

public class CastStrToDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sm)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends DateFunction
    implements UnaryFunction {
        private final Function arg;

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            try {
                return value == null ? Long.MIN_VALUE : DateFormatUtils.parseDateTime(value);
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
    }
}

