/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Util;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CastStrToLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sh)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends Long256Function
    implements UnaryFunction {
        private final Function arg;
        private final Long256Impl long256a = new Long256Impl();
        private final Long256Impl long256b = new Long256Impl();

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public Long256 getLong256A(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            if (value == null) {
                return Long256Impl.NULL_LONG256;
            }
            return Func.Z(value, value.length(), this.long256a);
        }

        @Override
        public Long256 getLong256B(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            if (value == null) {
                return Long256Impl.NULL_LONG256;
            }
            return Func.Z(value, value.length(), this.long256b);
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            CharSequence value = this.arg.getStr(rec);
            if (value == null) {
                return;
            }
            int len = value.length();
            if (Long256Util.isValidString(value, len)) {
                try {
                    long a = Numbers.parseHexLong(value, 2, Math.min(len, 18));
                    long b = 0L;
                    long c = 0L;
                    long d = 0L;
                    if (len > 18) {
                        b = Numbers.parseHexLong(value, 18, Math.min(len, 34));
                    }
                    if (len > 34) {
                        c = Numbers.parseHexLong(value, 34, Math.min(len, 42));
                    }
                    if (len > 42) {
                        d = Numbers.parseHexLong(value, 42, Math.min(len, 66));
                    }
                    Numbers.appendLong256(a, b, c, d, sink);
                }
                catch (NumericException numericException) {
                    // empty catch block
                }
            }
        }

        private static Long256Impl Z(CharSequence text, int len, Long256Impl long256) {
            if (Long256Util.isValidString(text, len)) {
                try {
                    long a = Numbers.parseHexLong(text, 2, Math.min(len, 18));
                    long b = 0L;
                    long c = 0L;
                    long d = 0L;
                    if (len > 18) {
                        b = Numbers.parseHexLong(text, 18, Math.min(len, 34));
                    }
                    if (len > 34) {
                        c = Numbers.parseHexLong(text, 34, Math.min(len, 42));
                    }
                    if (len > 42) {
                        d = Numbers.parseHexLong(text, 42, Math.min(len, 66));
                    }
                    long256.setAll(a, b, c, d);
                    return long256;
                }
                catch (NumericException numericException) {
                    // empty catch block
                }
            }
            return Long256Impl.NULL_LONG256;
        }
    }
}

