/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastSymbolToFloatFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Kf)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends FloatFunction
    implements UnaryFunction {
        private final Function arg;

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public float getFloat(Record rec) {
            CharSequence value = this.arg.getSymbol(rec);
            try {
                return value == null ? Float.NaN : Numbers.parseFloat(value);
            }
            catch (NumericException e) {
                return Float.NaN;
            }
        }
    }
}

