/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;

public class ClassCatalogueFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "pg_catalog.pg_class()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new CursorFunction(position, new ClassCatalogueCursorFactory(configuration, METADATA));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("relname", 10));
        metadata.add(new TableColumnMetadata("relnamespace", 4));
        metadata.add(new TableColumnMetadata("relkind", 3));
        metadata.add(new TableColumnMetadata("relowner", 4));
        metadata.add(new TableColumnMetadata("oid", 4));
        METADATA = metadata;
    }

    private static class ClassCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private final Path path;
        private final FilesFacade ff;
        private final ClassCatalogueRecord record = new ClassCatalogueRecord();
        private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
        private final int plimit;
        private long findFileStruct = 0L;

        public ClassCatalogueCursor(CairoConfiguration configuration, Path path) {
            this.ff = configuration.getFilesFacade();
            this.path = path;
            this.path.of(configuration.getRoot()).$();
            this.plimit = this.path.length();
        }

        @Override
        public void close() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.findFileStruct == 0L) {
                this.findFileStruct = this.ff.findFirst(this.path.trimTo(this.plimit).$());
                if (this.findFileStruct > 0L) {
                    return this.next0();
                }
                this.findFileStruct = 0L;
                return false;
            }
            if (this.ff.findNext(this.findFileStruct) > 0) {
                return this.next0();
            }
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
        }

        private boolean next0() {
            do {
                long pname = this.ff.findName(this.findFileStruct);
                this.nativeLPSZ.of(pname);
                if (this.ff.findType(this.findFileStruct) != 4 || Chars.equals((CharSequence)this.nativeLPSZ, '.') || Chars.equals((CharSequence)this.nativeLPSZ, "..")) continue;
                this.path.trimTo(this.plimit);
                if (!this.ff.exists(this.path.concat(pname).concat("_txn").$())) continue;
                return true;
            } while (this.ff.findNext(this.findFileStruct) > 0);
            this.ff.findClose(this.findFileStruct);
            this.findFileStruct = 0L;
            return false;
        }

        private class ClassCatalogueRecord
        implements Record {
            private final StringSink utf8SinkA = new StringSink();
            private final StringSink utf8SinkB = new StringSink();

            private ClassCatalogueRecord() {
            }

            @Override
            public int getInt(int col) {
                return col == 1 ? 1 : 0;
            }

            @Override
            public char getChar(int col) {
                return 'r';
            }

            @Override
            public CharSequence getStr(int col) {
                this.utf8SinkA.clear();
                if (Chars.utf8DecodeZ(ClassCatalogueCursor.this.ff.findName(ClassCatalogueCursor.this.findFileStruct), this.utf8SinkA)) {
                    return this.utf8SinkA;
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                this.utf8SinkB.clear();
                if (Chars.utf8DecodeZ(ClassCatalogueCursor.this.ff.findName(ClassCatalogueCursor.this.findFileStruct), this.utf8SinkB)) {
                    return this.utf8SinkB;
                }
                return null;
            }
        }
    }

    private static class ClassCatalogueCursorFactory
    extends AbstractRecordCursorFactory {
        private final Path path = new Path();
        private final ClassCatalogueCursor cursor;

        public ClassCatalogueCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            this.cursor = new ClassCatalogueCursor(configuration, this.path);
        }

        @Override
        public void close() {
            Misc.free(this.path);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }
    }
}

