/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.GenericRecordCursorFactory;
import io.questdb.std.ObjList;

public class NamespaceCatalogueFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "pg_catalog.pg_namespace()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new CursorFunction(position, new GenericRecordCursorFactory(METADATA, new NamespaceCatalogueCursor(), false));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("nspname", 10));
        metadata.add(new TableColumnMetadata("oid", 4));
        METADATA = metadata;
    }

    private static class NamespaceCatalogueRecord
    implements Record {
        private static final NamespaceCatalogueRecord INSTANCE = new NamespaceCatalogueRecord();

        private NamespaceCatalogueRecord() {
        }

        @Override
        public int getInt(int col) {
            return 1;
        }

        @Override
        public CharSequence getStr(int col) {
            return "public";
        }
    }

    private static class NamespaceCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private int row = 0;

        private NamespaceCatalogueCursor() {
        }

        @Override
        public void close() {
            this.row = 0;
        }

        @Override
        public Record getRecord() {
            return NamespaceCatalogueRecord.INSTANCE;
        }

        @Override
        public boolean hasNext() {
            return this.row++ == 0;
        }

        @Override
        public void toTop() {
            this.row = 0;
        }

        @Override
        public long size() {
            return 1L;
        }
    }
}

