/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import org.jetbrains.annotations.Nullable;

public class SymbolColumn
extends SymbolFunction
implements StatelessFunction {
    private final int columnIndex;
    private final boolean symbolTableStatic;
    private SymbolTable symbolTable;

    public SymbolColumn(int position, int columnIndex, boolean symbolTableStatic) {
        super(position);
        this.columnIndex = columnIndex;
        this.symbolTableStatic = symbolTableStatic;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.columnIndex);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return rec.getSym(this.columnIndex);
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.symbolTable.valueOf(symbolKey);
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.symbolTable = symbolTableSource.getSymbolTable(this.columnIndex);
    }

    @Override
    @Nullable
    public StaticSymbolTable getStaticSymbolTable() {
        return this.symbolTable instanceof StaticSymbolTable ? (StaticSymbolTable)this.symbolTable : null;
    }

    @Override
    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }
}

