/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.cast.CastBooleanToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.conditional.BinCaseFunction;
import io.questdb.griffin.engine.functions.conditional.BooleanCaseFunction;
import io.questdb.griffin.engine.functions.conditional.ByteCaseFunction;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionConstructor;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.griffin.engine.functions.conditional.CharCaseFunction;
import io.questdb.griffin.engine.functions.conditional.DateCaseFunction;
import io.questdb.griffin.engine.functions.conditional.DoubleCaseFunction;
import io.questdb.griffin.engine.functions.conditional.FloatCaseFunction;
import io.questdb.griffin.engine.functions.conditional.IntCaseFunction;
import io.questdb.griffin.engine.functions.conditional.Long256CaseFunction;
import io.questdb.griffin.engine.functions.conditional.LongCaseFunction;
import io.questdb.griffin.engine.functions.conditional.ShortCaseFunction;
import io.questdb.griffin.engine.functions.conditional.StrCaseFunction;
import io.questdb.griffin.engine.functions.conditional.TimestampCaseFunction;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import org.jetbrains.annotations.NotNull;

public class CaseCommon {
    private static final ObjList<CaseFunctionConstructor> constructors = new ObjList();
    private static final LongIntHashMap typeEscalationMap = new LongIntHashMap();
    private static final LongObjHashMap<FunctionFactory> castFactories = new LongObjHashMap();
    private static final ThreadLocal<ObjList<Function>> tlArgs = new ThreadLocal<ObjList>(ObjList::new);

    static int getCommonType(int commonType, int valueType, int valuePos) throws SqlException {
        if (commonType == -1) {
            return valueType;
        }
        int type = typeEscalationMap.get(Numbers.encodeLowHighInts(commonType, valueType));
        if (type == -1) {
            throw SqlException.$(valuePos, "inconvertible types ").put(ColumnType.nameOf(valueType)).put(" to ").put(ColumnType.nameOf(commonType));
        }
        return type;
    }

    static Function getCastFunction(Function arg, int toType, CairoConfiguration configuration) throws SqlException {
        int keyIndex = castFactories.keyIndex(Numbers.encodeLowHighInts(arg.getType(), toType));
        if (keyIndex < 0) {
            FunctionFactory fact = castFactories.valueAt(keyIndex);
            ObjList args = (ObjList)tlArgs.get();
            args.clear();
            args.add(arg);
            return fact.newInstance(args, 0, configuration);
        }
        return arg;
    }

    @NotNull
    private static CaseFunctionConstructor getCaseFunctionConstructor(int position, int returnType) throws SqlException {
        CaseFunctionConstructor constructor = constructors.getQuick(returnType);
        if (constructor == null) {
            throw SqlException.$(position, "not implemented for type '").put(ColumnType.nameOf(returnType)).put('\'');
        }
        return constructor;
    }

    static Function getCaseFunction(int position, int returnType, CaseFunctionPicker picker, ObjList<Function> args) throws SqlException {
        return CaseCommon.getCaseFunctionConstructor(position, returnType).getInstance(position, picker, args);
    }

    static {
        castFactories.put(Numbers.encodeLowHighInts(1, 12), new CastByteToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(1, 10), new CastByteToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(1, 11), new CastByteToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 12), new CastCharToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 10), new CastCharToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 11), new CastCharToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 12), new CastShortToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 10), new CastShortToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 11), new CastShortToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 12), new CastIntToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 10), new CastIntToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 11), new CastIntToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 12), new CastLongToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 10), new CastLongToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 11), new CastLongToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 12), new CastFloatToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 10), new CastFloatToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 11), new CastFloatToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 12), new CastDoubleToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 10), new CastDoubleToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 11), new CastDoubleToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 12), new CastDateToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 10), new CastDateToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 11), new CastDateToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 12), new CastTimestampToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 10), new CastTimestampToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 11), new CastTimestampToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(0, 12), new CastBooleanToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(12, 10), new CastLong256ToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(12, 11), new CastLong256ToSymbolFunctionFactory());
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 1), 1);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 0), 1);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 1), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 0), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 1), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 0), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 3), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 1), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 0), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 3), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 2), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 1), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 0), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 3), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 2), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 4), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 1), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 0), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 3), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 2), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 4), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 5), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 7), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 1), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 0), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 3), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 2), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 4), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 5), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 8), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 6), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 7), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 1), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 0), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 3), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 2), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 4), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 5), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 1), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 0), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 3), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 2), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 4), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 5), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 6), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 1), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 0), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 3), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 2), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 4), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 5), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 12), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 8), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 9), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 6), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 7), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 11), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 1), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 0), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 3), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 2), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 4), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 5), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 12), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 8), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 9), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 6), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 7), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 1), 1);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 0), 0);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(0, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 1), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 0), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 3), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 2), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 4), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 5), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 8), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 9), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 6), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 7), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 13), 13);
        constructors.set(0, 14, null);
        constructors.extendAndSet(10, StrCaseFunction::new);
        constructors.extendAndSet(4, IntCaseFunction::new);
        constructors.extendAndSet(5, LongCaseFunction::new);
        constructors.extendAndSet(1, ByteCaseFunction::new);
        constructors.extendAndSet(0, BooleanCaseFunction::new);
        constructors.extendAndSet(2, ShortCaseFunction::new);
        constructors.extendAndSet(3, CharCaseFunction::new);
        constructors.extendAndSet(8, FloatCaseFunction::new);
        constructors.extendAndSet(9, DoubleCaseFunction::new);
        constructors.extendAndSet(12, Long256CaseFunction::new);
        constructors.extendAndSet(11, StrCaseFunction::new);
        constructors.extendAndSet(6, DateCaseFunction::new);
        constructors.extendAndSet(7, TimestampCaseFunction::new);
        constructors.extendAndSet(13, BinCaseFunction::new);
    }
}

