/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

class LongCaseFunction
extends LongFunction {
    private final CaseFunctionPicker picker;
    private final ObjList<Function> args;

    public LongCaseFunction(int position, CaseFunctionPicker picker, ObjList<Function> args) {
        super(position);
        this.picker = picker;
        this.args = args;
    }

    @Override
    public long getLong(Record rec) {
        return this.picker.pick(rec).getLong(rec);
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        Function.init(this.args, symbolTableSource, executionContext);
    }

    @Override
    public void toTop() {
        Function.toTop(this.args);
    }

    @Override
    public void close() {
        Misc.freeObjList(this.args);
    }
}

