/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.conditional.CaseCommon;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.ObjList;

public class SwitchFunctionFactory
implements FunctionFactory {
    private static final LongMethod GET_LONG = SwitchFunctionFactory::getLong;
    private static final IntMethod GET_SHORT = SwitchFunctionFactory::getShort;
    private static final IntMethod GET_BYTE = SwitchFunctionFactory::getByte;
    private static final IntMethod GET_INT = SwitchFunctionFactory::getInt;
    private static final IntMethod GET_CHAR = SwitchFunctionFactory::getChar;
    private static final LongMethod GET_DATE = SwitchFunctionFactory::getDate;
    private static final LongMethod GET_TIMESTAMP = SwitchFunctionFactory::getTimestamp;
    private static final CharSequenceMethod GET_STRING = SwitchFunctionFactory::getString;
    private static final CharSequenceMethod GET_SYMBOL = SwitchFunctionFactory::getSymbol;

    private static char getChar(Function function, Record record) {
        return function.getChar(record);
    }

    private static int getInt(Function function, Record record) {
        return function.getInt(record);
    }

    private static byte getByte(Function function, Record record) {
        return function.getByte(record);
    }

    private static short getShort(Function function, Record record) {
        return function.getShort(record);
    }

    private static long getLong(Function function, Record record) {
        return function.getLong(record);
    }

    private static long getDate(Function function, Record record) {
        return function.getDate(record);
    }

    private static long getTimestamp(Function function, Record record) {
        return function.getTimestamp(record);
    }

    private static CharSequence getString(Function function, Record record) {
        return function.getStr(record);
    }

    private static CharSequence getSymbol(Function function, Record record) {
        return function.getSymbol(record);
    }

    @Override
    public String getSignature() {
        return "switch(V)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        int i;
        Function elseBranch;
        int n = args.size();
        Function keyFunction = args.getQuick(0);
        int keyType = keyFunction.getType();
        if (n % 2 == 0) {
            elseBranch = args.getLast();
            --n;
        } else {
            elseBranch = null;
        }
        int returnType = -1;
        for (i = 1; i < n; i += 2) {
            Function keyFunc = args.getQuick(i);
            int keyArgType = keyFunc.getType();
            if (!keyFunc.isConstant()) {
                throw SqlException.$(keyFunc.getPosition(), "constant expected");
            }
            if (!SqlCompiler.isAssignableFrom(keyType, keyArgType)) {
                throw SqlException.position(keyFunc.getPosition()).put("type mismatch [expected=").put(ColumnType.nameOf(keyType)).put(", actual=").put(ColumnType.nameOf(keyArgType)).put(']');
            }
            Function value = args.getQuick(i + 1);
            returnType = CaseCommon.getCommonType(returnType, value.getType(), value.getPosition());
        }
        for (i = 2; i < n; i += 2) {
            args.setQuick(i, CaseCommon.getCastFunction(args.getQuick(i), returnType, configuration));
        }
        switch (keyType) {
            case 3: {
                return this.getIntKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_CHAR);
            }
            case 4: {
                return this.getIntKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_INT);
            }
            case 1: {
                return this.getIntKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_BYTE);
            }
            case 2: {
                return this.getIntKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_SHORT);
            }
            case 5: {
                return this.getLongKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_LONG);
            }
            case 6: {
                return this.getLongKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_DATE);
            }
            case 7: {
                return this.getLongKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_TIMESTAMP);
            }
            case 0: {
                return this.getIfElseFunction(args, position, n, keyFunction, returnType, elseBranch);
            }
            case 10: {
                return this.getCharSequenceKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_STRING);
            }
            case 11: {
                return this.getCharSequenceKeyedFunction(args, position, n, keyFunction, returnType, elseBranch, GET_SYMBOL);
            }
        }
        throw SqlException.$(keyFunction.getPosition(), "type ").put(ColumnType.nameOf(keyType)).put(" is not supported in 'switch' type of 'case' statement");
    }

    private Function getIntKeyedFunction(ObjList<Function> args, int position, int n, Function keyFunction, int valueType, Function elseBranch, IntMethod intMethod) throws SqlException {
        IntObjHashMap<Function> map = new IntObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            int key = intMethod.getKey(fun, null);
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(fun.getPosition(), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        CaseFunctionPicker picker = record -> {
            int index = map.keyIndex(intMethod.getKey(keyFunction, record));
            if (index < 0) {
                return (Function)map.valueAtQuick(index);
            }
            return elseB;
        };
        argsToPoke.add(elseB);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    private Function getElseFunction(int valueType, Function elseBranch) {
        return elseBranch != null ? elseBranch : Constants.getNullConstant(valueType);
    }

    private Function getIfElseFunction(ObjList<Function> args, int position, int n, Function keyFunction, int returnType, Function elseBranch) throws SqlException {
        ObjList<Function> argsToPoke;
        CaseFunctionPicker picker;
        if (n == 3) {
            boolean value = args.getQuick(1).getBool(null);
            Function branch = args.getQuick(2);
            Function elseB = this.getElseFunction(returnType, elseBranch);
            picker = value ? record -> keyFunction.getBool(record) ? branch : elseB : record -> keyFunction.getBool(record) ? elseB : branch;
            argsToPoke = new ObjList<Function>();
            argsToPoke.add(keyFunction);
            argsToPoke.add(elseB);
        } else if (n == 5) {
            boolean a = args.getQuick(1).getBool(null);
            Function branchA = args.getQuick(2);
            boolean b = args.getQuick(3).getBool(null);
            Function branchB = args.getQuick(4);
            if (a && b || !a && !b) {
                throw SqlException.$(args.getQuick(3).getPosition(), "duplicate branch");
            }
            if (elseBranch != null) {
                throw SqlException.$(elseBranch.getPosition(), "duplicate boolean values");
            }
            picker = a ? record -> keyFunction.getBool(record) ? branchA : branchB : record -> keyFunction.getBool(record) ? branchB : branchA;
            argsToPoke = new ObjList();
            argsToPoke.add(keyFunction);
            argsToPoke.add(branchA);
            argsToPoke.add(branchB);
        } else {
            throw SqlException.$(args.getQuick(5).getPosition(), "too many branches");
        }
        return CaseCommon.getCaseFunction(position, returnType, picker, argsToPoke);
    }

    private Function getLongKeyedFunction(ObjList<Function> args, int position, int n, Function keyFunction, int valueType, Function elseBranch, LongMethod longMethod) throws SqlException {
        LongObjHashMap<Function> map = new LongObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            long key = longMethod.getKey(fun, null);
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(fun.getPosition(), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        CaseFunctionPicker picker = record -> {
            int index = map.keyIndex(longMethod.getKey(keyFunction, record));
            if (index < 0) {
                return (Function)map.valueAtQuick(index);
            }
            return elseB;
        };
        argsToPoke.add(elseB);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    private Function getCharSequenceKeyedFunction(ObjList<Function> args, int position, int n, Function keyFunction, int valueType, Function elseBranch, CharSequenceMethod method) throws SqlException {
        CaseFunctionPicker picker;
        CharSequenceObjHashMap<Function> map = new CharSequenceObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        Function nullFunc = null;
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            CharSequence key = method.getKey(fun, null);
            if (key == null) {
                nullFunc = args.getQuick(i + 1);
                continue;
            }
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(fun.getPosition(), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        if (nullFunc == null) {
            picker = record -> {
                int index;
                CharSequence value = method.getKey(keyFunction, record);
                if (value != null && (index = map.keyIndex(value)) < 0) {
                    return (Function)map.valueAtQuick(index);
                }
                return elseB;
            };
        } else {
            Function nullFuncRef = nullFunc;
            picker = record -> {
                CharSequence value = method.getKey(keyFunction, record);
                if (value == null) {
                    return nullFuncRef;
                }
                int index = map.keyIndex(value);
                if (index < 0) {
                    return (Function)map.valueAtQuick(index);
                }
                return elseB;
            };
            argsToPoke.add(nullFunc);
        }
        argsToPoke.add(elseB);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    @FunctionalInterface
    private static interface CharSequenceMethod {
        public CharSequence getKey(Function var1, Record var2);
    }

    @FunctionalInterface
    private static interface LongMethod {
        public long getKey(Function var1, Record var2);
    }

    @FunctionalInterface
    private static interface IntMethod {
        public int getKey(Function var1, Record var2);
    }
}

