/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.std.ObjList;
import io.questdb.std.time.MillisecondClock;

public class SysdateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sysdate()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, configuration.getMillisecondClock());
    }

    private static class Func
    extends DateFunction
    implements StatelessFunction {
        private final MillisecondClock clock;

        public Func(int position, MillisecondClock clock) {
            super(position);
            this.clock = clock;
        }

        @Override
        public long getDate(Record rec) {
            return this.clock.getTicks();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

