/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.ObjList;

public class TimestampSequenceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "timestamp_sequence(nL)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        long start = args.getQuick(0).getTimestamp(null);
        if (start == Long.MIN_VALUE) {
            return new TimestampConstant(args.getQuick(0).getPosition(), Long.MIN_VALUE);
        }
        return new TimestampSequenceFunction(position, start, args.getQuick(1));
    }

    private static final class TimestampSequenceFunction
    extends TimestampFunction {
        private final Function longIncrement;
        private final long start;
        private long next;

        public TimestampSequenceFunction(int position, long start, Function longIncrement) {
            super(position);
            this.start = start;
            this.next = start;
            this.longIncrement = longIncrement;
        }

        @Override
        public void close() {
        }

        @Override
        public long getTimestamp(Record rec) {
            long result = this.next;
            this.next += this.longIncrement.getLong(rec);
            return result;
        }

        @Override
        public void toTop() {
            this.next = this.start;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

