/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.NullStrConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import io.questdb.std.time.DateFormat;
import io.questdb.std.time.DateFormatCompiler;
import io.questdb.std.time.DateLocale;
import io.questdb.std.time.DateLocaleFactory;
import org.jetbrains.annotations.Nullable;

public class ToStrDateFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<DateFormatCompiler> tlCompiler = ThreadLocal.withInitial(DateFormatCompiler::new);
    private static final ThreadLocal<StringSink> tlSink = ThreadLocal.withInitial(StringSink::new);

    @Override
    public String getSignature() {
        return "to_str(Ms)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        Function fmt = args.getQuick(1);
        CharSequence format = fmt.getStr(null);
        if (format == null) {
            throw SqlException.$(fmt.getPosition(), "format must not be null");
        }
        DateFormat dateFormat = tlCompiler.get().compile(fmt.getStr(null));
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            long value = var.getDate(null);
            if (value == Long.MIN_VALUE) {
                return new NullStrConstant(position);
            }
            StringSink sink = tlSink.get();
            sink.clear();
            dateFormat.format(value, DateLocaleFactory.INSTANCE.getDefaultDateLocale(), "Z", sink);
            return new StrConstant(position, sink);
        }
        return new ToCharDateVCFFunc(position, args.getQuick(0), tlCompiler.get().compile(format));
    }

    private static class ToCharDateVCFFunc
    extends StrFunction
    implements UnaryFunction {
        final Function arg;
        final DateFormat format;
        final DateLocale locale;
        final StringSink sink1;
        final StringSink sink2;

        public ToCharDateVCFFunc(int position, Function arg, DateFormat format) {
            super(position);
            this.arg = arg;
            this.format = format;
            this.locale = DateLocaleFactory.INSTANCE.getDefaultDateLocale();
            this.sink1 = new StringSink();
            this.sink2 = new StringSink();
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.toSink(rec, this.sink1);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.toSink(rec, this.sink2);
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            long value = this.arg.getDate(rec);
            if (value == Long.MIN_VALUE) {
                return;
            }
            this.toSink(value, sink);
        }

        @Override
        public int getStrLen(Record rec) {
            long value = this.arg.getDate(rec);
            if (value == Long.MIN_VALUE) {
                return -1;
            }
            this.sink1.clear();
            this.toSink(value, (CharSink)this.sink1);
            return this.sink1.length();
        }

        @Nullable
        private CharSequence toSink(Record rec, StringSink sink) {
            long value = this.arg.getDate(rec);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            sink.clear();
            this.toSink(value, (CharSink)sink);
            return sink;
        }

        private void toSink(long value, CharSink sink) {
            this.format.format(value, this.locale, "Z", sink);
        }
    }
}

