/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;

public class EqStrCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(SA)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        Function strFunc = args.getQuick(0);
        Function charFunc = args.getQuick(1);
        if (strFunc.isConstant() && !charFunc.isConstant()) {
            CharSequence str = strFunc.getStr(null);
            if (str == null || str.length() != 1) {
                return new BooleanConstant(position, false);
            }
            return new ConstStrFunc(position, charFunc, str.charAt(0));
        }
        if (!strFunc.isConstant() && charFunc.isConstant()) {
            return new ConstChrFunc(position, strFunc, charFunc.getChar(null));
        }
        if (strFunc.isConstant() && charFunc.isConstant()) {
            return new BooleanConstant(position, Chars.equalsNc(strFunc.getStr(null), charFunc.getChar(null)));
        }
        return new Func(position, strFunc, charFunc);
    }

    private static class Func
    extends BooleanFunction
    implements BinaryFunction {
        private final Function strFunc;
        private final Function chrFunc;

        public Func(int position, Function strFunc, Function chrFunc) {
            super(position);
            this.strFunc = strFunc;
            this.chrFunc = chrFunc;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public Function getRight() {
            return this.chrFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return Chars.equalsNc(this.strFunc.getStr(rec), this.chrFunc.getChar(rec));
        }
    }

    private static class ConstStrFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function chrFunc;
        private final char chrConst;

        public ConstStrFunc(int position, Function chrFunc, char chrConst) {
            super(position);
            this.chrFunc = chrFunc;
            this.chrConst = chrConst;
        }

        @Override
        public Function getArg() {
            return this.chrFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.chrFunc.getChar(rec) == this.chrConst;
        }
    }

    private static class ConstChrFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function strFunc;
        private final char chrConst;

        public ConstChrFunc(int position, Function strFunc, char chrConst) {
            super(position);
            this.strFunc = strFunc;
            this.chrConst = chrConst;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return Chars.equalsNc(this.strFunc.getStr(rec), this.chrConst);
        }
    }
}

