/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;

public class EqSymStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(KS)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        Function symFunc = args.getQuick(0);
        Function strFunc = args.getQuick(1);
        if (strFunc.isConstant()) {
            return this.createHalfConstantFunc(position, strFunc, symFunc);
        }
        return new Func(position, symFunc, strFunc);
    }

    private Function createHalfConstantFunc(int position, Function constFunc, Function varFunc) {
        CharSequence constValue = constFunc.getStr(null);
        SymbolFunction func = (SymbolFunction)varFunc;
        if (func.getStaticSymbolTable() != null) {
            return new ConstCheckColumnFunc(position, func, constValue);
        }
        if (constValue == null) {
            return new NullCheckFunc(position, varFunc);
        }
        return new ConstCheckFunc(position, varFunc, constValue);
    }

    private static class Func
    extends BooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence a = this.left.getSymbol(rec);
            CharSequence b = this.right.getStr(rec);
            if (a == null) {
                return b == null;
            }
            return Chars.equalsNc(a, b);
        }
    }

    private static class ConstCheckColumnFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final CharSequence constant;
        private int valueIndex;

        public ConstCheckColumnFunc(int position, SymbolFunction arg, CharSequence constant) {
            super(position);
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.arg.getInt(rec) == this.valueIndex;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.arg.init(symbolTableSource, executionContext);
            StaticSymbolTable symbolTable = this.arg.getStaticSymbolTable();
            assert (symbolTable != null);
            this.valueIndex = symbolTable.keyOf(this.constant);
        }

        @Override
        public boolean isConstant() {
            return this.valueIndex == -2;
        }
    }

    private static class ConstCheckFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequence constant;

        public ConstCheckFunc(int position, Function arg, CharSequence constant) {
            super(position);
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return Chars.equalsNc(this.constant, this.arg.getSymbol(rec));
        }
    }

    private static class NullCheckFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public NullCheckFunc(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.arg.getSymbol(rec) == null;
        }
    }
}

