/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class MinIntGroupByFunction
extends IntFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinIntGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putInt(this.valueIndex, this.arg.getInt(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        int min = mapValue.getInt(this.valueIndex);
        int next = this.arg.getInt(record);
        if (next != Integer.MIN_VALUE && next < min || min == Integer.MIN_VALUE) {
            mapValue.putInt(this.valueIndex, next);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(4);
    }

    @Override
    public void setInt(MapValue mapValue, int value) {
        mapValue.putInt(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putInt(this.valueIndex, Integer.MIN_VALUE);
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.valueIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }
}

